/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree;

import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.XmlValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.ma4j.framework.MAQueryExecutor;
import com.cognos.xqe.ma4j.framework.MAQueryParser;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.XExpression;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMetadata
extends XExpression {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_DATASOURCE = "dataSource";
    private static final String ATTRIBUTE_RUN_LOCALE = "runLocale";
    private static final String ATTRIBUTE_PRODUCT_LOCALE = "productLocale";
    private static final String ELEMENT_ROOT = "root";
    private String dataSource;
    private String runLocale;
    private String productLocale;
    private Element root;

    @Override
    protected IValue executeImpl(XDataContext context) {
        XmlValue result = DataValueFactory.createXmlValue();
        result.setNull();
        ArrayList<Document> responses = new ArrayList<Document>();
        try {
            MetadataConnection metadataConnection = MetadataService.getInstance().getConnection("MFW4J", this.dataSource, (ExecutionEnvironment)context.getEnvironment(), true);
            MFWGateway gateway = metadataConnection.getGateway().getGatewayImpl();
            for (Element request : this.root.elements()) {
                MAQueryParser queryParser = new MAQueryParser();
                String modelPath = metadataConnection.getModelPath();
                modelPath = modelPath.substring(1, modelPath.indexOf(93) + 1);
                queryParser.setDataSource(modelPath);
                queryParser.setRunLocale(this.runLocale);
                queryParser.setProductLocale(this.productLocale);
                queryParser.processClientRequest(request);
                queryParser.calcEffectiveAuthoringLocales(gateway);
                MAQueryExecutor qe = new MAQueryExecutor(gateway, queryParser, ((ExecutionEnvironment)context.getEnvironment()).getPAC());
                qe.executeQuery();
                responses.add(qe.getResponseDOM());
            }
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
        Document document = (Document)responses.get(0);
        for (int i = 1; i < responses.size(); ++i) {
            Element response = ((Document)responses.get(i)).getRootElement();
            Element responseRoot = response.element("ResponseRoot");
            document.getRootElement().add(responseRoot.createCopy());
        }
        result.set(document.asXML());
        return result;
    }

    @Override
    public int getType() {
        return 501102;
    }

    public void setMetadata(Element theMetadata) {
        this.root = theMetadata;
    }

    public void setDataSource(String dsName) {
        this.dataSource = dsName;
    }

    public void setRunLocale(String locale) {
        this.runLocale = locale;
    }

    public void setProductLocale(String locale) {
        this.productLocale = locale;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.setDataSource(inputNode.attributeValue(ATTRIBUTE_DATASOURCE));
        this.setRunLocale(inputNode.attributeValue(ATTRIBUTE_RUN_LOCALE));
        this.setProductLocale(inputNode.attributeValue(ATTRIBUTE_PRODUCT_LOCALE));
        List children = inputNode.elements();
        this.setMetadata((Element)children.get(0));
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(ATTRIBUTE_DATASOURCE, this.dataSource);
        ctx.property(ATTRIBUTE_RUN_LOCALE, this.runLocale);
        ctx.property(ATTRIBUTE_PRODUCT_LOCALE, this.productLocale);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        ctx.elementProperty(ELEMENT_ROOT, this.root);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(ATTRIBUTE_DATASOURCE)) {
            Object val = ctx.attributeValue(att);
            this.dataSource = (String)val;
        } else if (attname.equals(ATTRIBUTE_RUN_LOCALE)) {
            Object val = ctx.attributeValue(att);
            this.runLocale = (String)val;
        } else if (attname.equals(ATTRIBUTE_PRODUCT_LOCALE)) {
            Object val = ctx.attributeValue(att);
            this.productLocale = (String)val;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_ROOT)) {
            List children = node.elements();
            if (children != null && children.size() > 0) {
                this.setMetadata((Element)children.get(0));
            }
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }
}

