/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import java.util.Random;

public class XSamplingTabularIterator
extends XTabularIterator {
    private XTabularIterator tabIt = null;
    private IRow result;
    private IRow inputRow;
    private double percent;
    private Random random;

    public XSamplingTabularIterator(XDataContext context, XTabularIterator theInputIterator, IRowsetInfo theIResultSetInfo, double thePercent) {
        super(context, new Integer(-1));
        this.tabIt = theInputIterator;
        this.percent = thePercent;
        this.random = new Random();
    }

    public XSamplingTabularIterator(XDataContext context, XTabularIterator theInputIterator, IRowsetInfo theIResultSetInfo, double thePercent, long seed) {
        this(context, theInputIterator, theIResultSetInfo, thePercent);
        this.random.setSeed(seed);
    }

    @Override
    public Object nextImpl() {
        do {
            try {
                this.inputRow = (IRow)this.tabIt.next();
            }
            catch (OperationCanceledException e) {
                this.release();
                throw e;
            }
            if (this.inputRow != null) continue;
            this.tabIt.release();
            this.tabIt = null;
            return null;
        } while (!(this.random.nextDouble() <= this.percent));
        this.result = this.inputRow;
        ++this.nRows;
        return this.result;
    }

    @Override
    public long getIndex() {
        return -1L;
    }

    @Override
    public void release() {
        if (this.tabIt != null) {
            this.tabIt.release();
            this.tabIt = null;
        }
        this.result = null;
        this.inputRow = null;
        super.release();
    }
}

