/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.ma;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.XmlValue;
import com.cognos.xqe.ma4j.utilities.MADOMResponseBuilder;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.ma.XMANode;
import com.cognos.xqe.transformation.ma.util.MASubQueryBuilder;
import com.cognos.xqe.transformation.v5.util.V5SubQueryBuilder;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class XMAMunQuery
extends XMANode {
    private static final long serialVersionUID = 1L;
    public static final String ATTRIBUTE_MUN = "mun";
    public static final String ATTRIBUTE_MODEL = "model";
    public static final String ATTRIBUTE_LOGICAL = "logical";
    public static final String ATTRIBUTE_PHYSICAL = "physical";
    public static final String MUN_QUERY = "munQuery";
    public static final String MEMBER = "//member";
    public static final String DOT_SEPARATOR = "].[";

    @Override
    public int getType() {
        return 501136;
    }

    @Override
    public IValue executeImpl(XDataContext context) {
        ExecutionEnvironment exeEnvironment = (ExecutionEnvironment)context.getEnvironment();
        context.setNodeId(this.getId());
        MADOMResponseBuilder mIdDOMResponseBuilder = new MADOMResponseBuilder();
        mIdDOMResponseBuilder.buildResponseDOM();
        mIdDOMResponseBuilder.buildResponseHeader();
        Element responseRootElem = mIdDOMResponseBuilder.getResponseRoot();
        this.setResponseElement(responseRootElem);
        String mun = (String)this.getPropertyValue(ATTRIBUTE_MUN);
        String logicalPart = (String)this.getPropertyValue(ATTRIBUTE_LOGICAL);
        String physicalPart = (String)this.getPropertyValue(ATTRIBUTE_PHYSICAL);
        if (logicalPart != null && logicalPart.length() > 0 && physicalPart != null && physicalPart.length() > 0) {
            return this.constructResponse(mun, mun);
        }
        PlanningEnvironment planEnvironment = V5SubQueryBuilder.createPlanningEnvironment(exeEnvironment, (PlanningEnvironment)this.getPlanningEnvironment());
        IXQEQueryNode maRequest = this.createMetadataRequest(planEnvironment, mun, logicalPart, physicalPart);
        XmlValue value = MASubQueryBuilder.executeMetadataSubQuery(context, planEnvironment, maRequest);
        String responseMUN = this.completeMUN(value);
        return this.constructResponse(mun, responseMUN);
    }

    private String completeMUN(XmlValue value) {
        String modelPart = (String)this.getPropertyValue(ATTRIBUTE_MODEL);
        String logicalPart = (String)this.getPropertyValue(ATTRIBUTE_LOGICAL);
        String physicalPart = (String)this.getPropertyValue(ATTRIBUTE_PHYSICAL);
        if (logicalPart != null && logicalPart.length() > 0) {
            physicalPart = this.getPhysicalPart(value);
        } else if (physicalPart != null && physicalPart.length() > 0) {
            logicalPart = this.getLogicalPart(value);
        }
        return UniqueNameGenerator.joinModelLogicalPhysicalParts(modelPart, logicalPart, physicalPart);
    }

    private String getLogicalPart(XmlValue value) {
        String logicalPart = null;
        Node node = value.getNode();
        List membersList = node.selectNodes(MEMBER);
        int i = membersList.size();
        String[] businessKeyParts = new String[i];
        --i;
        for (Element member : membersList) {
            String businessKey = member.attributeValue("businessKey");
            if (businessKey == null) {
                return null;
            }
            if (businessKey.contains(DOT_SEPARATOR)) {
                businessKey = UniqueNameGenerator.getSAPBusinessKeyFromMUN(businessKey);
            }
            businessKeyParts[i] = businessKey;
            --i;
        }
        if (businessKeyParts.length > 0) {
            logicalPart = UniqueNameGenerator.createUniqueName(businessKeyParts);
        }
        return logicalPart;
    }

    private String getPhysicalPart(XmlValue value) {
        String physicalPart = null;
        Node node = value.getNode();
        Element member = (Element)node.selectSingleNode(MEMBER);
        if (member != null) {
            String cognosMUN = member.attributeValue("memberUniqueName");
            physicalPart = UniqueNameGenerator.extractPhysicalPartFromCognosMUN(cognosMUN);
        }
        return physicalPart;
    }

    private IXQEQueryNode createMetadataRequest(PlanningEnvironment environment, String startAtRef, String logicalPart, String physicalPart) {
        IXQEQueryNode maRequest = MASubQueryBuilder.createMetadataRequest(environment, startAtRef);
        IXQEQueryNode metaDataQuery = maRequest.getFirstChildByType(1101015);
        XQENodeFactory nf = environment.getNodeFactory();
        if (logicalPart != null && logicalPart.length() > 0) {
            metaDataQuery.setPropertyValue(MUN_QUERY, ATTRIBUTE_LOGICAL);
        } else if (physicalPart != null && physicalPart.length() > 0) {
            metaDataQuery.setPropertyValue(MUN_QUERY, ATTRIBUTE_PHYSICAL);
            IXQEQueryNode businessKeyProperty = nf.createNode(1101026);
            metaDataQuery.addChild(businessKeyProperty);
            MASubQueryBuilder.addProperty(businessKeyProperty, "businessKey");
        }
        return maRequest;
    }

    public IValue constructResponse(String mun, String responseMUN) {
        if (null == responseMUN) {
            responseMUN = mun;
        }
        XmlValue xmlResult = DataValueFactory.createXmlValue();
        xmlResult.setNull();
        Document responseDoc = this.getResponseElement().getDocument();
        Element responseRoot = responseDoc.getRootElement();
        Element responseElem = responseRoot.element("ResponseRoot");
        Element member = responseElem.addElement("member");
        member.addText(responseMUN);
        member.addAttribute("memberUniqueName", mun);
        xmlResult.set(responseRoot.asXML());
        return xmlResult;
    }
}

