/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.ma;

import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.XmlValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.ma4j.framework.MAQueryLog;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.TreeOperatorEnum;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.ma.MAMunValidationException;
import com.cognos.xqe.runtree.ma.XMANode;
import com.cognos.xqe.runtree.olap.OLAPXNodeRuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class XMAMunValidationQuery
extends XMANode {
    private static final String MUN_PARTS_SEPARATOR = "]->:[";
    private static final String TMR_PROVIDER_PART = "[TMR].[";
    private static final String TM1_PROVIDER_PART = "[TM].[";
    private static final String CATALOG = "CATALOG";
    private static final long serialVersionUID = 1L;
    private static final int THREE = 3;
    private transient MetadataConnection mMetadataConnection;
    private List<String> mPaths;
    private String mNamespace;
    private String mModelPart;
    private String mPhysicalPart;
    private final transient Map<String, Pair> mMetadataProviders = new HashMap<String, Pair>();
    private transient ExecutionEnvironment mExecEnvironment;
    private long mStartTime;
    private transient XQELogger mLogger = MAQueryLog.getRuntreeLogger();

    public void setPaths(List<String> paths) {
        this.mPaths = paths;
    }

    @Override
    public IValue executeImpl(XDataContext context) {
        this.mStartTime = System.currentTimeMillis();
        this.mExecEnvironment = (ExecutionEnvironment)context.getEnvironment();
        context.setNodeId(this.getId());
        this.setupResponse();
        List<IModelDataSource> dataSources = this.mMetadataConnection.getModelDataSources();
        if (dataSources.isEmpty()) {
            this.mLogger.log(LogLevel.WARN, "MUN validation is unsupported for the empty models.");
            return this.constructResponse();
        }
        if (!this.prepareMetadataProviders(dataSources)) {
            this.log(LogLevel.TRACE, () -> "MUN validation is supported for the TMR models only.");
            return this.constructResponse();
        }
        int iChanged = 0;
        for (String path : this.mPaths) {
            if (this.isUnsupportedPath(path) || !this.preparePath(path)) {
                this.addResult(path);
                this.log(LogLevel.TRACE, () -> String.format("Skip unsupported path='%s'.", path));
                continue;
            }
            try {
                IOLAPMetadataProvider metadataProvider = this.getMetadataProvider(this.mNamespace);
                MetadataRestriction restrictions = this.buildRestrictions(this.mNamespace);
                List<MemberRecord> members = metadataProvider.getMembers(restrictions);
                if (members.isEmpty()) {
                    this.addResult(path);
                    this.log(LogLevel.TRACE, () -> String.format("Not found the path='%s'.", path));
                    continue;
                }
                MemberRecord member = members.get(0);
                String newPhysicalPart = UniqueNameGenerator.createMemberV5PhysicalPart("TMR", member.getUniqueName());
                String retMun = UniqueNameGenerator.joinModelLogicalPhysicalParts(this.mModelPart, null, newPhysicalPart);
                if (this.addResult(path, retMun)) {
                    this.log(LogLevel.INFO, () -> String.format("MUN substitute '%s' with '%s'.", path, retMun));
                    ++iChanged;
                    continue;
                }
                this.log(LogLevel.TRACE, () -> String.format("Valid MUN='%s'.", path));
            }
            catch (MAMunValidationException maEx) {
                this.addResult(path, maEx);
                this.log(LogLevel.TRACE, () -> String.format("Failed to get the MUN='%s'. Status=%s. Cause=%s", path, maEx.getStatus().getText(), maEx.getCauseMessage()));
            }
            catch (XQERuntimeException ex) {
                this.addResult(path);
                this.mLogger.log(LogLevel.ERROR, String.format("Failed to get the MUN='%s'.", path), (Throwable)ex);
            }
        }
        if (iChanged > 0) {
            return this.constructResponse();
        }
        return this.constructEmptyResponse();
    }

    public void setMetadataConnection(MetadataConnection metadataConnection) {
        this.mMetadataConnection = metadataConnection;
    }

    @Override
    public int getType() {
        return 501209;
    }

    private MetadataRestriction buildRestrictions(String cubeName) {
        MetadataRestriction restrictions = new MetadataRestriction();
        restrictions.add(RestrictionType.CATALOG, CATALOG);
        restrictions.add(RestrictionType.CUBE, cubeName);
        restrictions.add(RestrictionType.FROM, 0);
        restrictions.add(RestrictionType.SIZE, 1);
        restrictions.add(RestrictionType.TREEOP, EnumSet.of(TreeOperatorEnum.SELF));
        restrictions.add(RestrictionType.DATA_QUERY, true);
        restrictions.add(RestrictionType.MUN_VALIDATION_QUERY, true);
        restrictions.add(RestrictionType.MEMBER_UNIQUE_NAME, this.mPhysicalPart);
        return restrictions;
    }

    private IOLAPMetadataProvider getMetadataProvider(IModelDataSource modelDataSource, ExecutionEnvironment execEnvironment) {
        String modelType = modelDataSource.getInterface();
        IDataSource dataSource = execEnvironment.getOrAddDataSource(modelDataSource.getName(), modelDataSource.getCMDataSourceName(), modelType, modelDataSource.getMetadataProperties());
        MetadataQueryArguments arguments = new MetadataQueryArguments(dataSource, execEnvironment, this.mMetadataConnection.getContentLocale());
        IOLAPDataProvider provider = ProviderManager.getInstance().getOLAPProvider(modelType);
        if (provider == null) {
            throw new OLAPXNodeRuntimeException(XQEMessageKeys.EXE_DataProviderNotFound, this.getDataSource().getType());
        }
        return provider.getMetadataProvider(arguments);
    }

    private boolean isUnsupportedPath(String path) {
        return path.indexOf(MUN_PARTS_SEPARATOR) == -1;
    }

    private boolean preparePath(String path) {
        this.mModelPart = UniqueNameGenerator.extractLeftPartFromCognosMUN(path);
        String[] parts = UniqueNameParser.parseNoThrow(this.mModelPart);
        if (null == parts || parts.length != 3 || !this.mMetadataProviders.containsKey(parts[0])) {
            return false;
        }
        this.mNamespace = parts[0];
        String physicalPart = UniqueNameGenerator.extractPhysicalPartFromCognosMUN(path);
        if (physicalPart.startsWith(TMR_PROVIDER_PART)) {
            this.mPhysicalPart = physicalPart.substring(TMR_PROVIDER_PART.length() - 1);
        } else if (physicalPart.startsWith(TM1_PROVIDER_PART)) {
            this.mPhysicalPart = physicalPart.substring(TM1_PROVIDER_PART.length() - 1);
        } else {
            return false;
        }
        parts = UniqueNameParser.parseNoThrow(this.mPhysicalPart);
        return null != parts && parts.length >= 3;
    }

    private void setupResponse() {
        Document document = DocumentHelper.createDocument();
        Element rootElem = document.addElement("response");
        Element responseRootElem = rootElem.addElement("ResponseRoot");
        this.setResponseElement(responseRootElem);
    }

    private boolean addResult(String mun, String responseMUN) {
        Element member = this.getResponseElement().addElement("Path");
        member.addAttribute("name", mun);
        if (responseMUN != null && !responseMUN.equals(mun)) {
            member.addAttribute("substitute", responseMUN);
            return true;
        }
        return false;
    }

    private void addResult(String mun) {
        Element member = this.getResponseElement().addElement("Path");
        member.addAttribute("name", mun);
    }

    private void addResult(String mun, MAMunValidationException exception) {
        Element member = this.getResponseElement().addElement("Path");
        member.addAttribute("name", mun);
        member.addAttribute("status", exception.getStatus().getText());
        member.addAttribute("cause", exception.getCauseMessage());
    }

    private IValue constructResponse() {
        XmlValue xmlResult = DataValueFactory.createXmlValue();
        xmlResult.setNull();
        xmlResult.set(this.getResponseElement().getParent().asXML());
        this.logExecutionTime();
        return xmlResult;
    }

    private IValue constructEmptyResponse() {
        XmlValue xmlResult = DataValueFactory.createXmlValue();
        xmlResult.setNull();
        Document document = DocumentHelper.createDocument();
        Element rootElem = document.addElement("response");
        rootElem.addElement("ResponseRoot");
        xmlResult.set(rootElem.asXML());
        this.logExecutionTime();
        return xmlResult;
    }

    private boolean prepareMetadataProviders(List<IModelDataSource> dataSources) {
        for (IModelDataSource dataSource : dataSources) {
            if (!DataSourceTypeEnum.isTMR(dataSource.getInterface())) {
                return false;
            }
            String cubeName = dataSource.getCube().getUniqueName();
            this.mMetadataProviders.put(cubeName, new Pair(dataSource, null));
        }
        return true;
    }

    private IOLAPMetadataProvider getMetadataProvider(String cubeName) {
        Pair pair = this.mMetadataProviders.get(cubeName);
        if (null == pair) {
            return null;
        }
        if (pair.getSecond() == null) {
            IOLAPMetadataProvider metadataProvider = this.getMetadataProvider((IModelDataSource)pair.getFirst(), this.mExecEnvironment);
            pair.setSecond(metadataProvider);
        }
        return (IOLAPMetadataProvider)pair.getSecond();
    }

    private void log(LogLevel level, Supplier<String> message) {
        if (this.mLogger.isOn(level)) {
            this.mLogger.log(level, message.get());
        }
    }

    private void logExecutionTime() {
        long elapsedTime = System.currentTimeMillis() - this.mStartTime;
        this.log(LogLevel.TRACE, () -> String.format("Finished MA query execution in %d milliseconds.", elapsedTime));
    }
}

