/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.ma;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.XmlValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMultiRequestGateway;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.ma.XMANode;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class XMARequest
extends XMANode {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_MODELPATH = "modelPath";
    private String modelPath;
    private static final String CONNECTION_ID = "connectionID";
    private MetadataConnection connection;

    @Override
    protected IValue executeImpl(XDataContext context) {
        IXQEQueryNode[] children;
        XMARequest validateNode = this;
        int nodeID = ((XQEBaseQueryNode)validateNode).isValidPlannedQuery();
        if (nodeID != -1) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_MAQueryFailed, Integer.toString(nodeID));
        }
        XmlValue result = DataValueFactory.createXmlValue();
        result.setNull();
        context.setProperty("connection", this.connection);
        IMultiRequestGateway gateway = this.connection.getGateway();
        if (null != gateway) {
            context.setProperty("gateway", gateway.getGatewayImpl());
        }
        ArrayList<IValue> responses = new ArrayList<IValue>();
        for (IXQEQueryNode child : children = this.getChildren()) {
            IValue response = ((XNode)child).execute(context);
            responses.add(response);
        }
        Document responseDoc = DocumentHelper.createDocument();
        Element responseElem = responseDoc.addElement("response");
        Element connectionID = responseElem.addElement(CONNECTION_ID);
        connectionID.addAttribute("value", "***");
        for (IValue response : responses) {
            if (response.isNull()) continue;
            XmlValue xmlValue = (XmlValue)response;
            Element el = ((Element)xmlValue.getNode()).element("ResponseRoot");
            el.detach();
            responseElem.add(el);
        }
        result.set((Node)responseDoc.getRootElement());
        return result;
    }

    @Override
    public int getType() {
        return 501108;
    }

    public void setMetadataConnection(MetadataConnection aconnection) {
        this.connection = aconnection;
    }

    public String getModelPath() {
        return this.modelPath;
    }

    public void setModelPath(String theModelPath) {
        this.modelPath = theModelPath;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_MODELPATH, this.modelPath);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.modelPath = inputNode.attributeValue(ATTRIBUTE_MODELPATH);
        ((RequestEnvironment)env.getRequestEnvironment()).setModelPath(this.modelPath);
        if (env.getMetadataConnection() == null && this.modelPath != null) {
            this.connection = MetadataService.getInstance().getConnection("MFW4J", this.modelPath, (IExecutionEnvironment)env.getExecutionEnvironment(), true);
            env.setMetdataConnection(this.connection);
        }
        super.capture(env, inputNode);
    }
}

