/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.ma;

import com.cognos.xqe.data.types.ContextValueType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.exception.RequestCanceledException;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.resultsets.tabular.DimensionColumnInfo;
import com.cognos.xqe.resultsets.tabular.MeasureColumnInfo;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class XMATabularResultSet
extends XResultSetBase
implements ITabularResultSet {
    List<IMember> members = new ArrayList<IMember>();
    XSAPBWIterator iter = null;

    public XMATabularResultSet(XDataContext theContext, List<IMember> theMembers, Integer nodeId) {
        super(theContext, nodeId);
        this.members = theMembers;
        this.iter = new XSAPBWIterator(this.getDataContext(), this.members);
    }

    @Override
    public IScrollableIterator getScrollableTabularIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ITabularIterator getTabularIterator() {
        return this.iter;
    }

    @Override
    public void releaseImpl() {
    }

    private final class XSAPBWIterator
    extends XTabularIterator {
        private static final long serialVersionUID = 1L;
        private int nRows;
        private int index;
        List<IMember> members;
        private RowsetInfo rowSetInfo;
        private ReadWriteLock rowSetInfoLock;

        private XSAPBWIterator(XDataContext context, List<IMember> theMembers) {
            super(context, context.getNodeId());
            this.rowSetInfo = null;
            this.rowSetInfoLock = new ReentrantReadWriteLock();
            this.members = theMembers;
            this.nRows = this.members.size();
            this.index = 0;
        }

        @Override
        public void release() {
            if (null != this.members) {
                this.members.clear();
                this.members = null;
            }
        }

        @Override
        public IRow nextImpl() {
            if (this.index >= this.nRows) {
                return null;
            }
            IRow aRow = this.constructRow();
            ++this.index;
            return aRow;
        }

        private IRow constructRow() {
            int membersOnRow = 1;
            IValue[] values = new IValue[membersOnRow];
            RowValue aRow = DataValueFactory.createRowValue(values);
            IValue aValue = this.members.get(this.index);
            values[membersOnRow - 1] = (IValue)aValue.copy();
            return aRow;
        }

        @Override
        public long getIndex() {
            return this.index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public IRowsetInfo getTabularRowsetInfo() {
            Object contextItem;
            try {
                this.rowSetInfoLock.readLock().lockInterruptibly();
                try {
                    if (this.rowSetInfo != null) {
                        RowsetInfo rowsetInfo = this.rowSetInfo;
                        return rowsetInfo;
                    }
                }
                finally {
                    this.rowSetInfoLock.readLock().unlock();
                }
            }
            catch (InterruptedException ie) {
                throw new RequestCanceledException();
            }
            RowsetInfo aRowSet = new RowsetInfo();
            XSAPBWIterator memberIterator = XMATabularResultSet.this.iter;
            IRow aRow = null;
            aRow = (IRow)memberIterator.next();
            if (aRow != null) {
                IValue[] values = aRow.getColumns();
                for (int i = 0; i < values.length; ++i) {
                    contextItem = (ContextBase)((Object)values[i]);
                    if (((ContextBase)contextItem).contextIsAMember()) {
                        IMember aMember = (IMember)contextItem;
                        aRowSet.addColumnInfo(new DimensionColumnInfo(aMember.getDimension()));
                        continue;
                    }
                    ContextValue aValue = (ContextValue)contextItem;
                    ContextValueType contextValueType = DataTypeFactory.getContextValueType(aValue.getValue().getDataType());
                    aRowSet.addColumnInfo(new MeasureColumnInfo(aValue.getContextMember(), (IDataType)contextValueType));
                }
            }
            try {
                this.rowSetInfoLock.writeLock().lockInterruptibly();
                try {
                    if (this.rowSetInfo != null) {
                        contextItem = this.rowSetInfo;
                        return contextItem;
                    }
                    this.rowSetInfo = aRowSet;
                    contextItem = this.rowSetInfo;
                    return contextItem;
                }
                finally {
                    this.rowSetInfoLock.writeLock().unlock();
                }
            }
            catch (InterruptedException ie) {
                throw new RequestCanceledException();
            }
        }
    }
}

