/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.ma.member.response;

import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.data.model.DataSourceException;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.RollupTypeEnum;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.metadata.record.IDynamicField;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.metadata.record.StringField;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.ma.XMATabularResultSet;
import com.cognos.xqe.runtree.ma.member.response.XMAGenerateMemberResponse;
import com.cognos.xqe.runtree.olap.OLAPXNodeRuntimeException;
import com.cognos.xqe.trace.XQETrace;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import org.dom4j.Element;

public class XMAMemberMetadata
extends XMAGenerateMemberResponse {
    private static final long serialVersionUID = 1L;
    protected static final String ATTRIBUTE_CATALOG = "catalog";
    private String catalog;
    private IRestrictions restrictions = null;

    @Override
    public int getType() {
        return 501107;
    }

    @Override
    public ITabularResultSet executeImpl(XDataContext context) {
        ArrayList<IMember> members;
        TabularHybridResultSet result = null;
        if (this.getDataSource() == null) {
            return null;
        }
        if (this.restrictions == null) {
            XMAMemberMetadata validateNode = this;
            int nodeID = ((XQEBaseQueryNode)validateNode).isValidPlannedQuery();
            throw new XQERuntimeException(XQEMessageKeys.PLN_MAQueryFailed, Integer.toString(nodeID));
        }
        ExecutionEnvironment exeEnvironment = (ExecutionEnvironment)context.getEnvironment();
        context.setNodeId(this.getId());
        MetadataConnection metadataConnection = (MetadataConnection)context.getProperty("connection");
        Locale locale = null;
        if (metadataConnection != null) {
            locale = metadataConnection.getContentLocale();
        }
        MetadataQueryArguments arguments = new MetadataQueryArguments(this.getDataSource(), exeEnvironment, locale);
        IOLAPDataProvider provider = ProviderManager.getInstance().getOLAPProvider(this.getDataSource().getType());
        if (provider == null) {
            throw new OLAPXNodeRuntimeException(XQEMessageKeys.EXE_DataProviderNotFound, this.getDataSource().getType());
        }
        IOLAPMetadataProvider metadataProvider = provider.getMetadataProvider(arguments);
        try {
            String hierarchy = this.restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, null);
            String variable = this.restrictions.getValueOf(RestrictionType.VARIABLE, null);
            if (variable != null && (hierarchy == null || hierarchy.length() == 0)) {
                List<HierarchyRecord> tempHierarchies = metadataProvider.getHierarchies(this.restrictions);
                members = new ArrayList(tempHierarchies.size());
                members = this.convertHierarchiesToMatchMembers(tempHierarchies);
            } else {
                List<MemberRecord> tempMembers = metadataProvider.getMembers(this.restrictions);
                members = new ArrayList(tempMembers.size());
                members = this.convertMetadatMembers(tempMembers);
            }
        }
        catch (DataSourceException dse) {
            IDataSource dataSource = arguments.getDataSource();
            IDataSourceConnection connection = dataSource.getDataSourceConnection();
            connection.invalidateResolvedSignon();
            if (dse.getDataSource() == null) {
                dse.setDataSource(dataSource);
            }
            throw dse;
        }
        finally {
            metadataProvider.release();
        }
        result = new TabularHybridResultSet(context, new XMATabularResultSet(context, members, this.getId()), this.getId());
        if (result == null) {
            throw new OLAPXNodeRuntimeException(XQEMessageKeys.EXE_InvalidSAPBWResultSet, this.getDataSource().getType());
        }
        return result;
    }

    protected List<IMember> convertMetadatMembers(List<MemberRecord> memberRecords) {
        ArrayList<IMember> members = new ArrayList<IMember>(memberRecords.size());
        if (memberRecords.size() == 0) {
            return members;
        }
        MetadataConnection connection = this.getCube().getConnection();
        Iterator<MemberRecord> memberRecordIt = memberRecords.iterator();
        while (memberRecordIt.hasNext()) {
            ILevel level = null;
            Member member = new Member();
            MemberRecord memberRecord = memberRecordIt.next();
            member = this.convertMetadatMember(memberRecord);
            String levelUName = memberRecord.getLevelUniqueName();
            String dimensionUName = memberRecord.getDimensionUniqueName();
            String hierarchyUName = memberRecord.getHierarchyUniqueName();
            int levelNumber = memberRecord.getLevelNumber();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            String defDate = sdf.format(new GregorianCalendar().getTime());
            String keyDate = this.restrictions.getValueOf(RestrictionType.KEY_DATE, defDate);
            DateValue validFrom = this.restrictions.getValueOf(RestrictionType.VALID_FROM, null);
            DateValue validTo = this.restrictions.getValueOf(RestrictionType.VALID_TO, null);
            if (levelUName != null && levelUName.length() != 0) {
                level = this.determineLevel(levelUName, dimensionUName, hierarchyUName, keyDate, validFrom, validTo);
            }
            if (level == null && levelNumber != -1 && (level = this.determineLevel(levelNumber, dimensionUName, hierarchyUName, keyDate, validFrom, validTo)) != null) {
                levelUName = level.getUniqueName();
            }
            if (level != null) {
                member.setLevel(level);
            }
            member.setConnection(connection);
            members.add(member);
        }
        return members;
    }

    private List<IMember> convertHierarchiesToMatchMembers(List<HierarchyRecord> hierarchyRecords) {
        ArrayList<IMember> members = new ArrayList<IMember>(hierarchyRecords.size());
        if (hierarchyRecords.size() == 0) {
            return members;
        }
        MetadataConnection connection = this.getCube().getConnection();
        Iterator<HierarchyRecord> hierarchyRecordIt = hierarchyRecords.iterator();
        while (hierarchyRecordIt.hasNext()) {
            ILevel level = null;
            Member member = new Member();
            HierarchyRecord hierarchyRecord = hierarchyRecordIt.next();
            member = this.convertHierarchyToMatchMember(hierarchyRecord);
            member.setLevel(level);
            member.setConnection(connection);
            members.add(member);
        }
        return members;
    }

    private Member convertMetadatMember(MemberRecord memberRecord) {
        Member member = new Member();
        member.setName(memberRecord.getName());
        member.setUniqueName(memberRecord.getUniqueName());
        member.setCaption(memberRecord.getCaption().toString());
        member.setChildrenCardinality(memberRecord.getChildCardinality());
        member.setDescription(memberRecord.getDescription());
        member.setParentUniqueName(memberRecord.getParentUniqueName());
        member.setParentLevelNumber(memberRecord.getParentLevelNumber());
        member.setUniqueID(memberRecord.getUniqueId());
        member.setRollupType(memberRecord.getRollupType());
        ListIterator<IDynamicField> fieldIter = memberRecord.getDynamicFieldIterator();
        if (DataSourceTypeEnum.isEssbase(this.getCube().getModelDataSource().getInterface()) || DataSourceTypeEnum.isTM(this.getCube().getModelDataSource().getInterface())) {
            StringValue value = DataValueFactory.createStringValue();
            value.set(memberRecord.getName());
            member.setBusinessKey(value);
        }
        boolean isSAP = DataSourceTypeEnum.isSAPBW(this.getCube().getModelDataSource().getInterface());
        boolean isTM = DataSourceTypeEnum.isTM(this.getCube().getModelDataSource().getInterface());
        while (fieldIter.hasNext()) {
            IDynamicField nextField = (IDynamicField)fieldIter.next();
            if (!(nextField instanceof StringField)) continue;
            if (isSAP && nextField.getName().equals("SAP_BUSINESS_KEY") || isTM && nextField.getName().equals("MEMBER_KEY")) {
                StringValue value = DataValueFactory.createStringValue();
                value.set(nextField.stringValue());
                member.setBusinessKey(value);
            }
            member.setProperty(nextField.getName(), nextField.stringValue());
        }
        return member;
    }

    private Member convertHierarchyToMatchMember(HierarchyRecord hierarchyRecord) {
        Member member = new Member();
        member.setName(hierarchyRecord.getName());
        member.setUniqueName(hierarchyRecord.getUniqueName());
        member.setCaption(hierarchyRecord.getCaption().toString());
        member.setChildrenCardinality(hierarchyRecord.getCardinality());
        member.setDescription(hierarchyRecord.getDescription());
        member.setParentUniqueName(hierarchyRecord.getDimensionUniqueName());
        member.setParentLevelNumber(0);
        member.setUniqueID(hierarchyRecord.getUniqueId());
        member.setRollupType(RollupTypeEnum.ROLLUP);
        return member;
    }

    public void capture(PlanningEnvironment env, Element inputNode, ICube theCube, MetadataRestriction memberRestrictions) {
        this.setCatalog(inputNode.attributeValue(ATTRIBUTE_CATALOG));
        String dataSourceName = inputNode.attributeValue("dataSource");
        IDataSource dataSource = ((ExecutionEnvironment)env.getExecutionEnvironment()).getDataSourceByModelName(dataSourceName);
        this.setDataSource(dataSource);
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_CATALOG, this.getCatalog());
        if (this.getDataSource() == null) {
            return;
        }
        trace.attribute("dataSource", this.getDataSource().getName());
        trace.attribute("dataSourceType", this.getDataSource().getType());
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String theCatalog) {
        this.catalog = theCatalog;
    }

    public IRestrictions getRestrictions() {
        return this.restrictions;
    }

    public void setRestrictions(IRestrictions theRestrictions) {
        this.restrictions = theRestrictions;
    }
}

