/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.md.CacheHints;
import com.cognos.xqe.resultsets.md.Cell;
import com.cognos.xqe.resultsets.md.CubeHybridResultSet;
import com.cognos.xqe.resultsets.md.Tuple;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.olap.XCubeResultSet;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Attribute;
import org.dom4j.Element;

public final class XCellMapping
extends XNode {
    private static final long serialVersionUID = 0L;
    private static final String AXISMAPPING_SPEC = "AxisMappingSpec";
    private static final String AXISNUM = "axisNum";
    private static final String TUPLE_POSITION = "tuplePosition";
    private static final String ENDTAG = "endTag";
    private static final String CALC_NAMES = "calcNames";
    private static final String CALC_NEED_ADJUST = "calculationsNeedContextAdjustment";
    private static final String CALC_NAME_SEP = " | ";
    private ArrayList<XAxisMappingSpec> mAxisMappingSpecs = new ArrayList();

    @Override
    public int getType() {
        return 501095;
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        ICubeResultSet sourceResultSet = (ICubeResultSet)((IExecutable)((Object)this.getChild(0))).execute(context);
        XCellMappingResultSet cubeResultSet = new XCellMappingResultSet(context, sourceResultSet, this);
        return new CubeHybridResultSet(context, cubeResultSet, this.getId(), CacheHints.cacheCellsAlways());
    }

    public void addAxisCellMappingSpec(int theAxisNum, int tuplePos, String endTag, ArrayList<String> calcNames) {
        XAxisMappingSpec axisMappingSpec = new XAxisMappingSpec(theAxisNum, tuplePos, endTag, calcNames);
        this.mAxisMappingSpecs.add(axisMappingSpec);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        List axisMappingSpecsList = inputNode.elements(AXISMAPPING_SPEC);
        ListIterator it = axisMappingSpecsList.listIterator();
        while (it.hasNext()) {
            String[] a;
            Element anElement = (Element)it.next();
            int axisNum = Integer.parseInt(anElement.attributeValue(AXISNUM));
            int tuplePos = -1;
            String tuplePosStr = anElement.attributeValue(TUPLE_POSITION);
            if (tuplePosStr != null) {
                tuplePos = Integer.parseInt(tuplePosStr);
            }
            String endTagName = anElement.attributeValue(ENDTAG);
            ArrayList<String> list = null;
            String calcs = anElement.attributeValue(CALC_NEED_ADJUST);
            if (calcs != null && (a = calcs.split(CALC_NAME_SEP)).length > 0) {
                list = new ArrayList<String>();
                for (int i = 0; i < a.length; ++i) {
                    list.add(a[i]);
                }
            }
            this.addAxisCellMappingSpec(axisNum, tuplePos, endTagName, list);
            it.remove();
        }
        super.capture(env, inputNode);
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        for (XAxisMappingSpec spec : this.mAxisMappingSpecs) {
            ArrayList<String> list;
            trace.beginElement(AXISMAPPING_SPEC, -1);
            trace.attribute(AXISNUM, Integer.toString(spec.getAxisNum()));
            int tuplePos = spec.getTuplePosition();
            if (tuplePos != -1) {
                trace.attribute(TUPLE_POSITION, Integer.toString(tuplePos));
                trace.attribute(ENDTAG, spec.getEndTag());
            }
            if ((list = spec.getCalculationNames()) != null) {
                StringBuilder b = new StringBuilder();
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        b.append(CALC_NAME_SEP);
                    }
                    b.append(list.get(i));
                }
                trace.attribute(CALC_NEED_ADJUST, b.toString());
            }
            trace.endElement(-1);
        }
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.mAxisMappingSpecs != null) {
            ctx.elementProperty(AXISMAPPING_SPEC, this.mAxisMappingSpecs);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(AXISMAPPING_SPEC)) {
            Object val = ctx.elementValue(node);
            this.mAxisMappingSpecs = (ArrayList)val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    public final class XCellMappingResultSet
    extends XCubeResultSet {
        protected XAxisMapping[] mAxisMappings;
        protected XCellView mView;

        public void adjustCellValue(long cellOrdinal, ITuple[] tuples) {
            if (this.mView == null) {
                this.mView = new XCellView(this);
            }
            if (cellOrdinal < 0L || cellOrdinal >= this.mView.mCellSize) {
                return;
            }
            if (this.mView.mCellView[(int)cellOrdinal] != null) {
                return;
            }
            long[] axisOrdinalThis = new long[tuples.length];
            this.getAxisOrdinalThis(cellOrdinal, axisOrdinalThis);
            for (int i = 0; i < tuples.length; ++i) {
                XAxisMapping axisMap = this.mAxisMappings[i];
                if (!axisMap.mNeedMapping) continue;
                axisMap.adjustCoordinate(i, axisOrdinalThis, tuples[i]);
            }
            long srcCellOrdinalRemapped = this.computeBaseOrdinal(axisOrdinalThis);
            Long ord = new Long(srcCellOrdinalRemapped);
            this.mView.mCellView[(int)cellOrdinal] = this.mView.mSrcCells.containsKey(ord) ? this.mView.mSrcCells.get(ord) : DoubleValue.NULL_VALUE;
        }

        protected void getAxisOrdinalThis(long thisOrdinal, long[] axisOrdinalThis) {
            for (int i = 0; i < axisOrdinalThis.length; ++i) {
                long axisOrdinal;
                long axisSize = this.getAxisSize(i);
                if (axisSize > 0L) {
                    axisOrdinal = thisOrdinal % axisSize;
                    thisOrdinal /= axisSize;
                } else {
                    return;
                }
                axisOrdinalThis[i] = axisOrdinal;
            }
        }

        protected long computeBaseOrdinal(long[] axisOrdinalThis) {
            long baseOrdinal = 0L;
            long baseSize = 1L;
            for (int i = 0; i < axisOrdinalThis.length; ++i) {
                long baseAxisOrdinal = axisOrdinalThis[i];
                long baseAxisSize = this.mAxisMappings[i].mNumRows;
                if (baseAxisOrdinal >= baseAxisSize) {
                    return -1L;
                }
                if (baseAxisSize <= 0L) {
                    return -1L;
                }
                baseOrdinal += baseAxisOrdinal * baseSize;
                baseSize *= baseAxisSize;
            }
            return baseOrdinal;
        }

        public XCellMappingResultSet(XDataContext theDataContext, ICubeResultSet sourceResultSet, XCellMapping owner) {
            super(theDataContext, sourceResultSet, owner.getId());
            try {
                int numAxes = sourceResultSet.getNumAxes();
                this.mAxisMappings = new XAxisMapping[numAxes];
                for (XAxisMappingSpec spec : owner.mAxisMappingSpecs) {
                    int axisNum = spec.getAxisNum();
                    int tuplePos = spec.getTuplePosition();
                    String endTag = spec.getEndTag();
                    ArrayList<String> calcNames = spec.getCalculationNames();
                    if (endTag == null) {
                        this.mAxisMappings[axisNum] = new XAxisMapping(sourceResultSet, axisNum, tuplePos, true);
                        continue;
                    }
                    this.mAxisMappings[axisNum] = new XAxisMapping(sourceResultSet, tuplePos, endTag, axisNum, false, calcNames);
                }
                for (int i = 0; i < numAxes; ++i) {
                    if (this.mAxisMappings[i] != null) continue;
                    this.mAxisMappings[i] = new XAxisMapping(sourceResultSet, i, -1, false);
                }
            }
            catch (RuntimeException e) {
                this.release();
                throw e;
            }
        }

        @Override
        public long getAxisSize(int axisNumber) {
            XAxisMapping axisMap = this.mAxisMappings[axisNumber];
            if (axisMap.mRealNumRows == -1L) {
                return axisMap.mNumRows;
            }
            return axisMap.mRealNumRows;
        }

        @Override
        public XIterator getAxisIterator(int axisNumber) {
            XAxisMapping axisMap = this.mAxisMappings[axisNumber];
            if (!axisMap.mNeedMapping) {
                return super.getAxisIterator(axisNumber);
            }
            return new XAxisMappingAxisIterator(this.getDataContext(), axisMap, this.nodeId);
        }

        @Override
        public XCellIterator getCellIterator() {
            if (this.mView == null) {
                this.mView = new XCellView(this);
            }
            return new XCellMappingCellIterator(this, this.nodeId);
        }

        protected void cleanAxis() {
            for (int i = 0; i < this.mAxisMappings.length; ++i) {
                XAxisMapping axisMap = this.mAxisMappings[i];
                if (!axisMap.mNeedMapping) continue;
                axisMap.cleanCache();
            }
        }

        private final class XCellMappingCellIterator
        extends XCellIterator {
            XCellMappingResultSet mOwnerResultSet;
            protected long currentIndex;
            protected boolean eod;
            private ICell cellToReturn;
            ICell dummyCellToReturn;

            private XCellMappingCellIterator(XCellMappingResultSet owner, Integer theNodeId) {
                super(owner.getDataContext(), theNodeId);
                this.currentIndex = -1L;
                this.eod = false;
                this.cellToReturn = new Cell(0L, 0.0);
                this.dummyCellToReturn = new Cell(0L, DoubleValue.NULL_VALUE);
                this.mOwnerResultSet = owner;
                if (owner.mView == null || owner.mView.mCellSize == 0L) {
                    this.eod = true;
                }
            }

            @Override
            public boolean hasNext() {
                return !this.eod && this.currentIndex + 1L < this.mOwnerResultSet.mView.mCellSize;
            }

            @Override
            public void release() {
                this.cellToReturn = null;
            }

            @Override
            public long getIndex() {
                return this.currentIndex;
            }

            @Override
            public ICell nextImpl() {
                if (this.eod) {
                    return null;
                }
                if (this.currentIndex + 1L < this.mOwnerResultSet.mView.mCellSize) {
                    ++this.currentIndex;
                    IValue aValue = this.mOwnerResultSet.mView.mCellView[(int)this.currentIndex];
                    if (aValue == null) {
                        this.dummyCellToReturn.setOrdinal(this.currentIndex);
                        return this.dummyCellToReturn;
                    }
                    this.cellToReturn.setOrdinal(this.currentIndex);
                    this.cellToReturn.setValue(aValue);
                    return this.cellToReturn;
                }
                this.currentIndex = -1L;
                this.eod = true;
                this.mOwnerResultSet.cleanAxis();
                return null;
            }

            @Override
            public boolean hasPipelineIterator() {
                return false;
            }
        }

        private final class XAxisMappingAxisIterator
        extends XIterator {
            protected long mNumRows;
            protected boolean eod;
            XAxisMapping mAxisMap;

            private XAxisMappingAxisIterator(XDataContext context, XAxisMapping axisMap, Integer theNodeId) {
                super(context, theNodeId);
                this.eod = false;
                this.mAxisMap = axisMap;
                this.mNumRows = this.mAxisMap.mCachedlTuples.length;
                if (this.mNumRows == 0L) {
                    this.eod = true;
                }
            }

            @Override
            public Object nextImpl() {
                if (this.eod) {
                    return null;
                }
                if (this.currentIndex + 1L < this.mNumRows) {
                    ++this.currentIndex;
                    Tuple t = (Tuple)this.mAxisMap.mCachedlTuples[(int)this.currentIndex];
                    IMember[] r = t.getMembers();
                    IMember[] n = new IMember[r.length];
                    System.arraycopy(r, 0, n, 0, r.length);
                    return new Tuple(n);
                }
                this.currentIndex = -1L;
                this.eod = true;
                return null;
            }

            @Override
            public void release() {
                this.mAxisMap = null;
            }
        }

        private final class XAxisMapping {
            boolean mNeedMapping = true;
            protected long mRealNumRows = -1L;
            protected long mNumRows = 0L;
            protected HashMap<ITuple, Long> mRealCellTuples;
            protected ITuple[] mCachedlTuples;
            protected IMember mLastMember;
            protected int mLastOrdinal = -1;
            protected int mLastTuple = -1;
            protected boolean mRemovedMemberInTuple = false;
            protected ArrayList<String> mCalculationNames = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            XAxisMapping(ICubeResultSet sourceResultSet, int axisNum, int lastTuple, boolean needMapping) {
                this.mNeedMapping = needMapping;
                this.mLastTuple = lastTuple;
                ArrayList<Tuple> list = null;
                if (this.mNeedMapping) {
                    list = new ArrayList<Tuple>();
                }
                XIterator baseIterator = sourceResultSet.getAxisIterator(axisNum);
                try {
                    ITuple aTuple = (ITuple)baseIterator.next();
                    while (aTuple != null) {
                        if (this.mNeedMapping) {
                            IMember[] members = aTuple.getMembers();
                            IMember[] newMembers = (IMember[])members.clone();
                            list.add(new Tuple(newMembers));
                        }
                        ++this.mNumRows;
                        aTuple = (ITuple)baseIterator.next();
                    }
                }
                finally {
                    baseIterator.release();
                }
                if (this.mNeedMapping) {
                    this.mCachedlTuples = new ITuple[list.size()];
                    System.arraycopy(list.toArray(), 0, this.mCachedlTuples, 0, list.size());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            XAxisMapping(ICubeResultSet sourceResultSet, int tuplePos, String endTag, int axisNum, boolean bRemovedMemberInTuple, ArrayList<String> calcName) {
                this.mRemovedMemberInTuple = bRemovedMemberInTuple;
                this.mCalculationNames = calcName;
                XIterator baseIterator = sourceResultSet.getAxisIterator(axisNum);
                try {
                    this.mRealNumRows = 0L;
                    this.mRealCellTuples = new HashMap();
                    ArrayList<Tuple> list = new ArrayList<Tuple>();
                    ITuple aTuple = (ITuple)baseIterator.next();
                    while (aTuple != null) {
                        IMember aMember = aTuple.getMember(tuplePos);
                        if (endTag.equals(aMember.getUniqueName())) {
                            ++this.mNumRows;
                            break;
                        }
                        IMember[] members = aTuple.getMembers();
                        IMember[] newMembers = (IMember[])members.clone();
                        Tuple newTuple = new Tuple(newMembers);
                        list.add(newTuple);
                        ++this.mRealNumRows;
                        this.mRealCellTuples.put(newTuple, new Long(this.mNumRows));
                        ++this.mNumRows;
                        aTuple = (ITuple)baseIterator.next();
                    }
                    this.mCachedlTuples = new ITuple[list.size()];
                    System.arraycopy(list.toArray(), 0, this.mCachedlTuples, 0, list.size());
                    aTuple = (ITuple)baseIterator.next();
                    while (aTuple != null) {
                        IMember[] members = aTuple.getMembers();
                        IMember[] newMembers = (IMember[])members.clone();
                        Tuple newTuple = new Tuple(newMembers);
                        this.mRealCellTuples.put(newTuple, new Long(this.mNumRows));
                        ++this.mNumRows;
                        aTuple = (ITuple)baseIterator.next();
                    }
                }
                finally {
                    baseIterator.release();
                }
            }

            protected void adjustCoordinate(int axisNum, long[] oldOrdinal, ITuple aTuple) {
                int[] offset = new int[1];
                IMember[] origMember = new IMember[1];
                int i = 0;
                if (this.mRealNumRows == -1L) {
                    IMember aMember;
                    if (this.mCachedlTuples != null && (aMember = aTuple.getMember(this.mLastTuple)).isContextMember()) {
                        IMember leafMember = this.getLeafMember(aMember, offset, origMember);
                        if (offset[0] > 0) {
                            if (this.mLastMember != null && this.mLastMember == leafMember) {
                                oldOrdinal[axisNum] = this.mLastOrdinal;
                            } else {
                                for (i = (int)oldOrdinal[axisNum] - offset[0]; i >= 0; --i) {
                                    if (this.mCachedlTuples[i].getMember(this.mLastTuple) != leafMember) continue;
                                    oldOrdinal[axisNum] = i;
                                    this.mLastOrdinal = i;
                                    this.mLastMember = this.mCachedlTuples[i].getMember(this.mLastTuple);
                                    break;
                                }
                            }
                        }
                    }
                } else if (this.mRealCellTuples != null) {
                    Tuple tp;
                    Long coordinate;
                    IMember[] leafMembers = null;
                    if (this.mRemovedMemberInTuple) {
                        ITuple realTuple = this.mCachedlTuples[(int)oldOrdinal[axisNum]];
                        leafMembers = (IMember[])realTuple.getMembers().clone();
                    } else {
                        leafMembers = new IMember[aTuple.size()];
                    }
                    boolean tryUpdate = false;
                    block1: for (i = 0; i < aTuple.size(); ++i) {
                        IMember leafMember;
                        IMember aMember = aTuple.getMember(i);
                        if (this.mRemovedMemberInTuple) {
                            if (!aMember.isContextMember()) continue;
                            origMember[0] = ((ContextMember)aMember).getMember();
                            leafMember = this.getLeafMember(aMember, offset, origMember);
                            if (offset[0] <= 0) continue;
                            tryUpdate = true;
                            for (int j = 0; j < leafMembers.length; ++j) {
                                if (!leafMembers[j].equals(origMember[0])) continue;
                                leafMembers[j] = leafMember;
                                continue block1;
                            }
                            continue;
                        }
                        if (aMember.isContextMember()) {
                            leafMember = this.getLeafMember(aMember, offset, origMember);
                            if (offset[0] > 0) {
                                tryUpdate = true;
                            }
                            leafMembers[i] = leafMember;
                            continue;
                        }
                        leafMembers[i] = aMember;
                    }
                    if (tryUpdate && (coordinate = this.mRealCellTuples.get(tp = new Tuple(leafMembers))) != null) {
                        oldOrdinal[axisNum] = coordinate;
                    }
                }
            }

            protected IMember getLeafMember(IMember aMember, int[] offset, IMember[] origMember) {
                offset[0] = 0;
                ContextMember cMember = (ContextMember)aMember;
                IMember leafMember = cMember.getMember();
                if (cMember.isCalculatedMember() || cMember.isCalculatedMember()) {
                    String calcName = cMember.getMember().getUniqueName();
                    if (this.mCalculationNames == null || !this.mCalculationNames.contains(calcName) || cMember.getContextMember() == null) {
                        return leafMember;
                    }
                    cMember = cMember.getContextMember();
                    origMember[0] = leafMember = cMember.getMember();
                }
                ILevel lvl = leafMember.getLevel();
                int i = 0;
                if (lvl == null) {
                    return leafMember;
                }
                int maxLevelId = lvl.getIndex();
                for (cMember = cMember.getContextMember(); cMember != null; cMember = cMember.getContextMember()) {
                    ++i;
                    IMember theMember = cMember.getMember();
                    lvl = theMember.getLevel();
                    if (maxLevelId >= lvl.getIndex()) continue;
                    maxLevelId = lvl.getIndex();
                    leafMember = theMember;
                    offset[0] = i;
                }
                return leafMember;
            }

            protected void cleanCache() {
                this.mRealCellTuples = null;
                this.mLastMember = null;
            }
        }

        private final class XCellView {
            HashMap<Long, IValue> mSrcCells;
            IValue[] mCellView;
            protected long mCellSize = 1L;

            XCellView(XCellMappingResultSet owner) {
                for (int i = 0; i < owner.mAxisMappings.length; ++i) {
                    this.mCellSize *= owner.getAxisSize(i);
                }
                if (this.mCellSize == 0L) {
                    return;
                }
                this.mSrcCells = new HashMap();
                XCellIterator baseCellIterator = owner.mOlapResultSet.getCellIterator();
                ICell aCell = baseCellIterator.next();
                while (aCell != null) {
                    IValue cellValue = aCell.getValue();
                    this.mSrcCells.put(new Long(aCell.getOrdinal()), cellValue);
                    aCell = baseCellIterator.next();
                }
                baseCellIterator.release();
                baseCellIterator = null;
                if (this.mSrcCells.isEmpty()) {
                    this.mCellSize = 0L;
                } else {
                    this.mCellView = new IValue[(int)this.mCellSize];
                }
            }
        }
    }

    private static final class XAxisMappingSpec
    implements IXQEPersist {
        private int mAxisNum = -1;
        private int mTuplePosition = -1;
        private String mAxisTagName;
        private ArrayList<String> mCalcNames;

        private XAxisMappingSpec(int theAxisNum, int tuplePos, String endTag, ArrayList<String> calcNames) {
            this.mAxisNum = theAxisNum;
            this.mTuplePosition = tuplePos;
            this.mAxisTagName = endTag;
            this.mCalcNames = calcNames;
        }

        public int getAxisNum() {
            return this.mAxisNum;
        }

        public int getTuplePosition() {
            return this.mTuplePosition;
        }

        public String getEndTag() {
            return this.mAxisTagName;
        }

        public ArrayList<String> getCalculationNames() {
            return this.mCalcNames;
        }

        @Override
        public void persist(XQEPersistContext ctx, String optionalName) {
            if (ctx.beginElement(this, optionalName, -1)) {
                this.persistAttributeProperties(ctx);
                this.persistElementProperties(ctx);
                ctx.endElement();
            }
        }

        public void persistAttributeProperties(XQEPersistContext ctx) {
            ctx.property(XCellMapping.AXISNUM, this.mAxisNum);
            ctx.property(XCellMapping.TUPLE_POSITION, this.mTuplePosition);
            ctx.property(XCellMapping.ENDTAG, this.mAxisTagName);
        }

        public void persistElementProperties(XQEPersistContext ctx) {
            if (this.mCalcNames != null) {
                ctx.elementProperty(XCellMapping.CALC_NAMES, this.mCalcNames);
            }
        }

        @Override
        public void restore(XQERestoreContext ctx, Element node) {
            this.restoreAttributes(ctx, node);
            this.restoreChildren(ctx, node);
        }

        public void restoreAttributes(XQERestoreContext ctx, Element node) {
            int size = node.attributeCount();
            for (int i = 0; i < size; ++i) {
                Attribute att = node.attribute(i);
                this.restoreAttributeProperty(ctx, att, node);
            }
        }

        protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
            String attName = att.getName();
            if (attName.equals(XCellMapping.AXISNUM)) {
                Object val = ctx.attributeValue(att);
                this.mAxisNum = (Integer)val;
            } else if (attName.equals(XCellMapping.TUPLE_POSITION)) {
                Object val = ctx.attributeValue(att);
                this.mTuplePosition = (Integer)val;
            } else if (attName.equals(XCellMapping.ENDTAG)) {
                Object val = ctx.attributeValue(att);
                this.mAxisTagName = (String)val;
            }
        }

        protected void restoreChildren(XQERestoreContext ctx, Element node) {
            List childList = node.elements();
            int nChildren = childList.size();
            for (int i = 0; i < nChildren; ++i) {
                Element child = (Element)childList.get(i);
                if (child.getNamespace().getURI().isEmpty()) continue;
                this.restoreElementProperty(ctx, child, node);
            }
        }

        protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
            String pname = node.attributeValue("pname");
            if (pname.equals(XCellMapping.CALC_NAMES)) {
                Object val = ctx.elementValue(node);
                this.mCalcNames = (ArrayList)val;
            }
        }
    }
}

