/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.RequestCanceledException;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultsets.md.CacheHints;
import com.cognos.xqe.resultsets.md.CubeHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.olap.XCubeResultSet;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XDimensionalStore
extends XNode {
    private static final long serialVersionUID = 1L;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private XStorage cacheResult;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private AtomicInteger refCount = new AtomicInteger(0);

    @Override
    protected IValue executeImpl(XDataContext context) {
        try {
            try {
                this.lock.writeLock().lockInterruptibly();
                try {
                    if (this.cacheResult == null) {
                        ICubeResultSet cubeResultSet = (ICubeResultSet)((IExecutable)((Object)this.getChild(0))).execute(context);
                        this.cacheResult = new XStorage(context, cubeResultSet, this.getId());
                    }
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
            catch (InterruptedException e) {
                throw new RequestCanceledException();
            }
            this.refCount.incrementAndGet();
        }
        catch (RuntimeException e) {
            if (this.cacheResult != null) {
                this.cacheResult.release();
            }
            throw e;
        }
        return this.cacheResult;
    }

    @Override
    public int getType() {
        return 501130;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 501130) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        super.restoreAttributeProperty(ctx, att, inputNode);
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        super.restoreElementProperty(ctx, node, inputNode);
    }

    public class XStorage
    extends XCubeResultSet
    implements ICubeResultSet {
        public XStorage(XDataContext theDataContext, ICubeResultSet sourceResultSet, Integer theNodeId) {
            super(theDataContext, new CubeHybridResultSet(theDataContext, sourceResultSet, theNodeId, CacheHints.cacheNone()), theNodeId);
        }

        @Override
        public void release() {
            XDimensionalStore.this.refCount.decrementAndGet();
            if (XDimensionalStore.this.cacheResult != null && XDimensionalStore.this.refCount.get() == 0) {
                try {
                    super.release();
                }
                catch (Exception e) {
                    mErrorLogger.log(e);
                }
                finally {
                    XDimensionalStore.this.cacheResult = null;
                }
            }
        }
    }
}

