/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQEQueryNodeCheckSum;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.olap.MDXDimensionProperties;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.ProviderException;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.MDXQueryArguments;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultsets.md.CacheHints;
import com.cognos.xqe.resultsets.md.CubeHybridResultSet;
import com.cognos.xqe.runtree.IXDataSource;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.olap.MDXQueryFake;
import com.cognos.xqe.runtree.olap.OLAPXNodeRuntimeException;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.XMissingMemberValidate;
import com.cognos.xqe.runtree.olap.querytemplates.CustomQuery;
import com.cognos.xqe.runtree.olap.querytemplates.CustomQueryFactory;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.Flat3Map;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XMdx
extends XNode
implements IXDataSource {
    private static final long serialVersionUID = 23472835723L;
    protected static final String ATTRIBUTE_DATASOURCE = "dataSource";
    protected static final String ATTRIBUTE_CMDATASOURCE = "cmDataSourceName";
    protected static final String ATTRIBUTE_DATASOURCETYPE = "dataSourceType";
    protected static final String ATTRIBUTE_CUBE = "cube";
    protected static final String ATTRIBUTE_CATALOG = "catalog";
    protected static final String ATTRIBUTE_AXISCOUNT = "axisCount";
    protected static final String ATTRIBUTE_ISCONSTANTQUERY = "isConstantQuery";
    protected static final String ELEMENT_MDXTEXT = "MdxText";
    private boolean isConstantQuery;
    protected IDataSource dataSource;
    protected String catalogName;
    protected String cubeName;
    protected String attributeDimensionsAsProperties;
    protected int axisCount;
    protected MDXQuery mdxQuery;
    private boolean useNLDecorationRules = false;
    List<MDXDimensionProperties> dimPropertiesForAncestorQuery = null;
    private CacheHints cachingHints = CacheHints.cacheAll();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IValue executeImpl(XDataContext context) {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("DQExecuteRuntree", this.getNodeTypeName(), ZipiContext.getQRDName());
        try {
            IValue iValue = this.tryToExecute(context);
            return iValue;
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IValue tryToExecute(XDataContext context) {
        IOLAPDataProvider provider;
        ICubeResultSet result = null;
        ExecutionEnvironment execEnv = (ExecutionEnvironment)context.getEnvironment();
        MDXQueryArguments arguments = new MDXQueryArguments(this.dataSource, this.mdxQuery, ((RequestEnvironment)execEnv.getRequestEnvironment()).getRunLocale(), this.mdxQuery.getReferencedCube().getModelDataSource().getConnection().getContentLocale());
        if (execEnv.getDumpMDX()) {
            XQEDebugLog.out.println(this.mdxQuery.getMDX());
        }
        if ((provider = ProviderManager.getInstance().getOLAPProvider(this.dataSource.getType())) == null) {
            throw new OLAPXNodeRuntimeException(XQEMessageKeys.EXE_DataProviderNotFound, this.dataSource.getType());
        }
        XDataContext subContext = execEnv.pushDataContext();
        subContext.setNodeId(this.getId());
        try {
            result = provider.query(subContext, arguments);
        }
        catch (ProviderException xre) {
            if (context.isForValidateMUN()) {
                throw xre;
            }
            this.validateMissingMun(xre, execEnv);
        }
        finally {
            execEnv.popDataContext(subContext);
        }
        if (null == result) {
            throw new OLAPXNodeRuntimeException(XQEMessageKeys.EXE_InvalidMDXResultSet, this.dataSource.getType());
        }
        CubeHybridResultSet resultSet = new CubeHybridResultSet(context, result, this.getId(), this.cachingHints);
        return resultSet;
    }

    public void validateMissingMun(XQERuntimeException xre, ExecutionEnvironment execEnv) {
        XMissingMemberValidate xMMVNode = (XMissingMemberValidate)this.getAncestorOfType(501117);
        if (xMMVNode == null) {
            throw xre;
        }
        xMMVNode.validateMuns(xre, execEnv);
    }

    @Override
    public int getType() {
        return 501017;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 501017) {
            return true;
        }
        return super.isOfCategory(category);
    }

    public String getMdxText() {
        return this.getMdxText(false);
    }

    public String getMdxText(boolean forMasterComparison) {
        return this.mdxQuery.getMDX(forMasterComparison);
    }

    @Override
    public String getQueryText() {
        return this.getMdxText();
    }

    public IDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(IDataSource theDataSource) {
        this.dataSource = theDataSource;
    }

    public String getCatalog() {
        return this.catalogName;
    }

    public void setCatalog(String theCatalog) {
        this.catalogName = theCatalog;
    }

    public String getCube() {
        return this.cubeName;
    }

    public void setCube(String theCubeName) {
        this.cubeName = theCubeName;
    }

    public String getAttributeDimensionsAsProperties() {
        return this.attributeDimensionsAsProperties;
    }

    public void setAttributeDimensionsAsProperties(String theAttributeDimensionsAsProperties) {
        this.attributeDimensionsAsProperties = theAttributeDimensionsAsProperties;
    }

    public MDXQuery getMDXQuery() {
        return this.mdxQuery;
    }

    public void setMDXQuery(MDXQuery theQuery) {
        this.mdxQuery = theQuery;
    }

    public void setAxisCount(int theAxisCount) {
        this.axisCount = theAxisCount;
    }

    public int getAxisCount() {
        return this.axisCount;
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement(this.getNodeTypeName(), -1);
        this.mdxQuery.dumpFormattedXMLQuery(trace);
        trace.endElement();
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        trace.attribute(ATTRIBUTE_DATASOURCE, this.dataSource.getName());
        trace.attribute(ATTRIBUTE_CMDATASOURCE, this.dataSource.getCMDataSourceName());
        trace.attribute(ATTRIBUTE_CATALOG, this.catalogName);
        trace.attribute(ATTRIBUTE_CUBE, this.cubeName);
        trace.attribute(ATTRIBUTE_DATASOURCETYPE, this.dataSource.getType());
        trace.attribute(ATTRIBUTE_AXISCOUNT, this.axisCount);
        if (this.isConstantQuery) {
            trace.attribute(ATTRIBUTE_ISCONSTANTQUERY, this.isConstantQuery);
        }
        if (this.mdxQuery instanceof CustomQuery) {
            this.mdxQuery.dump(trace);
        } else {
            trace.beginElement(ELEMENT_MDXTEXT, -1);
            trace.data(this.getMdxText(true));
            trace.endElement();
        }
    }

    @Override
    public void dump(XQETrace trace, boolean includeRuntimeSpecifics) {
        Integer nodeID = -1;
        if (includeRuntimeSpecifics) {
            nodeID = this.getId();
        }
        trace.beginElement(this.getNodeTypeName(), nodeID);
        this.dumpProperties(trace);
        this.dumpExtraInfo(trace, includeRuntimeSpecifics);
        trace.endElement();
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)env.getExecutionEnvironment();
        this.catalogName = inputNode.attributeValue(ATTRIBUTE_CATALOG);
        this.cubeName = inputNode.attributeValue(ATTRIBUTE_CUBE);
        this.isConstantQuery = inputNode.attributeValue(ATTRIBUTE_ISCONSTANTQUERY) != null;
        String dataSourceType = inputNode.attributeValue(ATTRIBUTE_DATASOURCETYPE);
        if (dataSourceType == null) {
            throw new OLAPXNodeRuntimeException(XQEMessageKeys.EXE_DataSourceTypeNotFound);
        }
        String dataSourceName = inputNode.attributeValue(ATTRIBUTE_DATASOURCE);
        String cmDataSourceName = inputNode.attributeValue(ATTRIBUTE_CMDATASOURCE);
        if (cmDataSourceName == null || cmDataSourceName.length() == 0) {
            cmDataSourceName = dataSourceName;
        }
        StringBuilder modelNameBuffer = new StringBuilder("%TMP%_");
        Flat3Map metadataProps = new Flat3Map();
        modelNameBuffer.append(cmDataSourceName);
        if (null != this.catalogName) {
            metadataProps.put(ATTRIBUTE_CATALOG, this.catalogName);
            modelNameBuffer.append('_').append(this.catalogName);
        }
        if (null != this.cubeName) {
            metadataProps.put(ATTRIBUTE_CUBE, this.cubeName);
            modelNameBuffer.append('_').append(this.cubeName);
        }
        metadataProps.put("interface", dataSourceType);
        metadataProps.put("name", modelNameBuffer.toString());
        IDataSource ds = execEnv.getOrAddDataSource(dataSourceName, cmDataSourceName, dataSourceType, (Map<String, Object>)metadataProps);
        this.setDataSource(ds);
        int numberOfEdges = 0;
        Attribute attribute = inputNode.attribute(ATTRIBUTE_AXISCOUNT);
        if (attribute != null) {
            numberOfEdges = Integer.parseInt(attribute.getValue());
        }
        Element child = (Element)inputNode.elements().get(0);
        String childName = child.getName();
        MetadataConnection connection = MetadataService.getInstance().getConnection("MFW4J", env.getModelPath(), (IExecutionEnvironment)env.getExecutionEnvironment(), true);
        ICube cube = connection.getCube(this.cubeName);
        if (cube == null) {
            throw new OLAPXNodeRuntimeException(XQEMessageKeys.EXE_CubeNotFound, this.cubeName);
        }
        CustomQuery aQuery = CustomQueryFactory.createCustomQuery(childName, cube);
        if (aQuery == null) {
            MDXQueryFake fakeQuery = new MDXQueryFake(child.getStringValue(), cube);
            fakeQuery.setNumberOfEdges(numberOfEdges);
            this.mdxQuery = fakeQuery;
        } else {
            aQuery.capture(env, child);
            this.mdxQuery = aQuery;
        }
        Attribute nodeIdAttribute = inputNode.attribute("id");
        if (nodeIdAttribute != null) {
            this.setNodeId(XQEIntegerPool.getInteger(Integer.parseInt(nodeIdAttribute.getValue())));
        }
    }

    public void computeCheckSum(XQEQueryNodeCheckSum checkSum) {
        checkSum.compute(this.mdxQuery);
    }

    @Override
    public int isValidPlannedQuery() {
        return -1;
    }

    @Override
    public int isRSAPISupportedQuery() {
        if (this.mdxQuery.isExecutionNotSupported()) {
            return this.getId();
        }
        return -1;
    }

    @Override
    protected void endTrace(XQETrace trace, IValue retVal) {
        if (!this.mdxQuery.isQueryIntentMetadata()) {
            super.endTrace(trace, retVal);
        }
    }

    @Override
    protected void beginTrace(XQETrace trace, String nodeTypeName, Integer id) {
        if (!this.mdxQuery.isQueryIntentMetadata()) {
            super.beginTrace(trace, nodeTypeName, id);
        }
    }

    @Override
    public void copyContentTo(IXQENodeFactory nodeFactory, IXQEQueryNode node) {
        super.copyContentTo(nodeFactory, node);
        XMdxLocal copy = (XMdxLocal)node;
        copy.setCube(this.cubeName);
        copy.setDataSource(this.dataSource);
        copy.setCatalog(this.catalogName);
        copy.setMDXQuery(this.mdxQuery);
        copy.setAxisCount(this.axisCount);
        copy.setAttributeDimensionsAsProperties(this.attributeDimensionsAsProperties);
        copy.setDataSource(this.dataSource);
    }

    public void setCacheHints(CacheHints hints) {
        if (hints != null) {
            this.cachingHints = hints;
        }
    }

    public List<MDXDimensionProperties> getDimPropertiesForAncestorQuery() {
        return this.dimPropertiesForAncestorQuery;
    }

    public void setDimPropertiesForAncestorQuery(List<MDXDimensionProperties> aDimensionPropertiesList) {
        this.dimPropertiesForAncestorQuery = aDimensionPropertiesList;
    }

    public boolean isConstantQuery() {
        return this.isConstantQuery;
    }

    public void setIsConstantQuery(boolean b) {
        this.isConstantQuery = b;
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        super.restoreAttributeProperty(ctx, att, inputNode);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        super.restoreElementProperty(ctx, node, inputNode);
    }
}

