/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap;

import com.cognos.xqe.data.providers.filedatasource.GenericDataSourceManager;
import com.cognos.xqe.data.providers.filedatasource.IGenericDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.MDXQueryFake;
import com.cognos.xqe.runtree.olap.OLAPXNodeRuntimeException;
import com.cognos.xqe.runtree.olap.XMdx;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XMdxTest
extends XMdx {
    static final long serialVersionUID = 2L;

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        int numberOfEdges = 0;
        if (env.getModelPath() != null) {
            throw new OLAPXNodeRuntimeException(XQEMessageKeys.EXE_DataSourceNotFound);
        }
        String dataSourceName = inputNode.attributeValue("dataSource");
        GenericDataSourceManager dataSourceMgr = GenericDataSourceManager.getInstance();
        IGenericDataSource userDataSource = dataSourceMgr.findDataSource(dataSourceName);
        if (userDataSource == null) {
            throw new OLAPXNodeRuntimeException(XQEMessageKeys.EXE_DataSourceNotFound);
        }
        if (userDataSource.getType() == null) {
            throw new OLAPXNodeRuntimeException(XQEMessageKeys.EXE_DataSourceTypeNotFound);
        }
        Map<String, Object> metadataProps = userDataSource.getMetadataProperties();
        this.catalogName = userDataSource.getCatalogName();
        if (null == this.catalogName && this.catalogName.length() != 0) {
            throw new OLAPXNodeRuntimeException(XQEMessageKeys.EXE_CatalogNotFound);
        }
        metadataProps.put("catalog", this.catalogName);
        this.cubeName = userDataSource.getCubeName();
        if (null == this.cubeName && this.cubeName.length() != 0) {
            throw new OLAPXNodeRuntimeException(XQEMessageKeys.EXE_CubeNotFound, "");
        }
        metadataProps.put("cube", this.cubeName);
        this.setDataSource(userDataSource);
        Attribute attribute = inputNode.attribute("axisCount");
        if (attribute != null) {
            numberOfEdges = Integer.parseInt(attribute.getValue());
        }
        Element child = (Element)inputNode.elements().get(0);
        MDXQueryFake fakeQuery = new MDXQueryFake(child.getStringValue(), null, dataSourceName);
        fakeQuery.setNumberOfEdges(numberOfEdges);
        this.setMDXQuery(fakeQuery);
        Attribute nodeIdAttribute = inputNode.attribute("id");
        if (nodeIdAttribute != null) {
            this.setNodeId(XQEIntegerPool.getInteger(Integer.parseInt(nodeIdAttribute.getValue())));
        }
    }
}

