/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5Exp.V5MemberUniqueName;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.ResponseMessageFolder;
import com.cognos.xqe.query.missingMember.MissingMember;
import com.cognos.xqe.query.missingMember.MissingMemberException;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.olap.XMdx;
import com.cognos.xqe.runtree.olap.querytemplates.CustomQuery;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.v5.util.V5SubQueryBuilder;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class XMissingMemberValidate
extends XNode {
    private static final long serialVersionUID = 0L;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    @Override
    public int getType() {
        return 501117;
    }

    @Override
    public int isRSAPISupportedQuery() {
        return -1;
    }

    public void validateMuns(ExecutionEnvironment execEnv) {
        this.validateMuns(null, execEnv);
    }

    public void validateMuns(XQERuntimeException xqeRuntimeException, ExecutionEnvironment execEnv) {
        XMissingMemberValidate xMMVNode = this;
        int[] types = new int[]{501017, 501053};
        IXQEQueryNode[] listOfXMdxNodes = xMMVNode.getDescendantsOfTypes(types, false);
        for (int i = 0; i < listOfXMdxNodes.length; ++i) {
            XMdx thisMdx = (XMdx)listOfXMdxNodes[i];
            if (thisMdx == null) continue;
            this.validateMun(thisMdx, execEnv);
        }
        if (this.hasMissingMuns(execEnv)) {
            this.throwMissingMemberException(xqeRuntimeException, execEnv);
        } else if (null != xqeRuntimeException) {
            throw xqeRuntimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateMun(XMdx aMdx, ExecutionEnvironment execEnv) {
        if (aMdx.getMDXQuery() == null) {
            return;
        }
        if (aMdx.getMDXQuery() instanceof CustomQuery) {
            return;
        }
        RequestEnvironment reqEnv = (RequestEnvironment)execEnv.getRequestEnvironment();
        MDXQuery mdxQuery = aMdx.getMDXQuery();
        Map<String, MissingMember> missingMemberList = reqEnv.getRequestMissingMembers();
        Map<String, V5MemberUniqueName> munList = reqEnv.getV5Muns();
        String queryName = mdxQuery.getRefQueryProperty();
        String providerCode = mdxQuery.getDataSourceType();
        for (Map.Entry<String, V5MemberUniqueName> entry : munList.entrySet()) {
            PlanningEnvironment subQueryPlanEnv = V5SubQueryBuilder.createPlanningEnvironment(execEnv, (PlanningEnvironment)aMdx.getPlanningEnvironment());
            ExecutionEnvironment subQueryExecEnv = (ExecutionEnvironment)subQueryPlanEnv.getExecutionEnvironment();
            MultiRequestContext multiRequestContext = QueryEngine.getInstance().configureMultiRequestContext(reqEnv, null);
            ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(subQueryExecEnv);
            multiRequestContext.incrementRefCount();
            V5MemberUniqueName mun = entry.getValue();
            String dataItemName = (String)mun.getPropertyValue("dataItemName");
            PlannedV5QuerySet plannedQuery = V5SubQueryBuilder.planSingleExpressionQuery(mun.getNativeName(), subQueryPlanEnv, false);
            if (plannedQuery == null) {
                XQEDebugLog.err.println("Error creating single member expression sub-query " + mun.getNativeName());
                return;
            }
            IHybridResultSet set = null;
            try {
                XDataContext subContext = subQueryExecEnv.pushDataContext();
                subContext.flagIsForValidateMUN();
                try {
                    BaseMember member;
                    set = V5SubQueryBuilder.executeSubQuery(subContext, plannedQuery);
                    Map<String, MissingMember> missingMUNs = this.analyzeMun(subQueryPlanEnv, set, mun, queryName, dataItemName, providerCode, member = XMissingMemberValidate.getBaseMemberFromMissingMemberSubQuery(plannedQuery));
                    if (missingMUNs == null) continue;
                    missingMemberList.putAll(missingMUNs);
                }
                catch (Throwable t) {
                    XMissingMemberValidate.collectMissingMembers(mun, dataItemName, queryName, missingMemberList);
                    mErrorLogger.log(t);
                }
                finally {
                    subQueryExecEnv.popDataContext(subContext);
                    if (set == null) continue;
                    set.release();
                }
            }
            catch (Throwable t) {
                mErrorLogger.log(t);
            }
            finally {
                multiRequestContext.decrementRefCount();
                executionEnvironmentContext.exit();
            }
        }
    }

    public static void collectMissingMembers(V5MemberUniqueName v5Mun, String dataItemName, String queryName, Map<String, MissingMember> missingMemberList) {
        MissingMember mm = new MissingMember();
        mm.setQueryName(queryName);
        mm.setRefDataItem(dataItemName);
        String mun = v5Mun.getNativeName();
        missingMemberList.put(mun, mm);
    }

    public boolean hasMissingMuns(ExecutionEnvironment execEnv) {
        Map<String, MissingMember> missingMembers = ((RequestEnvironment)execEnv.getRequestEnvironment()).getRequestMissingMembers();
        return !missingMembers.isEmpty();
    }

    private void throwMissingMemberException(XQERuntimeException cause, ExecutionEnvironment execEnv) {
        RequestEnvironment reqEnv = (RequestEnvironment)execEnv.getRequestEnvironment();
        String munToThrow = null;
        int aSeverity = 0;
        Map<String, MissingMember> missingMembers = reqEnv.getRequestMissingMembers();
        for (Map.Entry<String, MissingMember> entry : missingMembers.entrySet()) {
            String mun;
            munToThrow = mun = entry.getKey();
            reqEnv.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.PLN_MissingMembers, mun));
        }
        MissingMemberException missingMemberException = null != cause ? new MissingMemberException(reqEnv, cause, munToThrow) : new MissingMemberException(reqEnv, munToThrow);
        throw missingMemberException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, MissingMember> analyzeMun(PlanningEnvironment planEnv, IHybridResultSet set, V5MemberUniqueName mun, String queryName, String dataItemName, String providerCode, BaseMember baseMember) {
        IMember theMember = null;
        TreeMap<String, MissingMember> missingMemberList = null;
        String providerMunReturned = null;
        if (baseMember == null) {
            return missingMemberList;
        }
        try {
            theMember = V5SubQueryBuilder.getMemberFromSubQuery(set);
        }
        catch (Throwable t) {
            missingMemberList = new TreeMap<String, MissingMember>();
            XMissingMemberValidate.collectMissingMembers(mun, dataItemName, queryName, missingMemberList);
            mErrorLogger.log(t);
        }
        finally {
            set.release();
        }
        if (theMember != null) {
            String baseMemberName;
            String theMemberLevelName;
            String memberLevelName;
            ILevel baseMemberLevel = baseMember.getLevel();
            ILevel theMemberLevel = theMember.getLevel();
            if (baseMemberLevel != null && theMemberLevel == null) {
                missingMemberList = new TreeMap();
                XMissingMemberValidate.collectMissingMembers(mun, dataItemName, queryName, missingMemberList);
            }
            if (baseMemberLevel != null && theMemberLevel != null && !(memberLevelName = baseMemberLevel.getUniqueName()).equals(theMemberLevelName = theMemberLevel.getUniqueName())) {
                missingMemberList = new TreeMap();
                XMissingMemberValidate.collectMissingMembers(mun, dataItemName, queryName, missingMemberList);
            }
            if (!(providerMunReturned = theMember.getUniqueName()).equals(baseMemberName = baseMember.getUniqueName())) {
                String leftPart = UniqueNameGenerator.extractLeftPartFromCognosMUN(mun.getNativeName());
                String newMun = UniqueNameGenerator.joinModelPhysicalParts(leftPart, UniqueNameGenerator.createMemberV5PhysicalPart(providerCode, providerMunReturned));
                ResponseMessageFolder messageFolder = planEnv.getResponseMessageFolder();
                ResponseMessage memberWarning = new ResponseMessage(1, ResponseMessage.ResponseMessageType.TYPE_EXEC_STAT_INT, XQEMessageKeys.WRN_ProviderReturnedDifferentMUN, mun.getNativeName(), newMun, queryName, dataItemName);
                messageFolder.appendPlanningResponseMessage(memberWarning);
            }
        } else {
            missingMemberList = new TreeMap();
            XMissingMemberValidate.collectMissingMembers(mun, dataItemName, queryName, missingMemberList);
        }
        return missingMemberList;
    }

    public static BaseMember getBaseMemberFromMissingMemberSubQuery(PlannedV5QuerySet plannedQuery) {
        BaseMember member = null;
        List<IXQEQueryNode> mdxQueries = plannedQuery.getDescendantsOfCategory(501017, true);
        XMdx mdxNode = (XMdx)mdxQueries.get(0);
        MDXQuery mdxQuery = mdxNode.getMDXQuery();
        if (mdxQuery == null) {
            return member;
        }
        MDXEdge[] edges = mdxQuery.getEdges();
        ArrayList<BaseMember> listOfMembers = new ArrayList<BaseMember>();
        for (MDXEdge edge : edges) {
            List<IXQEQueryNode> members = edge.getDescendantsOfCategory(1067, false);
            for (IXQEQueryNode bMember : members) {
                BaseMember mdxMember = (BaseMember)bMember;
                IHierarchy hierarchy = mdxMember.getHierarchy();
                if (hierarchy == null || hierarchy.getDimension() == null || hierarchy.getDimension().isMeasuresDimension()) continue;
                listOfMembers.add(mdxMember);
            }
        }
        if (listOfMembers.size() != 1) {
            plannedQuery.throwInternalError("Missing member validate mun query has more than 1 member, this is not expected.");
        }
        member = (BaseMember)listOfMembers.get(0);
        return member;
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        return ((XNode)this.getChild(0)).execute(context);
    }
}

