/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.decoration;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.runtree.olap.decoration.AbstractOLAPDecorationRules;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class OLAPEmptyRowDecorationRules
extends AbstractOLAPDecorationRules {
    private static final String HEADER_NAME = "header";
    private static final String GROUP_BODY_NAME = "groupBody";
    private static final String FOOTER_NAME = "footer";
    private static final String EMPTY_ROWSET_ID = "emptyRowsetId";
    private static final String STRING_ROWSET_EDGE_ORDINAL = "edgeOrdinal";
    private static final String TYPE = "type";
    private EmptyRowEnum emptyRowType;
    private RSAPIRowset emptyRowRowset;

    @Override
    protected void dumpAdditionalAttributes(XQETrace trace) {
        trace.attribute(EMPTY_ROWSET_ID, this.emptyRowRowset.getRowsetId());
        trace.attribute(TYPE, this.emptyRowType.toString());
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode, int edgeOrdinal) {
        super.capture(env, inputNode, edgeOrdinal);
        String attribute = inputNode.attributeValue(EMPTY_ROWSET_ID);
        if (attribute != null) {
            this.emptyRowRowset = OLAPEmptyRowDecorationRules.getRowset(attribute, edgeOrdinal);
        }
        if ((attribute = inputNode.attributeValue(TYPE)) != null) {
            if (HEADER_NAME.equals(attribute)) {
                this.emptyRowType = EmptyRowEnum.HEADER;
            } else if (GROUP_BODY_NAME.equals(attribute)) {
                this.emptyRowType = EmptyRowEnum.GROUP_BODY;
            } else if (FOOTER_NAME.equals(attribute)) {
                this.emptyRowType = EmptyRowEnum.FOOTER;
            } else {
                throw new IllegalStateException();
            }
        }
    }

    protected RSAPIRowset getEmptyRowset() {
        return this.emptyRowRowset;
    }

    public void setEmptyRowset(RSAPIRowset rowset) {
        this.emptyRowRowset = rowset;
    }

    public EmptyRowEnum getEmptyRowType() {
        return this.emptyRowType;
    }

    public void setEmptyRowType(EmptyRowEnum enumType) {
        this.emptyRowType = enumType;
    }

    public boolean isEmptyRowDecorationRules() {
        return true;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(EMPTY_ROWSET_ID, this.emptyRowRowset.getRowsetId());
        if (this.emptyRowRowset != null && this.emptyRowRowset.getEdge() != null) {
            ctx.property(STRING_ROWSET_EDGE_ORDINAL, this.emptyRowRowset.getEdge().getPositionalOrdinal());
        }
        ctx.property(TYPE, this.emptyRowType.toString());
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(EMPTY_ROWSET_ID)) {
            int edgeOrdinal;
            RSAPIEdge edge;
            Object value = ctx.attributeValue(att);
            RSAPIDataset ds = ctx.getDataset();
            Attribute edgeOrdinalAttr = inputNode.attribute("rowsetEdgeOrdinal");
            if (ds != null && edgeOrdinalAttr != null && (edge = ds.getEdge(edgeOrdinal = ((Integer)ctx.attributeValue(edgeOrdinalAttr)).intValue())) != null) {
                RSAPIEdgeRowset rowset = edge.getRowset((Integer)value);
                this.emptyRowRowset = rowset;
            }
        } else if (attname.equals(EMPTY_ROWSET_ID)) {
            Object value = ctx.attributeValue(att);
            this.emptyRowType = EmptyRowEnum.parse((String)value);
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    public static final class EmptyRowEnum {
        public static final EmptyRowEnum HEADER = new EmptyRowEnum("header");
        public static final EmptyRowEnum GROUP_BODY = new EmptyRowEnum("groupBody");
        public static final EmptyRowEnum FOOTER = new EmptyRowEnum("footer");
        private String name;

        private EmptyRowEnum(String label) {
            this.name = label;
        }

        public String toString() {
            return this.name;
        }

        public static EmptyRowEnum parse(String value) {
            EmptyRowEnum result = null;
            if (value.equals(HEADER.toString())) {
                result = HEADER;
            } else if (value.equals(GROUP_BODY.toString())) {
                result = GROUP_BODY;
            } else if (value.equals(FOOTER.toString())) {
                result = FOOTER;
            }
            return result;
        }
    }
}

