/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.decoration;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.md.CacheHints;
import com.cognos.xqe.resultsets.md.Cell;
import com.cognos.xqe.resultsets.md.CubeHybridResultSet;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.XScrollableIterator;
import com.cognos.xqe.runtree.olap.XCellMapping;
import com.cognos.xqe.runtree.olap.decoration.DecorationResultSet;
import com.cognos.xqe.runtree.olap.decoration.EdgeOrdinalMapping;
import com.cognos.xqe.runtree.olap.decoration.XOLAPEdgeDecoration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;

public class XOLAPComputeCellOrdinalDecoration
extends XOLAPEdgeDecoration {
    private static final long serialVersionUID = 0L;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private int numAxesInBaseResult = 0;

    @Override
    public int getType() {
        return 501027;
    }

    @Override
    protected DecorationResultSet executeImpl(XDataContext context, ICubeResultSet cubeResult) {
        this.numAxesInBaseResult = cubeResult.getNumAxes();
        return new ComputeCellOrdinalResultSet(context, cubeResult, this);
    }

    @Override
    public void release() {
        super.release();
    }

    @Override
    protected CacheHints getCacheHints() {
        CacheHints cacheHints = CacheHints.cacheCellsOnly();
        for (int i = 0; i <= this.numAxesInBaseResult - 2; ++i) {
            cacheHints.setUseAxis(i);
        }
        return cacheHints;
    }

    private class ComputeCellOrdinalResultSet
    extends DecorationResultSet {
        private XCellMapping.XCellMappingResultSet theCellMappingResultSet;
        protected EdgeOrdinalMapping[] tupleOrdinalMaps;

        ComputeCellOrdinalResultSet(XDataContext context, ICubeResultSet result, XOLAPEdgeDecoration owner) {
            super(context, result, owner);
            int numAxes = result.getNumAxes();
            this.tupleOrdinalMaps = new EdgeOrdinalMapping[numAxes];
            XNode childNode = (XNode)owner.getChild(0);
            if (childNode.isDecorationNode()) {
                for (int i = 0; i < numAxes; ++i) {
                    this.tupleOrdinalMaps[i] = context.getCoordinateMappings(childNode, i);
                    if (this.tupleOrdinalMaps[i] != null) continue;
                    this.tupleOrdinalMaps[i] = new EdgeOrdinalMapping(null);
                }
            } else {
                EdgeOrdinalMapping edgeMap = new EdgeOrdinalMapping(null);
                for (int i = 0; i < numAxes; ++i) {
                    this.tupleOrdinalMaps[i] = edgeMap;
                }
            }
            if (result instanceof CubeHybridResultSet) {
                DecorationResultSet decoResult;
                CubeHybridResultSet theResult = (CubeHybridResultSet)result;
                do {
                    if (!(theResult.getDimensionalResult() instanceof XCellMapping.XCellMappingResultSet)) continue;
                    this.theCellMappingResultSet = (XCellMapping.XCellMappingResultSet)theResult.getDimensionalResult();
                    break;
                } while (theResult.getDimensionalResult() instanceof DecorationResultSet && (decoResult = (DecorationResultSet)theResult.getDimensionalResult()).getBaseResultSet() != null && decoResult.getBaseResultSet() instanceof CubeHybridResultSet && (theResult = (CubeHybridResultSet)decoResult.getBaseResultSet()) != null);
            }
        }

        @Override
        public XCellIterator getCellIterator() {
            RSAPIDataset dataset = (RSAPIDataset)this.parentNode.getAncestorOfType(401005);
            return new MappedCellIterator(this, XOLAPComputeCellOrdinalDecoration.this.getId(), dataset.hasNonDetailGroupBody());
        }

        @Override
        public XScrollableCellIterator getScrollableCellIterator() {
            IXQEQueryNode xCellMapping = XOLAPComputeCellOrdinalDecoration.this.getFirstDescendantOfTypeOrdered(501095, false);
            if (xCellMapping != null) {
                throw new UnsupportedOperationException();
            }
            ICubeResultSet baseResultSet = this.getBaseResultSet();
            XScrollableCellIterator baseScrollableCellIterator = baseResultSet.getScrollableCellIterator();
            if (baseScrollableCellIterator.hasPipelineIterator()) {
                throw new UnsupportedOperationException();
            }
            return new ScrollableCellIterator(this, XOLAPComputeCellOrdinalDecoration.this.getId(), baseScrollableCellIterator);
        }

        @Override
        public void releaseImpl() {
            this.tupleOrdinalMaps = null;
            super.releaseImpl();
        }
    }

    private final class MappedCellIterator
    extends XCellIterator {
        private long[] axisPositions;
        private long[] axisSizes;
        private ITuple[] currentTuples;
        private XScrollableIterator[] axisIterators;
        private XCellIterator cellIterator;
        private boolean eod;
        private ICell cellCache;
        private long currentCellOrdinal;
        private boolean hasNext;
        private boolean nextCalled;
        private boolean hasNextCalled;
        private ICell nextCell;
        private DecorationResultSet resultSet;
        private EdgeOrdinalMapping[] tupleOrdinalMaps;
        private boolean usingReverseTupleMap;

        private MappedCellIterator(ComputeCellOrdinalResultSet result, Integer theNodeId, boolean hasNonDetailGroupBody) {
            super(result.getDataContext(), theNodeId);
            this.eod = false;
            this.currentCellOrdinal = -1L;
            this.hasNext = false;
            this.nextCalled = true;
            this.hasNextCalled = false;
            this.nextCell = null;
            this.usingReverseTupleMap = false;
            try {
                this.resultSet = result;
                int numAxes = this.resultSet.getNumAxes();
                if (numAxes == 0) {
                    this.eod = true;
                    return;
                }
                this.axisPositions = new long[numAxes];
                this.axisIterators = new XScrollableIterator[numAxes];
                this.axisSizes = new long[numAxes];
                this.currentTuples = new ITuple[numAxes];
                ICubeResultSet sourceResult = this.resultSet.getBaseResultSet();
                if (hasNonDetailGroupBody) {
                    this.tupleOrdinalMaps = result.tupleOrdinalMaps;
                } else {
                    this.usingReverseTupleMap = true;
                    this.tupleOrdinalMaps = new EdgeOrdinalMapping[result.tupleOrdinalMaps.length];
                    for (int i = 0; i < result.tupleOrdinalMaps.length; ++i) {
                        this.tupleOrdinalMaps[i] = result.tupleOrdinalMaps[i].createReverseMapping();
                    }
                }
                this.cellIterator = sourceResult.getCellIterator();
                int numAxesMinusOne = numAxes - 1;
                for (int i = 0; i < numAxes; ++i) {
                    this.axisIterators[i] = sourceResult.getScrollableAxisIterator(i);
                    this.currentTuples[i] = (ITuple)this.axisIterators[i].next();
                    if (i == numAxesMinusOne) {
                        this.axisSizes[i] = -1L;
                        if (this.currentTuples[i] != null) continue;
                        this.eod = true;
                        return;
                    }
                    long axisSize = sourceResult.getAxisSize(i);
                    if (axisSize == 0L) {
                        this.eod = true;
                        continue;
                    }
                    this.loadSourceTupleCount(i);
                }
                if (!this.cellIterator.hasPipelineIterator() && !this.cellIterator.hasNext()) {
                    this.eod = true;
                }
            }
            catch (RuntimeException e) {
                this.release();
                throw e;
            }
        }

        private ICell getNextCell() {
            if (this.cellIterator.hasNext()) {
                return this.cellIterator.next();
            }
            return null;
        }

        private ICell fetchNext() {
            ICell aCell = null;
            while (aCell == null) {
                if (this.usingReverseTupleMap) {
                    if (this.eod) {
                        return null;
                    }
                    aCell = this.getNextCell();
                    if (aCell == null) {
                        this.eod = true;
                        return null;
                    }
                    long cellOrdinal = this.computeCellOrdinalFromSourceCellOrdinal(aCell.getOrdinal());
                    if (cellOrdinal == -1L) continue;
                    if (((ComputeCellOrdinalResultSet)this.resultSet).theCellMappingResultSet != null) {
                        ((ComputeCellOrdinalResultSet)this.resultSet).theCellMappingResultSet.adjustCellValue(cellOrdinal, this.currentTuples);
                    }
                    this.currentCellOrdinal = cellOrdinal;
                } else {
                    if (this.eod && this.currentTuples == null) {
                        return null;
                    }
                    ITuple aTuple = this.currentTuples[XOLAPComputeCellOrdinalDecoration.this.getEdgeOrdinal()];
                    if (this.eod && aTuple == null) {
                        return null;
                    }
                    long cellOrdinal = this.computeCellOrdinal();
                    if (((ComputeCellOrdinalResultSet)this.resultSet).theCellMappingResultSet != null) {
                        ((ComputeCellOrdinalResultSet)this.resultSet).theCellMappingResultSet.adjustCellValue(cellOrdinal, this.currentTuples);
                    }
                    ++this.currentCellOrdinal;
                    aCell = this.getCell(cellOrdinal);
                    if (aCell == null) {
                        this.advanceToNextTuple(0);
                        continue;
                    }
                    this.advanceToNextTuple(0);
                }
                return new Cell(this.currentCellOrdinal, aCell.getValue());
            }
            return null;
        }

        private void advanceToNextTuple(int edgeOrdinal) {
            if (edgeOrdinal >= this.axisIterators.length) {
                this.eod = true;
                return;
            }
            this.currentTuples[edgeOrdinal] = (ITuple)this.axisIterators[edgeOrdinal].next();
            if (this.currentTuples[edgeOrdinal] != null) {
                int n = edgeOrdinal;
                this.axisPositions[n] = this.axisPositions[n] + 1L;
            } else {
                this.advanceToNextTuple(edgeOrdinal + 1);
                if (!this.eod) {
                    this.axisPositions[edgeOrdinal] = 0L;
                    this.axisIterators[edgeOrdinal].reset();
                    this.currentTuples[edgeOrdinal] = (ITuple)this.axisIterators[edgeOrdinal].next();
                }
            }
        }

        private void loadSourceTupleCount(int axisOrdinal) {
            XOLAPEdgeDecoration childNode = (XOLAPEdgeDecoration)XOLAPComputeCellOrdinalDecoration.this.getChild(0);
            long sourceTupleCount = childNode.getSourceTupleCount(axisOrdinal);
            if (sourceTupleCount == -1L) {
                sourceTupleCount = this.resultSet.getBaseResultSet().getAxisSize(axisOrdinal);
            }
            this.axisSizes[axisOrdinal] = sourceTupleCount;
        }

        private long computeCellOrdinal() {
            return this.calculateOffset(this.axisIterators.length - 1);
        }

        private long computeCellOrdinalFromSourceCellOrdinal(long cellOrdinal) {
            long[] axisOrdinals = this.computeEdgeOrdinalsFromCellOrdinal(cellOrdinal);
            return this.calculateOffset(axisOrdinals);
        }

        private long[] computeEdgeOrdinalsFromCellOrdinal(long cellOrdinal) {
            int numAxes = this.resultSet.getNumAxes();
            long[] axisOrdinals = new long[numAxes];
            long remainder = cellOrdinal;
            for (int i = numAxes - 1; i > 0; --i) {
                long previousAxesSize = 1L;
                for (int j = i - 1; j >= 0; --j) {
                    if (this.axisSizes[j] <= 0L) continue;
                    previousAxesSize *= this.axisSizes[j];
                }
                axisOrdinals[i] = remainder / previousAxesSize;
                remainder -= axisOrdinals[i] * previousAxesSize;
            }
            axisOrdinals[0] = remainder;
            return axisOrdinals;
        }

        private long calculateOffset(int edgeOrdinal) {
            if (edgeOrdinal == 0) {
                return this.tupleOrdinalMaps[0].lookup(this.axisPositions[0]);
            }
            int previousEdgeOrdinal = edgeOrdinal - 1;
            long offset = 0L;
            long tupleOrdinal = this.tupleOrdinalMaps[edgeOrdinal].lookup(this.axisPositions[edgeOrdinal]);
            if (tupleOrdinal > 0L) {
                offset = 1L;
                for (int i = previousEdgeOrdinal; i >= 0; --i) {
                    offset *= this.axisSizes[i];
                }
                offset *= tupleOrdinal;
            }
            return this.calculateOffset(previousEdgeOrdinal) + offset;
        }

        private long calculateOffset(long[] cellEdgeOrdinals) {
            long finalOffset = 0L;
            for (int edgeOrdinal = this.axisSizes.length - 1; edgeOrdinal >= 0; --edgeOrdinal) {
                if (edgeOrdinal == 0) {
                    return this.tupleOrdinalMaps[0].lookup(cellEdgeOrdinals[0]) + finalOffset;
                }
                long offset = 0L;
                int previousEdgeOrdinal = edgeOrdinal - 1;
                long tupleOrdinal = this.tupleOrdinalMaps[edgeOrdinal].lookup(cellEdgeOrdinals[edgeOrdinal]);
                if (tupleOrdinal > 0L) {
                    offset = 1L;
                    for (int i = previousEdgeOrdinal; i >= 0; --i) {
                        offset *= this.axisSizes[i];
                    }
                    offset *= tupleOrdinal;
                }
                finalOffset += offset;
            }
            return finalOffset;
        }

        private ICell getCell(long cellOrdinal) {
            if (this.cellCache == null) {
                this.cellCache = this.cellIterator.hasNext() ? this.cellIterator.next() : null;
            }
            while (this.cellCache != null && this.cellCache.getOrdinal() < cellOrdinal) {
                if (this.cellIterator.hasNext()) {
                    this.cellCache = this.cellIterator.next();
                    continue;
                }
                this.cellCache = null;
            }
            if (this.cellCache == null) {
                return null;
            }
            if (this.cellCache.getOrdinal() == cellOrdinal) {
                return this.cellCache;
            }
            return null;
        }

        @Override
        public void release() {
            if (this.axisIterators != null) {
                for (int i = 0; i < this.axisIterators.length; ++i) {
                    if (this.axisIterators[i] == null) continue;
                    try {
                        this.axisIterators[i].release();
                        continue;
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                }
                this.axisIterators = null;
            }
            if (this.cellIterator != null) {
                try {
                    this.cellIterator.release();
                }
                catch (Exception ex) {
                    mErrorLogger.log(ex);
                }
                this.cellIterator = null;
            }
            this.cellCache = null;
            this.currentTuples = null;
        }

        @Override
        public long getIndex() {
            return this.currentCellOrdinal;
        }

        @Override
        public boolean hasNext() {
            this.hasNextCalled = true;
            if (this.nextCalled) {
                this.nextCalled = false;
                this.nextCell = this.fetchNext();
                this.hasNext = this.nextCell != null;
            }
            return this.hasNext;
        }

        @Override
        public ICell nextImpl() {
            if (!this.hasNextCalled) {
                this.hasNext();
            }
            if (!this.hasNext) {
                return null;
            }
            this.nextCalled = true;
            this.hasNextCalled = false;
            return this.nextCell;
        }

        @Override
        public boolean hasPipelineIterator() {
            return this.cellIterator.hasPipelineIterator();
        }
    }

    private final class ScrollableCellIterator
    extends XScrollableCellIterator {
        private ComputeCellOrdinalResultSet resultSet;
        private long[] axisSizes;
        private long[] originalAxisSizes;
        private XScrollableCellIterator scrollableCellIterator;
        private boolean isEmpty;
        private XScrollableIterator axisIterator;

        private ScrollableCellIterator(ComputeCellOrdinalResultSet result, Integer theNodeId, XScrollableCellIterator sourceIterator) {
            super(result.getDataContext(), theNodeId);
            this.isEmpty = false;
            try {
                this.resultSet = result;
                ICubeResultSet sourceResult = this.resultSet.getBaseResultSet();
                this.scrollableCellIterator = sourceIterator;
                this.isEmpty = !this.scrollableCellIterator.hasNext();
                int numAxes = result.getNumAxes();
                int numAxesMinusOne = numAxes - 1;
                this.axisSizes = new long[numAxes];
                this.originalAxisSizes = new long[numAxes];
                this.axisIterator = sourceResult.getScrollableAxisIterator(XOLAPComputeCellOrdinalDecoration.this.getEdgeOrdinal());
                for (int i = 0; i < numAxesMinusOne; ++i) {
                    this.axisSizes[i] = sourceResult.getAxisSize(i);
                    this.originalAxisSizes[i] = this.loadSourceTupleCount(i);
                }
            }
            catch (RuntimeException e) {
                this.release();
                throw e;
            }
        }

        @Override
        public ICell nextImpl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean absolute(long index) {
            throw new UnsupportedOperationException();
        }

        private long loadSourceTupleCount(int axisOrdinal) {
            XOLAPEdgeDecoration childNode = (XOLAPEdgeDecoration)XOLAPComputeCellOrdinalDecoration.this.getChild(0);
            long sourceTupleCount = childNode.getSourceTupleCount(axisOrdinal);
            if (sourceTupleCount == -1L) {
                sourceTupleCount = this.resultSet.getBaseResultSet().getAxisSize(axisOrdinal);
            }
            return sourceTupleCount;
        }

        private long[] computeEdgeOrdinalsFromCellOrdinal(long cellOrdinal) {
            long[] axisOrdinals = new long[this.axisSizes.length];
            long remainder = cellOrdinal;
            for (int i = this.axisSizes.length - 1; i > 0; --i) {
                long previousAxesSize = 1L;
                for (int j = i - 1; j >= 0; --j) {
                    if (this.axisSizes[j] <= 0L) continue;
                    previousAxesSize *= this.axisSizes[j];
                }
                axisOrdinals[i] = remainder / previousAxesSize;
                remainder -= axisOrdinals[i] * previousAxesSize;
            }
            axisOrdinals[0] = remainder;
            return axisOrdinals;
        }

        private long computeCellOrdinalFromEdgeOrdinals(long[] edgeOrdinals) {
            long ordinal = 0L;
            for (int i = this.originalAxisSizes.length - 1; i > 0; --i) {
                long previousAxesSize = 1L;
                for (int j = i - 1; j >= 0; --j) {
                    previousAxesSize *= this.originalAxisSizes[j];
                }
                ordinal += previousAxesSize * edgeOrdinals[i];
            }
            return ordinal += edgeOrdinals[0];
        }

        @Override
        public ICell byOrdinal(long cellOrdinal) {
            long[] edgeOrdinals = this.computeEdgeOrdinalsFromCellOrdinal(cellOrdinal);
            long[] mappedEdgeOrdinals = new long[edgeOrdinals.length];
            for (int i = 0; i < mappedEdgeOrdinals.length; ++i) {
                mappedEdgeOrdinals[i] = this.resultSet.tupleOrdinalMaps[i].lookup(edgeOrdinals[i]);
            }
            long providerCellOrdinal = this.computeCellOrdinalFromEdgeOrdinals(mappedEdgeOrdinals);
            this.axisIterator.absolute(edgeOrdinals[XOLAPComputeCellOrdinalDecoration.this.getEdgeOrdinal()]);
            ITuple aTuple = (ITuple)this.axisIterator.current();
            if (aTuple == null) {
                return null;
            }
            ICell aCell = this.scrollableCellIterator.byOrdinal(providerCellOrdinal);
            if (aCell == null) {
                return null;
            }
            return new Cell(cellOrdinal, aCell.getValue());
        }

        @Override
        public ICell current() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasPrevious() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ICell previous() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean reset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return !this.isEmpty;
        }

        @Override
        public void release() {
            super.release();
            if (this.axisIterator != null) {
                try {
                    this.axisIterator.release();
                }
                catch (Exception ex) {
                    mErrorLogger.log(ex);
                }
            }
            if (this.scrollableCellIterator != null) {
                try {
                    this.scrollableCellIterator.release();
                }
                catch (Exception ex) {
                    mErrorLogger.log(ex);
                }
            }
            this.axisIterator = null;
            this.scrollableCellIterator = null;
        }

        @Override
        public boolean hasPipelineIterator() {
            return this.scrollableCellIterator.hasPipelineIterator();
        }
    }
}

