/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.decoration;

import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.md.CacheHints;
import com.cognos.xqe.resultsets.md.Tuple;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.olap.decoration.AbstractOLAPDecorationRules;
import com.cognos.xqe.runtree.olap.decoration.DecorationResultSet;
import com.cognos.xqe.runtree.olap.decoration.OLAPDecorationAxisIterator;
import com.cognos.xqe.runtree.olap.decoration.OLAPEmptyRowDecorationRules;
import com.cognos.xqe.runtree.olap.decoration.XOLAPEdgeDecoration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.dom4j.Element;

public class XOLAPEmptyRowDecoration
extends XOLAPEdgeDecoration {
    private static final long serialVersionUID = 0L;

    @Override
    public int getType() {
        return 501026;
    }

    @Override
    protected DecorationResultSet executeImpl(XDataContext context, ICubeResultSet cubeResult) {
        return new EmptyRowResultSet(context, cubeResult, this);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        super.capture(env, inputNode);
        List childList = inputNode.elements();
        ListIterator listIterator = childList.listIterator();
        while (listIterator.hasNext()) {
            Element anElement = (Element)listIterator.next();
            String elementName = anElement.getName();
            if (!"OLAPEmptyRowDecorationRules".equals(elementName)) continue;
            OLAPEmptyRowDecorationRules aRule = (OLAPEmptyRowDecorationRules)env.getRuleFactory().createRule(3);
            aRule.capture(env, anElement, this.getEdgeOrdinal());
            this.addDecorationRules(aRule);
        }
    }

    @Override
    protected CacheHints getCacheHints() {
        return CacheHints.cacheOneAxisNoCells(this.getEdgeOrdinal());
    }

    private class EmptyRowAxisIterator
    extends OLAPDecorationAxisIterator {
        private List<ITuple> tupleBuffer;
        private SortedMap<Integer, ITuple> rowsetIdToEmptyRowMap;
        private HashMap<Integer, ContextMember> ancestorMembersMap;
        private int decoratePosition;

        protected EmptyRowAxisIterator(int axisOrdinal, XOLAPEdgeDecoration parent, DecorationResultSet resultSet) {
            super(axisOrdinal, parent, resultSet, XOLAPEmptyRowDecoration.this.getId());
            this.tupleBuffer = new ArrayList<ITuple>();
            this.rowsetIdToEmptyRowMap = new TreeMap<Integer, ITuple>();
            this.ancestorMembersMap = new HashMap();
        }

        @Override
        public Object nextImpl() {
            this.decoratePosition = XOLAPEmptyRowDecoration.this.getTuplePosition();
            this.openIteratorTrace(this.parentXNode, this.parentXNode.getEdgeOrdinal(), this.parentXNode.getEdgeName(), true);
            this.openNextImplTrace(++this.callId);
            ITuple aTuple = null;
            ITuple retTuple = null;
            if (!this.tupleBuffer.isEmpty()) {
                retTuple = this.tupleBuffer.remove(0);
            } else {
                aTuple = (ITuple)this.sourceIterator.next();
                this.traceInTuple(aTuple, this.oldCoordinate);
                if (aTuple == null) {
                    retTuple = this.renderRemainingEmptyFooters();
                }
            }
            if (retTuple != null) {
                this.coordinateMap.map(++this.newCoordinate, this.oldCoordinate);
                this.traceOutTuple(retTuple, this.oldCoordinate, this.newCoordinate);
                this.closeNextImplTrace();
                return retTuple;
            }
            if (aTuple == null) {
                XOLAPEmptyRowDecoration.this.setSourceTupleCount(this.oldCoordinate + 1L);
                this.traceOutTuple(null, this.oldCoordinate, this.newCoordinate);
                this.closeNextImplTrace();
                this.closeIteratorTrace();
                return null;
            }
            this.buildAncestorMembersMap(aTuple);
            if (!this.rowsetIdToEmptyRowMap.isEmpty()) {
                this.consumeEmptyRowsBeforeTuple(aTuple);
            }
            this.generateEmptyRowsFromTuple(aTuple);
            this.coordinateMap.map(++this.newCoordinate, ++this.oldCoordinate);
            if (!this.tupleBuffer.isEmpty()) {
                this.tupleBuffer.add(aTuple);
                retTuple = this.tupleBuffer.remove(0);
                this.traceOutTuple(retTuple, this.oldCoordinate, this.newCoordinate);
                return retTuple;
            }
            this.traceOutTuple(aTuple, this.oldCoordinate, this.newCoordinate);
            return aTuple;
        }

        private void generateEmptyRow(ContextMember matchedMember, ITuple aTuple, RSAPIRowset emptyRowset) {
            IMember[] srcMembers = aTuple.getMembers();
            ContextMember aContextMember = (ContextMember)srcMembers[this.decoratePosition].copy();
            IMember[] ctxMembers = new IMember[srcMembers.length];
            System.arraycopy(srcMembers, 0, ctxMembers, 0, srcMembers.length);
            ctxMembers[this.decoratePosition] = aContextMember;
            while (aContextMember.getContextMember() != null && (aContextMember.getMember() != matchedMember.getMember() || aContextMember.getRowset() != matchedMember.getRowset())) {
                aContextMember.setDataItemIndex(-3);
                aContextMember = aContextMember.getContextMember();
            }
            aContextMember.setQueryCalculation(true);
            aContextMember.setSummary(true);
            aContextMember.setRowset(emptyRowset);
            aContextMember.setDataItemIndex(-2);
            Tuple emptyRow = new Tuple(ctxMembers);
            this.rowsetIdToEmptyRowMap.put(new Integer(emptyRowset.getRowsetId()), emptyRow);
            if (((RSAPIEdgeRowset)emptyRowset).isHeaderRowset()) {
                this.tupleBuffer.add(emptyRow);
            }
        }

        private void generateEmptyRowsFromTuple(ITuple aTuple) {
            ContextMember aContextMember = (ContextMember)aTuple.getMember(this.decoratePosition);
            int rowsetId = -1;
            if (aContextMember.getRowset() != null) {
                rowsetId = aContextMember.getRowset().getRowsetId();
            }
            for (AbstractOLAPDecorationRules rule : XOLAPEmptyRowDecoration.this.getDecorationRules()) {
                RSAPIRowset emptyRowset = ((OLAPEmptyRowDecorationRules)rule).getEmptyRowset();
                if (this.rowsetIdToEmptyRowMap.get(emptyRowset.getRowsetId()) != null) continue;
                ContextMember matchedMember = null;
                int matchRowsetId = rule.getRowset().getRowsetId();
                if (aContextMember.getContextMember() != null) {
                    matchedMember = this.ancestorMembersMap.get(matchRowsetId);
                }
                if (matchedMember == null && rowsetId == matchRowsetId) {
                    matchedMember = aContextMember;
                }
                if (matchedMember == null) continue;
                this.generateEmptyRow(matchedMember, aTuple, emptyRowset);
            }
        }

        public ITuple renderRemainingEmptyFooters() {
            ITuple ret = null;
            for (Integer rowsetId : this.rowsetIdToEmptyRowMap.keySet()) {
                ITuple emptyTuple = (ITuple)this.rowsetIdToEmptyRowMap.get(rowsetId);
                ContextMember matchedMember = this.findMatchedMember((ContextMember)emptyTuple.getMember(this.decoratePosition), rowsetId);
                if (matchedMember == null || matchedMember.getRowset() == null || !((RSAPIEdgeRowset)matchedMember.getRowset()).isFooterRowset()) continue;
                this.tupleBuffer.add(0, emptyTuple);
            }
            this.rowsetIdToEmptyRowMap.clear();
            if (!this.tupleBuffer.isEmpty()) {
                ret = this.tupleBuffer.remove(0);
            }
            return ret;
        }

        public ContextMember findMatchedMember(ContextMember aMember, int rowsetId) {
            while (aMember != null && (aMember.getRowset() == null || aMember.getRowset().getRowsetId() != rowsetId)) {
                aMember = aMember.getContextMember();
            }
            return aMember;
        }

        private void buildAncestorMembersMap(ITuple aTuple) {
            ContextMember currentMember = (ContextMember)aTuple.getMember(this.decoratePosition);
            this.ancestorMembersMap.clear();
            ContextMember currentMemberAncestor = currentMember.getContextMember();
            while (currentMemberAncestor != null) {
                if (currentMemberAncestor.isNullContext()) continue;
                this.ancestorMembersMap.put(currentMemberAncestor.getRowset().getRowsetId(), currentMemberAncestor);
                currentMemberAncestor = currentMemberAncestor.getContextMember();
            }
        }

        private void consumeEmptyRowsBeforeTuple(ITuple aTuple) {
            ContextMember matchedMember;
            Object[] listEmptyRowsetId = this.rowsetIdToEmptyRowMap.keySet().toArray();
            int i = 0;
            while (i < listEmptyRowsetId.length) {
                Integer emptyRowsetId;
                ITuple emptyRow;
                ContextMember emptyMember;
                if ((matchedMember = this.findMatchedMember(emptyMember = (ContextMember)(emptyRow = (ITuple)this.rowsetIdToEmptyRowMap.get(emptyRowsetId = (Integer)listEmptyRowsetId[i++])).getMember(this.decoratePosition), emptyRowsetId)) == null) continue;
                ContextMember outerMemberForEmptyRow = matchedMember.getContextMember();
                if (outerMemberForEmptyRow != null) {
                    RSAPIRowset outerRowsetForEmptyRow = outerMemberForEmptyRow.getRowset();
                    if (outerRowsetForEmptyRow == null) {
                        --i;
                        break;
                    }
                    ContextMember currentMemberAncestor = this.ancestorMembersMap.get(outerRowsetForEmptyRow.getRowsetId());
                    if (currentMemberAncestor != null && currentMemberAncestor.getMember().equals(outerMemberForEmptyRow.getMember())) continue;
                    --i;
                    break;
                }
                if (this.decoratePosition <= 0) continue;
                boolean differentOuterDimMember = false;
                for (int j = this.decoratePosition - 1; j >= 0; --j) {
                    ContextMember currentRowMember = (ContextMember)aTuple.getMember(j);
                    ContextMember emptyRowMember = (ContextMember)emptyRow.getMember(j);
                    if (emptyRowMember.getMember().equals(currentRowMember.getMember())) continue;
                    differentOuterDimMember = true;
                    break;
                }
                if (!differentOuterDimMember) continue;
                --i;
                break;
            }
            for (int j = listEmptyRowsetId.length - 1; j >= i; --j) {
                Integer rowsetId = (Integer)listEmptyRowsetId[j];
                ITuple emptyRow = (ITuple)this.rowsetIdToEmptyRowMap.remove(rowsetId);
                matchedMember = this.findMatchedMember((ContextMember)emptyRow.getMember(this.decoratePosition), rowsetId);
                if (matchedMember.isNullContext() || !((RSAPIEdgeRowset)matchedMember.getRowset()).isFooterRowset()) continue;
                this.tupleBuffer.add(emptyRow);
            }
        }

        @Override
        public void release() {
            super.release();
            this.tupleBuffer.clear();
            this.rowsetIdToEmptyRowMap.clear();
        }
    }

    private final class EmptyRowResultSet
    extends DecorationResultSet {
        private EmptyRowResultSet(XDataContext context, ICubeResultSet result, XOLAPEdgeDecoration owner) {
            super(context, result, owner);
        }

        @Override
        public XIterator getAxisIterator(int axisNumber) {
            if (axisNumber == XOLAPEmptyRowDecoration.this.getEdgeOrdinal()) {
                return new EmptyRowAxisIterator(axisNumber, this.parentNode, this);
            }
            return this.getBaseResultSet().getAxisIterator(axisNumber);
        }
    }
}

