/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.edgemapping.actions;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPEdgeMappingException;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class CrosstabSpacerCoordinates {
    private static final String SPACE_COMMA = " ,";
    private static final String CLOSE_PARENTHESIS = ")";
    private static final String OPEN_PARENTHESIS = "(";
    private static final String ROWSET_ID2 = "rowsetId2";
    private static final String ROWSET_ID1 = "rowsetId1";
    private static final String ROWSET_ID = "rowsetId";
    public static final int UNKNOWN = -1;
    public static final int AFTER = 0;
    public static final int BEFORE = 1;
    public static final int BETWEEN = 2;
    public static final int BETWEEN_AFTER = 21;
    public static final int BETWEEN_BEFORE = 22;
    public static final int ABOVE = 3;
    public static final int BENEATH = 4;
    private int position = -1;
    private List<RSAPIEdgeRowset> neighborList1 = null;
    private List<RSAPIEdgeRowset> neighborList2 = null;
    private int hashCode = Integer.MIN_VALUE;

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int aPosition) {
        this.position = aPosition;
    }

    public List<RSAPIEdgeRowset> getNeighborList1() {
        return this.neighborList1;
    }

    public void setNeighborList1(List<RSAPIEdgeRowset> aNeighborList) {
        this.neighborList1 = aNeighborList;
    }

    public List<RSAPIEdgeRowset> getNeighborList2() {
        return this.neighborList2;
    }

    public void setNeighborList2(List<RSAPIEdgeRowset> aNeighborList) {
        this.neighborList2 = aNeighborList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CrosstabSpacerCoordinates");
        sb.append(OPEN_PARENTHESIS);
        sb.append(this.positionToString());
        sb.append(": ");
        if (this.neighborList1 != null && this.neighborList2 != null) {
            sb.append(ROWSET_ID1);
            this.rowseListToString(sb, this.neighborList1);
        } else if (this.neighborList1 != null) {
            sb.append(ROWSET_ID);
            this.rowseListToString(sb, this.neighborList1);
        }
        if (this.neighborList2 != null) {
            sb.append(SPACE_COMMA);
            sb.append(ROWSET_ID2);
            this.rowseListToString(sb, this.neighborList2);
        }
        sb.append(CLOSE_PARENTHESIS);
        return sb.toString();
    }

    private void rowseListToString(StringBuilder sb, List<RSAPIEdgeRowset> rowsetList) {
        sb.append(OPEN_PARENTHESIS);
        for (int i = 0; i < rowsetList.size(); ++i) {
            sb.append(rowsetList.get(i).getRowsetId());
            if (i >= rowsetList.size() - 1) continue;
            sb.append(SPACE_COMMA);
        }
        sb.append(CLOSE_PARENTHESIS);
    }

    private String positionToString() {
        switch (this.position) {
            case -1: {
                return "UNKNOWN";
            }
            case 0: {
                return "AFTER";
            }
            case 1: {
                return "BEFORE";
            }
            case 2: {
                return "BETWEEN";
            }
            case 3: {
                return "ABOVE";
            }
            case 4: {
                return "BENEATH";
            }
        }
        throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "position?");
    }

    public void dump(XQETrace trace) {
        StringBuilder sb;
        trace.beginElement(this.getClass().getSimpleName(), -1);
        trace.attribute("position", this.positionToString());
        if (this.neighborList1 != null && this.neighborList2 != null) {
            sb = new StringBuilder();
            this.rowseListToString(sb, this.neighborList1);
            trace.attribute(ROWSET_ID1, sb.toString());
        } else if (this.neighborList1 != null) {
            sb = new StringBuilder();
            this.rowseListToString(sb, this.neighborList1);
            trace.attribute(ROWSET_ID, sb.toString());
        }
        if (this.neighborList2 != null) {
            sb = new StringBuilder();
            this.rowseListToString(sb, this.neighborList2);
            trace.attribute(ROWSET_ID2, sb.toString());
        }
        trace.endElement();
    }

    public boolean validate() {
        if (this.position == 4) {
            return true;
        }
        if (this.position < 0 || this.position > 3) {
            return false;
        }
        if (this.neighborList1 == null || this.neighborList1.isEmpty()) {
            return false;
        }
        if (this.position == 2 && (this.neighborList2 == null || this.neighborList2.isEmpty())) {
            return false;
        }
        return this.position == 2 || this.neighborList2 == null;
    }

    public boolean equals(Object other) {
        int i;
        if (this == other) {
            return true;
        }
        if (!(other instanceof CrosstabSpacerCoordinates)) {
            return false;
        }
        CrosstabSpacerCoordinates otherCoord = (CrosstabSpacerCoordinates)other;
        EqualsBuilder eb = new EqualsBuilder();
        eb.append(this.getPosition(), otherCoord.getPosition());
        eb.append(this.getNeighborList1() != null, otherCoord.getNeighborList1() != null);
        eb.append(this.getNeighborList2() != null, otherCoord.getNeighborList2() != null);
        if (!eb.isEquals()) {
            return false;
        }
        eb = new EqualsBuilder();
        if (this.getNeighborList1() != null) {
            eb.append(this.getNeighborList1().size(), otherCoord.getNeighborList1().size());
            if (eb.isEquals()) {
                return false;
            }
            for (i = 0; i < this.getNeighborList1().size(); ++i) {
                eb.append((Object)this.getNeighborList1().get(i), (Object)otherCoord.getNeighborList1().get(i));
                if (eb.isEquals()) continue;
                return false;
            }
        }
        eb = new EqualsBuilder();
        if (this.getNeighborList2() != null) {
            eb.append(this.getNeighborList2().size(), otherCoord.getNeighborList2().size());
            if (eb.isEquals()) {
                return false;
            }
            for (i = 0; i < this.getNeighborList2().size(); ++i) {
                eb.append((Object)this.getNeighborList2().get(i), (Object)otherCoord.getNeighborList2().get(i));
                if (eb.isEquals()) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int i;
        if (this.hashCode != Integer.MIN_VALUE) {
            return this.hashCode;
        }
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append(this.getPosition());
        if (this.getNeighborList1() != null) {
            for (i = 0; i < this.getNeighborList1().size(); ++i) {
                hcb.append((Object)this.getNeighborList1().get(i));
            }
        }
        if (this.getNeighborList2() != null) {
            for (i = 0; i < this.getNeighborList2().size(); ++i) {
                hcb.append((Object)this.getNeighborList2().get(i));
            }
        }
        this.hashCode = hcb.toHashCode();
        if (this.hashCode == Integer.MIN_VALUE) {
            this.hashCode = 0;
        }
        return this.hashCode;
    }
}

