/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.edgemapping.actions;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.edgemapping.EdgeMappingUtils;
import com.cognos.xqe.runtree.olap.edgemapping.actions.AbstractAction;
import com.cognos.xqe.runtree.olap.edgemapping.actions.IEdgeElementMappingAction;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class LinkSuppression
extends AbstractAction {
    private static final String ELEMENT_TARGET_IDS = "targetIds";
    private static final String ATTRIBUTE_TARGET_CLASS_NAME = "targetClassName";
    private List<Integer> targetIds = new ArrayList<Integer>();
    private String targetClassName = null;

    @Override
    public String getName() {
        return "LinkSuppression";
    }

    @Override
    public int getType() {
        return 3;
    }

    public List<Integer> getTargetIds() {
        return this.targetIds;
    }

    public void setTargetIds(List<Integer> ids) {
        this.targetIds = ids;
    }

    public void addTargetId(Integer aTargetId) {
        this.targetIds.add(0, aTargetId);
    }

    public String getTargetClassName() {
        return this.targetClassName;
    }

    public void setTargetClassName(String aTargetClassName) {
        this.targetClassName = aTargetClassName;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputAction, int edgeOrdinal) {
        Attribute attribute = inputAction.attribute("to");
        if (attribute == null) {
            throw new IllegalStateException();
        }
        String rowIdList = attribute.getValue();
        if (rowIdList == null) {
            throw new IllegalStateException();
        }
        this.setTargetIds(EdgeMappingUtils.stringToIntegerList(rowIdList));
    }

    @Override
    public void dump(XQETrace trace) {
        this.validate();
        trace.beginElement(this.getName(), -1);
        trace.attribute("to", this.getTargetIdsAsString());
        trace.endElement();
    }

    @Override
    public void validate() {
        if (this.getTargetIds() == null || this.getTargetIds().isEmpty()) {
            EdgeMappingUtils.actionValidationError(this);
        }
    }

    @Override
    public int getPrecedence() {
        return 3;
    }

    @Override
    public IEdgeElementMappingAction copy(EdgeElementFactory edgeElementFactory) {
        LinkSuppression newAction = (LinkSuppression)super.copy(edgeElementFactory);
        newAction.setTargetClassName(this.getTargetClassName());
        newAction.setTargetIds(this.getTargetIds());
        return newAction;
    }

    @Override
    public IEdgeElementMappingAction exactCopy(EdgeElementFactory edgeElementFactory) {
        return this.copy(edgeElementFactory);
    }

    public String getTargetIdsAsString() {
        List<Integer> ids = this.getTargetIds();
        return EdgeMappingUtils.integerListToString(ids);
    }

    @Override
    public SortedMap<String, String> getCheckSumPropertiesMap() {
        SortedMap<String, String> propertiesMap = super.getCheckSumPropertiesMap();
        propertiesMap.put("to", this.getTargetIdsAsString());
        return propertiesMap;
    }

    @Override
    public void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(ATTRIBUTE_TARGET_CLASS_NAME, this.targetClassName);
    }

    @Override
    public void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.targetIds != null) {
            ctx.elementProperty(ELEMENT_TARGET_IDS, this.targetIds);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
        String attName = att.getName();
        if (attName.equals(ATTRIBUTE_TARGET_CLASS_NAME)) {
            Object val = ctx.attributeValue(att);
            this.targetClassName = (String)val;
        } else {
            super.restoreAttributeProperty(ctx, att, node);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_TARGET_IDS)) {
            Object val = ctx.elementValue(node);
            this.targetIds = (List)val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }
}

