/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.mdx.parser.ASTBooleanTerm;
import com.cognos.xqe.ast.mdx.parser.MDXQueryNode;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.MDXEngineException;
import com.cognos.xqe.runtree.olap.mdx.XMdxBooleanFactor;
import com.cognos.xqe.runtree.olap.mdx.XMdxBooleanNode;
import com.cognos.xqe.runtree.olap.mdx.XMdxBooleanPrimary;
import com.cognos.xqe.runtree.olap.mdx.XMdxTuple;
import com.cognos.xqe.runtree.olap.mdx.XMdxValueExpressionPrimary;
import com.cognos.xqe.runtree.olap.mdx.data.values.CubicsValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSetProcessor;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.FilterPushdownUtility;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownManager;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XMdxBooleanTerm
extends XMdxBooleanNode {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_OPERATOR = "operator";
    private static final String ATTRIBUTE_AND = "and";
    private String operator;

    @Override
    public int getType() {
        return 501057;
    }

    @Override
    public void setParserNode(MDXQueryNode node) {
        super.setParserNode(node);
        ASTBooleanTerm booleanTerm = (ASTBooleanTerm)node;
        this.operator = booleanTerm.getParameter(ATTRIBUTE_OPERATOR);
        this.setPropertyValue(ATTRIBUTE_OPERATOR, new String(this.operator));
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        super.capture(env, inputNode);
        this.setPropertyValue(ATTRIBUTE_OPERATOR, inputNode.attributeValue(ATTRIBUTE_OPERATOR));
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        this.dumpProperty(trace, ATTRIBUTE_OPERATOR);
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        Object result = null;
        InterpreterContext interpreterContext = context.getInterpreterContext();
        PushdownManager pushdownManager = PushdownManager.getPushdownManager(interpreterContext);
        if (pushdownManager != null && pushdownManager.isFilter() && this.isValidForPushdown()) {
            int i;
            boolean bIsPushdownInProgress = true;
            for (i = 0; i < this.getNumberChildren() - 1; ++i) {
                pushdownManager.setConfigureOnly(true);
                this.executeXMdxChildNode(i, context);
                if (!pushdownManager.isPushdownAborted(interpreterContext)) continue;
                bIsPushdownInProgress = false;
                break;
            }
            if (bIsPushdownInProgress) {
                pushdownManager.setConfigureOnly(false);
                pushdownManager.setParameter("Filter", "booleanOperator", 1);
                Object pushdownResult = this.executeXMdxChildNode(i, context);
                if (PushdownManager.isPushdownExecutionFinished(interpreterContext)) {
                    BooleanValue pushdownResultDefaultValue = (BooleanValue)pushdownManager.getParameter("Filter", "defaultValue");
                    ((Block)pushdownResult).setDefaultValue(pushdownResultDefaultValue);
                    return new CubicsValue(pushdownResult);
                }
            }
        }
        Object booleanFactor = this.executeXMdxChildNode(0, context);
        if (this.getNumberChildren() <= 1) {
            return new CubicsValue(booleanFactor);
        }
        Object booleanTerm = this.executeXMdxChildNode(1, context);
        try {
            ICube cube = interpreterContext.getCube();
            ResultSetProcessor rsProcessor = new ResultSetProcessor(cube);
            if (!this.operator.equalsIgnoreCase(ATTRIBUTE_AND)) {
                throw new MDXEngineException("X01434", new String[]{this.operator, ATTRIBUTE_AND});
            }
            result = rsProcessor.performSimpleOp(interpreterContext, booleanFactor, booleanTerm, 1);
        }
        catch (InterpreterException e) {
            throw new MDXEngineException(e);
        }
        return new CubicsValue(result);
    }

    private boolean isValueExpressionValidForPushdown() {
        boolean result = true;
        XMdxValueExpressionPrimary valueExpression = null;
        for (int i = 0; i < this.getNumberChildren() && result; ++i) {
            IXQEQueryNode tempValueExpression;
            IXQEQueryNode booleanPrimaryNode = this.getChild(i).getFirstDescendantOfTypeOrdered(501056, true);
            if (booleanPrimaryNode == null) {
                return false;
            }
            if (valueExpression == null) {
                for (valueExpression = (XMdxValueExpressionPrimary)booleanPrimaryNode.getFirstDescendantOfTypeOrdered(501077, false); valueExpression != null && valueExpression.getNumberChildren() == 1 && valueExpression.getChild(0).getType() == 501077; valueExpression = (XMdxValueExpressionPrimary)valueExpression.getChild(0)) {
                }
                if (valueExpression != null && valueExpression.getNumberChildren() == 1 && valueExpression.getChild(0).getType() == 501075 && !((XMdxTuple)valueExpression.getChild(0)).isMemberRange()) continue;
                return false;
            }
            for (tempValueExpression = booleanPrimaryNode.getFirstDescendantOfTypeOrdered(501077, false); tempValueExpression != null && tempValueExpression.getNumberChildren() == 1 && tempValueExpression.getChild(0).getType() == 501077; tempValueExpression = tempValueExpression.getChild(0)) {
            }
            result = valueExpression.isSameExpression(tempValueExpression, false);
        }
        return result;
    }

    private boolean isValidForPushdown() {
        boolean result = false;
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            boolean isSupportedExpression = false;
            IXQEQueryNode child = this.getChild(i);
            if (child.getType() == 501056 && FilterPushdownUtility.isSupportedOperator(((XMdxBooleanPrimary)child).getOperatonValue())) {
                isSupportedExpression = true;
            } else if (child.getType() == 501055 && ((XMdxBooleanFactor)child).isNotIsEmptyExpression()) {
                isSupportedExpression = true;
            }
            if (isSupportedExpression) continue;
            return false;
        }
        result = this.isValueExpressionValidForPushdown();
        return result;
    }
}

