/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.provider.Metadata;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.mdx.MDXEngineException;
import com.cognos.xqe.runtree.olap.mdx.XMdxCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.XMdxElement;
import com.cognos.xqe.runtree.olap.mdx.XMdxFormulaSpecification;
import com.cognos.xqe.runtree.olap.mdx.XMdxNode;
import com.cognos.xqe.runtree.olap.mdx.XMdxSet;
import com.cognos.xqe.runtree.olap.mdx.XMdxSetSpecification;
import com.cognos.xqe.runtree.olap.mdx.XMdxStringValueExpression;
import com.cognos.xqe.runtree.olap.mdx.XMdxValueExpressionPrimary;
import com.cognos.xqe.runtree.olap.mdx.data.values.CubicsValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NamedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Session;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.Provider;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;
import org.dom4j.Element;

public class XMdxCreate
extends XMdxNode {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_CUBENAME = "cubeName";

    @Override
    public int getType() {
        return 501122;
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        Metadata result = null;
        int childCount = this.getNumberChildren();
        if (childCount == 0) {
            throw new MDXEngineException("X01425", new String[]{""});
        }
        InterpreterContext interpreterContext = context.getInterpreterContext();
        interpreterContext.setXDataContext(context);
        Session session = null;
        Provider provider = null;
        session = interpreterContext.getSession();
        provider = interpreterContext.getProvider();
        if (!(this.getParent() instanceof XMdxLocal)) {
            throw new XQERuntimeException(XQEMessageKeys.MDX_ExecutionFailed);
        }
        XMdxFormulaSpecification formulaSpecNode = (XMdxFormulaSpecification)this.getChild(0);
        XMdxNode setOrMemberNode = (XMdxNode)formulaSpecNode.getChild(0);
        if (setOrMemberNode instanceof XMdxCalculatedMember) {
            XMdxCalculatedMember cMemberNode = (XMdxCalculatedMember)setOrMemberNode;
            CubicsValue value = (CubicsValue)cMemberNode.executeImpl(context);
            CalculatedMember calculatedMember = (CalculatedMember)value.getCubicsObject();
            session.addSessionMember(calculatedMember);
            result = calculatedMember;
        } else if (setOrMemberNode instanceof XMdxSetSpecification) {
            NamedSet namedSet = null;
            String cubeName = null;
            XMdxNode setNode = (XMdxNode)setOrMemberNode.getChild(0);
            int itemCount = setNode.getNumberChildren();
            int setNameIndex = 0;
            if (itemCount > 1) {
                Block cubeNameB = (Block)((CubicsValue)((XMdxElement)setNode.getChild(0)).executeImpl(context)).getCubicsObject();
                cubeName = ((Value)cubeNameB.first()).getString();
                setNameIndex = 1;
            }
            Block setNameB = (Block)((CubicsValue)((XMdxElement)setNode.getChild(setNameIndex)).executeImpl(context)).getCubicsObject();
            String setName = ((Value)setNameB.first()).getString();
            XMdxNode setExpressionNode = (XMdxNode)setOrMemberNode.getChild(1);
            try {
                if (cubeName == null) {
                    throw new MDXEngineException("X01518");
                }
                Cube c = provider.getCube(cubeName);
                if (c == null) {
                    throw new MDXEngineException("X01425", new String[]{cubeName});
                }
                c.initialize();
                try {
                    interpreterContext.setCube(c);
                }
                catch (InterpreterException e) {
                    throw new XQERuntimeException(XQEMessageKeys.MDX_ExecutionFailed, (Throwable)e);
                }
                List<IHierarchy> cubeHierarchies = c.getHierarchies();
                IMember[] mems = new IMember[cubeHierarchies.size()];
                for (int j = 0; j < cubeHierarchies.size(); ++j) {
                    IHierarchy hier = cubeHierarchies.get(j);
                    try {
                        mems[j] = MemberOperations.getDefaultMemberOp(hier, interpreterContext);
                        if (mems[j] != null) continue;
                        XQEDebugLog.out.println("Hierarchy " + hier.getUniqueName() + " contains no default member. Creating empty initial context");
                        continue;
                    }
                    catch (MetadataException e) {
                        throw new MDXEngineException("X01408", new String[]{hier.getUniqueID()});
                    }
                }
                ISet[] contextSets = new Set[]{new Set(new Tuple(mems))};
                interpreterContext.setInitialContextSet(new CrossJoinedSet(contextSets));
            }
            catch (ProviderException e) {
                throw new MDXEngineException("X01425", new String[]{cubeName});
            }
            if (setExpressionNode instanceof XMdxValueExpressionPrimary) {
                IXQEQueryNode parent = ((XMdxValueExpressionPrimary)setExpressionNode).getParent();
                ((XMdxValueExpressionPrimary)setExpressionNode).setParent(null);
                Block setB = (Block)((CubicsValue)((XMdxValueExpressionPrimary)setExpressionNode).executeImpl(context)).getCubicsObject();
                setB.removeInvalidTuples();
                ((XMdxValueExpressionPrimary)setExpressionNode).setParent(parent);
                namedSet = new NamedSet(setName, setB);
            } else if (setExpressionNode instanceof XMdxStringValueExpression) {
                Block setStringB = (Block)((CubicsValue)((XMdxStringValueExpression)setExpressionNode).executeImpl(context)).getCubicsObject();
                String setString = (String)setStringB.first();
                setString = setString.replaceAll("''", "'");
                namedSet = new NamedSet(setName, setString);
            } else if (setExpressionNode instanceof XMdxSet) {
                Block setB = (Block)((CubicsValue)((XMdxSet)setExpressionNode).executeImpl(context)).getCubicsObject();
                setB.removeInvalidTuples();
                namedSet = new NamedSet(setName, setB);
            }
            namedSet.setCubeName(cubeName);
            session.addSessionSet(namedSet);
            result = namedSet;
        }
        interpreterContext.setSession(session);
        context.setInterpreterContext(interpreterContext);
        return new CubicsValue(result);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        super.capture(env, inputNode);
        this.setPropertyValue(ATTRIBUTE_CUBENAME, inputNode.attributeValue(ATTRIBUTE_CUBENAME));
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        this.dumpProperty(trace, ATTRIBUTE_CUBENAME);
    }

    public String getCubeName() {
        return (String)this.getPropertyValue(ATTRIBUTE_CUBENAME);
    }
}

