/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.XMdxBooleanPrimary;
import com.cognos.xqe.runtree.olap.mdx.XMdxNode;
import com.cognos.xqe.runtree.olap.mdx.data.values.CubicsValue;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.DMRProviderForPreciseLoading;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ErrorCell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ICalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NamedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.metadata.Provider;
import com.cognos.xqe.util.primitive.ArrayListLong;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class XMdxIfExpression
extends XMdxNode {
    private static final long serialVersionUID = 1L;

    @Override
    public int getType() {
        return 501063;
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        Block result = null;
        InterpreterContext interpreterContext = context.getInterpreterContext();
        try {
            Block booleanExpB = (Block)this.executeXMdxChildNode(0, context);
            BooleanExpression booleanExp = new BooleanExpression(booleanExpB);
            int allCellValue = booleanExp.createBooleanSets(booleanExpB, interpreterContext);
            if (allCellValue == 3) {
                return new CubicsValue(booleanExpB);
            }
            InterpreterContext.ContextInfo currCtxtInfo = interpreterContext.getContext();
            Block insBooleanExpB = booleanExpB;
            if (currCtxtInfo.hasExpandedSets()) {
                insBooleanExpB = new Block(interpreterContext, booleanExpB);
                insBooleanExpB.expandSets();
            }
            boolean primeIfConditionOnly = interpreterContext.inPrimingPhase() && interpreterContext.getPrimingInfo().getPrimingMode() == 1;
            boolean forceToRunBoth = this.touchBothinDummyRun(interpreterContext);
            Block bTrue = null;
            if (allCellValue == 1 && !primeIfConditionOnly) {
                bTrue = (Block)this.executeXMdxChildNode(1, context);
                bTrue.getValues(interpreterContext);
            } else if (booleanExp.getTrueSet() != null && !primeIfConditionOnly) {
                interpreterContext.pushPartialContext(booleanExpB, booleanExp.getTrueSet());
                HashMap<NamedSet, Block> currContextInsBlocks = this.changeInlineNamedSetContextPush(interpreterContext, insBooleanExpB, true);
                bTrue = (Block)this.executeXMdxChildNode(1, context);
                bTrue.getValues(interpreterContext);
                bTrue.changeToPreviousContext(booleanExpB, booleanExp.getTrueMap(), false);
                this.changeInlineNamedSetContextPop(interpreterContext, booleanExp, true, currContextInsBlocks);
                interpreterContext.popContext();
            } else {
                bTrue = new Block(booleanExpB);
                if (forceToRunBoth) {
                    Block tmpBlock = (Block)this.executeXMdxChildNode(1, context);
                    tmpBlock.getValues(interpreterContext);
                }
            }
            Block bFalse = null;
            if (allCellValue == 2 && !primeIfConditionOnly) {
                bFalse = (Block)this.executeXMdxChildNode(2, context);
                bFalse.getValues(interpreterContext);
            } else if (booleanExp.getFalseSet() != null && !primeIfConditionOnly) {
                interpreterContext.pushPartialContext(booleanExpB, booleanExp.getFalseSet());
                HashMap<NamedSet, Block> currContextInsBlocks = this.changeInlineNamedSetContextPush(interpreterContext, insBooleanExpB, false);
                bFalse = (Block)this.executeXMdxChildNode(2, context);
                bFalse.getValues(interpreterContext);
                bFalse.changeToPreviousContext(booleanExpB, booleanExp.getFalseMap(), false);
                this.changeInlineNamedSetContextPop(interpreterContext, booleanExp, false, currContextInsBlocks);
                interpreterContext.popContext();
            } else {
                bFalse = new Block(booleanExpB);
                if (forceToRunBoth) {
                    Block tmpBlock = (Block)this.executeXMdxChildNode(2, context);
                    tmpBlock.getValues(interpreterContext);
                }
            }
            booleanExpB.keepOnlyErrorCells();
            Block[] childBlocks = new Block[]{bTrue, bFalse, booleanExpB};
            Block retBlock = new Block(interpreterContext, childBlocks);
            IBlockIterator blockIter = Block.getBlockIterator(childBlocks);
            while (blockIter.hasNext()) {
                Object[] blockObj = (Object[])blockIter.next();
                if (null != blockObj[0]) {
                    retBlock.add(blockIter, blockObj[0]);
                    continue;
                }
                if (null != blockObj[1]) {
                    retBlock.add(blockIter, blockObj[1]);
                    continue;
                }
                retBlock.add(blockIter, blockObj[2]);
            }
            result = retBlock;
        }
        catch (InterpreterException e) {
            throw new XQERuntimeException(XQEMessageKeys.MDX_ExecutionFailed, (Throwable)e);
        }
        return new CubicsValue(result);
    }

    private HashMap<NamedSet, Block> changeInlineNamedSetContextPush(InterpreterContext interpreterContext, Block booleanExpB, boolean truePart) throws InterpreterException {
        ICalculationEngine calcEngine = interpreterContext.getCalculationEngine();
        Collection<NamedSet> namedSets = calcEngine.getNamedSets().values();
        HashMap<NamedSet, Block> currContextInsBlocks = new HashMap<NamedSet, Block>();
        Block setB = null;
        for (NamedSet namedSet : namedSets) {
            if (!namedSet.isInlineAndActive()) continue;
            setB = (Block)namedSet.getSet1(interpreterContext);
            currContextInsBlocks.put(namedSet, new Block(interpreterContext, setB));
            setB.changeToCurrentContext(booleanExpB, truePart);
        }
        return currContextInsBlocks;
    }

    private void changeInlineNamedSetContextPop(InterpreterContext interpreterContext, BooleanExpression booleanExp, boolean truePart, HashMap<NamedSet, Block> currContextInsBlocks) throws InterpreterException {
        ICalculationEngine calcEngine = interpreterContext.getCalculationEngine();
        Collection<NamedSet> namedSets = calcEngine.getNamedSets().values();
        Block setB = null;
        for (NamedSet namedSet : namedSets) {
            if (!namedSet.isInlineAndActive()) continue;
            Block currContextInsBlock = currContextInsBlocks.get(namedSet);
            if (currContextInsBlocks.get(namedSet) != null) {
                namedSet.setBlock(currContextInsBlock, false);
                continue;
            }
            setB = (Block)namedSet.getSet1(interpreterContext);
            if (truePart) {
                setB.changeToPreviousContext(booleanExp.getBlock(), booleanExp.getTrueMap(), true);
                continue;
            }
            setB.changeToPreviousContext(booleanExp.getBlock(), booleanExp.getFalseMap(), true);
        }
    }

    private boolean touchBothinDummyRun(InterpreterContext interpreterContext) {
        Provider p = interpreterContext.getProvider();
        if (!(p instanceof DMRProviderForPreciseLoading)) {
            return false;
        }
        XMdxNode condition = (XMdxNode)this.getChild(0);
        return !(condition instanceof XMdxBooleanPrimary) || ((XMdxBooleanPrimary)condition).getOperatonValue() != 21;
    }

    private class BooleanExpression {
        public static final int TUPLES_TRUE_FALSE = 0;
        public static final int TUPLES_ALL_TRUE = 1;
        public static final int TUPLES_ALL_FALSE = 2;
        public static final int TUPLES_ALL_ERROR = 3;
        Block block;
        private Set trueSet;
        private ArrayListLong trueMap;
        private Set falseSet;
        private ArrayListLong falseMap;
        private Set errorSet;

        BooleanExpression(Block booleanExpB) {
            this.block = booleanExpB;
        }

        public Set getTrueSet() {
            return this.trueSet;
        }

        public ArrayListLong getTrueMap() {
            return this.trueMap;
        }

        public Set getFalseSet() {
            return this.falseSet;
        }

        public ArrayListLong getFalseMap() {
            return this.falseMap;
        }

        public Block getBlock() {
            return this.block;
        }

        public int createBooleanSets(Block booleanExpB, InterpreterContext interpreterContext) throws InterpreterException {
            if (booleanExpB.tupleSetSize() == 0L) {
                Object defaultValueObj = booleanExpB.getDefaultValue();
                if (defaultValueObj == null) {
                    defaultValueObj = booleanExpB.cellSetSize() > 0 ? booleanExpB.first() : new Boolean(false);
                }
                if (ErrorCell.isErrorCell(defaultValueObj)) {
                    return 3;
                }
                boolean defaultBoolValue = interpreterContext.getBooleanOperand(defaultValueObj);
                if (defaultBoolValue) {
                    return 1;
                }
                return 2;
            }
            ArrayList<Tuple> trueTuples = new ArrayList<Tuple>();
            ArrayList<Tuple> falseTuples = new ArrayList<Tuple>();
            ArrayList<Tuple> errorTuples = new ArrayList<Tuple>();
            this.trueMap = new ArrayListLong();
            this.falseMap = new ArrayListLong();
            if (booleanExpB.getDefaultValue() != null) {
                booleanExpB.expandNullCells(false);
            }
            BlockIterator blockIter = booleanExpB.iterator();
            while (blockIter.hasNext()) {
                Object[] blockObj = (Object[])blockIter.next();
                Tuple currTuple = (Tuple)blockIter.getCurrentTuple();
                Boolean cellValue = null;
                if (ErrorCell.isErrorCell(blockObj[0])) {
                    errorTuples.add(currTuple);
                    continue;
                }
                try {
                    cellValue = interpreterContext.getBooleanOperand(blockObj[0]);
                }
                catch (InterpreterException ie) {
                    errorTuples.add(currTuple);
                    continue;
                }
                long cellOrdSurrogateId = blockIter.pos();
                if (cellValue.booleanValue()) {
                    trueTuples.add(currTuple);
                    this.trueMap.add(cellOrdSurrogateId);
                    continue;
                }
                falseTuples.add(currTuple);
                this.falseMap.add(cellOrdSurrogateId);
            }
            if (trueTuples.size() > 0) {
                this.trueSet = new Set(trueTuples.toArray(new Tuple[trueTuples.size()]));
            }
            if (falseTuples.size() > 0) {
                this.falseSet = new Set(falseTuples.toArray(new Tuple[falseTuples.size()]));
            }
            if (errorTuples.size() > 0) {
                this.errorSet = new Set(errorTuples.toArray(new Tuple[errorTuples.size()]));
            }
            return 0;
        }
    }
}

