/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.mdx.parser.MDXQueryNode;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.olap.mdx.data.values.CubicsValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.trace.XQETrace;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public abstract class XMdxNode
extends XNode {
    private static final long serialVersionUID = 1L;
    protected static final String STRING_VALUE = "value";
    public static final String PROPERTY_CONTEXT = "mdxContext";
    private static final String PROPERTY_NODECONTEXT = "nodeContext";
    public static final String CACHEABLE_PARAMETER_NAME = "cacheable";
    public static final String ELEMENT_PARSER_NODE = "parserNode";
    public static final String ELEMENT_CONTEXT_NODES = "contextNodes";
    public static final String ELEMENT_PROPERTIES = "properties";
    private MDXQueryNode parserNode;
    private List<MDXQueryNode> contextNodes = new LinkedList<MDXQueryNode>();
    private Map<String, Object> properties;

    public MDXQueryNode getParserNode() {
        return this.parserNode;
    }

    public void setParserNode(MDXQueryNode node) {
        this.parserNode = node;
    }

    public final void addContextNode(MDXQueryNode contextNode) {
        this.contextNodes.add(contextNode);
        this.processAddContextNode(contextNode);
    }

    protected void processAddContextNode(MDXQueryNode contextNode) {
    }

    public MDXQueryNode[] getContextNodes() {
        return this.contextNodes.toArray(new MDXQueryNode[this.contextNodes.size()]);
    }

    protected Object executeXMdxChildNode(int i, XDataContext context) {
        CubicsValue cubicsValue = (CubicsValue)((XMdxNode)this.getChild(i)).execute(context);
        return cubicsValue.getCubicsObject();
    }

    @Override
    public synchronized Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = Collections.synchronizedMap(new HashMap());
        }
        return this.properties;
    }

    public Object getParameterObject(String name, XDataContext context) {
        Map<String, Object> nodeParameters = this.getParameterMap(context);
        return nodeParameters.get(name);
    }

    public void setParameterObject(String name, Object value, XDataContext context) {
        Map<String, Object> nodeParameters = this.getParameterMap(context);
        nodeParameters.put(name, value);
    }

    private Map<String, Object> getParameterMap(XDataContext context) {
        HashMap nodeParameters;
        HashMap nodeContextMap = (HashMap)context.getProperty(PROPERTY_NODECONTEXT);
        if (nodeContextMap == null) {
            nodeContextMap = new HashMap();
            context.setProperty(PROPERTY_NODECONTEXT, nodeContextMap);
        }
        if ((nodeParameters = (HashMap)nodeContextMap.get(this)) == null) {
            nodeParameters = new HashMap();
            nodeContextMap.put(this, nodeParameters);
        }
        return nodeParameters;
    }

    @Override
    public void setPropertyValue(String key, Object value) {
        boolean trace;
        XQETrace traceObj;
        if (this.getPlanningEnvironment() != null && (traceObj = this.getPlanningEnvironment().getTrace()) != null && (trace = traceObj.isEnable(256))) {
            traceObj.beginElement("setPropertyValue", this.getId());
            traceObj.attribute("key", key);
            if (value != null) {
                traceObj.attribute(STRING_VALUE, value);
            }
            traceObj.endElement();
        }
        this.getProperties().put(key, value);
    }

    @Override
    public Object getPropertyValue(String key) {
        return this.getProperties().get(key);
    }

    protected void dumpProperty(XQETrace trace, String key) {
        trace.attribute(key, this.getPropertyValue(key));
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 501137) {
            return true;
        }
        return super.isOfCategory(category);
    }

    protected void traceInParameters(InterpreterContext interpreterContext, XQETrace trace) {
        interpreterContext.toXML(trace);
    }

    protected static String getClassNameCode(String className) {
        if (className.endsWith("TupleValue") || className.endsWith("TupleValue[]")) {
            return "";
        }
        if (className.endsWith("ResultSet") || className.endsWith("ResultSet[]")) {
            return "";
        }
        if (className.endsWith("Set") || className.endsWith("Set[]")) {
            return "CMP_TYPESET";
        }
        if (className.endsWith("Tuple") || className.endsWith("Tuple[]")) {
            return "CMP_TYPETUPLE";
        }
        if (className.endsWith("Member") || className.endsWith("Member[]")) {
            return "CMP_TYPEMEMBER";
        }
        if (className.endsWith("Cube") || className.endsWith("Cube[]")) {
            return "CMP_TYPECUBE";
        }
        if (className.endsWith("Dimension") || className.endsWith("Dimension[]")) {
            return "CMP_TYPEDIMENSION";
        }
        if (className.endsWith("Hierarchy") || className.endsWith("Hierarchy[]")) {
            return "CMP_TYPEHIERARCHY";
        }
        if (className.endsWith("Level") || className.endsWith("Level[]")) {
            return "CMP_TYPELEVEL";
        }
        if (className.endsWith("String") || className.endsWith("String[]")) {
            return "CMP_TYPESTRING";
        }
        if (className.endsWith("Double") || className.endsWith("Double[]") || className.endsWith("Integer") || className.endsWith("Integer[]")) {
            return "CMP_TYPENUMERIC";
        }
        if (className.endsWith("CalculatedMember") || className.endsWith("CalculatedMember[]")) {
            return "CMP_TYPECALCMEMBER";
        }
        if (className.endsWith("NamedSet") || className.endsWith("NamedSet[]")) {
            return "CMP_TYPENAMEDSET";
        }
        if (className.endsWith("MetaData") || className.endsWith("MetaData[]")) {
            return "";
        }
        return className;
    }

    public boolean isCacheableNode(XDataContext dataContext) {
        Object cacheableProp = this.getParameterObject(CACHEABLE_PARAMETER_NAME, dataContext);
        if (cacheableProp != null && cacheableProp instanceof Boolean) {
            return (Boolean)cacheableProp;
        }
        return true;
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.parserNode != null) {
            ctx.elementProperty(ELEMENT_PARSER_NODE, this.parserNode);
        }
        if (this.contextNodes != null) {
            ctx.elementProperty(ELEMENT_CONTEXT_NODES, this.contextNodes);
        }
        if (this.properties != null) {
            ctx.elementProperty(ELEMENT_PROPERTIES, this.properties);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_PARSER_NODE)) {
            Object val = ctx.elementValue(node);
            this.parserNode = (MDXQueryNode)val;
        } else if (pname.equals(ELEMENT_CONTEXT_NODES)) {
            Object val = ctx.elementValue(node);
            this.contextNodes = (List)val;
        } else if (pname.equals(ELEMENT_PROPERTIES)) {
            Object val = ctx.elementValue(node);
            this.properties = (Map)val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }
}

