/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx;

import com.cognos.xqe.ast.olap.MDXSetTerminal;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.olap.XMdx;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.mdx.XMdxNode;
import com.cognos.xqe.runtree.olap.mdx.data.values.CubicsValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SimpleTupleList;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPCube;
import com.cognos.xqe.trace.XQEDebugLog;
import java.util.ArrayList;

public class XMdxSetTerminal
extends XMdxNode {
    private static final long serialVersionUID = 1L;
    private MDXSetTerminal planNode;
    private XMdxLocal localNode;
    private String mdxStatement;

    @Override
    public int getType() {
        return 501135;
    }

    public void setPlanNode(MDXSetTerminal node) {
        this.planNode = node;
    }

    public void setLocalNode(XMdxLocal node) {
        this.localNode = node;
    }

    public void setMDXStatement(String mdx) {
        this.mdxStatement = mdx;
    }

    public String getMDXStatement() {
        return this.mdxStatement;
    }

    public XMdx getMdxQueryNode() {
        XMdx mdxQueryNode = null;
        if (this.planNode != null) {
            mdxQueryNode = this.planNode.getMdxQueryNode();
        }
        return mdxQueryNode;
    }

    public PlanningEnvironment getRuntreeEnvironment() {
        return this.planNode.getRuntreeEnvironment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IValue executeImpl(XDataContext context) {
        Block nsblock = null;
        ICube cube = this.localNode.getLocalCube();
        XMdx mdxNode = this.getMdxQueryNode();
        long ticks = System.currentTimeMillis();
        ICubeResultSet result = null;
        if (mdxNode != null) {
            IPlanningEnvironment environment = this.getPlanningEnvironment();
            environment.setPlanningActive(environment.getRequestEnvironment());
            result = (ICubeResultSet)mdxNode.execute(context);
        } else {
            result = ((LOLAPCube)cube).remoteMDXStatement(this.getMDXStatement(), context);
        }
        XQEDebugLog.out.println("TopCount Opt Execution Time:" + (System.currentTimeMillis() - ticks));
        ticks = System.currentTimeMillis();
        XIterator tupleIterator = null;
        ArrayList<ITuple> tuples = new ArrayList<ITuple>();
        int count = 0;
        try {
            ITuple aTuple;
            tupleIterator = result.getAxisIterator(0);
            while ((aTuple = (ITuple)tupleIterator.next()) != null) {
                ++count;
                ITuple tuple = ((LOLAPCube)cube).getCubicsTuple(aTuple);
                tuples.add(tuple);
            }
            XQEDebugLog.out.println("TopCount Opt Expand Set count: " + count);
            ITuple[] tups = tuples.toArray(new ITuple[tuples.size()]);
            ITupleList tl = SimpleTupleList.construct(tups);
            Set nsSet = new Set(tl);
            nsblock = new Block(context.getInterpreterContext(), nsSet);
            XQEDebugLog.out.println("TopCount Opt Expand Set in member cache:" + (System.currentTimeMillis() - ticks));
        }
        finally {
            if (tupleIterator != null) {
                tupleIterator.release();
            }
            result.release();
        }
        nsblock.removeInvalidTuples();
        return new CubicsValue(nsblock);
    }
}

