/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx;

import com.cognos.xqe.ast.mdx.parser.ASTUnsignedNumericLiteral;
import com.cognos.xqe.ast.mdx.parser.MDXQueryNode;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.XMdxNode;
import com.cognos.xqe.runtree.olap.mdx.data.values.CubicsValue;
import com.cognos.xqe.runtree.olap.mdx.functions.MDXFunctionProcessorFactory;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XMdxUnsignedNumericLiteral
extends XMdxNode {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_VALUE = "value";
    public static final String ATTRIBUTE_EXACT_VALUE = "exactvalue";

    public XMdxUnsignedNumericLiteral() {
        DoubleValue v = DataValueFactory.createDoubleValue();
        ((Value)v).set(Double.NaN);
        v.setFormatId(FormatId.EMPTY_FORMAT_FID);
        this.setPropertyValue(ATTRIBUTE_VALUE, v);
    }

    @Override
    public int getType() {
        return 501076;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        super.capture(env, inputNode);
        String value = inputNode.attributeValue(ATTRIBUTE_VALUE);
        DoubleValue v = DataValueFactory.createDoubleValue();
        ((Value)v).set(value);
        v.setFormatId(FormatId.EMPTY_FORMAT_FID);
        this.setPropertyValue(ATTRIBUTE_VALUE, v);
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        this.dumpProperty(trace, ATTRIBUTE_VALUE);
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        Block result = null;
        Value v = MDXFunctionProcessorFactory.getExactNumber(context.getInterpreterContext().getCube(), this);
        if (v == null) {
            v = this.getValue();
        }
        result = new Block(context.getInterpreterContext(), v);
        return new CubicsValue(result);
    }

    @Override
    public void setParserNode(MDXQueryNode node) {
        super.setParserNode(node);
        ASTUnsignedNumericLiteral numericLiteralNode = (ASTUnsignedNumericLiteral)node;
        DoubleValue v = DataValueFactory.createDoubleValue();
        ((Value)v).set(numericLiteralNode.getParameter("literal"));
        v.setFormatId(FormatId.EMPTY_FORMAT_FID);
        this.setPropertyValue(ATTRIBUTE_VALUE, v);
    }

    public Value getValue() {
        return (Value)this.getPropertyValue(ATTRIBUTE_VALUE);
    }
}

