/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.rqp.RQPPrePlan;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.olap.securecache.DMRMemberStorage;
import com.cognos.xqe.data.providers.olap.securecache.DMRMemberStoragePerLevel;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IFolder;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.ISortItem;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.metadata.wrapper.AbstractDimensionWrapper;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.DynamicDimensionWrapper;
import com.cognos.xqe.metadata.wrapper.LevelWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToLevelWrapper;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCubeWithCaching;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMemberComparator;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRProperty;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.IDMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.DMRLevelMemberLoader;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.DMRSecondaryLevelMemberLoader;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryOverTabularStream;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryResult;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.rsapi.RSAPIQueryResult;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.LoadDMRCubeSingleV5Query;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.Member;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MemberProxy;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderQueryResult;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownManager;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.PrePlanUtilities;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.SetOfTables;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.MetadataContext;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.INullPlacement;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.OrderedMap;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DMRLevel
extends Level {
    public static final String ASCENDING = "ascending";
    public static final String ISMANUAL = "isManual";
    public static final String ID = "ID";
    private static final String UNDERSCORE = "_";
    public static final String BUSINESS_KEY = RoleTypeEnum.BUSINESS_KEY.toV5Keyword();
    public static final String MEMBER_CAPTION = RoleTypeEnum.MEMBER_CAPTION.toV5Keyword();
    private static final String FORMAT = "format";
    protected ILevel fmLevel;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private String businessKeyModelExpression = null;
    private final DMRMemberStorage memberStorageForCacheMetrics;
    private List<BaseMember> restrictionMembers = new ArrayList<BaseMember>(2);
    private String descriptionPropertyName = null;
    private DMRMemberStoragePerLevel levelStorage = null;
    private final HashMap<String, String> propertyUNameToNameMap = new HashMap();
    private boolean bDynamicPropertyLoaded = false;
    private IMember dummyMemberForDynamicProp = null;

    public DMRLevel(String name, Hierarchy hierarchy, ILevel level) {
        super(name, hierarchy);
        this.fmLevel = level;
        this.setConnection(hierarchy.getConnection());
        this.loadMFWMemberProperties();
        this.setMembers(this.createOrderedMap());
        ICube cube = this.getDimension().getCube();
        if (cube instanceof DMRCubeWithCaching) {
            this.memberStorageForCacheMetrics = (DMRMemberStorage)((DMRCubeWithCaching)cube).getMemberStorage();
            if (this.memberStorageForCacheMetrics != null) {
                this.levelStorage = this.memberStorageForCacheMetrics.getLevelStorage(this.getUniqueName());
            }
        } else {
            this.memberStorageForCacheMetrics = null;
        }
    }

    public DMRMemberStoragePerLevel getLevelStorage() {
        return this.levelStorage;
    }

    public DMRLevel(String name, Hierarchy hierarchy) {
        this(name, hierarchy, null);
    }

    public OrderedMap<IMember> createOrderedMap() {
        ISortItem.NullPlacementType nullPlacement;
        OrderedMap.NullOrder nullOrder = OrderedMap.NullOrder.DEFAULT;
        ISortItem[] sortItems = this.getSortItems();
        if (sortItems.length > 0 && (nullPlacement = sortItems[0].getNullPlacement()) != null) {
            if (nullPlacement == ISortItem.NullPlacementType.NULL_LAST) {
                nullOrder = OrderedMap.NullOrder.LAST;
            } else if (nullPlacement == ISortItem.NullPlacementType.NULL_FIRST) {
                nullOrder = OrderedMap.NullOrder.FIRST;
            }
        }
        return new OrderedMap<IMember>(true, nullOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IMember> getMembers() throws MetadataException {
        if (this.memberStorageForCacheMetrics != null) {
            this.memberStorageForCacheMetrics.recordNewMemberRequest();
        }
        if (!this.hasGotAllMembers() && this.fmLevel != null) {
            if (this.isMappedToRelationalColumn()) {
                DMRLevel.dmrLoadLevelMembers(this);
            } else if (!this.fmLevel.getDimension().isMeasuresDimension() && this.getIndex() > 0) {
                this.writeLock().lock();
                try {
                    if (this.fmLevel.getMembers().size() == 1) {
                        String munName = this.fmLevel.getMembers().get(0).getName();
                        StringValue cap = DataValueFactory.createStringValue();
                        cap.set(munName);
                        DMRMember dummyMember = new DMRMember(cap, (Value)cap.copy(), this);
                        this.addMember(dummyMember);
                    }
                    super.setGotAllMembers();
                }
                finally {
                    this.writeLock().unlock();
                }
            }
        }
        if (this.getMemberCount() == 0 && this.getRestrictionMembers().isEmpty()) {
            return super.getMembers();
        }
        return super.copyMemberMap(false, false);
    }

    @Override
    public IMember getMember(String memberName) throws MetadataException {
        IMember member = null;
        member = this.getMembersOrderedMap().get(memberName);
        if (member != null) {
            return member;
        }
        return super.getMember(memberName);
    }

    private void loadMFWMemberProperties() {
        if (this.fmLevel == null) {
            return;
        }
        DynamicDimensionWrapper dynamicDim = null;
        if (this.fmLevel.getDimension() instanceof DynamicDimensionWrapper) {
            dynamicDim = (DynamicDimensionWrapper)this.fmLevel.getDimension();
        }
        List<IProperty> propertyList = this.fmLevel.getMemberProperties();
        for (IProperty property : propertyList) {
            List<String> roles;
            String uName;
            String[] parts;
            DMRProperty dmrProperty = new DMRProperty(property.getName(), this, property);
            this.propertyUNameToNameMap.put(property.getUniqueName(), property.getName());
            if (dynamicDim != null && (parts = UniqueNameParser.parseNoThrow(uName = property.getUniqueName())) != null && parts.length > 0) {
                parts[0] = dynamicDim.getWrappedDimension().getName();
                uName = UniqueNameGenerator.createUniqueName(parts);
                this.propertyUNameToNameMap.put(uName, property.getName());
            }
            this.addMemberProperty(dmrProperty);
            if (this.descriptionPropertyName != null || (roles = property.getRoles()) == null || !roles.contains(RoleTypeEnum.MEMBER_DESCRIPTION.toV5Keyword())) continue;
            this.descriptionPropertyName = property.getName();
        }
    }

    public boolean isMappedToRelationalColumn() {
        String manual = (String)this.fmLevel.getProperty(ISMANUAL);
        if (manual == null) {
            return true;
        }
        return !manual.equals("true");
    }

    @Override
    public boolean isUnique() {
        return this.fmLevel.isUnique();
    }

    @Override
    public double getOrderOfMagnitude() {
        return this.fmLevel.getOrderOfMagnitude();
    }

    public static IQueryItem getQueryItemWithRole(IMetadata metadata, String role, boolean returnFirstIfNull) {
        IQueryItem result = null;
        List<IMetadata> items = metadata.getChildMetadataObjects();
        IQueryItem firstQI = null;
        if (items == null || items.size() <= 0) {
            return null;
        }
        Iterator<IMetadata> it = items.iterator();
        while (result == null && it.hasNext()) {
            IQueryItem folderRes;
            IMetadata item = it.next();
            if (item instanceof IQueryItem) {
                IProperty qItem;
                List<String> roles;
                if (firstQI == null) {
                    firstQI = (IQueryItem)item;
                }
                if (!(item instanceof IProperty) || (roles = (qItem = (IProperty)item).getRoles()) == null || !roles.contains(role)) continue;
                result = (IQueryItem)item;
                continue;
            }
            if (!(item instanceof IFolder) || (folderRes = DMRLevel.getQueryItemWithRole(item, role, false)) == null) continue;
            result = folderRes;
        }
        if (returnFirstIfNull && result == null) {
            result = firstQI;
        }
        return result;
    }

    public IQueryItem getBusinessKeyQueryItem() {
        return DMRLevel.getQueryItemWithRole(this.fmLevel, BUSINESS_KEY, true);
    }

    public IQueryItem getMemberCaptionQueryItem() {
        return DMRLevel.getQueryItemWithRole(this.fmLevel, MEMBER_CAPTION, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Value[]> runV5QueryForChildren(IMember parent, Pair loadCaptionAndProperties) {
        List<Value[]> listResult = null;
        if (this.fmLevel != null && this.isMappedToRelationalColumn()) {
            DMRCube dmrCube = (DMRCube)this.getDimension().getCube();
            StringBuilder sb = new StringBuilder("LoadChildrenMember");
            sb.append(UNDERSCORE);
            String pName = DMRUtilities.getMetadataNameForLog(parent);
            sb.append(pName);
            V5QueryOverTabularStream query = new V5QueryOverTabularStream(dmrCube, DMRUtilities.SubqueryType.LOAD_MEMBER_CHILDREN, pName, sb.toString());
            query.addColumn(this);
            if (parent != null) {
                this.addRestrictionsForMember(query, parent);
            }
            V5ProviderQueryResult v5Result = query.execute(null);
            RSAPIQueryResult result = v5Result.getRSAPIQueryResult();
            if (query.needLevelCaption(this)) {
                loadCaptionAndProperties.setFirst(Boolean.TRUE);
            } else {
                loadCaptionAndProperties.setFirst(Boolean.FALSE);
            }
            loadCaptionAndProperties.setSecond(query.getLevelProperties(this));
            try {
                listResult = ((V5QueryResult)result).toList(Value[].class);
            }
            finally {
                result.release();
                v5Result = null;
            }
        } else {
            XQEDebugLog.out.println("Error: no members query possible for level " + this.getName());
        }
        return listResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dmrLoadMeasureLevelMembers() {
        this.writeLock().lock();
        try {
            if (!this.hasGotAllMembersNoLock()) {
                IOrderedMap<IMember> membersMap = this.getMembersOrderedMap();
                List<IMember> members = this.fmLevel.getMembers();
                for (IMember member : members) {
                    StringValue v = DataValueFactory.createStringValue();
                    ((Value)v).set(member.getName());
                    DMRMember dmrMember = new DMRMember(v, null, this);
                    membersMap.put(dmrMember);
                }
                super.setGotAllMembers();
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void dmrLoadLevelMembers(DMRLevel level) {
        DMRLevel lowestLevel;
        DMRCube dmrCube = (DMRCube)level.getDimension().getCube();
        int levelThreshold = dmrCube.getLevelCountThreshold();
        if (levelThreshold > 0 && (lowestLevel = dmrCube.getLowestProjectedLevel(level)) != null) {
            level = lowestLevel;
        }
        if (level.hasGotAllMembers() || level.fmLevel == null || !level.isMappedToRelationalColumn()) {
            return;
        }
        if (level.fmLevel.getDimension().isMeasuresDimension()) {
            level.dmrLoadMeasureLevelMembers();
            return;
        }
        level.writeLock().lock();
        try {
            if (!level.hasGotAllMembersNoLock()) {
                boolean bLoadingLevelRequired = true;
                Map.Entry<ILevel, List<BaseMember>> restriction = dmrCube.getRestrictionMembersForHierarchy(level.getHierarchy());
                if (dmrCube.getIncrementalMemberLoading() != DMRCube.IncrementalMemberLoading.NONE && restriction != null && !restriction.getValue().isEmpty()) {
                    bLoadingLevelRequired = false;
                    Comparator<BaseMember> baseMemberComparator = new Comparator<BaseMember>(){

                        @Override
                        public int compare(BaseMember o1, BaseMember o2) {
                            return o1.getExternalName().compareTo(o2.getExternalName());
                        }
                    };
                    ArrayList<BaseMember> existingRestrictionMembers = new ArrayList<BaseMember>(level.restrictionMembers);
                    Collections.sort(existingRestrictionMembers, baseMemberComparator);
                    for (BaseMember newRestrictionMember : restriction.getValue()) {
                        if (Collections.binarySearch(existingRestrictionMembers, newRestrictionMember, baseMemberComparator) >= 0) continue;
                        bLoadingLevelRequired = true;
                        break;
                    }
                }
                if (bLoadingLevelRequired) {
                    if (level.memberStorageForCacheMetrics != null) {
                        level.memberStorageForCacheMetrics.recordMemberCacheMiss();
                    }
                    DMRLevelMemberLoader loader = null;
                    PushdownManager pushDownManager = level.getPushdownManager();
                    loader = pushDownManager != null ? new DMRLevelMemberLoader(level, pushDownManager) : new DMRLevelMemberLoader(level);
                    loader.load();
                }
            }
        }
        finally {
            level.writeLock().unlock();
        }
    }

    protected static void createMemberFromV5Result(int countLevels, List<Value[]> listResult, DMRLevel levelToStartAdding, IMemberCubics rootParentMember, Pair loadCaptionAndProperties) {
        int startRow;
        DMRCube cube = (DMRCube)levelToStartAdding.getDimension().getCube();
        boolean membersCachedInMemberStorage = cube.memberStorageEnabled();
        DMRLevel currentLevel = null;
        for (int i = startRow = 1; i < listResult.size(); ++i) {
            Value[] row = listResult.get(i);
            currentLevel = levelToStartAdding;
            IMemberCubics currentParent = rootParentMember;
            int rowOffset = 0;
            for (int j = 0; j < countLevels; ++j) {
                List props;
                Value businessKey = row[rowOffset];
                ++rowOffset;
                if (businessKey == null) {
                    businessKey = DMRMember.DEFAULT_BUSINESSKEY;
                }
                Value memberName = null;
                if (loadCaptionAndProperties.getFirst() == Boolean.TRUE) {
                    memberName = row[rowOffset];
                    ++rowOffset;
                } else {
                    memberName = (Value)businessKey.copy();
                }
                if (memberName == null) {
                    memberName = DataValueFactory.createStringValue();
                    memberName.set("");
                }
                HashMap<String, Value> propertyValues = null;
                if (loadCaptionAndProperties.getSecond() != null && !(props = (List)loadCaptionAndProperties.getSecond()).isEmpty()) {
                    propertyValues = new HashMap<String, Value>();
                    for (String prop : props) {
                        Value propValue = row[rowOffset];
                        ++rowOffset;
                        propertyValues.put(currentLevel.getMemberProperty(prop).getUniqueName(), propValue);
                    }
                }
                IDMRMember currentMember = null;
                if (currentParent != null) {
                    currentParent.setGotAllChildren();
                    String businessKeyText = businessKey.getV5formattedString();
                    if (businessKey.isNull()) {
                        businessKeyText = "";
                    }
                    if ((currentMember = (IDMRMember)currentParent.searchChildrenOrderedMap(businessKeyText)) != null) {
                        currentParent.removeMember(currentMember);
                        currentParent.addMemberToChildrenOrderedMap(currentMember);
                        currentMember.resetIndexInParentsChildren();
                    }
                }
                if (currentMember == null) {
                    DMRMember dmrMember = new DMRMember(memberName, businessKey, currentLevel);
                    if (propertyValues != null) {
                        for (Map.Entry e : propertyValues.entrySet()) {
                            dmrMember.setProperty((String)e.getKey(), ((Value)e.getValue()).copy());
                        }
                    }
                    currentMember = membersCachedInMemberStorage ? DMRMemberProxy.cacheMember(dmrMember, currentParent) : dmrMember;
                    if (currentParent != null) {
                        currentParent.addMemberToChildrenOrderedMap(currentMember);
                        currentMember.setParentMember(currentParent);
                        if (currentParent instanceof IDMRMember) {
                            ((IDMRMember)currentParent).addChildToBusinessKeyMap(currentMember);
                        }
                    }
                    currentLevel.addMember(currentMember);
                } else if (!currentLevel.hasGotAllMembers()) {
                    currentLevel.removeMember(currentMember);
                    currentLevel.addMember(currentMember);
                }
                currentParent = currentMember;
                currentLevel = (DMRLevel)currentLevel.getNextLevel();
            }
        }
    }

    private void createSetsForRestrictMembers(DMRLevel aLevel, List<Set<IMember>> restrictMembers) {
        if (aLevel.isMappedToRelationalColumn()) {
            HashSet set = new HashSet();
            restrictMembers.add(set);
            if (!aLevel.isUnique()) {
                this.createSetsForRestrictMembers((DMRLevel)aLevel.getPreviousLevel(), restrictMembers);
            }
        }
    }

    private void addRestrictMember(IMember member, List<Set<IMember>> restrictMembers, int pos) {
        DMRLevel subjectLevel = (DMRLevel)member.getLevel();
        if (subjectLevel.isMappedToRelationalColumn() && member.getBusinessKeyValue() != null) {
            IMember parent;
            restrictMembers.get(pos).add(member);
            if (!subjectLevel.isUnique() && (parent = member.getParent()) != null) {
                this.addRestrictMember(parent, restrictMembers, ++pos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void dmrLoadLevelMembersProperty(String propertyName) {
        int startRow;
        if (this.memberStorageForCacheMetrics != null) {
            this.memberStorageForCacheMetrics.recordNewMemberRequest();
        }
        if (this.fmLevel.getDimension().isMeasuresDimension()) {
            return;
        }
        DMRProperty property = (DMRProperty)this.getMemberProperty(propertyName);
        if (property == null) {
            return;
        }
        if (this.memberStorageForCacheMetrics != null) {
            this.memberStorageForCacheMetrics.recordMemberCacheMiss();
        }
        List<DMRLevel> levelsToQuery = this.getParentLevelToQueryWith();
        DMRCube dmrCube = (DMRCube)this.getDimension().getCube();
        StringBuilder sb = new StringBuilder("LoadLevelMembersProperty");
        sb.append(UNDERSCORE);
        String pName = DMRUtilities.getMetadataNameForLog(property);
        sb.append(pName);
        V5QueryOverTabularStream query = new V5QueryOverTabularStream(dmrCube, DMRUtilities.SubqueryType.LOAD_MEMBERS_PROPERTY, pName, sb.toString());
        query.setV5QueryToLoadmembers(false);
        query.setV5QueryToLoadMemberProperties(true);
        query.setUseTabularStream(false);
        int countLevels = levelsToQuery.size();
        ArrayList<DMRProperty> extraLoadProperties = new ArrayList<DMRProperty>();
        for (int i = countLevels - 1; i >= 0; --i) {
            DMRLevel level = levelsToQuery.get(i);
            query.addColumn(level);
            List<DMRProperty> list = level.getPropertiesLoadWithKey(dmrCube);
            if (list == null) continue;
            for (DMRProperty dMRProperty : list) {
                if (i == countLevels - 1 && dMRProperty.equals(property) || dMRProperty.equals(property)) continue;
                extraLoadProperties.add(dMRProperty);
            }
            dmrCube.removeLevelPropertiesLoadedWithMembers(level);
        }
        query.addColumn(property);
        int offset = query.getColumnCount();
        for (DMRProperty prop : extraLoadProperties) {
            query.addColumn(prop);
        }
        if (!this.hasGotAllMembers()) {
            List<IMember> existMembers = super.getMembers();
            int maxMmembersAllowed = dmrCube.getMaxMembersInSubQueryDetailFilter();
            if (existMembers.size() <= maxMmembersAllowed) {
                ArrayList<Set<IMember>> restrictMembers = new ArrayList<Set<IMember>>();
                this.createSetsForRestrictMembers(this, restrictMembers);
                for (IMember iMember : existMembers) {
                    this.addRestrictMember(iMember, restrictMembers, 0);
                }
                for (Set set : restrictMembers) {
                    if (set.isEmpty()) continue;
                    query.addFilteringMembers(set);
                }
            } else {
                LoadDMRCubeSingleV5Query.logSingleLoading(this.getName(), " 's member restrictions are not added because the size exceeds ", Integer.toString(maxMmembersAllowed));
            }
        }
        V5ProviderQueryResult v5Result = query.execute(null);
        RSAPIQueryResult result = v5Result.getRSAPIQueryResult();
        List<Value[]> listResult = null;
        try {
            listResult = ((V5QueryResult)result).toList(Value[].class);
        }
        finally {
            result.release();
            v5Result = null;
        }
        DMRLevel dMRLevel = levelsToQuery.get(levelsToQuery.size() - 1);
        Object var15_24 = null;
        try {
            Level rootLevel = (Level)this.getHierarchy().getLevel(0);
            if (rootLevel.hasGotAllMembers() && rootLevel != this && rootLevel.getMembers().size() == 1) {
                IMember iMember = rootLevel.getMembers().get(0);
            }
        }
        catch (Exception e) {
            mErrorLogger.log(e);
        }
        FormatId businessKeyFormatId = this.getBusinessKeyFormatId();
        String propertyFormat = (String)property.getProperty(FORMAT);
        FormatId propertyFormatId = null;
        if (propertyFormat != null) {
            propertyFormatId = FormatService.getInstance().registerV5Format(propertyFormat, null);
        }
        DMRLevel currentLevel = null;
        for (int i = startRow = 1; i < listResult.size(); ++i) {
            void var15_26;
            Value[] row = listResult.get(i);
            currentLevel = dMRLevel;
            IMember currentParent = var15_26;
            IMember currentMember = null;
            int rowOffset = 0;
            for (int j = 0; j < countLevels; ++j) {
                Value value = row[rowOffset];
                ++rowOffset;
                if (value != null && !value.isNull() && businessKeyFormatId != null) {
                    value.setFormatId(businessKeyFormatId);
                }
                if ((currentMember = ((IDMRMember)currentParent).getChildMemberAsPerBusinessKeyValue(value)) == null) break;
                this.setExtraMemberPropertyValue(currentMember, extraLoadProperties, offset, row);
                currentParent = currentMember;
                currentLevel = (DMRLevel)currentLevel.getNextLevel();
            }
            if (currentMember == null) continue;
            Value propertyValue = row[rowOffset];
            if (propertyValue == null) {
                propertyValue = DataValueFactory.createStringValue();
                propertyValue.set("");
                propertyValue.setState(ValueState.NULL);
            }
            if (propertyFormatId != null) {
                propertyValue.setFormatId(propertyFormatId);
            }
            ((IDMRMember)currentMember).setProperty(propertyName, propertyValue);
        }
    }

    protected List<DMRProperty> getPropertiesLoadWithKey(DMRCube dmrCube) {
        if (!this.hasGotAllMembers()) {
            return null;
        }
        List<String> props = dmrCube.getLevelPropertiesLoadedWithMembers(this);
        if (props == null) {
            return null;
        }
        IDMRMember firstMember = (IDMRMember)this.getMember(0);
        ArrayList<DMRProperty> rt = new ArrayList<DMRProperty>();
        for (String propName : props) {
            if (firstMember.hasProperty(propName)) continue;
            rt.add((DMRProperty)this.getMemberProperty(propName));
        }
        if (rt.isEmpty()) {
            return null;
        }
        return rt;
    }

    protected void setExtraMemberPropertyValue(IMember currentMember, List<DMRProperty> extraLoadProperties, int offset, Value[] row) {
        if (extraLoadProperties.isEmpty()) {
            return;
        }
        ILevel currentLevel = currentMember.getLevel();
        for (int i = 0; i < extraLoadProperties.size(); ++i) {
            DMRProperty property = extraLoadProperties.get(i);
            String propertyName = property.getName();
            if (!property.getLevel().equals(currentLevel) || ((IDMRMember)currentMember).hasProperty(propertyName)) continue;
            Value propertyValue = row[offset + i];
            if (propertyValue == null) {
                propertyValue = DataValueFactory.createStringValue();
                propertyValue.set("");
                propertyValue.setState(ValueState.NULL);
            }
            String propertyFormat = (String)property.getProperty(FORMAT);
            FormatId propertyFormatId = null;
            if (propertyFormat != null) {
                propertyFormatId = FormatService.getInstance().registerV5Format(propertyFormat, null);
            }
            if (propertyFormatId != null) {
                propertyValue.setFormatId(propertyFormatId);
            }
            ((IDMRMember)currentMember).setProperty(propertyName, propertyValue);
        }
    }

    public FormatId getBusinessKeyFormatId() {
        String businessKeyFormat = null;
        IQueryItem businessKeyQueryItem = this.getBusinessKeyQueryItem();
        if (businessKeyQueryItem != null) {
            businessKeyFormat = businessKeyQueryItem.getFormat();
        }
        FormatId businessKeyFormatId = null;
        if (businessKeyFormat != null) {
            businessKeyFormatId = FormatService.getInstance().registerV5Format(businessKeyFormat, null);
        }
        return businessKeyFormatId;
    }

    public FormatId getCaptionFormatId() {
        String captionFormat = null;
        IQueryItem captionQueryItem = this.getMemberCaptionQueryItem();
        if (captionQueryItem != null) {
            captionFormat = captionQueryItem.getFormat();
        }
        FormatId captionFormatId = null;
        if (captionFormat != null) {
            captionFormatId = FormatService.getInstance().registerV5Format(captionFormat, null);
        }
        return captionFormatId;
    }

    public List<DMRLevel> getParentLevelToQueryWith() {
        ArrayList<DMRLevel> levelsToQuery = new ArrayList<DMRLevel>();
        ILevel currentFMLevel = this.fmLevel;
        for (DMRLevel currentLevel = this; currentLevel != null && currentFMLevel != null && currentLevel.isMappedToRelationalColumn(); currentLevel = (DMRLevel)currentLevel.getPreviousLevel()) {
            levelsToQuery.add(currentLevel);
        }
        return levelsToQuery;
    }

    public String getQueryItemExpressionForKey() {
        IQueryItem key;
        if (this.businessKeyModelExpression != null) {
            return this.businessKeyModelExpression;
        }
        String expr = (String)this.fmLevel.getProperty("expression");
        if (expr == null && (expr = (key = this.getBusinessKeyQueryItem()).getExpression()) == null) {
            expr = key.getID();
        }
        this.businessKeyModelExpression = MetadataUtil.extractExpressionFromModelString(expr);
        return this.businessKeyModelExpression;
    }

    public String getQueryItemExpressionForCaption() {
        String expr = (String)this.fmLevel.getProperty("expression");
        if (expr == null) {
            IQueryItem caption = this.getMemberCaptionQueryItem();
            if (caption == null) {
                caption = this.getBusinessKeyQueryItem();
            }
            if ((expr = caption.getExpression()) == null) {
                expr = caption.getID();
            }
        }
        return MetadataUtil.extractExpressionFromModelString(expr);
    }

    @Override
    public ISortItem[] getSortItems() {
        if (this.fmLevel == null) {
            return super.getSortItems();
        }
        return this.fmLevel.getSortItems();
    }

    private void addRestrictionsForMember(V5QueryOverTabularStream query, IMember member) {
        DMRLevel subjectLevel = (DMRLevel)member.getLevel();
        if (subjectLevel.isMappedToRelationalColumn() && member.getBusinessKeyValue() != null) {
            IMember parent;
            query.addFilteringMember(member);
            if (!subjectLevel.isUnique() && (parent = member.getParent()) != null) {
                this.addRestrictionsForMember(query, parent);
            }
        }
    }

    @Override
    public String getV5UniqueName() {
        if (this.v5UniqueName == null && this.fmLevel != null) {
            this.v5UniqueName = this.fmLevel.getV5UniqueName();
        }
        return this.v5UniqueName;
    }

    public String getV5Name() {
        if (this.fmLevel instanceof LevelWrapper) {
            return ((LevelWrapper)this.fmLevel).getV5Name();
        }
        return this.getName();
    }

    @Override
    public void setGotAllMembers() {
        super.setGotAllMembers();
        ILevel parentLevel = this.getPreviousLevel();
        if (parentLevel == null || !((DMRLevel)parentLevel).isMappedToRelationalColumn()) {
            return;
        }
        DMRCube cube = (DMRCube)parentLevel.getDimension().getCube();
        boolean membersCachedInMemberStorage = cube.memberStorageEnabled();
        for (IMember member : parentLevel.getMembers()) {
            boolean hasChilden = false;
            if (member instanceof MemberProxy) {
                hasChilden = ((MemberProxy)member).getChildrenOrderedMapSize() > 0;
            } else {
                boolean bl = hasChilden = ((Member)member).getChildrenOrderedMapSize() > 0;
            }
            if (hasChilden) continue;
            Value theBusinessKey = DMRMember.DEFAULT_BUSINESSKEY;
            StringValue theMemberName = DataValueFactory.createStringValue();
            ((Value)theMemberName).set("");
            INullPlacement currentMember = membersCachedInMemberStorage ? new DMRMemberProxy(null, "", (ILevel)this) : new DMRMember(theMemberName, theBusinessKey, this);
            ((IMemberCubics)member).addMemberToChildrenOrderedMap((IMember)((Object)currentMember));
            currentMember.setParentMember(member);
        }
    }

    @Override
    public String toString() {
        return this.getUniqueName();
    }

    protected void addToCubeMetadataObject(DMRCube cube) {
        cube.addDMRMetadataObject(this.fmLevel, this);
    }

    public boolean isV5LevelWrapper() {
        return this.fmLevel != null && this.fmLevel instanceof V5DataItemToLevelWrapper;
    }

    public SetOfTables getInvolvedTables() {
        if (this.isV5LevelWrapper()) {
            SetOfTables rt = new SetOfTables();
            rt.add("relationalDummy");
            return rt;
        }
        DMRCube dmrCube = (DMRCube)this.getDimension().getCube();
        CubeWrapper cubeWrapper = dmrCube.getModelCube();
        RQPPrePlan prePlan = cubeWrapper.getRQPPrePlanQuery();
        if (prePlan == null) {
            return new SetOfTables();
        }
        ArrayList<IMetadata> queryItems = new ArrayList<IMetadata>();
        queryItems.add(this.getBusinessKeyQueryItem());
        IQueryItem caption = this.getMemberCaptionQueryItem();
        if (caption != null) {
            queryItems.add(caption);
        }
        return PrePlanUtilities.getInvolvedTables(prePlan, queryItems, true);
    }

    public boolean needCaptionWhenLoadMembers() {
        if (this.isV5LevelWrapper()) {
            return false;
        }
        if (this.getQueryItemExpressionForKey().equals(this.getQueryItemExpressionForCaption())) {
            return false;
        }
        if (!this.hasGotAllMembers()) {
            return true;
        }
        ISortItem[] levelSortItems = this.getSortItems();
        return levelSortItems.length == 0;
    }

    @Override
    public Object getProperty(String propertyName) {
        Object property = super.getProperty(propertyName);
        if (property == null && this.fmLevel != null) {
            property = this.fmLevel.getProperty(propertyName);
        }
        return property;
    }

    public SetOfTables getInvolvedTablesForItem(String itemName) {
        DMRCube dmrCube = (DMRCube)this.getDimension().getCube();
        CubeWrapper cubeWrapper = dmrCube.getModelCube();
        RQPPrePlan prePlan = cubeWrapper.getRQPPrePlanQuery();
        if (prePlan == null) {
            return new SetOfTables();
        }
        ArrayList<String> queryItems = new ArrayList<String>();
        IMetadata wrapped = cubeWrapper.getWrapped(this.fmLevel);
        queryItems.add(itemName);
        return PrePlanUtilities.getInvolvedTablesFromOriginalIdentifiers(prePlan, queryItems, true);
    }

    public IXQEQueryNode getBinaryExpression() {
        if (this.fmLevel instanceof V5DataItemToLevelWrapper) {
            return ((V5DataItemToLevelWrapper)this.fmLevel).getBinaryExpression();
        }
        return null;
    }

    public boolean needReturnRawData() {
        if (!this.isV5LevelWrapper()) {
            return false;
        }
        Boolean b = (Boolean)((V5DataItemToLevelWrapper)this.fmLevel).getProperty("ReturnRaw");
        return Boolean.TRUE == b;
    }

    public List<BaseMember> getRestrictionMembers() {
        return this.restrictionMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRestrictionMembers(List<BaseMember> members) {
        this.writeLock().lock();
        try {
            for (BaseMember member : members) {
                for (BaseMember aMember : this.restrictionMembers) {
                    if (aMember != member && !member.isSameExpression(aMember, false)) continue;
                }
                this.restrictionMembers.add(member);
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    public void clearRestrictionMembers() {
        this.writeLock().lock();
        try {
            this.restrictionMembers.clear();
        }
        finally {
            this.writeLock().unlock();
        }
    }

    public String getMemberDescriptionProperty() {
        return this.descriptionPropertyName;
    }

    public List<Pair> getSortPropertyNamesWhenLoadMembers() {
        if (!this.hasSortItemsForTreeMerge()) {
            return null;
        }
        ISortItem[] levelSortItems = this.getSortItems();
        if (levelSortItems == null || levelSortItems.length == 0) {
            return new ArrayList<Pair>();
        }
        ArrayList<Pair> ret = new ArrayList<Pair>();
        for (ISortItem sortItem : levelSortItems) {
            IQueryItem sortQueryItem = V5QueryOverTabularStream.getSortQueryItem(this.getConnection(), sortItem);
            if (sortQueryItem == null) continue;
            ret.add(new Pair(sortQueryItem.getName(), sortItem.getSort().toString()));
        }
        return ret;
    }

    protected boolean hasSortItemsForTreeMerge() {
        if (this.isV5LevelWrapper()) {
            return false;
        }
        DMRCube dmrCube = (DMRCube)this.getDimension().getCube();
        return dmrCube.getIncrementalMemberLoading() == DMRCube.IncrementalMemberLoading.TREE_MERGE;
    }

    public DMRMemberComparator getMemberComparatorForTreeMerge() {
        if (!this.hasSortItemsForTreeMerge()) {
            return null;
        }
        ISortItem[] levelSortItems = this.getSortItems();
        if (levelSortItems == null || levelSortItems.length == 0) {
            DMRMemberComparator r = new DMRMemberComparator();
            r.addCaption(1, ISortItem.NullPlacementType.NULL_LAST);
            r.addBusinessKey(1, ISortItem.NullPlacementType.NULL_LAST);
            return r;
        }
        boolean bSortedOnKey = false;
        boolean bSortedOnCaption = false;
        DMRMemberComparator r = new DMRMemberComparator();
        for (ISortItem sortItem : levelSortItems) {
            IQueryItem sortQueryItem = V5QueryOverTabularStream.getSortQueryItem(this.getConnection(), sortItem);
            if (sortQueryItem == null) continue;
            int d = 1;
            ISortItem.SortType s = sortItem.getSort();
            d = s == ISortItem.SortType.ASCENDING ? 1 : -1;
            DMRProperty propMeta = (DMRProperty)this.getMemberProperty(sortQueryItem.getName());
            if (propMeta.isBusinessKey()) {
                bSortedOnKey = true;
                r.addBusinessKey(d, sortItem.getNullPlacement());
                continue;
            }
            if (propMeta.isMemberCaption()) {
                bSortedOnCaption = true;
                r.addCaption(d, sortItem.getNullPlacement());
                continue;
            }
            r.addProperty(propMeta.getUniqueName(), d, sortItem.getNullPlacement());
        }
        if (!bSortedOnCaption) {
            r.addCaption(1, ISortItem.NullPlacementType.NULL_LAST);
        }
        if (!bSortedOnKey) {
            r.addBusinessKey(1, ISortItem.NullPlacementType.NULL_LAST);
        }
        return r;
    }

    public IOrderedMap<IMember> getMembersNoBlock() {
        return this.members;
    }

    @Override
    public IProperty getMemberProperty(String name) {
        if (this.propertyUNameToNameMap.containsKey(name)) {
            name = this.propertyUNameToNameMap.get(name);
        }
        return super.getMemberProperty(name);
    }

    public ILevel getFMLevel() {
        return this.fmLevel;
    }

    public MetadataContext getMetadataContext() {
        if (this.fmLevel == null) {
            return null;
        }
        IDimension dim = this.fmLevel.getDimension();
        if (dim instanceof AbstractDimensionWrapper) {
            return ((AbstractDimensionWrapper)dim).getMetadataContext();
        }
        return null;
    }

    public void loadDynamicProperty() {
        if (this.bDynamicPropertyLoaded) {
            return;
        }
        this.bDynamicPropertyLoaded = true;
        if (this.fmLevel instanceof LevelWrapper && ((LevelWrapper)this.fmLevel).hasDynamicProperty()) {
            DMRSecondaryLevelMemberLoader loader = new DMRSecondaryLevelMemberLoader(this);
            loader.load();
        }
    }

    public IMember returnNullMemberFromSecondaryLevel(String dynamicProperty) {
        LevelWrapper secondaryLevel = (LevelWrapper)((LevelWrapper)this.fmLevel).getSecondaryLevelByDynamicPropertyName(dynamicProperty);
        if (secondaryLevel == null) {
            return null;
        }
        DMRCube cube = (DMRCube)this.getDimension().getCube();
        DMRLevel dmrSecondaryLevel = (DMRLevel)cube.getWrapper(secondaryLevel);
        return dmrSecondaryLevel.getDummyMember();
    }

    public IMember getDummyMember() {
        if (this.dummyMemberForDynamicProp == null) {
            DMRSecondaryLevelMemberLoader loader = new DMRSecondaryLevelMemberLoader(this);
            this.dummyMemberForDynamicProp = loader.generateDummyMember();
        }
        return this.dummyMemberForDynamicProp;
    }

    public boolean needToConvertEmptyKeyToNull(Governors gv) {
        if (gv == null || gv.getTreatEmptyDMRMUN() != Governors.DMREmptyMUNTreatment.EMPTY_OR_NULL) {
            return false;
        }
        if (this.isV5LevelWrapper()) {
            return false;
        }
        IQueryItem keyQI = this.getBusinessKeyQueryItem();
        if (keyQI == null) {
            return false;
        }
        IDataType dt = keyQI.getDataType();
        if (dt == null) {
            return false;
        }
        return dt.isTextType();
    }

    public String convertEmptyToNull(String expr) {
        return "nullif(" + expr + "; '')";
    }
}

