/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider;

import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.providers.olap.securecache.DMRMemberStorage;
import com.cognos.xqe.data.providers.olap.securecache.DMRMemberStoragePerLevel;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorageKey;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.RollupTypeEnum;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCubeWithCaching;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRDimension;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRProperty;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.IDMRMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.DimensionContext;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MemberProxy;
import com.cognos.xqe.util.INullPlacement;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.ImmutableOrderedMap;
import com.cognos.xqe.util.OrderedMap;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DMRMemberProxy
extends MemberProxy
implements INullPlacement,
IDMRMember {
    private static final String DESCRIPTION_VALUE = "DESCRIPTION_VALUE";
    public static final String MEMBER_BUSINESS_KEY_STR = "MEMBER_BUSINESS_KEY";
    public static final String MEMBER_CAPTION_VALUE = "MEMBER_CAPTION_VALUE";
    private boolean gotAllChildren;
    private int memberId;
    private boolean isFillerMember = false;
    private HashMap<Integer, IMember> fillerMembers = null;
    private final Map<Value, IDMRMember> indexedChildren;
    private String v5Name = null;
    private FormatId childrenFormatId = null;
    protected MemberTypeEnum type = MemberTypeEnum.REGULAR;
    protected RollupTypeEnum rollUpType = RollupTypeEnum.ROLLUP;
    protected byte hierarchyMemberType = 0;

    public DMRMemberProxy(MemberStorageKey memKey, String memName, ILevel memLevel) {
        super(memKey, memName, memLevel);
        if (memKey == null && memName != null && memName.equals("")) {
            this.isFillerMember = true;
            this.memberId = -1;
        } else {
            this.memberId = memKey.getMemberId();
        }
        this.indexedChildren = new HashMap<Value, IDMRMember>(2);
    }

    @Override
    public MemberTypeEnum getType() {
        return this.type;
    }

    @Override
    public RollupTypeEnum getRollupType() {
        return this.rollUpType;
    }

    @Override
    public String getUniqueName() {
        if (this.memberUniqueName == null) {
            this.memberUniqueName = this.isFillerMember() ? this.getName() : this.createUniqueName();
        }
        return this.memberUniqueName;
    }

    protected String createUniqueName() {
        IMember parent = this.getParent();
        if (parent == null) {
            return UniqueNameGenerator.appendUniqueName(this.getHierarchy().getUniqueName(), this.getName());
        }
        return UniqueNameGenerator.appendUniqueName(parent.getUniqueName(), this.getName());
    }

    @Override
    public Object retrievePropValueFromCache(String propertyName) {
        Object value = null;
        if (propertyName.equalsIgnoreCase("MEMBER_CAPTION") || propertyName.equalsIgnoreCase("memberCaption")) {
            propertyName = "CAPTION";
        } else if (propertyName.equalsIgnoreCase("DESCRIPTION")) {
            propertyName = "DESCRIPTION";
        } else {
            if (propertyName.equalsIgnoreCase("MEMBER_TYPE")) {
                return this.getType();
            }
            if (propertyName.equalsIgnoreCase("ROLLUP_TYPE")) {
                return this.getRollupType();
            }
        }
        if (this.isFillerMember()) {
            if (propertyName.equalsIgnoreCase("CAPTION") || propertyName.equalsIgnoreCase(MEMBER_CAPTION_VALUE) || propertyName.equalsIgnoreCase(MEMBER_BUSINESS_KEY_STR) || propertyName.equalsIgnoreCase("MEMBER_UNIQUE_NAME")) {
                value = this.getName();
            }
        } else {
            DMRMemberStoragePerLevel storage = ((DMRLevel)this.getLevel()).getLevelStorage();
            try {
                if (propertyName.equalsIgnoreCase("CAPTION")) {
                    value = storage.getMemberPropValueFromCache((MemberStorageKey)this.getCacheKey(), "CAPTION", false, ((DMRCubeWithCaching)this.getDimension().getCube()).getCubeContext().getUniqueId());
                } else if (propertyName.equalsIgnoreCase(MEMBER_CAPTION_VALUE)) {
                    value = storage.getMemberPropValueFromCache((MemberStorageKey)this.getCacheKey(), MEMBER_CAPTION_VALUE, false, ((DMRCubeWithCaching)this.getDimension().getCube()).getCubeContext().getUniqueId());
                } else if (propertyName.equalsIgnoreCase(MEMBER_BUSINESS_KEY_STR)) {
                    value = storage.getMemberPropValueFromCache((MemberStorageKey)this.getCacheKey(), MEMBER_BUSINESS_KEY_STR, false, ((DMRCubeWithCaching)this.getDimension().getCube()).getCubeContext().getUniqueId());
                } else if (propertyName.equalsIgnoreCase("DESCRIPTION") || propertyName.equalsIgnoreCase(DESCRIPTION_VALUE)) {
                    Object desc;
                    String descriptionPropertyName = ((DMRLevel)this.getLevel()).getMemberDescriptionProperty();
                    if (descriptionPropertyName != null && (desc = this.retrievePropertyValue(storage, descriptionPropertyName)) != null) {
                        value = propertyName.equalsIgnoreCase("DESCRIPTION") ? ((Value)desc).getV5formattedString() : desc;
                    }
                } else {
                    value = this.retrievePropertyValue(storage, propertyName);
                }
            }
            catch (Exception e) {
                throw XQERuntimeException.wrap(e);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object retrievePropertyValue(DMRMemberStoragePerLevel storage, String propertyName) {
        Object value = null;
        DMRProperty dmrProperty = (DMRProperty)this.getLevel().getMemberProperty(propertyName);
        if (dmrProperty != null) {
            if (dmrProperty.isBusinessKey()) {
                return this.getBusinessKeyValue();
            }
            if (dmrProperty.isMemberCaption()) {
                return this.getCaptionValue();
            }
            propertyName = dmrProperty.getUniqueName();
        }
        int contextId = ((DMRCubeWithCaching)this.getDimension().getCube()).getCubeContext().getUniqueId();
        value = storage.getMemberPropValueFromCache((MemberStorageKey)this.getCacheKey(), propertyName, true, contextId);
        if (value == null) {
            try {
                ((DMRLevel)this.getLevel()).writeLock().lock();
                ((DMRLevel)this.getLevel()).getLevelStorage().openBuffer(contextId);
                ((DMRLevel)this.getLevel()).dmrLoadLevelMembersProperty(propertyName);
                value = storage.getDynamicPropValueFromBufferOrAddNullValue((MemberStorageKey)this.getCacheKey(), propertyName, contextId);
            }
            finally {
                ((DMRLevel)this.getLevel()).getLevelStorage().flushToCache(contextId);
                ((DMRLevel)this.getLevel()).writeLock().unlock();
            }
        }
        return value;
    }

    @Override
    protected IOrderedMap<IMember> fetchChildren() {
        IOrderedMap<IMember> children;
        Level childLevel = (Level)this.getLevel().getNextLevel();
        if (childLevel == null) {
            children = ImmutableOrderedMap.EMPTY_ORDERED_MEMBER_MAP;
        } else {
            try {
                if (childLevel.hasGotAllMembers()) {
                    List<IMember> mems = childLevel.getMembers();
                    children = this.createOrderedMap();
                    CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();
                    for (IMember mem : mems) {
                        if (cancelManager != null && cancelManager.isRequestCancelled()) {
                            throw new OperationCanceledException();
                        }
                        if (mem.getParent() != this) continue;
                        children.put(mem);
                    }
                    if (children.size() == 0) {
                        children = ImmutableOrderedMap.EMPTY_ORDERED_MEMBER_MAP;
                    }
                } else {
                    children = this.fetchChildMembers();
                }
            }
            catch (ProviderException e) {
                throw new MetadataException("X01493", new String[]{this.getName(), e.toString()}, e);
            }
        }
        return children;
    }

    @Override
    public void addChildToBusinessKeyMap(IDMRMember child) {
        if (this.childrenFormatId == null) {
            this.childrenFormatId = child.getBusinessKeyValue().getFormatId();
        }
        if (child.getName().equals("")) {
            Value value = child.getBusinessKeyValue();
            this.indexedChildren.put(value, child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOrderedMap<IMember> fetchChildMembers() throws MetadataException, ProviderException {
        Pair loadCaptionAndProperties;
        List<Value[]> v5result;
        IOrderedMap<IMember> result = ImmutableOrderedMap.EMPTY_ORDERED_MEMBER_MAP;
        if (((Level)this.getLevel()).isBottomLevel()) {
            return result;
        }
        DMRLevel currentLevel = (DMRLevel)this.getLevel();
        DMRLevel childLevel = (DMRLevel)this.getLevel().getNextLevel();
        DMRCube dmrCube = (DMRCube)this.getHierarchy().getDimension().getCube();
        DMRLevel loadLevel = dmrCube.getNextNLevelMembers(currentLevel, childLevel);
        if (loadLevel != null) {
            DMRLevel.dmrLoadLevelMembers(loadLevel);
            return this.getChildrenOrderedMap();
        }
        DMRMemberStorage memberStorageForCacheMetrics = (DMRMemberStorage)((DMRCubeWithCaching)dmrCube).getMemberStorage();
        if (memberStorageForCacheMetrics != null) {
            memberStorageForCacheMetrics.recordMemberCacheMiss();
        }
        if ((v5result = childLevel.runV5QueryForChildren(this, loadCaptionAndProperties = new Pair())) == null) {
            return result;
        }
        int contextId = ((DMRCubeWithCaching)this.getDimension().getCube()).getCubeContext().getUniqueId();
        try {
            childLevel.writeLock().lock();
            childLevel.getLevelStorage().openBuffer(contextId);
            DMRLevel.createMemberFromV5Result(1, v5result, childLevel, this, loadCaptionAndProperties);
        }
        finally {
            childLevel.getLevelStorage().flushToCache(contextId);
            childLevel.writeLock().unlock();
        }
        this.setGotAllChildren();
        result = this.getChildrenOrderedMap();
        if (result.size() < 1 && ((DMRLevel)this.getLevel()).isMappedToRelationalColumn()) {
            DMRMemberProxy currentMember = new DMRMemberProxy(null, "", (ILevel)childLevel);
            this.getChildrenOrderedMap().put(currentMember);
            currentMember.setParentMember(this);
        }
        return result;
    }

    @Override
    public boolean isMeasure() {
        return this.getDimension().isMeasuresDimension();
    }

    @Override
    public IDataType getDataType() {
        return MemberType.MEMBERTYPE;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DMRMemberProxy)) {
            if (other instanceof IMember) {
                return this.getUniqueName().equals(((IMember)other).getUniqueName());
            }
            return false;
        }
        if (this.isFillerMember() && ((DMRMemberProxy)other).isFillerMember()) {
            return this.getParent() == ((DMRMemberProxy)other).getParent();
        }
        if (this.isFillerMember() || ((DMRMemberProxy)other).isFillerMember()) {
            return false;
        }
        return this.getCacheKey().equals(((DMRMemberProxy)other).getCacheKey()) && this.hierarchyMemberType == ((DMRMemberProxy)other).hierarchyMemberType;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == -1) {
            if (this.getCacheKey() != null) {
                this.hashCode = this.getCacheKey().hashCode() * 61;
                this.hashCode = this.hashCode * 61 + this.hierarchyMemberType;
            } else {
                this.hashCode = this.memberId * 61;
            }
        }
        return this.hashCode;
    }

    @Override
    public int compareTo(Object arg0) {
        if (!(arg0 instanceof DMRMemberProxy)) {
            if (arg0 instanceof IMember) {
                return this.getUniqueName().compareTo(((IMember)arg0).getUniqueName());
            }
            return -1;
        }
        if (this.equals(arg0)) {
            return 0;
        }
        if (this.isFillerMember() && ((DMRMemberProxy)arg0).isFillerMember()) {
            return this.getParent().compareTo(((DMRMemberProxy)arg0).getParent());
        }
        if (this.isFillerMember()) {
            return -1;
        }
        if (((DMRMemberProxy)arg0).isFillerMember()) {
            return 1;
        }
        int r = this.getCacheKey().compareTo(((DMRMemberProxy)arg0).getCacheKey());
        if (r == 0) {
            if (this.hierarchyMemberType > ((DMRMemberProxy)arg0).hierarchyMemberType) {
                r = 1;
            } else if (this.hierarchyMemberType < ((DMRMemberProxy)arg0).hierarchyMemberType) {
                r = -1;
            }
        }
        return r;
    }

    @Override
    public int getIndex() {
        return this.memberId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIndexInParentsChildren() {
        if (this.indexInParentsChildrenList == -1) {
            DMRMemberProxy dMRMemberProxy = this;
            synchronized (dMRMemberProxy) {
                IMember parentMember = this.getParent(true);
                if (parentMember == null) {
                    List<IMember> rootLevelMembers = this.getLevel().getMembers();
                    this.indexInParentsChildrenList = rootLevelMembers.size() > 0 ? rootLevelMembers.indexOf(this) : -1;
                } else if (((IMemberCubics)parentMember).isFillerMember()) {
                    IMember realParent = parentMember;
                    while (((IMemberCubics)realParent).isFillerMember()) {
                        realParent = parentMember.getParent();
                    }
                    this.indexInParentsChildrenList = ((MemberProxy)realParent).getChildIndex(this);
                } else {
                    this.indexInParentsChildrenList = ((MemberProxy)parentMember).getChildIndex(this, true);
                }
            }
        }
        return this.indexInParentsChildrenList;
    }

    @Override
    public long getMemberId() {
        return this.memberId;
    }

    @Override
    public boolean isFillerMember() {
        return this.isFillerMember;
    }

    @Override
    public synchronized ArrayList<IMember> getChildFillerMembers() {
        if (this.fillerMembers == null) {
            return null;
        }
        ArrayList<IMember> childFillerMembers = new ArrayList<IMember>();
        childFillerMembers.addAll(this.fillerMembers.values());
        return childFillerMembers;
    }

    public void setFillerMember(boolean theIsFillerMember) {
        this.isFillerMember = theIsFillerMember;
    }

    @Override
    public String getDescription() {
        return (String)this.retrievePropValueFromCache("DESCRIPTION");
    }

    @Override
    public Value getDescriptionValue() {
        return (Value)this.retrievePropValueFromCache(DESCRIPTION_VALUE);
    }

    @Override
    public List<IMember> getChildren(boolean includeFillerMembers, int maxLevelIndex) {
        if (this.isPopulateChildrenRequired()) {
            this.populateChildren();
        }
        if (this.hasGotAllChildren() || !this.getHierarchy().isRagged() || maxLevelIndex == -1) {
            return this.getChildren(includeFillerMembers);
        }
        ArrayList<IMember> result = new ArrayList<IMember>();
        IOrderedMap<IMember> children = this.getChildrenOrderedMap(maxLevelIndex);
        if (children != null) {
            if (includeFillerMembers) {
                result.addAll(children.toArrayList());
            } else {
                for (IMemberCubics iMemberCubics : children) {
                    if (iMemberCubics.isFillerMember()) {
                        List<IMember> nonFillerChildren = iMemberCubics.getChildren(false, maxLevelIndex);
                        result.addAll(nonFillerChildren);
                        continue;
                    }
                    result.add(iMemberCubics);
                }
            }
        }
        return result;
    }

    @Override
    public boolean isNullPlacement() {
        String caption = this.getCaption();
        return caption == null || caption.length() == 0;
    }

    @Override
    public boolean isDMR() {
        return true;
    }

    @Override
    public boolean hasGotAllChildren() {
        return this.gotAllChildren;
    }

    @Override
    public synchronized void setGotAllChildren() {
        super.setGotAllChildren();
        this.gotAllChildren = true;
    }

    @Override
    public IOrderedMap<IMember> getChildrenOrderedMap() {
        DMRMemberStorage memberStorageForCacheMetrics = DMRMemberProxy.getStorage((DMRDimension)this.getHierarchy().getDimension());
        if (memberStorageForCacheMetrics != null) {
            memberStorageForCacheMetrics.recordNewMemberRequest();
        }
        this.initChildrenOrderedMap();
        return this.childrenOrderedMap;
    }

    private static DMRMemberStorage getStorage(DMRDimension dim) {
        DimensionContext context = dim.getStorage();
        if (context != null) {
            return (DMRMemberStorage)context.getMemberStorage();
        }
        DMRCubeWithCaching cube = (DMRCubeWithCaching)dim.getCube();
        return (DMRMemberStorage)cube.getMemberStorage();
    }

    @Override
    public boolean isPopulateChildrenRequired() {
        DMRCube cube = (DMRCube)this.getLevel().getDimension().getCube();
        if (cube.getIncrementalMemberLoading() == DMRCube.IncrementalMemberLoading.NONE) {
            return !this.hasGotAllChildren();
        }
        if (this.hasGotAllChildren()) {
            return false;
        }
        if (((Level)this.getLevel()).getPushdownManager() != null) {
            return this.getChildrenOrderedMapSize() == 0;
        }
        DMRCube dmrCube = (DMRCube)this.getLevel().getDimension().getCube();
        Map.Entry<ILevel, List<BaseMember>> restriction = dmrCube.getRestrictionMembersForHierarchy(this.getHierarchy());
        if (restriction == null || restriction.getValue().isEmpty()) {
            return true;
        }
        int highestRestrictionLevel = Integer.MAX_VALUE;
        for (BaseMember restrictionMember : restriction.getValue()) {
            int restrictionMemberLevel = restrictionMember.getLevel().getIndex();
            if (highestRestrictionLevel <= restrictionMemberLevel) continue;
            highestRestrictionLevel = restrictionMemberLevel;
        }
        if (highestRestrictionLevel < this.getLevel().getIndex()) {
            return true;
        }
        if (highestRestrictionLevel == this.getLevel().getIndex()) {
            for (BaseMember restrictionMember : restriction.getValue()) {
                if (!restrictionMember.getExternalName().equals(this.getUniqueName())) continue;
                return this.getChildrenOrderedMapSize() == 0;
            }
            return true;
        }
        return this.getChildrenOrderedMapSize() == 0;
    }

    protected OrderedMap<IMember> createOrderedMap() {
        if (this.getLevel() instanceof DMRLevel) {
            return ((DMRLevel)this.getLevel()).createOrderedMap();
        }
        return new OrderedMap<IMember>();
    }

    @Override
    public IMember getChildMemberAsPerBusinessKeyValue(Value theBusinessKey) {
        if (this.childrenFormatId == null) {
            return null;
        }
        Value[] rtBusinessKey = new Value[]{null};
        String childMemberName = DMRMember.convertBusinessKeyToDMRMemberName(theBusinessKey, this.childrenFormatId, rtBusinessKey);
        if (rtBusinessKey[0] != null) {
            theBusinessKey = rtBusinessKey[0];
        }
        IMember childMember = childMemberName.equals("") ? (IMember)this.indexedChildren.get(theBusinessKey) : this.getChildMember(childMemberName);
        return childMember;
    }

    @Override
    public IMember searchChildMemberAsPerBusinessKeyValue(Value theBusinessKey) {
        if (this.childrenFormatId == null) {
            return null;
        }
        Value[] rtBusinessKey = new Value[]{null};
        String childMemberName = DMRMember.convertBusinessKeyToDMRMemberName(theBusinessKey, this.childrenFormatId, rtBusinessKey);
        if (rtBusinessKey[0] != null) {
            theBusinessKey = rtBusinessKey[0];
        }
        IMember childMember = childMemberName.equals("") ? (IMember)this.indexedChildren.get(theBusinessKey) : this.searchChildrenOrderedMap(childMemberName);
        return childMember;
    }

    @Override
    public Value getBusinessKeyValue() {
        Value bkValue = DMRMember.DEFAULT_BUSINESSKEY;
        if (!this.isFillerMember()) {
            bkValue = (Value)this.retrievePropValueFromCache(MEMBER_BUSINESS_KEY_STR);
        }
        return bkValue;
    }

    @Override
    public synchronized String getV5Name() {
        if (this.v5Name != null) {
            return this.v5Name;
        }
        return this.getName();
    }

    @Override
    public synchronized void setV5Name(String name) {
        this.v5Name = name;
    }

    @Override
    public String getV5UniqueName() {
        return DMRMember.createMemberV5UniqueName(this);
    }

    @Override
    public boolean isRelational() {
        return true;
    }

    @Override
    public Value getCaptionValue() {
        return (Value)this.retrievePropValueFromCache(MEMBER_CAPTION_VALUE);
    }

    @Override
    public String getCaption() {
        return (String)this.retrievePropValueFromCache("CAPTION");
    }

    public static DMRMemberProxy cacheMember(DMRMember dmrMember, IMemberCubics parentMember) {
        DMRMemberStoragePerLevel storage = ((DMRLevel)dmrMember.getLevel()).getLevelStorage();
        DMRMemberStoragePerLevel.UniqueKey memberKey = (DMRMemberStoragePerLevel.UniqueKey)storage.cacheMember(dmrMember, (DMRMemberProxy)parentMember, ((DMRCubeWithCaching)dmrMember.getDimension().getCube()).getCubeContext().getUniqueId());
        DMRMemberProxy dmrMemberProxy = new DMRMemberProxy(memberKey, memberKey.getMUN(), dmrMember.getLevel());
        dmrMemberProxy.type = dmrMember.getType();
        dmrMemberProxy.rollUpType = dmrMember.getRollupType();
        return dmrMemberProxy;
    }

    public static DMRMemberProxy cacheMemberRootMember(DMRMember dmrMember) {
        DMRMemberStoragePerLevel storage = ((DMRLevel)dmrMember.getLevel()).getLevelStorage();
        DMRMemberStoragePerLevel.UniqueKey memberKey = (DMRMemberStoragePerLevel.UniqueKey)storage.cacheRootMember(dmrMember);
        DMRMemberProxy dmrMemberProxy = new DMRMemberProxy(memberKey, memberKey.getMUN(), dmrMember.getLevel());
        dmrMemberProxy.type = dmrMember.getType();
        dmrMemberProxy.rollUpType = dmrMember.getRollupType();
        return dmrMemberProxy;
    }

    public static DMRMemberProxy cloneRootMember(DMRMemberProxy rootmember) {
        DMRMemberProxy dmrMemberProxy = new DMRMemberProxy((MemberStorageKey)rootmember.getCacheKey(), rootmember.getName(), rootmember.getLevel());
        dmrMemberProxy.type = rootmember.type;
        dmrMemberProxy.rollUpType = rootmember.rollUpType;
        DMRMemberStoragePerLevel storage = ((DMRLevel)rootmember.getLevel()).getLevelStorage();
        dmrMemberProxy.memberId = storage.getNewMemberID();
        return dmrMemberProxy;
    }

    @Override
    public boolean hasProperty(String propertyName) {
        if (propertyName.equalsIgnoreCase("MEMBER_CAPTION") || propertyName.equalsIgnoreCase("memberCaption")) {
            propertyName = "CAPTION";
        } else if (propertyName.equalsIgnoreCase("DESCRIPTION")) {
            propertyName = "DESCRIPTION";
        } else {
            if (propertyName.equalsIgnoreCase("MEMBER_TYPE")) {
                return true;
            }
            if (propertyName.equalsIgnoreCase("ROLLUP_TYPE")) {
                return true;
            }
        }
        if (this.isFillerMember()) {
            return propertyName.equalsIgnoreCase("CAPTION") || propertyName.equalsIgnoreCase(MEMBER_CAPTION_VALUE) || propertyName.equalsIgnoreCase(MEMBER_BUSINESS_KEY_STR) || propertyName.equalsIgnoreCase("MEMBER_UNIQUE_NAME");
        }
        DMRMemberStoragePerLevel storage = ((DMRLevel)this.getLevel()).getLevelStorage();
        try {
            if (propertyName.equalsIgnoreCase("CAPTION")) {
                return true;
            }
            if (propertyName.equalsIgnoreCase(MEMBER_CAPTION_VALUE)) {
                return true;
            }
            if (propertyName.equalsIgnoreCase(MEMBER_BUSINESS_KEY_STR)) {
                return true;
            }
            if (propertyName.equalsIgnoreCase("MEMBER_UNIQUE_NAME")) {
                return true;
            }
            if ((propertyName.equalsIgnoreCase("DESCRIPTION") || propertyName.equalsIgnoreCase(DESCRIPTION_VALUE)) && (propertyName = ((DMRLevel)this.getLevel()).getMemberDescriptionProperty()) == null) {
                return false;
            }
            DMRProperty dmrProperty = (DMRProperty)this.getLevel().getMemberProperty(propertyName);
            if (dmrProperty != null) {
                if (dmrProperty.isBusinessKey()) {
                    return true;
                }
                if (dmrProperty.isMemberCaption()) {
                    return true;
                }
            }
            return storage.hasDynamicPropertyInCache((MemberStorageKey)this.getCacheKey(), propertyName, ((DMRCubeWithCaching)this.getDimension().getCube()).getCubeContext().getUniqueId());
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
    }

    @Override
    public void setProperty(String propName, Object propValue) {
        if (propValue != null) {
            DMRMemberStoragePerLevel storage = ((DMRLevel)this.getLevel()).getLevelStorage();
            storage.setDynamicPropertyIfNotExist((MemberStorageKey)this.getCacheKey(), propName, propValue, ((DMRCubeWithCaching)this.getDimension().getCube()).getCubeContext().getUniqueId());
        }
    }

    @Override
    public MetadataConnection getConnection() {
        throw new UnsupportedOperationException();
    }

    public byte getHierarchyMemberType() {
        return this.hierarchyMemberType;
    }

    public void setHierarchyMemberType(byte t) {
        this.hierarchyMemberType = t;
    }

    @Override
    public void setIndexInParentsChildren(int index) {
        this.indexInParentsChildrenList = index;
    }
}

