/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider;

import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.CJSPreloader;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DMRPreloadQueryEliminator {
    public static List<CJSPreloader> eliminatesUnnecesaryPreloadQueries(List<CJSPreloader> cjsPreloaders) {
        ArrayList<CJSPreloader> subqueriesToDB = new ArrayList<CJSPreloader>();
        for (CJSPreloader cjSworker : cjsPreloaders) {
            if (subqueriesToDB.size() == 0) {
                subqueriesToDB.add(cjSworker);
                continue;
            }
            if (!DMRPreloadQueryEliminator.setsRequiredPreloadQuery(cjSworker, subqueriesToDB)) continue;
            subqueriesToDB.add(cjSworker);
        }
        return subqueriesToDB;
    }

    private static boolean setsRequiredPreloadQuery(CJSPreloader cjsPreloader, List<CJSPreloader> cjsPreloadersToDB) {
        ArrayList<V5QueryGroup> v5QueryGroupsToDB = new ArrayList<V5QueryGroup>();
        List<V5QueryGroup> v5QueryGroups = cjsPreloader.getV5QueryGroups();
        ArrayList<List<V5QueryGroup>> listV5QueryGroups = new ArrayList<List<V5QueryGroup>>();
        for (CJSPreloader preloaderToDB : cjsPreloadersToDB) {
            listV5QueryGroups.add(preloaderToDB.getV5QueryGroups());
        }
        for (V5QueryGroup v5QueryGroup : v5QueryGroups) {
            boolean v5QueryGroupIsHandled = false;
            for (List list : listV5QueryGroups) {
                if (!DMRPreloadQueryEliminator.v5QueryGroupMeasuresAreAlreadyHandled(v5QueryGroup, list)) continue;
                v5QueryGroupIsHandled = true;
                break;
            }
            if (v5QueryGroupIsHandled) continue;
            v5QueryGroupsToDB.add(v5QueryGroup);
        }
        cjsPreloader.setV5QueryGroups(v5QueryGroupsToDB);
        return cjsPreloader.getV5QueryGroups().size() > 0;
    }

    private static boolean v5QueryGroupMeasuresAreAlreadyHandled(V5QueryGroup v5QueryGroup, List<V5QueryGroup> listV5QueryGroupToDB) {
        boolean isV5QueryGroupHandled = false;
        for (V5QueryGroup v5QueryGroupToDB : listV5QueryGroupToDB) {
            if (!DMRPreloadQueryEliminator.allMeasuresHandled(v5QueryGroup.getListOfMeasures(), v5QueryGroupToDB.getListOfMeasures())) continue;
            isV5QueryGroupHandled = true;
            break;
        }
        return isV5QueryGroupHandled;
    }

    private static boolean allMeasuresHandled(List<Map<IMember, List<ILevel>>> listMeasures1, List<Map<IMember, List<ILevel>>> listMeasures2) {
        boolean allMeasuresFound = true;
        for (Map<IMember, List<ILevel>> x : listMeasures1) {
            if (DMRPreloadQueryEliminator.measuresFoundInList(x, listMeasures2)) continue;
            allMeasuresFound = false;
            break;
        }
        return allMeasuresFound;
    }

    private static boolean measuresFoundInList(Map<IMember, List<ILevel>> measure, List<Map<IMember, List<ILevel>>> measuresToDB) {
        boolean found = false;
        for (Map<IMember, List<ILevel>> measureToDB : measuresToDB) {
            if (!DMRPreloadQueryEliminator.allMeasuresFound(measure, measureToDB)) continue;
            found = true;
            break;
        }
        return found;
    }

    private static boolean allMeasuresFound(Map<IMember, List<ILevel>> measures1, Map<IMember, List<ILevel>> measures2) {
        boolean allMeasuresFound = true;
        for (IMember measure1 : measures1.keySet()) {
            boolean measureFound = false;
            List<ILevel> levels1 = measures1.get(measure1);
            for (IMember measure2 : measures2.keySet()) {
                List<ILevel> levels2;
                if (!DMRPreloadQueryEliminator.preloadMeasureEquals(measure1, levels1, measure2, levels2 = measures2.get(measure2))) continue;
                measureFound = true;
                break;
            }
            if (measureFound) continue;
            allMeasuresFound = false;
            break;
        }
        return allMeasuresFound;
    }

    private static boolean preloadMeasureEquals(IMember measure1, List<ILevel> levels1, IMember measure2, List<ILevel> levels2) {
        return measure1.equals(measure2) && DMRPreloadQueryEliminator.preloadAreLevelsEqual(levels1, levels2);
    }

    private static boolean preloadAreLevelsEqual(List<ILevel> levels1, List<ILevel> levels2) {
        boolean hasAllLevels = true;
        for (ILevel level1 : levels1) {
            boolean hasLevel = false;
            for (ILevel level2 : levels2) {
                if (!level1.equals(level2)) continue;
                hasLevel = true;
                break;
            }
            if (hasLevel) continue;
            hasAllLevels = false;
            break;
        }
        return hasAllLevels;
    }
}

