/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXNamedSetDefinition;
import com.cognos.xqe.ast.olap.MDXNamedSetReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.PreLoadDMRCubeUtil;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SelectQuery;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.DMRPushdownAdapter;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.IPushdownAdapter;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DMRQueryStrategyPreCellLoading
extends QueryStrategy {
    private static final XQELogger INFO_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "PreLoadCells", LogLevel.INFO);
    private static final String MSG1 = " preload is not applicable. Some set function needs cell values to evaluate.";
    public static final DoubleValue ZERO_VALUE = DataValueFactory.createDoubleValue();
    private static final int[] FUNCTIONS_CELLVALUE;
    private static final int[] REFS;
    private static final int[] CONSTS;
    private boolean inProcessOfPreCellLoading = false;
    private boolean loadLowestLevel = true;
    private boolean isPreLoaded = false;
    private boolean preloading = false;
    private int maxCells = 0;
    private int visitedTuples = 0;
    private TreeMap<Integer, HashSet<IMember>[]> groupTuplesByLevels = new TreeMap();
    private HashMap<ILevel, HashSet<IMember>> groupedByLevels = new HashMap();
    private int tupleSz = -1;
    private int measurePos = -1;

    public void setLimit(int limit) {
        this.maxCells = limit;
    }

    public void setInProcessOfPreCellLoading(boolean b) {
        this.inProcessOfPreCellLoading = b;
    }

    public boolean getInProcessOfPreCellLoading() {
        return this.inProcessOfPreCellLoading;
    }

    public void setLoadLowestLevel(boolean b) {
        this.loadLowestLevel = b;
    }

    public boolean loadLowestLevel() {
        return this.loadLowestLevel;
    }

    public void setIsPreLoaded() {
        this.isPreLoaded = true;
    }

    public boolean isPreLoaded() {
        return this.isPreLoaded;
    }

    public void clear() {
        this.visitedTuples = 0;
        this.groupTuplesByLevels.clear();
        this.groupedByLevels.clear();
        this.tupleSz = -1;
    }

    public void setPreloading(boolean b) {
        this.preloading = b;
    }

    public boolean getPreLoading() {
        return this.preloading;
    }

    @Override
    public IPushdownAdapter getPushdownAdapter() {
        return new DMRPushdownAdapter();
    }

    @Override
    public void execute(CrossJoinedSet cjs, IResultSet resultSet) throws InterpreterException {
        if (cjs.size() == 0L) {
            return;
        }
        List<IDimension> dimensions = this.getCube().getDimensions();
        IIterator it2 = cjs.dimensionOrderedIterator(dimensions.toArray(new Dimension[dimensions.size()]));
        while (it2.hasNext()) {
            if (this.visitedTuples >= this.maxCells) {
                this.clear();
                throw new InterpreterException("Stop Pre-loading");
            }
            Tuple t = (Tuple)((Tuple)it2.next()).copy();
            ++this.visitedTuples;
            this.groupTupleByLevelsOrdinal(t);
            DoubleValue value = DataValueFactory.createDoubleValue();
            value.set(ZERO_VALUE);
            resultSet.addCell(t, new Cell(value));
        }
    }

    public List<CrossJoinedSet> getCrossJoinedSet() {
        if (this.visitedTuples == 0) {
            return null;
        }
        return this.getCrossJoinedSetFromTuplesExtra();
    }

    public static List<IMember[][]> getPreciseSelectionsFromCJS(CrossJoinedSet cjs, DMRCube cube) {
        TreeMap<Integer, HashSet[]> groupedTuples = new TreeMap<Integer, HashSet[]>();
        int i = 0;
        List<IDimension> dimensions = cube.getDimensions();
        IIterator it2 = cjs.dimensionOrderedIterator(dimensions.toArray(new Dimension[dimensions.size()]));
        while (it2.hasNext()) {
            Tuple t = (Tuple)it2.next();
            Integer id = DMRQueryStrategyPreCellLoading.computeTupleOrdinal(t);
            HashSet[] tps = (HashSet[])groupedTuples.get(id);
            if (tps == null) {
                tps = new HashSet[t.size()];
                groupedTuples.put(id, tps);
            }
            IMember[] members = t.getMembers();
            for (i = 0; i < members.length; ++i) {
                if (tps[i] == null) {
                    tps[i] = new HashSet();
                }
                tps[i].add(members[i]);
            }
        }
        ArrayList<IMember[][]> rt = new ArrayList<IMember[][]>();
        for (Map.Entry e : groupedTuples.entrySet()) {
            HashSet[] s = (HashSet[])e.getValue();
            IMember[][] r = new IMember[s.length][];
            for (i = 0; i < s.length; ++i) {
                r[i] = s[i].toArray(new IMember[s[i].size()]);
            }
            rt.add(r);
        }
        return rt;
    }

    private static Integer computeTupleOrdinal(Tuple tp) {
        int ord = 0;
        int baseSectionSize = 1;
        IMember[] members = tp.getMembers();
        int i = 0;
        for (i = 0; i < members.length; ++i) {
            ILevel level = members[i].getLevel();
            IDimension dim = level.getDimension();
            if (dim.isMeasuresDimension()) continue;
            int levelIdx = level.getIndex();
            int dimLevels = dim.getLevelCount();
            ord += levelIdx * baseSectionSize;
            baseSectionSize *= dimLevels;
        }
        return XQEIntegerPool.getInteger(ord * -1);
    }

    protected List<CrossJoinedSet> getCrossJoinedSetFromTuplesExtra() {
        ArrayList<CrossJoinedSet> result = new ArrayList<CrossJoinedSet>();
        for (Map.Entry<Integer, HashSet<IMember>[]> e : this.groupTuplesByLevels.entrySet()) {
            ISet[] ss = new Set[this.tupleSz];
            HashSet<IMember>[] members = e.getValue();
            for (int i = 0; i < ss.length; ++i) {
                ss[i] = new Set(Tuple.createTupleList(members[i].toArray(new IMember[members[i].size()])));
            }
            result.add(new CrossJoinedSet(ss));
        }
        this.clear();
        return result;
    }

    private void groupTupleByLevelsOrdinal(Tuple tp) {
        this.tupleSz = tp.size();
        int ord = 0;
        int baseSectionSize = 1;
        IMember measure = null;
        IMember[] members = tp.getMembers();
        int i = 0;
        for (i = 0; i < members.length; ++i) {
            ILevel level = members[i].getLevel();
            IDimension dim = level.getDimension();
            if (dim.isMeasuresDimension()) {
                measure = members[i];
                if (this.measurePos != -1) continue;
                this.measurePos = i;
                continue;
            }
            HashSet<IMember> s = this.groupedByLevels.get(level);
            if (s == null) {
                s = new HashSet();
                this.groupedByLevels.put(level, s);
            }
            s.add(members[i]);
            int levelIdx = level.getIndex();
            int dimLevels = dim.getLevelCount();
            ord += levelIdx * baseSectionSize;
            baseSectionSize *= dimLevels;
        }
        Integer gId = XQEIntegerPool.getInteger(ord * -1);
        HashSet<IMember>[] sets = this.groupTuplesByLevels.get(gId);
        if (sets != null) {
            sets[this.measurePos].add(measure);
            return;
        }
        sets = new HashSet[members.length];
        this.groupTuplesByLevels.put(gId, sets);
        for (i = 0; i < members.length; ++i) {
            ILevel level = members[i].getLevel();
            IDimension dim = level.getDimension();
            if (dim.isMeasuresDimension()) {
                if (sets[i] == null) {
                    sets[i] = new HashSet();
                }
                sets[i].add(measure);
                continue;
            }
            sets[i] = this.groupedByLevels.get(level);
        }
    }

    public static int getPreLoadCellCountThreshold(IDataSource dataSource, XMdxLocal xmdxLocal, ICube modelCube) {
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        int preloadThreshold = capabilities.getIntegerValue("preLoadCellCountThreshold", 0);
        if (preloadThreshold <= 0) {
            return 0;
        }
        if (xmdxLocal.getParent().getType() == 501088) {
            return 0;
        }
        if (!(modelCube instanceof CubeWrapper)) {
            return 0;
        }
        if (((CubeWrapper)modelCube).getTabStreamWrapper() != null) {
            return 0;
        }
        MDXQuery q = xmdxLocal.getMDXQuery();
        if (q == null) {
            return 0;
        }
        String nm = q.getV5NameProperty();
        if (nm != null && nm.endsWith("MultiDimensionalSubquery")) {
            return 0;
        }
        if (PreLoadDMRCubeUtil.cubeHasTemporaryObjects(modelCube, xmdxLocal)) {
            return 0;
        }
        List<IMeasure> cubeMeasures = xmdxLocal.getMDXQuery().getInvolvedMeasuresAndMeasuresFactDrivenCustomValue();
        if (cubeMeasures.isEmpty()) {
            return 0;
        }
        if (capabilities.isSupported("pushdownFilterToRelational")) {
            return 0;
        }
        if (capabilities.isSupported("pushdownHeadTailToRelational")) {
            return 0;
        }
        if (capabilities.isSupported("pushdownTopBottomCountToRelational")) {
            return 0;
        }
        if (capabilities.isSupported("pushdownTopPercentSumToRelational")) {
            return 0;
        }
        MDXLevelInfo levelInfo = xmdxLocal.getLevelInfoProperty();
        for (IHierarchy infoHierarchy : levelInfo.getHierarchyInfo().getProjectedHierarchies()) {
            ILevel lowestLevel;
            if (infoHierarchy.getDimension().isMeasuresDimension() || (lowestLevel = levelInfo.getLowestProjectedLevelsSkipCalculation(infoHierarchy)) == null || !(lowestLevel instanceof MDXLevelInfo.LevelInfo) || (lowestLevel = ((MDXLevelInfo.LevelInfo)lowestLevel).getLevel()).getName() != "tagLevelForCompleteTuple") continue;
            return 0;
        }
        return preloadThreshold;
    }

    public static int getPreLoadCellsThreshold(DMRCube cube, SelectQuery query, MDXQuery mdxQuery) {
        int nSetting = cube.getPreLoadCellCountThreshold();
        if (nSetting <= 0) {
            return 0;
        }
        if (!query.hasMeasureDimensions()) {
            return 0;
        }
        ISet[] ss = query.getAxes();
        int n = 1;
        for (ISet s : ss) {
            if (s == null) continue;
            n = (int)((long)n * s.size());
        }
        if (n == 0 || n > nSetting) {
            if (n > nSetting) {
                StringBuilder sb = new StringBuilder();
                sb.append(" too many cells to preload. number of cells: ");
                sb.append(n);
                sb.append(". Preload Threshold: ");
                sb.append(nSetting);
                DMRQueryStrategyPreCellLoading.logWithReportName(mdxQuery, sb.toString());
            }
            return 0;
        }
        HashMap<String, Boolean> calcDependingOnCellValue = new HashMap<String, Boolean>();
        HashMap<String, Boolean> namedSetDependingOnCellValue = new HashMap<String, Boolean>();
        IXQEQueryNode[] calcs = mdxQuery.getDescendantsOfType(1005, false);
        boolean[] hasCalculation = new boolean[]{false};
        for (IXQEQueryNode aC : calcs) {
            LinkedList<String> stack = new LinkedList<String>();
            if (!DMRQueryStrategyPreCellLoading.setCalculationNamedSetDependingOnCellValue(aC, calcDependingOnCellValue, namedSetDependingOnCellValue, stack, hasCalculation)) {
                DMRQueryStrategyPreCellLoading.logWithReportName(mdxQuery, MSG1);
                return 0;
            }
            String name = ((MDXCalculatedMemberDefinition)aC).getUniqueName();
            if (calcDependingOnCellValue.get(name) == Boolean.FALSE) continue;
            DMRQueryStrategyPreCellLoading.logWithReportName(mdxQuery, MSG1);
            return 0;
        }
        if (!hasCalculation[0]) {
            DMRQueryStrategyPreCellLoading.logWithReportName(mdxQuery, " preload is not required because there is no calculation.");
            return 0;
        }
        return nSetting;
    }

    protected static boolean hasFunctionsDependingOnCellValue(IXQEQueryNode node) {
        IXQEQueryNode[] fs;
        for (IXQEQueryNode f : fs = node.getDescendantsOfTypes(FUNCTIONS_CELLVALUE, false)) {
            IXQEQueryNode[] tps;
            int type = f.getType();
            if (type != 1053 && type != 1085) {
                return true;
            }
            int pos = 0;
            if (type == 1053) {
                pos = 1;
            }
            if ((tps = f.getChild(pos).getDescendantsOfType(1069, false)).length <= 0) continue;
            return true;
        }
        return false;
    }

    protected static boolean setCalculationNamedSetDependingOnCellValue(IXQEQueryNode aC, HashMap<String, Boolean> calcDependingOnCellValue, HashMap<String, Boolean> namedSetDependingOnCellValue, LinkedList<String> stack, boolean[] hasCalculation) {
        boolean bHasFnsDependingOnCellValue;
        int type = aC.getType();
        String name = null;
        if (type == 1005) {
            name = ((MDXCalculatedMemberDefinition)aC).getUniqueName();
            if (calcDependingOnCellValue.containsKey(name)) {
                return true;
            }
            if (!hasCalculation[0] && !aC.getChild(0).isOfTypes(CONSTS)) {
                hasCalculation[0] = true;
            }
        } else {
            name = ((MDXNamedSetDefinition)aC).getUniqueName();
            if (namedSetDependingOnCellValue.containsKey(name)) {
                return true;
            }
        }
        if (bHasFnsDependingOnCellValue = DMRQueryStrategyPreCellLoading.hasFunctionsDependingOnCellValue(aC)) {
            if (type == 1005) {
                calcDependingOnCellValue.put(name, Boolean.TRUE);
            } else {
                namedSetDependingOnCellValue.put(name, Boolean.TRUE);
            }
            return true;
        }
        IXQEQueryNode[] refs = aC.getDescendantsOfTypes(REFS, false);
        if (refs.length == 0) {
            if (type == 1005) {
                calcDependingOnCellValue.put(name, Boolean.FALSE);
            } else {
                namedSetDependingOnCellValue.put(name, Boolean.FALSE);
            }
            return true;
        }
        if (stack.contains(name)) {
            return false;
        }
        stack.addLast(name);
        boolean bOk = true;
        for (IXQEQueryNode ref : refs) {
            if (ref.getType() == 1013) {
                MDXCalculatedMemberReference calcref = (MDXCalculatedMemberReference)ref;
                MDXCalculatedMemberDefinition caclDef = calcref.getDefinition();
                String calcDefName = caclDef.getUniqueName();
                bOk = DMRQueryStrategyPreCellLoading.setCalculationNamedSetDependingOnCellValue(caclDef, calcDependingOnCellValue, namedSetDependingOnCellValue, stack, hasCalculation);
                if (!bOk) break;
                if (calcDependingOnCellValue.get(calcDefName) == Boolean.FALSE) continue;
                if (type == 1005) {
                    calcDependingOnCellValue.put(name, Boolean.TRUE);
                    break;
                }
                namedSetDependingOnCellValue.put(name, Boolean.TRUE);
                break;
            }
            MDXNamedSetReference namedref = (MDXNamedSetReference)ref;
            MDXNamedSetDefinition namedDef = namedref.getDefinition();
            String namedDefName = namedDef.getUniqueName();
            bOk = DMRQueryStrategyPreCellLoading.setCalculationNamedSetDependingOnCellValue(namedDef, calcDependingOnCellValue, namedSetDependingOnCellValue, stack, hasCalculation);
            if (!bOk) break;
            if (namedSetDependingOnCellValue.get(namedDefName) == Boolean.FALSE) continue;
            if (type == 1005) {
                calcDependingOnCellValue.put(name, Boolean.TRUE);
                break;
            }
            namedSetDependingOnCellValue.put(name, Boolean.TRUE);
            break;
        }
        if (type == 1005) {
            if (!calcDependingOnCellValue.containsKey(name)) {
                calcDependingOnCellValue.put(name, Boolean.FALSE);
            }
        } else if (!namedSetDependingOnCellValue.containsKey(name)) {
            namedSetDependingOnCellValue.put(name, Boolean.FALSE);
        }
        stack.removeLast();
        return bOk;
    }

    public static boolean hasSetWithMultipleDimensions(CrossJoinedSet cjs) {
        Set[] sets;
        for (Set s : sets = cjs.getSets()) {
            if (s.getDimensions().length <= 1) continue;
            return true;
        }
        return false;
    }

    public static void logWithReportName(MDXQuery mdxQuery, String info) {
        if (INFO_LOGGER.isOn()) {
            DMRQueryStrategyPreCellLoading.log(mdxQuery, info + QueryStrategy.getReportName());
        }
    }

    public static void log(MDXQuery mdxQuery, String info) {
        if (INFO_LOGGER.isOn()) {
            String v5Name = mdxQuery.getV5NameProperty();
            String queryName = mdxQuery.getRefQueryProperty();
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            if (v5Name != null) {
                sb.append(v5Name);
            }
            sb.append("->");
            if (queryName != null) {
                sb.append(queryName);
            }
            sb.append("]: ");
            if (info != null) {
                sb.append(info);
            }
            INFO_LOGGER.log(sb.toString());
        }
    }

    public static void log(IMember[][] unknownMemberSet, DMRQueryStrategyPreCellLoading pre) {
        if (pre != null && (pre.getPreLoading() || pre.isPreLoaded()) && INFO_LOGGER.isOn()) {
            StringBuilder sb = new StringBuilder();
            if (pre.getPreLoading()) {
                sb.append("pre-loading: ");
            } else {
                sb.append("after pre-loading(missed): ");
            }
            int n = 1;
            StringBuilder sb1 = new StringBuilder();
            for (int i = 0; i < unknownMemberSet.length; ++i) {
                n *= unknownMemberSet[i].length;
                if (i > 0) {
                    sb1.append(", ");
                }
                sb1.append(unknownMemberSet[i][0].getUniqueName());
            }
            sb.append(n);
            sb.append(". First tuple: ");
            sb.append((CharSequence)sb1);
            INFO_LOGGER.log(sb.toString());
        }
    }

    static {
        ZERO_VALUE.set(0);
        FUNCTIONS_CELLVALUE = new int[]{1041, 1053, 1085, 1192};
        REFS = new int[]{1013, 1014};
        CONSTS = new int[]{1064, 1089, 1127, 1151};
    }

    public static enum LoadType {
        OVERLOAD,
        NOLOAD,
        PRECISELOAD;

    }
}

