/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.DoubleType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DecimalValue;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.function.ArgumentList;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.function.set.Avg;
import com.cognos.xqe.function.set.Maximum;
import com.cognos.xqe.function.set.Minimum;
import com.cognos.xqe.function.set.PercentileCont;
import com.cognos.xqe.function.set.StdDevPop;
import com.cognos.xqe.function.set.StdDevSamp;
import com.cognos.xqe.function.set.Sum;
import com.cognos.xqe.function.set.VarPop;
import com.cognos.xqe.function.set.VarSamp;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.functions.IMDXFunctionProcessor;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import java.util.HashSet;

public class MDXAggregateProcessorRelationalSetFunction
implements IMDXFunctionProcessor {
    private static final double MEDIAN_PERCENTILE_VALUE = 0.5;
    protected HashSet<IDataType> dataTypes;
    protected SetFunction func;
    protected IDataType[] typeToCheck = null;
    protected int typePos = -1;
    protected XDataContext context = null;
    protected ISetFunctionState state = null;
    protected IDataType rtType = null;
    private Value[] vs = null;
    private ArgumentList arg = null;
    private int sizeofvalues;
    private boolean bAggregationComplete = false;

    @Override
    public void setFunctionCode(int op, int parameterSize) {
        this.dataTypes = new HashSet();
        this.sizeofvalues = parameterSize;
        if (op == 0) {
            this.func = new Sum();
        } else if (op == 4) {
            this.func = new Avg();
        } else if (op == 7) {
            this.func = new PercentileCont();
        } else if (op == 2) {
            this.func = new Maximum();
        } else if (op == 1) {
            this.func = new Minimum();
        } else if (op == 6) {
            this.func = new StdDevSamp();
        } else if (op == 8) {
            this.func = new StdDevPop();
        } else if (op == 5) {
            this.func = new VarSamp();
        } else if (op == 9) {
            this.func = new VarPop();
        }
        if (op == 7) {
            this.typeToCheck = new IDataType[2];
            this.typeToCheck[0] = DoubleType.DOUBLETYPE;
            this.typePos = 1;
        } else {
            this.typeToCheck = new IDataType[1];
            this.typePos = 0;
        }
    }

    private void closeContextAndSetCompleteFlag(InterpreterContext interpreterContext) {
        if (this.context != null) {
            if (this.state != null) {
                this.func.terminate(this.context, this.state);
                this.state = null;
            }
            interpreterContext.getXDataContext().getEnvironment().popDataContext(this.context);
            this.context = null;
        }
        this.bAggregationComplete = true;
    }

    @Override
    public Object addParameter(InterpreterContext interpreterContext, Object value) {
        if (this.bAggregationComplete) {
            return TextValue.ERROR_VALUE;
        }
        if (!(value instanceof Value)) {
            this.closeContextAndSetCompleteFlag(interpreterContext);
            return TextValue.ERROR_VALUE;
        }
        Value v = (Value)value;
        if (v.isError()) {
            this.closeContextAndSetCompleteFlag(interpreterContext);
            return TextValue.ERROR_VALUE;
        }
        if (!v.isOK() && !v.isNull()) {
            DoubleValue resultValue = DataValueFactory.createDoubleValue();
            resultValue.setState(v.getState());
            this.closeContextAndSetCompleteFlag(interpreterContext);
            return resultValue;
        }
        if (v.isNull()) {
            return null;
        }
        IDataType dt = v.getDataType();
        if (!this.dataTypes.contains(dt)) {
            this.typeToCheck[this.typePos] = dt;
            if (!this.func.validArgumentTypes(this.typeToCheck)) {
                this.closeContextAndSetCompleteFlag(interpreterContext);
                return TextValue.ERROR_VALUE;
            }
            this.dataTypes.add(dt);
        }
        if (this.context == null) {
            IDataType[] oDataTypes = null;
            if (this.func instanceof PercentileCont) {
                oDataTypes = new IDataType[2];
                DecimalValue percentileValue = DataValueFactory.createDecimalValue(DataTypeFactory.getDecimalType(2, 1));
                percentileValue.set(0.5);
                percentileValue.setFormatId(FormatId.EMPTY_FORMAT_FID);
                oDataTypes[0] = percentileValue.getDataType();
                this.vs = new Value[2];
                this.vs[0] = percentileValue;
            } else {
                oDataTypes = new IDataType[1];
                this.vs = new Value[1];
            }
            this.arg = new ArgumentList(this.vs);
            oDataTypes[this.typePos] = dt;
            this.rtType = this.func.getResultDataTypeImpl(oDataTypes);
            this.context = interpreterContext.getXDataContext().getEnvironment().pushDataContext();
            try {
                if (this.func instanceof PercentileCont) {
                    this.vs[1] = v;
                    this.state = ((PercentileCont)this.func).initializeNoCloning(this.context, this.arg, this.rtType, this.sizeofvalues);
                } else {
                    this.state = this.func.initialize(this.context, null, this.rtType);
                }
            }
            catch (XQERuntimeException e) {
                this.closeContextAndSetCompleteFlag(interpreterContext);
                return TextValue.ERROR_VALUE;
            }
        }
        try {
            this.vs[this.typePos] = v;
            this.func.iterate(this.context, this.state, this.arg);
        }
        catch (XQERuntimeException e) {
            this.closeContextAndSetCompleteFlag(interpreterContext);
            return TextValue.ERROR_VALUE;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getResult(InterpreterContext interpreterContext) {
        if (this.context == null || this.bAggregationComplete) {
            this.closeContextAndSetCompleteFlag(interpreterContext);
            return DoubleValue.NULL_VALUE;
        }
        IValue v = this.rtType.createValue();
        try {
            this.func.getResult(this.context, this.state, v);
        }
        catch (XQERuntimeException e) {
            v = TextValue.ERROR_VALUE;
        }
        finally {
            this.closeContextAndSetCompleteFlag(interpreterContext);
        }
        return v;
    }
}

