/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5;

import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.MultiV5QueryResult;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryOverTabularStream;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryResult;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.rsapi.RSAPIQueryResult;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.AdaptiveCubeletStorageManager;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderQueryGroup;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderQueryResult;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class V5QueryGroup
extends V5ProviderQueryGroup {
    private static final int MAX_CONCURRENT_SUBQUERIES = 4;
    private List<Map<IMember, List<ILevel>>> listofMeasures = new ArrayList<Map<IMember, List<ILevel>>>();
    private IMember[][] unknownMemberSet;
    private AdaptiveCubeletStorageManager.ParamDefinition param;

    @Override
    public V5QueryOverTabularStream getQuery(int i) {
        return (V5QueryOverTabularStream)this.getQueries().get(i);
    }

    public List<Value[]> getResultAsValueArray(String queryName) {
        RSAPIQueryResult queryResult = this.getV5QueryResult(queryName).getRSAPIQueryResult();
        return ((V5QueryResult)queryResult).toList(Value[].class);
    }

    public List<Value[]> getResultAsValueArray(String queryName, int count) {
        if (count == 0) {
            return this.getResultAsValueArray(queryName);
        }
        RSAPIQueryResult queryResult = this.getV5QueryResult(queryName).getRSAPIQueryResult();
        return ((V5QueryResult)queryResult).toList(Value[].class, count);
    }

    public V5ProviderQueryResult getV5QueryResult(String queryName) {
        return this.getQueryNameToResult().get(queryName);
    }

    public V5QueryResult execute() {
        int queryCount = this.getQueries().size();
        ArrayList<V5ProviderQueryResult> multipleResults = new ArrayList<V5ProviderQueryResult>(queryCount);
        for (int i = 0; i < queryCount; ++i) {
            V5QueryOverTabularStream q = (V5QueryOverTabularStream)this.getQueries().get(i);
            V5ProviderQueryResult result = q.execute(null);
            this.setQueryNameToResult(q.getName(), result);
            multipleResults.add(result);
        }
        return new MultiV5QueryResult(multipleResults);
    }

    public V5QueryResult execute(ExecutionEnvironment executionEnvironment) {
        int queryCount = this.getQueries().size();
        ArrayList<V5ProviderQueryResult> multipleResults = new ArrayList<V5ProviderQueryResult>(queryCount);
        for (int i = 0; i < queryCount; ++i) {
            V5QueryOverTabularStream q = (V5QueryOverTabularStream)this.getQueries().get(i);
            q.setCreateNewConnectionPoolToTrue();
            V5ProviderQueryResult result = q.execute(executionEnvironment);
            this.setQueryNameToResult(q.getName(), result);
            multipleResults.add(result);
        }
        return new MultiV5QueryResult(multipleResults);
    }

    public V5QueryResult execute(int beginning, int end) {
        int queryCount = this.getQueries().size();
        ArrayList<V5ProviderQueryResult> multipleResults = new ArrayList<V5ProviderQueryResult>(queryCount);
        for (int i = beginning; i <= end && i < queryCount; ++i) {
            V5QueryOverTabularStream q = (V5QueryOverTabularStream)this.getQueries().get(i);
            V5ProviderQueryResult result = q.execute(null);
            this.setQueryNameToResult(q.getName(), result);
            multipleResults.add(result);
        }
        return new MultiV5QueryResult(multipleResults);
    }

    public V5QueryResult executeConcurrent() {
        int queryCount = this.getQueries().size();
        ArrayList<V5ProviderQueryResult> multipleResults = new ArrayList<V5ProviderQueryResult>(queryCount);
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        ExecutorService executor = Executors.newFixedThreadPool(4);
        ArrayList<SubQueryRunner> runners = new ArrayList<SubQueryRunner>(queryCount);
        for (int i = 0; i < queryCount; ++i) {
            V5QueryOverTabularStream q = (V5QueryOverTabularStream)this.getQueries().get(i);
            runners.add(new SubQueryRunner(q, execEnv));
        }
        try {
            List results = executor.invokeAll(runners);
            int i = 0;
            for (Future future : results) {
                V5ProviderQueryResult result = (V5ProviderQueryResult)future.get();
                this.setQueryNameToResult(this.getQueries().get(i++).getName(), result);
                multipleResults.add(result);
            }
        }
        catch (Exception ex) {
            throw XQERuntimeException.wrap(ex);
        }
        finally {
            executor.shutdown();
        }
        return new MultiV5QueryResult(multipleResults);
    }

    public void setListOfMeasures(List<Map<IMember, List<ILevel>>> measures) {
        this.listofMeasures = measures;
    }

    public List<Map<IMember, List<ILevel>>> getListOfMeasures() {
        return this.listofMeasures;
    }

    public void setUnknownMemberSet(IMember[][] unknown) {
        this.unknownMemberSet = unknown;
    }

    public IMember[][] getUnknownMemberSet() {
        return this.unknownMemberSet;
    }

    public void setParam(AdaptiveCubeletStorageManager.ParamDefinition parameter) {
        this.param = parameter;
    }

    public AdaptiveCubeletStorageManager.ParamDefinition getParam() {
        return this.param;
    }

    private class SubQueryRunner
    implements Callable<V5ProviderQueryResult> {
        private V5QueryOverTabularStream query;
        ExecutionEnvironment env;

        SubQueryRunner(V5QueryOverTabularStream subQuery, ExecutionEnvironment execEnv) {
            this.query = subQuery;
            this.env = execEnv;
        }

        @Override
        public V5ProviderQueryResult call() {
            return this.query.execute(this.env);
        }
    }
}

