/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination;

import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IScopeRelationship;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMeasure;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRQueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryOverTabularStream;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.AggregateCombinationBuilder;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.AggregateCombinationRule;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.Combination;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.CombinationBuilder;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.MeasureScope;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.MeasureSelection;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.Selection;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.PreLoadDMRCubeUtil;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.AdaptiveCubeletStorageManager;
import com.cognos.xqe.util.ArrayCast;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CrossJoinedSetDecomposer {
    private static final String HALF = "0.5";
    private boolean hasMeasure = false;
    private List<IDimension> dimensions;
    private List<IMember>[] selectionsByDimension;
    protected Map<IDimension, ILevel> levelInfo;
    private Set<IDimension> firstLastAggregatesDimensions;
    private Map<String, List<IMember>>[] dimensionIndexToMemberGroups;
    protected Map<IMeasure, List<AggregateCombinationRule>> rules = new HashMap<IMeasure, List<AggregateCombinationRule>>();
    protected Map<IMeasure, MeasureScope> measureToscope = new HashMap<IMeasure, MeasureScope>();
    private boolean oneMeasurePerSubquery = false;
    protected List<Combination> combinations = new ArrayList<Combination>();

    public CrossJoinedSetDecomposer() {
    }

    public CrossJoinedSetDecomposer(List<IDimension> dims) {
        this.dimensions = dims;
        this.selectionsByDimension = (List[])ArrayCast.uncheckedCast(new List[this.dimensions.size()]);
        this.firstLastAggregatesDimensions = new HashSet<IDimension>();
        this.levelInfo = new HashMap<IDimension, ILevel>();
    }

    public void addToSelectionsByDimension(IDimension dimension, IMember[] mems, int index) {
        this.selectionsByDimension[index] = new ArrayList<IMember>(Arrays.asList(mems));
        if (!dimension.isMeasuresDimension()) {
            if (mems.length > 0) {
                IMember mem = mems[0];
                this.levelInfo.put(dimension, mem.getLevel());
            }
        } else if (dimension.getMembers().length > 0) {
            this.hasMeasure = true;
        }
    }

    protected Map<String, List<IMember>>[] getDimensionIndexToMemberGroups() {
        return this.dimensionIndexToMemberGroups;
    }

    Set<IDimension> getFirstLastAggregatesDimensions() {
        if (this.firstLastAggregatesDimensions == null) {
            this.buildDimIndexToMemberGroups();
        }
        return this.firstLastAggregatesDimensions;
    }

    public Map<String, List<IMember>>[] buildDimIndexToMemberGroups() {
        if (this.dimensionIndexToMemberGroups == null) {
            int dimCount = this.selectionsByDimension.length;
            this.dimensionIndexToMemberGroups = (Map[])ArrayCast.uncheckedCast(new Map[dimCount]);
            for (int i = 0; i < dimCount; ++i) {
                this.dimensionIndexToMemberGroups[i] = new HashMap<String, List<IMember>>();
                List<IMember> members = this.selectionsByDimension[i];
                for (IMember member : members) {
                    List<IMember> memberGrouping;
                    ILevel level = member.getLevel();
                    StringBuilder mergeKeyBuf = new StringBuilder();
                    if (member instanceof DMRMemberProxy && ((DMRMemberProxy)member).getHierarchyMemberType() > 0) {
                        mergeKeyBuf.append(HALF);
                    } else if (member instanceof DMRMember && ((DMRMember)member).getHierarchyMemberType() > 0) {
                        mergeKeyBuf.append(HALF);
                    } else {
                        mergeKeyBuf.append(Integer.toString(level.getIndex()));
                    }
                    if (member instanceof IMeasure) {
                        IMeasure measure = (IMeasure)member;
                        for (IAggregateRule rule : measure.getAggregateRules()) {
                            if (rule.getAggregate() != AggregateTypeEnum.FIRST && rule.getAggregate() != AggregateTypeEnum.LAST) continue;
                            AggregateCombinationRule combinationRule = null;
                            List<AggregateCombinationRule> rulesOfTheMeasure = this.rules.get(measure);
                            if (rulesOfTheMeasure == null) {
                                rulesOfTheMeasure = new ArrayList<AggregateCombinationRule>();
                                combinationRule = new AggregateCombinationRule(rule, measure);
                                rulesOfTheMeasure.add(combinationRule);
                                this.rules.put(measure, rulesOfTheMeasure);
                            } else {
                                for (AggregateCombinationRule aRule : rulesOfTheMeasure) {
                                    if (!aRule.getMeasure().equals(measure) || !aRule.getRule().equals(rule)) continue;
                                    combinationRule = aRule;
                                    break;
                                }
                                if (combinationRule == null) {
                                    combinationRule = new AggregateCombinationRule(rule, measure);
                                    rulesOfTheMeasure.add(combinationRule);
                                }
                            }
                            IDimension dim = DMRQueryStrategy.getLowestDimensionInContext(this.levelInfo, this.dimensions, rule);
                            combinationRule.add(dim);
                            this.firstLastAggregatesDimensions.add(dim);
                        }
                        MeasureScope measureScope = this.createScopeForMeasure(measure);
                        this.measureToscope.put(measure, measureScope);
                    }
                    if ((memberGrouping = this.dimensionIndexToMemberGroups[i].get(mergeKeyBuf.toString())) == null) {
                        memberGrouping = new ArrayList<IMember>();
                        this.dimensionIndexToMemberGroups[i].put(mergeKeyBuf.toString(), memberGrouping);
                    }
                    memberGrouping.add(member);
                }
            }
        }
        return this.dimensionIndexToMemberGroups;
    }

    public List<IMember>[] getSelectionByDimension() {
        return this.selectionsByDimension;
    }

    int getDimCount() {
        return this.dimensions.size();
    }

    public List<Combination> getCombinationObjects() {
        if (!this.hasMeasure) {
            return new ArrayList<Combination>();
        }
        ArrayList<Combination> combinationList = new ArrayList<Combination>();
        if (this.rules.isEmpty()) {
            CombinationBuilder combinationBuilder = new CombinationBuilder(this);
            return combinationBuilder.getCombinationObjects();
        }
        for (IMeasure measure : this.rules.keySet()) {
            List<AggregateCombinationRule> rulesPerMeasure = this.rules.get(measure);
            AggregateCombinationBuilder combinationBuilder = new AggregateCombinationBuilder(this, rulesPerMeasure);
            combinationList.addAll(((CombinationBuilder)combinationBuilder).getCombinationObjects());
        }
        return combinationList;
    }

    boolean measureHasAggregateRule(IMember measure) {
        return this.rules.containsKey(measure);
    }

    boolean isOneMeasurePerSubquery() {
        return this.oneMeasurePerSubquery;
    }

    public void setOneMeasurePerSubquery(boolean oneMeasurePerSubq) {
        this.oneMeasurePerSubquery = oneMeasurePerSubq;
    }

    protected MeasureScope createScopeForMeasure(IMeasure measure) {
        MeasureScope measureScope = new MeasureScope(this.dimensions, measure);
        for (IDimension dim : this.dimensions) {
            if (dim.isMeasuresDimension()) continue;
            if (CubeWrapper.isDummyDimension(dim)) {
                measureScope.addLevel(dim.getLevel(0), dim);
                continue;
            }
            IScopeRelationship sr = measure.getScopeRelationship(dim);
            if (sr != null) {
                DMRLevel lowestLevel = V5QueryOverTabularStream.getLowestLevelFromScope(measure, this.levelInfo.get(dim));
                measureScope.addLevel(lowestLevel, dim);
                continue;
            }
            if (PreLoadDMRCubeUtil.isMeasureForCustomValue(measure.getName())) {
                int nLevels = dim.getLevelCount();
                measureScope.addLevel(dim.getLevel(nLevels - 1), dim);
                continue;
            }
            measureScope.addLevel(dim.getLevel(0), dim);
        }
        return measureScope;
    }

    public void addMeasuresForReport(AdaptiveCubeletStorageManager storageManager, List<Combination> combs) {
        this.addMeasuresForReport(-1, storageManager, combs, true);
    }

    protected void addMeasuresForReport(int maxCheckExist, AdaptiveCubeletStorageManager storage, List<Combination> combs, boolean bCheckExist) {
        MeasureScope measureScope;
        if (!this.hasMeasure) {
            return;
        }
        if (!this.rules.isEmpty()) {
            return;
        }
        List<IMember> measures = null;
        DMRCube cube = null;
        int i = 0;
        for (i = 0; i < this.dimensions.size(); ++i) {
            if (!this.dimensions.get(i).isMeasuresDimension()) continue;
            measures = this.selectionsByDimension[i];
            cube = (DMRCube)this.dimensions.get(i).getCube();
            break;
        }
        if (measures == null || measures.isEmpty()) {
            return;
        }
        HashSet<DMRMeasure> extraMeasures = new HashSet<DMRMeasure>();
        List<DMRMeasure> requiredMeasures = cube.getMeasureInfo();
        for (DMRMeasure dMRMeasure : requiredMeasures) {
            boolean bHasFirstLastRule = false;
            for (IAggregateRule iAggregateRule : dMRMeasure.getAggregateRules()) {
                if (iAggregateRule.getAggregate() != AggregateTypeEnum.FIRST && iAggregateRule.getAggregate() != AggregateTypeEnum.LAST) continue;
                bHasFirstLastRule = true;
                break;
            }
            if (bHasFirstLastRule || measures.contains(dMRMeasure)) continue;
            extraMeasures.add(dMRMeasure);
        }
        if (extraMeasures.isEmpty()) {
            return;
        }
        if (maxCheckExist > 0) {
            int nNeedToCheck = 0;
            for (Combination c : combs) {
                int n = 1;
                Selection measureSel = null;
                for (Selection selection : c.getSelections()) {
                    if (selection instanceof MeasureSelection) {
                        measureSel = (MeasureSelection)selection;
                        continue;
                    }
                    n *= selection.size();
                }
                if (measureSel == null || measureSel.size() == 0) continue;
                int nM = 0;
                for (DMRMeasure dMRMeasure : extraMeasures) {
                    if (!((MeasureSelection)measureSel).laodMeasureWithThisSelection(dMRMeasure, measureScope = this.createScopeForMeasure(dMRMeasure))) continue;
                    ++nM;
                }
                if (nM <= 0) continue;
                nNeedToCheck += nM * n;
            }
            if (nNeedToCheck >= maxCheckExist) {
                return;
            }
        }
        for (Combination combination : combs) {
            List<Selection> sels = combination.getSelections();
            IMember[][] memberSelectionsArray = null;
            IMember[] extraMeasureArray = null;
            if (bCheckExist) {
                memberSelectionsArray = new IMember[sels.size()][];
            }
            Selection measureSel = null;
            for (i = 0; i < sels.size(); ++i) {
                Selection selection = sels.get(i);
                if (selection instanceof MeasureSelection) {
                    measureSel = (MeasureSelection)selection;
                    if (memberSelectionsArray == null) continue;
                    memberSelectionsArray[i] = new IMember[1];
                    extraMeasureArray = memberSelectionsArray[i];
                    continue;
                }
                if (memberSelectionsArray == null) continue;
                List<IMember> list = selection.getMembersList();
                memberSelectionsArray[i] = list.toArray(new IMember[list.size()]);
            }
            if (measureSel == null || measureSel.size() == 0) continue;
            for (DMRMeasure dMRMeasure : extraMeasures) {
                if (!((MeasureSelection)measureSel).laodMeasureWithThisSelection(dMRMeasure, measureScope = this.createScopeForMeasure(dMRMeasure))) continue;
                if (bCheckExist) {
                    if (memberSelectionsArray == null) continue;
                    extraMeasureArray[0] = dMRMeasure;
                    if (storage.measureExistInStorage(memberSelectionsArray)) continue;
                }
                ((MeasureSelection)measureSel).addExtraMeasure(dMRMeasure);
                if (measures.contains(dMRMeasure)) continue;
                measures.add(dMRMeasure);
            }
        }
    }
}

