/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination;

import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.wrapper.IMeasureWrapper;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMeasure;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.AggregateCombinationRule;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.MeasureScope;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.Selection;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.SetOfTables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MeasureSelection
extends Selection {
    private Map<IMeasure, MeasureScope> measureToscope = null;
    private boolean oneMeasurePerSubquery = false;
    private List<IMember> extraMeasures = null;

    MeasureSelection(List<IMember> mems, Map<IMeasure, MeasureScope> measureScope, boolean oneMeasurePerSub) {
        super(mems);
        this.measureToscope = measureScope;
        this.oneMeasurePerSubquery = oneMeasurePerSub;
    }

    @Override
    protected List<Selection> decomposeSelection(AggregateCombinationRule rule) {
        ArrayList<Selection> selection = new ArrayList<Selection>(this.size());
        for (IMember m : this.getMembersList()) {
            if (rule.getMeasure() != m) continue;
            selection.add(new Selection(m));
        }
        return selection;
    }

    @Override
    protected List<Selection> decomposeSelection() {
        if (this.allSameScope() && this.allFromSameModelDimension() && !this.oneMeasurePerSubquery && this.allFromSameTable()) {
            return super.decomposeSelection();
        }
        if (!this.oneMeasurePerSubquery) {
            return this.groupMeasures();
        }
        return this.splitMeasuresOneByOne();
    }

    protected List<Selection> splitMeasuresOneByOne() {
        ArrayList<Selection> selections = new ArrayList<Selection>(this.size());
        for (IMember m : this.getMembersList()) {
            ArrayList<IMember> list = new ArrayList<IMember>();
            list.add(m);
            MeasureSelection s = new MeasureSelection(list, this.measureToscope, this.oneMeasurePerSubquery);
            selections.add(s);
        }
        return selections;
    }

    private boolean allFromSameModelDimension() {
        IDimension dim = null;
        for (IMember m : this.getMembersList()) {
            if (!(m instanceof IMeasureWrapper)) {
                return false;
            }
            if (dim == null) {
                dim = ((IMeasureWrapper)m).getModelDimension();
                continue;
            }
            if (((IMeasureWrapper)m).getModelDimension() == dim) continue;
            return false;
        }
        return true;
    }

    private boolean allSameScope() {
        MeasureScope previousScope = null;
        for (MeasureScope scope : this.measureToscope.values()) {
            if (previousScope == null) {
                previousScope = scope;
                continue;
            }
            if (scope.equals(previousScope)) continue;
            return false;
        }
        return true;
    }

    private boolean allFromSameTable() {
        SetOfTables previousSetOfTables = null;
        for (IMember m : this.getMembersList()) {
            if (!(m instanceof DMRMeasure)) {
                return true;
            }
            DMRMeasure measure = (DMRMeasure)m;
            SetOfTables currentSetOfTables = measure.getInvolvedTables();
            if (previousSetOfTables == null) {
                previousSetOfTables = currentSetOfTables;
                continue;
            }
            if (previousSetOfTables.equals(currentSetOfTables)) continue;
            return false;
        }
        return true;
    }

    protected List<Selection> groupMeasures() {
        HashMap<MeasureGroupingKey, ArrayList> groupedMeasures = new HashMap<MeasureGroupingKey, ArrayList>();
        ArrayList<MeasureGroupingKey> addedKeys = new ArrayList<MeasureGroupingKey>();
        List<IMember> measures = this.getMembersList();
        for (int i = 0; i < measures.size(); ++i) {
            MeasureGroupingKey key = new MeasureGroupingKey();
            IMember m = measures.get(i);
            if (!(m instanceof IMeasureWrapper)) {
                key.mId = i + 1;
            } else {
                this.setKey(key, i + 1, (DMRMeasure)m, this.measureToscope.get(m));
            }
            ArrayList l = null;
            if (groupedMeasures.containsKey(key)) {
                l = (ArrayList)groupedMeasures.get(key);
            } else {
                l = new ArrayList();
                groupedMeasures.put(key, l);
                addedKeys.add(key);
            }
            l.add(m);
        }
        if (addedKeys.size() == measures.size()) {
            return this.splitMeasuresOneByOne();
        }
        ArrayList<Selection> selections = new ArrayList<Selection>();
        for (MeasureGroupingKey k : addedKeys) {
            ArrayList<IMember> list = new ArrayList<IMember>();
            list.addAll((Collection)groupedMeasures.get(k));
            MeasureSelection s = new MeasureSelection(list, this.measureToscope, this.oneMeasurePerSubquery);
            selections.add(s);
        }
        return selections;
    }

    protected void setKey(MeasureGroupingKey key, int id, DMRMeasure measure, MeasureScope measureScope) {
        SetOfTables currentSetOfTables = measure.getInvolvedTables();
        IDimension dim = measure.getModelDimension();
        if (currentSetOfTables.size() == 0 || measureScope == null || dim == null || !(dim instanceof IDimension) || !measure.isReUseable() || measure.getBinaryExpression() != null) {
            key.mId = id;
        } else {
            if (dim.getFilters().isEmpty() && dim.getPreviewFilters().isEmpty() && dim.getSecurityFilters().isEmpty()) {
                dim = null;
            }
            key.mInvolvedTables = currentSetOfTables;
            key.mScope = measureScope;
            key.mDimension = dim;
        }
    }

    public boolean laodMeasureWithThisSelection(DMRMeasure aM, MeasureScope measureScope) {
        List<IMember> mems = this.getMembersList();
        if (mems.isEmpty()) {
            return false;
        }
        IMember m = mems.get(0);
        if (!(m instanceof IMeasureWrapper)) {
            return false;
        }
        MeasureGroupingKey key1 = new MeasureGroupingKey();
        this.setKey(key1, 1, (DMRMeasure)m, this.measureToscope.get(m));
        if (key1.mId > 0) {
            return false;
        }
        MeasureGroupingKey key2 = new MeasureGroupingKey();
        this.setKey(key2, 1, aM, measureScope);
        if (key2.mId > 0) {
            return false;
        }
        return key1.equals(key2);
    }

    public void addExtraMeasure(DMRMeasure aM) {
        if (this.extraMeasures == null) {
            this.extraMeasures = new ArrayList<IMember>();
        }
        this.extraMeasures.add(aM);
    }

    public List<IMember> getExtraMeasures() {
        return this.extraMeasures;
    }

    private final class MeasureGroupingKey {
        private int mId = 0;
        private SetOfTables mInvolvedTables = null;
        private MeasureScope mScope = null;
        private IDimension mDimension = null;

        private MeasureGroupingKey() {
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MeasureGroupingKey)) {
                return false;
            }
            MeasureGroupingKey other = (MeasureGroupingKey)obj;
            if (this.mId != other.mId) {
                return false;
            }
            return this.mInvolvedTables.equals(other.mInvolvedTables) && this.mScope.equals(other.mScope) && this.mDimension == other.mDimension;
        }

        public int hashCode() {
            int r = this.mId;
            if (this.mInvolvedTables != null) {
                r += this.mInvolvedTables.hashCode();
            }
            if (this.mScope != null) {
                r += this.mScope.hashCode();
            }
            if (this.mDimension != null) {
                r += this.mDimension.hashCode();
            }
            return r;
        }
    }
}

