/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.rsapi;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.metrics.IteratorProfilingManager;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.engine.QueryEngineLoggingUtils;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdgeIterator;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIPartialDataset;
import com.cognos.xqe.rsapi.RSAPIRow;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryResult;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.rsapi.RSAPIRowCallback;
import com.cognos.xqe.runtree.relational.decoration.XValueDecoration;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.CollectionCast;
import java.util.ArrayList;
import java.util.List;

public class RSAPIQueryResult
extends V5QueryResult {
    protected final RSAPIDataset rsapiDataset;
    protected final ExecutionEnvironment execEnv;

    public RSAPIQueryResult(RSAPIDataset dataset, ExecutionEnvironment env) {
        this.rsapiDataset = dataset;
        this.execEnv = env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> toList(Class<T> elementType) {
        ArrayList<Value[]> result = new ArrayList<Value[]>();
        RSAPIPartialDataset partialDataset = QueryEngine.getInstance().getPartialDataset(this.rsapiDataset, new int[]{0}, new int[]{0}, true, false, this.execEnv);
        RSAPIEdgeRowset rowset = partialDataset.getMasterDataset().getEdge(0).getRowsets()[0];
        RSAPIEdgeIterator it = partialDataset.edgeIterator(0);
        try {
            RSAPIColumn[] cols = rowset.getColumns();
            FormatService formatService = FormatService.getInstance();
            FormatId[] formatIds = new FormatId[cols.length];
            Value[] headers = new Value[cols.length];
            for (int i = 0; i < cols.length; ++i) {
                headers[i] = DataValueFactory.createStringValue();
                headers[i].set(cols[i].getName());
                String format = cols[i].getFormat();
                formatIds[i] = format != null && format.length() > 0 ? formatService.registerV5Format(format, null) : (cols[i].getDatatype().isNumeric() ? FormatId.DEFAULT_NUMBER_FORMAT_FID : FormatId.INVALID_FORMAT_FID);
            }
            result.add(headers);
            RSAPIRow rsapiRow = null;
            while ((rsapiRow = it.next()) != null) {
                Value[] row = new Value[cols.length];
                for (int i = 0; i < cols.length; ++i) {
                    Value val = (Value)rsapiRow.getColumn(i);
                    if (val == null || val.isNull()) {
                        row[i] = null;
                        continue;
                    }
                    row[i] = (Value)val.copy();
                    if (row[i].getFormatId() != FormatId.INVALID_FORMAT_FID) continue;
                    row[i].setFormatId(formatIds[i]);
                }
                result.add(row);
            }
        }
        finally {
            if (it != null) {
                it.release();
            }
            if (partialDataset != null) {
                partialDataset.release();
            }
            this.rsapiDataset.releaseResultset(this.execEnv);
        }
        return CollectionCast.downcast(result, Value[].class, elementType);
    }

    @Override
    public <T> List<T> toList(Class<T> elementType, int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void release() {
        if (!this.released.compareAndSet(false, true)) {
            return;
        }
        this.rsapiDataset.releaseResultset(this.execEnv);
    }

    public void iterateResult(RSAPIRowCallback callback, int rowCount) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterateResult(RSAPIRowCallback callback) {
        RSAPIPartialDataset partialDataset = null;
        RSAPIEdgeRowset rowset = null;
        RSAPIEdgeIterator it = null;
        XQETrace trace = this.execEnv.getTrace();
        if (trace == null) {
            trace = new XQETrace();
            QueryEngineLoggingUtils.addExecutionTraceLevels(trace, this.execEnv.getRequestEnvironment());
        }
        IteratorProfilingManager profilingMgr = IteratorProfilingManager.getInstance();
        profilingMgr.registerProfiler(trace);
        try {
            if (callback.needReIterateRows()) {
                this.setForceCacheInXValueDecoration();
            }
            partialDataset = QueryEngine.getInstance().getPartialDataset(this.rsapiDataset, new int[]{0}, new int[]{0}, true, false, this.execEnv);
            rowset = partialDataset.getMasterDataset().getEdge(0).getRowsets()[0];
            it = partialDataset.edgeIterator(0);
            RSAPIColumn[] columns = rowset.getColumns();
            FormatService formatService = FormatService.getInstance();
            FormatId[] formatIds = new FormatId[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                String format = columns[i].getFormat();
                formatIds[i] = format != null && format.length() > 0 ? formatService.registerV5Format(format, null) : (columns[i].getDatatype().isNumeric() ? FormatId.DEFAULT_NUMBER_FORMAT_FID : FormatId.INVALID_FORMAT_FID);
            }
            RSAPIRow rsapiRow = null;
            while ((rsapiRow = it.next()) != null) {
                callback.consumeRow(rsapiRow, columns, formatIds);
            }
            while (callback.reRun()) {
                it.reset();
                while ((rsapiRow = it.next()) != null) {
                    callback.consumeRow(rsapiRow, columns, formatIds);
                }
            }
            profilingMgr.logProfiling(partialDataset.getMasterDataset(), (IExecutionEnvironment)this.execEnv);
        }
        finally {
            if (it != null) {
                it.release();
            }
            if (partialDataset != null) {
                partialDataset.release();
                profilingMgr.unregisterProfiler();
            }
        }
    }

    protected void setForceCacheInXValueDecoration() {
        IXQEQueryNode xnode = this.rsapiDataset.getFirstDescendantOfTypeOrdered(501043, false);
        if (xnode instanceof XValueDecoration) {
            ((XValueDecoration)xnode).setForceCache(true);
        }
    }
}

