/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream;

import com.cognos.xqe.ast.rqp.RQPPrePlan;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.RequestCanceledException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.MeasureWrapper;
import com.cognos.xqe.metadata.wrapper.QueryItemWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToMeasureWrapper;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.mdx.XMdxSelect;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRDimension;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRHierarchy;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMeasure;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRQueryStrategyPreCellLoading;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.DMRProviderForPreciseLoading;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.LoadDMRCubeSingleV5Query;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.PreLoadDMRCubeUtil;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.PreciseCubeLoadInfo;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.PrePlanUtilities;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.SetOfTables;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.ImmutableOrderedMap;
import com.cognos.xqe.util.OrderedMap;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class DMRCubeForPreciseLoading
extends DMRCube {
    public static final String LEVEL_ALL_MEMBERS = "Level_All_Members";
    public static final String HIERARCHY_DEFAULT_MEMBER = "Hierarchy_Default_Member";
    public static final String MEMBER_ALL_CHILDREN = "Member_All_Children";
    private static final String MSG1 = "Collect precise fact driven load information";
    private static final String MSG2 = " fails: ";
    private final List<IMeasure> measures;
    private final HashSet<DMRDummyMember> createdMembers = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void collectInformationForPreciseCubeLoading(XMdxLocal xmdxlocal, List<PreciseCubeLoadInfo> rt) {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        XDataContext subDataContext = execEnv.pushDataContext();
        XMdxSelect selectNode = (XMdxSelect)xmdxlocal.getChild(0);
        try {
            selectNode.setIsDummyRun(true);
            selectNode.execute(subDataContext);
            DMRProviderForPreciseLoading theProvider = (DMRProviderForPreciseLoading)subDataContext.getInterpreterContext().getProvider();
            if (theProvider.useExternalAggregate()) {
                LoadDMRCubeSingleV5Query.logSingleLoading(MSG1, MSG2, "needs external aggregation.");
                return;
            }
            DMRCubeForPreciseLoading cb = (DMRCubeForPreciseLoading)subDataContext.getInterpreterContext().getCube();
            DMRQueryStrategyPreCellLoading st = (DMRQueryStrategyPreCellLoading)theProvider.getQueryStrategy();
            List<CrossJoinedSet> cjs = st.getCrossJoinedSet();
            for (CrossJoinedSet a : cjs) {
                PreciseCubeLoadInfo.createFactDrivenPreciseLoadingDefinition(cb, a, rt);
            }
        }
        catch (OperationCanceledException oce) {
            LoadDMRCubeSingleV5Query.logSingleLoading(MSG1, MSG2, oce.getMessage());
        }
        catch (RequestCanceledException rce) {
            LoadDMRCubeSingleV5Query.logSingleLoading(MSG1, MSG2, rce.getMessage());
        }
        catch (RuntimeException re) {
            LoadDMRCubeSingleV5Query.logSingleLoading(MSG1, MSG2, re.getMessage());
        }
        finally {
            XMdxLocal.removeLocalCache(Thread.currentThread().getName());
            selectNode.setIsDummyRun(false);
            execEnv.popDataContext(subDataContext);
        }
    }

    public static IMetadata getFMMetadata(IMetadata m) {
        if (m instanceof DMRDummyLevel) {
            return ((DMRDummyLevel)m).getFMLevel();
        }
        return ((DMRDummyMeasure)m).getFMMeasure();
    }

    public DMRCubeForPreciseLoading(ICube theModelCube, XMdxLocal xmdxlocal) throws ProviderException {
        super(theModelCube.getName(), "", "", theModelCube.getConnection(), theModelCube, null);
        this.measures = xmdxlocal.getMDXQuery().getInvolvedMeasuresAndMeasuresFactDrivenCustomValue();
    }

    private DMRDummyMember createNewDMRDummyMember(Value caption, Value key, DMRDummyLevel level) {
        DMRDummyMember rt = new DMRDummyMember(caption, key, level);
        this.createdMembers.add(rt);
        return rt;
    }

    protected List<IMember> createMeasures(DMRDummyLevel level) {
        ArrayList<IMember> result = new ArrayList<IMember>();
        for (IMeasure measure : this.measures) {
            String name = measure.getName();
            DMRDummyMeasure dmrMeasure = new DMRDummyMeasure(name, level, measure);
            this.addDMRMetadataObject(measure, dmrMeasure);
            result.add(dmrMeasure);
        }
        return result;
    }

    @Override
    protected void initialiseDimensions() {
        if (this.modelCube != null) {
            List<IDimension> otherDims = this.modelCube.getDimensions();
            for (int i = 0; i < otherDims.size(); ++i) {
                IDimension dim = otherDims.get(i);
                DMRDummyDimension d = new DMRDummyDimension(dim.getName(), this, dim);
                this.addDMRMetadataObject(dim, d);
            }
        }
    }

    private final class DMRDummyMeasure
    extends DMRMeasure {
        DMRDummyMeasure(String s, DMRDummyLevel level, IMeasure measure) {
            super(s, level, measure);
        }

        public IMeasure getFMMeasure() {
            return this.fmMeasure;
        }

        @Override
        public boolean equals(Object other) {
            return this == other;
        }

        @Override
        public int hashCode() {
            return (int)this.getMemberId();
        }

        @Override
        public SetOfTables getInvolvedTables() {
            SetOfTables t = PreLoadDMRCubeUtil.getInvolvedTablesForMeasureForCustomValue(this.getName());
            if (t != null) {
                return t;
            }
            CubeWrapper cubeWrapper = DMRCubeForPreciseLoading.this.getModelCube();
            RQPPrePlan prePlan = cubeWrapper.getRQPPrePlanQuery();
            if (prePlan == null) {
                return new SetOfTables();
            }
            IMetadata qItem = null;
            if (this.fmMeasure instanceof QueryItemWrapper) {
                qItem = ((QueryItemWrapper)((Object)this.fmMeasure)).getQueryItem();
            } else if (this.fmMeasure instanceof V5DataItemToMeasureWrapper) {
                qItem = this.fmMeasure;
            } else if (this.fmMeasure instanceof MeasureWrapper) {
                qItem = this.fmMeasure;
            }
            if (qItem == null) {
                return new SetOfTables();
            }
            ArrayList<IMetadata> queryItems = new ArrayList<IMetadata>();
            queryItems.add(qItem);
            return PrePlanUtilities.getInvolvedTables(prePlan, queryItems, false);
        }
    }

    private final class DMRDummyMember
    extends DMRMember {
        private HashMap<String, DMRDummyMember> seenChild;
        private OrderedMap<IMember> allChildren;

        DMRDummyMember(Value objectName, Value businessKeyObj, DMRDummyLevel level) {
            super(objectName, businessKeyObj, level);
            this.seenChild = new HashMap();
            this.allChildren = new OrderedMap();
        }

        @Override
        public boolean isPopulateChildrenRequired() {
            return false;
        }

        @Override
        public void populateChildren() {
        }

        @Override
        public IOrderedMap<IMember> fetchChildMembers() throws MetadataException, ProviderException {
            if (this.getLevel().getNextLevel() == null) {
                return ImmutableOrderedMap.EMPTY_ORDERED_MEMBER_MAP;
            }
            if (this.allChildren.size() == 0) {
                StringValue memberCaption = DataValueFactory.createStringValue();
                ((Value)memberCaption).set(DMRCubeForPreciseLoading.MEMBER_ALL_CHILDREN);
                StringValue businessKey = DataValueFactory.createStringValue();
                ((Value)businessKey).set(memberCaption);
                DMRDummyMember mb = DMRCubeForPreciseLoading.this.createNewDMRDummyMember(memberCaption, businessKey, (DMRDummyLevel)this.getLevel().getNextLevel());
                this.addMemberToChildrenOrderedMap(mb);
                mb.setParentMember(this);
                this.allChildren.add(mb);
            }
            return this.allChildren;
        }

        @Override
        public Object getProperty(String propertyProviderUniqueName) {
            return DEFAULT_BUSINESSKEY;
        }

        @Override
        public IOrderedMap<IMember> getChildrenOrderedMap() {
            return this.fetchChildMembers();
        }

        @Override
        public IMember getChildMember(String memberName) throws MetadataException {
            DMRDummyMember c = this.seenChild.get(memberName);
            if (c == null) {
                StringValue memberCaption = DataValueFactory.createStringValue();
                ((Value)memberCaption).set(memberName);
                StringValue businessKey = DataValueFactory.createStringValue();
                ((Value)businessKey).set(memberCaption);
                c = DMRCubeForPreciseLoading.this.createNewDMRDummyMember(memberCaption, businessKey, (DMRDummyLevel)this.getLevel().getNextLevel());
                this.addMemberToChildrenOrderedMap(c);
                c.setParentMember(this);
                this.seenChild.put(memberName, c);
            }
            return c;
        }
    }

    private final class DMRDummyLevel
    extends DMRLevel {
        private List<IMember> allMembers;

        private DMRDummyLevel(String name, DMRDummyHierarchy hierarchy, ILevel level) {
            super(name, hierarchy, level);
            this.allMembers = new ArrayList<IMember>();
        }

        @Override
        public List<IMember> getMembers() throws MetadataException {
            if (this.allMembers.isEmpty()) {
                if ("MeasuresLevel".equals(this.getName())) {
                    this.allMembers.addAll(DMRCubeForPreciseLoading.this.createMeasures(this));
                } else if (this.isRootLevel()) {
                    DMRDummyMember rootMember = this.createRootMember();
                    this.allMembers.add(rootMember);
                } else {
                    DMRDummyMember memberForallMembers = this.createAllMembersMember();
                    this.allMembers.add(memberForallMembers);
                }
            }
            return this.allMembers;
        }

        @Override
        public IMember getMember(String memberName) throws MetadataException {
            if (this.isRootLevel()) {
                List<IMember> members = this.getMembers();
                if ("MeasuresLevel".equals(this.getName())) {
                    for (IMember m : members) {
                        if (!m.getName().equals(memberName)) continue;
                        return m;
                    }
                    throw new MetadataException(memberName);
                }
                return members.get(0);
            }
            throw new MetadataException(memberName);
        }

        private DMRDummyMember createAllMembersMember() {
            List<IMember> members = this.getPreviousLevel().getMembers();
            DMRDummyMember parentMember = (DMRDummyMember)members.get(0);
            StringValue memberCaption = DataValueFactory.createStringValue();
            ((Value)memberCaption).set(DMRCubeForPreciseLoading.LEVEL_ALL_MEMBERS);
            StringValue businessKey = DataValueFactory.createStringValue();
            ((Value)businessKey).set(memberCaption);
            DMRDummyMember mb = DMRCubeForPreciseLoading.this.createNewDMRDummyMember(memberCaption, businessKey, this);
            parentMember.addMemberToChildrenOrderedMap(mb);
            mb.setParentMember((IMember)parentMember);
            return mb;
        }

        private DMRDummyMember createRootMember() {
            DMRDummyHierarchy hier = (DMRDummyHierarchy)this.getHierarchy();
            IMember rootMember = hier.getFMRootMember();
            Value memberCaption = null;
            Value businessKey = null;
            if (rootMember != null) {
                memberCaption = rootMember.getCaptionValue();
                try {
                    businessKey = rootMember.getBusinessKeyValue();
                }
                catch (UnsupportedOperationException e) {
                    XQEDebugLog.err.println("Root member has no business key: " + rootMember.getUniqueName());
                }
            } else {
                memberCaption = DataValueFactory.createStringValue();
                memberCaption.set("all");
                businessKey = DataValueFactory.createStringValue();
                businessKey.set(memberCaption);
            }
            if (businessKey == null || businessKey.isNull()) {
                String rootName = rootMember.getUniqueName();
                if ((rootName = UniqueNameGenerator.extractRightPartFromCognosMUN(rootName)) == null) {
                    rootName = rootMember.getUniqueName();
                }
                String[] parts = null;
                try {
                    parts = UniqueNameParser.parse(rootName);
                }
                catch (UniqueNameParserException uniqueNameParserException) {
                    // empty catch block
                }
                if (parts != null && parts.length > 0) {
                    businessKey = DataValueFactory.createStringValue();
                    businessKey.set(parts[parts.length - 1]);
                }
            }
            if (memberCaption == null || memberCaption.isNull()) {
                memberCaption = DataValueFactory.createStringValue();
                memberCaption.set("All " + this.getName());
            }
            return DMRCubeForPreciseLoading.this.createNewDMRDummyMember(memberCaption, businessKey, this);
        }
    }

    private final class DMRDummyHierarchy
    extends DMRHierarchy {
        private DMRDummyHierarchy(String name, DMRDummyDimension d, IHierarchy hierarchy) {
            super(name, (Dimension)d, hierarchy);
        }

        @Override
        protected void initialiseHierarchy() {
            DMRCubeForPreciseLoading.this.addDMRMetadataObject(this.fmHierarchy, this);
            int levelCount = this.fmHierarchy.getLevelCount();
            for (int i = 0; i < levelCount; ++i) {
                ILevel level = this.fmHierarchy.getLevel(i);
                DMRDummyLevel dmrLevel = new DMRDummyLevel(level.getName(), this, level);
                DMRCubeForPreciseLoading.this.addDMRMetadataObject(level, dmrLevel);
            }
            this.setUnbalanced(false);
            this.setRagged(false);
            this.setParentChild(false);
        }

        @Override
        protected void initialiseMeasureHierarchy() {
            new DMRDummyLevel("MeasuresLevel", this, null);
        }

        public IMember getFMRootMember() {
            return this.fmHierarchy.getRootMember();
        }

        @Override
        public IMember getDefaultMember() throws MetadataException {
            if (this.defaultMember != null) {
                return this.defaultMember;
            }
            List<IMember> members = this.getLevel(0).getMembers();
            this.defaultMember = members.get(0);
            if (this.fmHierarchy != null && PreLoadDMRCubeUtil.dimensionHasEmbeddedFilter(DMRCubeForPreciseLoading.this.getModelCube(), this.fmHierarchy.getDimension())) {
                ((DMRDummyMember)this.defaultMember).setHierarchyMemberType((byte)1);
                StringValue memberCaption = DataValueFactory.createStringValue();
                ((Value)memberCaption).set(DMRCubeForPreciseLoading.HIERARCHY_DEFAULT_MEMBER);
                StringValue businessKey = DataValueFactory.createStringValue();
                ((Value)businessKey).set(memberCaption);
                this.defaultMember = DMRCubeForPreciseLoading.this.createNewDMRDummyMember(memberCaption, businessKey, (DMRDummyLevel)this.getLevel(0));
            }
            return this.defaultMember;
        }

        @Override
        public IMember findMember(String memberNamePart) throws MetadataException {
            String trimmedName = memberNamePart.trim();
            if (!trimmedName.startsWith("[")) {
                throw new MetadataException(memberNamePart);
            }
            String uniqueName = this.getUniqueName();
            if (!trimmedName.startsWith(uniqueName)) {
                throw new MetadataException(memberNamePart);
            }
            trimmedName = trimmedName.substring(uniqueName.length() + 1);
            IMember result = null;
            String[] parts = null;
            try {
                parts = UniqueNameParser.parse(trimmedName);
            }
            catch (Exception e) {
                throw new MetadataException(e.getMessage());
            }
            if (parts == null || parts.length == 0) {
                throw new MetadataException(memberNamePart);
            }
            IMember rmb = this.getDefaultMember();
            if (!parts[0].equals(rmb.getName())) {
                return null;
            }
            result = rmb;
            for (int i = 1; i < parts.length; ++i) {
                result = this.findDescendant(result, parts[i], true);
            }
            return result;
        }

        @Override
        public IMember findDescendant(IMember parent, String memberNamePart, boolean caseSensitive) {
            return ((DMRDummyMember)parent).getChildMember(memberNamePart);
        }

        @Override
        public IMember[] getMembers() {
            List<ILevel> levels = this.getLevels();
            IMember[] rt = new IMember[levels.size()];
            for (int i = 0; i < levels.size(); ++i) {
                List<IMember> mbs = levels.get(i).getMembers();
                rt[i] = mbs.get(0);
            }
            return rt;
        }
    }

    private final class DMRDummyDimension
    extends DMRDimension {
        private DMRDummyDimension(String s, DMRCubeForPreciseLoading cube, IDimension dim) {
            super(s, cube, dim);
        }

        @Override
        protected void initialiseHierarchies() {
            if (this.getWrappedDimension().isMeasuresDimension()) {
                new DMRDummyHierarchy("Measures", this, null);
            } else {
                int hierarchyCount = this.getWrappedDimension().getHierarchyCount();
                for (int i = 0; i < hierarchyCount; ++i) {
                    IHierarchy fmHierarchy = this.getWrappedDimension().getHierarchy(i);
                    new DMRDummyHierarchy(fmHierarchy.getName(), this, fmHierarchy);
                }
            }
        }

        @Override
        public IMember findDescendant(IMember parent, String memberNamePart, boolean caseSensitive) {
            return ((DMRDummyMember)parent).getChildMember(memberNamePart);
        }
    }
}

