/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.math;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.runtree.olap.mdx.functions.math.MathFunction;
import java.util.ArrayList;

public class Ceil
extends MathFunction {
    private static final String CEIL_FUNCTION_NAME = "Ceil";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Double.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Double.class;
    }

    @Override
    public String getName() {
        return CEIL_FUNCTION_NAME;
    }

    @Override
    public Double doMathFunction(Double value) {
        return new Double(Math.ceil(value));
    }

    @Override
    public Value doMathFunction(Value value) {
        DoubleValue v = DataValueFactory.createDoubleValue();
        FormatService service = FormatService.getInstance();
        ArrayList<FormatId> operandIds = new ArrayList<FormatId>();
        operandIds.add(value.getFormatId());
        FormatId resultFormatId = service.formatResult("RoundToInteger", operandIds);
        v.setFormatId(resultFormatId);
        ((Value)v).set(Math.ceil(value.getDouble()));
        return v;
    }
}

