/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.math;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.runtree.olap.mdx.functions.math.MathFunction;
import java.util.ArrayList;

public class Tanh
extends MathFunction {
    private static final String TANH_FUNCTION_NAME = "Tanh";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Double.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Double.class;
    }

    @Override
    public String getName() {
        return TANH_FUNCTION_NAME;
    }

    private double tanh(double d) {
        double e = Math.E;
        double sinh = (Math.pow(e, d) - Math.pow(e, -d)) / 2.0;
        double cosh = (Math.pow(e, d) + Math.pow(e, -d)) / 2.0;
        return sinh / cosh;
    }

    @Override
    public Double doMathFunction(Double value) {
        return new Double(this.tanh(value));
    }

    @Override
    public Value doMathFunction(Value value) {
        DoubleValue v = DataValueFactory.createDoubleValue();
        FormatService service = FormatService.getInstance();
        ArrayList<FormatId> operandIds = new ArrayList<FormatId>();
        operandIds.add(value.getFormatId());
        FormatId resultFormatId = service.formatResult("Trigonometric", operandIds);
        v.setFormatId(resultFormatId);
        ((Value)v).set(this.tanh(value.getDouble()));
        return v;
    }
}

