/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.member;

import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;

public class Lead
implements Function {
    private static final String LEAD_FUNCTION_NAME = "Lead";

    @Override
    public Class<?> getSubjectType() {
        return IMember.class;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Double.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return IMember.class;
    }

    @Override
    public String getName() {
        return LEAD_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        int paramCount = parameterFetcher.getParameterCount();
        if (paramCount != 1) {
            throw new InterpreterException("X01517", new String[]{"1", this.getName()});
        }
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block memberParamB = (Block)subject;
        memberParamB = Caster.cast(memberParamB, IMember.class, interpreterContext);
        Block indexParamB = (Block)parameterFetcher.getParameter(0);
        indexParamB.getValues(interpreterContext);
        indexParamB = Caster.castToInt(indexParamB, interpreterContext);
        Block[] wrkBlocks = new Block[]{memberParamB, indexParamB};
        Block block = new Block(interpreterContext, wrkBlocks);
        BlockIterator blockIter = new BlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            IMember leadMember = this.doExecute((IMember)blockObj[0], blockObj[1], interpreterContext);
            block.add(blockIter, (Object)leadMember);
        }
        return block;
    }

    public IMember doExecute(IMember member, Object countParam, InterpreterContext interpreterContext) throws InterpreterException {
        Value v;
        int count = 0;
        if (countParam instanceof Integer) {
            count = (Integer)countParam;
        } else if (countParam instanceof Value && !(v = (Value)countParam).isNull()) {
            count = v.getInteger();
        }
        boolean lagged = false;
        if (count < 0) {
            lagged = true;
            count = -count;
        }
        return this.lead(member, count, lagged, interpreterContext);
    }

    public IMember lead(IMember member, int count, boolean lagged, InterpreterContext interpreterContext) throws InterpreterException {
        member = (IMember)MemberOperations.getOriginalCalculatedMember(member);
        boolean includeFillerMembers = false;
        if (member != null && member.isExtendedCalculatedMember()) {
            includeFillerMembers = true;
        }
        IMember resultMember = member;
        for (int j = 0; j < count && resultMember != null && !(resultMember instanceof NullMember); ++j) {
            try {
                if (lagged) {
                    resultMember = MemberOperations.getPreviousMemberOp(resultMember, includeFillerMembers, interpreterContext);
                    continue;
                }
                resultMember = MemberOperations.getNextMemberOp(resultMember, includeFillerMembers, interpreterContext);
                continue;
            }
            catch (MetadataException e) {
                throw new InterpreterException("X01495", new String[]{this.getName(), resultMember.getName()}, e);
            }
        }
        if (resultMember == null && member != null) {
            resultMember = NullMember.getNullMember(member);
        }
        return resultMember;
    }
}

