/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.set;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.V5ExpressionUtils;
import com.cognos.xqe.util.monitor.ResourceMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class AddCalculatedMembers
implements Function {
    private static final String ADDCALCULATEDMEMBERS_FUNCTION_NAME = "AddCalculatedMembers";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Set.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return 1;
    }

    @Override
    public Class<?> getReturnType() {
        return Set.class;
    }

    @Override
    public String getName() {
        return ADDCALCULATEDMEMBERS_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block setParamB = (Block)parameterFetcher.getParameter(0);
        setParamB = Caster.cast(setParamB, Set.class, interpreterContext);
        Block[] wrkBlocks = new Block[]{setParamB};
        Block block = new Block(interpreterContext, wrkBlocks);
        BlockIterator blockIter = new BlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Set aSet = (Set)blockObj[0];
            aSet = aSet.removeNullMembers();
            Set addCalcMemsSet = this.addCalculatedMember(aSet, interpreterContext);
            block.add(blockIter, (Object)addCalcMemsSet);
        }
        block.removeInvalidTuples();
        return block;
    }

    private Set addCalculatedMember(Set set, InterpreterContext interpreterContext) throws InterpreterException {
        int i;
        if (set.getRelativeTimeAncestorObject() != null) {
            return this.addCalculatedMemberToDescendantsSetOfRelativeTimeMember(set, interpreterContext);
        }
        if (set.isEmpty()) {
            if (set.getPtdLastChild() != null) {
                set = new Set(new Tuple(set.getPtdLastChild()));
            } else {
                if (set.getEmptyChildrenSetParentMember() != null) {
                    return this.addCalculatedMemberToEmptyChildrenSet(set, interpreterContext);
                }
                return set;
            }
        }
        if (set.getHierarchyCount() > 1) {
            throw new InterpreterException("X01482", new String[]{this.getName()}, 1L);
        }
        ITuple testTuple = set.getTuple(0L);
        IMember testMember = testTuple.getMember(0);
        Dimension testDimension = (Dimension)testMember.getDimension();
        ArrayList<IMember> allCalcMembers = interpreterContext.getCalculationEngine().getCalculatedMembers(testDimension);
        ArrayList<CalculatedMember> calcMembers = new ArrayList<CalculatedMember>();
        for (int i2 = 0; i2 < allCalcMembers.size(); ++i2) {
            CalculatedMember calc = (CalculatedMember)allCalcMembers.get(i2);
            if (!calc.isExtendedCalculatedMember() && interpreterContext.getCube() instanceof ROLAPCube && !V5ExpressionUtils.validateSimpleExpression((ROLAPCube)interpreterContext.getCube(), calc.getCalculationString(), null, null, true)) continue;
            calcMembers.add(calc);
        }
        HashMap<IMember, ArrayList<IMember>> parentToCalcMembers = new HashMap<IMember, ArrayList<IMember>>();
        HashSet<IMember> calcMembersInSet = new HashSet<IMember>();
        int sz = (int)set.size();
        ResourceMonitor.checkMaxSetSize((long)sz, interpreterContext.getQueryContext(), XQEMessageKeys.MDX_MaxCrossjoinSize);
        for (i = 0; i < sz; ++i) {
            ITuple t = set.getTuple(i);
            IMember m = t.getMember(0);
            if (!(m instanceof CalculatedMember)) continue;
            calcMembersInSet.add(m);
        }
        for (i = 0; i < calcMembers.size(); ++i) {
            CalculatedMember cal = (CalculatedMember)calcMembers.get(i);
            if (calcMembersInSet.contains(cal) || cal.getDimension() != testDimension) continue;
            IMember parent = cal.getParent();
            ArrayList<CalculatedMember> calcs = (ArrayList<CalculatedMember>)parentToCalcMembers.get(parent);
            if (calcs == null) {
                calcs = new ArrayList<CalculatedMember>();
            }
            calcs.add(cal);
            parentToCalcMembers.put(parent, calcs);
        }
        if (parentToCalcMembers.size() == 0) {
            return set;
        }
        ArrayList<ITuple> tuples = new ArrayList<ITuple>();
        int iNext = 0;
        while (iNext < sz) {
            ITuple t = set.getTuple(iNext);
            IMember m = t.getMember(0);
            ++iNext;
            iNext = this.appendOne(m, set, iNext, tuples, parentToCalcMembers, true);
        }
        ITuple[] tupsOut = tuples.toArray(new Tuple[tuples.size()]);
        Set result = new Set(tupsOut, false);
        return result;
    }

    private Set addCalculatedMemberToDescendantsSetOfRelativeTimeMember(Set set, InterpreterContext interpreterContext) {
        IMetadata parentObject = set.getRelativeTimeAncestorObject();
        if (parentObject instanceof IMember) {
            IMember parentMember = (IMember)parentObject;
            ArrayList<IMember> calcMembers = interpreterContext.getCalculationEngine().getCalculatedMembers(parentMember.getHierarchy());
            ArrayList<IMember> descendants = new ArrayList<IMember>();
            this.addChildrenRecursive(parentMember, calcMembers, descendants);
            if (descendants.isEmpty()) {
                return set;
            }
            IMember[] descendantMems = descendants.toArray(new IMember[descendants.size()]);
            return new Set(Tuple.createTupleList(descendantMems));
        }
        IHierarchy hier = (IHierarchy)parentObject;
        List<IMember> members = hier.getLevel(0).getMembers();
        ArrayList<IMember> calcMembers = interpreterContext.getCalculationEngine().getCalculatedMembers(hier);
        ArrayList<IMember> descendants = new ArrayList<IMember>();
        for (IMember m : members) {
            descendants.add(m);
            if (m.getLevel().isLeafLevel()) continue;
            this.addChildrenRecursive(m, calcMembers, descendants);
        }
        for (IMember calcMember : calcMembers) {
            if (calcMember.getParent() != null) continue;
            descendants.add(calcMember);
            if (calcMember.getLevel().isLeafLevel()) continue;
            this.addChildrenRecursive(calcMember, calcMembers, descendants);
        }
        if (descendants.isEmpty()) {
            return set;
        }
        IMember[] descendantMems = descendants.toArray(new IMember[descendants.size()]);
        return new Set(Tuple.createTupleList(descendantMems));
    }

    private void addChildrenRecursive(IMember parentMember, ArrayList<IMember> calcMembers, ArrayList<IMember> descendants) {
        if (!parentMember.isCalculatedMember()) {
            List<IMember> children = parentMember.getChildren();
            for (IMember child : children) {
                descendants.add(child);
                if (child.getLevel().isLeafLevel()) continue;
                this.addChildrenRecursive(child, calcMembers, descendants);
            }
        }
        for (IMember calcMember : calcMembers) {
            if (calcMember.getParent() != parentMember) continue;
            descendants.add(calcMember);
            if (calcMember.getLevel().isLeafLevel()) continue;
            this.addChildrenRecursive(calcMember, calcMembers, descendants);
        }
    }

    private Set addCalculatedMemberToEmptyChildrenSet(Set set, InterpreterContext interpreterContext) {
        IMember parentMember = set.getEmptyChildrenSetParentMember();
        ArrayList<IMember> calcMembers = interpreterContext.getCalculationEngine().getCalculatedMembers(parentMember.getHierarchy());
        ArrayList<IMember> children = new ArrayList<IMember>();
        for (IMember calcMember : calcMembers) {
            if (calcMember.getParent() != parentMember) continue;
            children.add(calcMember);
        }
        if (children.isEmpty()) {
            return set;
        }
        IMember[] childMems = children.toArray(new IMember[children.size()]);
        return new Set(Tuple.createTupleList(childMems));
    }

    private int appendOne(IMember m, Set s, int iNext, ArrayList<ITuple> tuples, HashMap<IMember, ArrayList<IMember>> parentToCalcMembers, boolean appendCalcs) {
        ITuple t;
        IMember mNext;
        IMember parent = m.getParent();
        tuples.add(new Tuple(m));
        while (iNext < (int)s.size() && (mNext = (t = s.getTuple(iNext)).getMember(0)).getParent() == m) {
            ++iNext;
            iNext = this.appendOne(mNext, s, iNext, tuples, parentToCalcMembers, true);
        }
        if (iNext < (int)s.size() && (mNext = (t = s.getTuple(iNext)).getMember(0)).getParent() == parent) {
            return iNext;
        }
        if (appendCalcs && parentToCalcMembers.containsKey(m.getParent())) {
            ArrayList<IMember> calcs = parentToCalcMembers.get(parent);
            for (int k = 0; k < calcs.size(); ++k) {
                CalculatedMember mem = (CalculatedMember)calcs.get(k);
                tuples.add(new Tuple(mem));
            }
        }
        return iNext;
    }
}

