/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.set;

import com.cognos.xqe.runtree.olap.mdx.functions.Utilities;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullBehavior;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SimpleTupleValueComparator;
import com.ibm.icu.text.Collator;
import java.util.Comparator;

public class CellValueComparatorFactory {
    public static Comparator<Object> getComparator(InterpreterContext interpreterContext, boolean useOrdinalsToBreakTies) {
        NullBehavior nullHandling = Utilities.getNullBehavior(interpreterContext);
        Collator collator = interpreterContext.getXDataContext().getLocalCollator();
        Comparator<Object> c = new SimpleTupleValueComparator(collator, false, nullHandling);
        if (useOrdinalsToBreakTies) {
            c = new UseOrdinalToBreakTieComparator(c);
        }
        return c;
    }

    private static class UseOrdinalToBreakTieComparator
    implements Comparator<Object> {
        private final Comparator<Object> valueComparator;

        UseOrdinalToBreakTieComparator(Comparator<Object> aValueComparator) {
            this.valueComparator = aValueComparator;
        }

        @Override
        public int compare(Object o1, Object o2) {
            int compareResult = this.valueComparator.compare(o1, o2);
            if (compareResult == 0) {
                Cell c1 = (Cell)o1;
                Cell c2 = (Cell)o2;
                if (c1.getOrdinal() < c2.getOrdinal()) {
                    return -1;
                }
                if (c2.getOrdinal() < c1.getOrdinal()) {
                    return 1;
                }
            }
            return compareResult;
        }
    }
}

