/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.set;

import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import java.util.ArrayList;

public class Extract
implements Function {
    private static final String EXTRACT_FUNCTION_NAME = "Extract";
    private static final String NULL_STR = "null";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Set.class, Dimension.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Set.class;
    }

    @Override
    public String getName() {
        return EXTRACT_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        ArrayList<Object> al = new ArrayList<Object>();
        Block setParamB = (Block)parameterFetcher.getParameter(0);
        setParamB = Caster.cast(setParamB, Set.class, interpreterContext, this.getName());
        al.add(setParamB);
        int paramCount = parameterFetcher.getParameterCount();
        if (paramCount < 2) {
            throw new InterpreterException("X01517", new String[]{"> 1", this.getName()});
        }
        for (int i = 1; i < paramCount; ++i) {
            Block hierParamB = (Block)parameterFetcher.getParameter(i);
            if (hierParamB == null) {
                throw new InterpreterException("X01490", new String[]{"", this.getName(), "CMP_TYPEHIERARCHY"});
            }
            al.add(hierParamB);
        }
        Block[] wrkBlocks = al.toArray(new Block[0]);
        Block block = new Block(interpreterContext, wrkBlocks);
        BlockIterator blockIter = new BlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            al.clear();
            for (int i = 1; i < blockObj.length; ++i) {
                al.add(blockObj[i]);
            }
            IMetadata[] metadataObjs = al.toArray(new IMetadata[al.size()]);
            Set extractSet = this.extract((Set)blockObj[0], metadataObjs);
            block.add(blockIter, (Object)extractSet);
        }
        block.removeInvalidTuples();
        return block;
    }

    private Set extract(Set set, IMetadata[] metadataObjs) throws InterpreterException {
        if (metadataObjs == null || metadataObjs.length == 0) {
            return new Set((ITupleList)null);
        }
        set = set.removeNullMembers();
        if (metadataObjs[0].getObjectType() == MetadataType.HIERARCHY) {
            IHierarchy[] hiers = this.validateParamsHier(metadataObjs, set);
            set = set.extract(hiers, false);
        } else if (metadataObjs[0].getObjectType() == MetadataType.DIMENSION) {
            IDimension[] dims = this.validateParamsDim(metadataObjs, set);
            set = set.extract(dims, false);
        } else {
            throw new InterpreterException("X01490", new String[]{metadataObjs[0].getObjectType().toString(), this.getName(), "IDimension or IHierarchy"});
        }
        return set;
    }

    private IHierarchy[] validateParamsHier(IMetadata[] metadataObjs, Set set) throws InterpreterException {
        IHierarchy[] hierarchies = new IHierarchy[metadataObjs.length];
        boolean setIsEmpty = set.isEmpty();
        for (int i = 0; i < metadataObjs.length; ++i) {
            if (metadataObjs[i].getObjectType() == MetadataType.HIERARCHY) {
                hierarchies[i] = (IHierarchy)metadataObjs[i];
                if (setIsEmpty || set.contains(hierarchies[i])) {
                    continue;
                }
            } else if (metadataObjs[i].getObjectType() != MetadataType.DIMENSION) {
                throw new InterpreterException("X01490", new String[]{metadataObjs[i].getObjectType().toString(), EXTRACT_FUNCTION_NAME, "IHierarchy"});
            }
            this.throwTheNotFoundException(metadataObjs[i], set);
        }
        return hierarchies;
    }

    private IDimension[] validateParamsDim(IMetadata[] metadataObjs, Set set) throws InterpreterException {
        IDimension[] dimensions = new IDimension[metadataObjs.length];
        boolean setIsEmpty = set.isEmpty();
        for (int i = 0; i < metadataObjs.length; ++i) {
            if (metadataObjs[i].getObjectType() == MetadataType.DIMENSION) {
                dimensions[i] = (IDimension)metadataObjs[i];
                if (setIsEmpty || set.contains(dimensions[i])) {
                    continue;
                }
            } else if (metadataObjs[i].getObjectType() != MetadataType.DIMENSION) {
                throw new InterpreterException("X01490", new String[]{metadataObjs[i].getObjectType().toString(), EXTRACT_FUNCTION_NAME, "IDimension"});
            }
            this.throwTheNotFoundException(metadataObjs[i], set);
        }
        return dimensions;
    }

    private void throwTheNotFoundException(IMetadata metadataObj, Set set) throws InterpreterException {
        IHierarchy[] setHierarchies = set.getHierarchies();
        StringBuilder hierarchiesString = new StringBuilder();
        if (setHierarchies.length > 0) {
            hierarchiesString = setHierarchies[0] != null ? hierarchiesString.append(setHierarchies[0].toString()) : hierarchiesString.append(NULL_STR);
        }
        for (int j = 1; j < setHierarchies.length; ++j) {
            if (setHierarchies[j] != null) {
                hierarchiesString = hierarchiesString.append(", ");
                hierarchiesString.append(setHierarchies[j].toString());
                continue;
            }
            hierarchiesString = hierarchiesString.append(NULL_STR);
        }
        String paramName = metadataObj.toString();
        throw new InterpreterException("X01490", new String[]{paramName, this.getName(), hierarchiesString.toString()});
    }
}

