/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.set;

import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import com.cognos.xqe.trace.XQEDebugLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LastPeriods
implements Function {
    private static final String LASTPERIODS_FUNCTION_NAME = "LastPeriods";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Double.class}, {Double.class, IMember.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Set.class;
    }

    @Override
    public String getName() {
        return LASTPERIODS_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block indexParamB = (Block)parameterFetcher.getParameter(0);
        indexParamB.getValues(interpreterContext);
        indexParamB = Caster.castToInt(indexParamB, interpreterContext);
        Block memberParamB = null;
        int paramCount = parameterFetcher.getParameterCount();
        if (paramCount > 1) {
            memberParamB = (Block)parameterFetcher.getParameter(1);
            memberParamB = Caster.cast(memberParamB, IMember.class, interpreterContext, this.getName());
        } else {
            ICube cube = interpreterContext.getCube();
            Dimension timeDimension = this.getTimeDimension(cube);
            memberParamB = new Block(interpreterContext, timeDimension);
            memberParamB.getCurrentMembers();
        }
        IMember firstMember = (IMember)memberParamB.first();
        if (firstMember != null) {
            boolean mayContainFillers = firstMember.getHierarchy().isRagged() || firstMember.getHierarchy().isUnbalanced();
            IDataSource dataSource = null;
            if (interpreterContext.getXDataContext() != null && interpreterContext.getXDataContext().getEnvironment() != null) {
                dataSource = interpreterContext.getXDataContext().getEnvironment().getDataSource();
            }
            boolean forceOperationOnRaggedUnbalanced = false;
            if (dataSource != null) {
                forceOperationOnRaggedUnbalanced = dataSource.getCapabilities().getStringValue("engine.forceOperationsOnRaggedTimeHierarchies", "false").equals("true");
            }
            if (mayContainFillers && !forceOperationOnRaggedUnbalanced) {
                throw new InterpreterException("X01460", new String[]{this.getName()});
            }
        }
        Block[] wrkBlocks = new Block[]{indexParamB, memberParamB};
        Block block = new Block(interpreterContext, wrkBlocks);
        IBlockIterator blockIter = Block.getBlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Set lastPeriodsSet = this.lastPeriods(blockObj[0], (IMember)blockObj[1], interpreterContext);
            block.add(blockIter, (Object)lastPeriodsSet);
        }
        block.removeInvalidTuples();
        return block;
    }

    private Set lastPeriods(Object indexParam, IMember member, InterpreterContext interpreterContext) throws InterpreterException {
        Value v;
        member = (IMember)MemberOperations.getOriginalCalculatedMember(member);
        boolean includeFillerMembers = false;
        if (member != null && member.isExtendedCalculatedMember()) {
            includeFillerMembers = true;
        }
        int index = 0;
        if (indexParam instanceof Integer) {
            index = (Integer)indexParam;
        } else if (indexParam instanceof Value && !(v = (Value)indexParam).isNull()) {
            double d = v.getDouble();
            index = d > 2.147483647E9 ? Integer.MAX_VALUE : (d < -2.147483648E9 ? Integer.MIN_VALUE : v.getInteger());
        }
        boolean lag = true;
        if (index < 0) {
            lag = false;
            index = index == Integer.MIN_VALUE ? Integer.MAX_VALUE : -index;
        }
        ArrayList<IMember> al = new ArrayList<IMember>();
        for (int i = 0; member != null && !(member instanceof NullMember) && i < index; ++i) {
            al.add(member);
            try {
                if (lag) {
                    member = MemberOperations.getPreviousMemberOp(member, includeFillerMembers, interpreterContext);
                    continue;
                }
                member = MemberOperations.getNextMemberOp(member, includeFillerMembers, interpreterContext);
                continue;
            }
            catch (MetadataException e) {
                throw new InterpreterException("X01427", new String[]{"NULL: " + e.toString()}, e);
            }
        }
        if (lag) {
            Collections.reverse(al);
        }
        Set result = new Set(Tuple.createTupleList(al.toArray(new IMember[0])));
        return result;
    }

    protected Dimension getTimeDimension(ICube c) {
        Dimension result = null;
        List<IDimension> dimensionList = c.getDimensions();
        Dimension[] dims = dimensionList.toArray(new Dimension[0]);
        for (int i = 0; i < dims.length && result == null; ++i) {
            Dimension dim = dims[i];
            if (!dim.isTimeDimension() && dim.getName().indexOf("Time") != 0) continue;
            result = dim;
        }
        if (result == null) {
            XQEDebugLog.out.println(" Error getting time dimension of cube " + c.getName());
        }
        return result;
    }
}

