/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.set;

import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleListFilter;
import java.util.Iterator;
import java.util.TreeSet;

public class NonEmptyCrossjoin
implements Function {
    private static final String NONEMPTYCROSSJOIN_FUNCTION_NAME = "NonEmptyCrossjoin";
    private static final long LAST_TUPLE_IDX_DEFAULT = 0xFFFFFFFFL;

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Set.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Set.class;
    }

    @Override
    public String getName() {
        return NONEMPTYCROSSJOIN_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        int paramIdx;
        int paramCount = parameterFetcher.getParameterCount();
        if (paramCount == 0) {
            throw new InterpreterException("X01517", new String[]{"> 0", this.getName()});
        }
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block[] paramsB = new Block[paramCount];
        for (int paramIdx2 = 0; paramIdx2 < paramCount; ++paramIdx2) {
            paramsB[paramIdx2] = (Block)parameterFetcher.getParameter(paramIdx2);
        }
        int[] setCounts = this.getSetCounts(paramsB);
        int crossjoinCount = setCounts[0];
        int columnSetsCount = setCounts[1];
        Block[] setsB = new Block[crossjoinCount + columnSetsCount];
        Block[] setsToCrossjoinB = new Block[crossjoinCount];
        for (paramIdx = 0; paramIdx < crossjoinCount; ++paramIdx) {
            setsToCrossjoinB[paramIdx] = Caster.cast(paramsB[paramIdx], Set.class, interpreterContext);
            setsB[paramIdx] = Caster.cast(paramsB[paramIdx], Set.class, interpreterContext);
        }
        for (paramIdx = crossjoinCount; paramIdx < crossjoinCount + columnSetsCount; ++paramIdx) {
            setsB[paramIdx] = Caster.cast(paramsB[paramIdx], Set.class, interpreterContext);
        }
        Block sBlock = new Block(interpreterContext, setsToCrossjoinB);
        BlockIterator blockIter = new BlockIterator(setsToCrossjoinB);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            ISet s = new CrossJoinedSet(new Set[]{new Set(new Tuple[0])});
            for (int paramIdx3 = 0; paramIdx3 < blockObj.length; ++paramIdx3) {
                Set s1 = (Set)blockObj[paramIdx3];
                if (s1.isEmpty()) {
                    s = new Set(new Tuple[0]);
                    break;
                }
                s = ((Set)s).crossjoin(s1, true);
            }
            sBlock.add(blockIter, (Object)s);
        }
        Block aBlock = new Block(interpreterContext, setsB);
        blockIter = new BlockIterator(setsB);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            ISet s = new CrossJoinedSet(new Set[]{new Set(new Tuple[0])});
            for (int paramIdx4 = 0; paramIdx4 < blockObj.length; ++paramIdx4) {
                Set s1 = (Set)blockObj[paramIdx4];
                if (s1.isEmpty()) {
                    if (paramIdx4 >= crossjoinCount) continue;
                    s = new Set(new Tuple[0]);
                    break;
                }
                s = ((Set)s).crossjoin(s1, true);
            }
            aBlock.add(blockIter, (Object)s);
        }
        Block vBlock = new Block(interpreterContext, aBlock, null, 0, true, true);
        Block[] childBlocks = null;
        childBlocks = new Block[]{sBlock, aBlock, vBlock};
        Block retBlock = new Block(interpreterContext, childBlocks);
        blockIter = new BlockIterator(childBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Set s = (Set)blockObj[0];
            Set a = (Set)blockObj[1];
            if (s.isEmpty() || a.isEmpty()) {
                s = new Set(new Tuple[0]);
            } else {
                long f = a.size() / s.size();
                TreeSet v = (TreeSet)blockObj[2];
                s = this.getNonEmptySet(s, v, f);
            }
            retBlock.add(blockIter, (Object)s);
        }
        retBlock.removeInvalidTuples();
        return retBlock;
    }

    public int[] getSetCounts(Block[] paramB) {
        Value v;
        int crossjoinCount = paramB.length;
        int columnSetsCount = 0;
        Object paramFirstObj = paramB[paramB.length - 1].first();
        if (paramFirstObj instanceof Double) {
            crossjoinCount = ((Double)paramFirstObj).intValue();
            columnSetsCount = paramB.length - crossjoinCount - 1;
        } else if (paramFirstObj instanceof Value && !(v = (Value)paramFirstObj).isNull()) {
            crossjoinCount = v.getInteger();
            columnSetsCount = paramB.length - crossjoinCount - 1;
        }
        return new int[]{crossjoinCount, columnSetsCount};
    }

    private Set getNonEmptySet(Set s, TreeSet<Cell> v, long f) {
        if (v == null) {
            return new Set(new Tuple[0]);
        }
        TupleListFilter filter = new TupleListFilter(s.size());
        Iterator<Cell> cellValuesIter = v.iterator();
        Long lastTupleIndex = 0xFFFFFFFFL;
        while (cellValuesIter.hasNext()) {
            Cell cellValue = cellValuesIter.next();
            long tupleIndex = cellValue.getOrdinal() / f;
            if (tupleIndex == lastTupleIndex) continue;
            filter.enable(tupleIndex);
            lastTupleIndex = tupleIndex;
        }
        return s.getFilteredSet(filter);
    }
}

