/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.set;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.functions.member.PeriodFunction;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.ArrayList;

public class PeriodsToDate
extends PeriodFunction {
    private static final String PERIODSTODATE_FUNCTION_NAME = "PeriodsToDate";
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        Block[] wrkBlocks;
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block levelParamB = null;
        Block memberParamB = null;
        int paramCount = parameterFetcher.getParameterCount();
        if (paramCount > 0) {
            levelParamB = (Block)parameterFetcher.getParameter(0);
            levelParamB = Caster.cast(levelParamB, Level.class, interpreterContext, this.getName());
            if (paramCount > 1) {
                memberParamB = (Block)parameterFetcher.getParameter(1);
                memberParamB = Caster.cast(memberParamB, IMember.class, interpreterContext, this.getName());
            } else {
                Level firstLevelParam = (Level)levelParamB.first();
                IHierarchy levelHier = firstLevelParam.getHierarchy();
                memberParamB = new Block(interpreterContext, levelHier);
                memberParamB.getCurrentMembers();
            }
        } else {
            ICube cube = interpreterContext.getCube();
            Dimension timeDimension = (Dimension)this.getTimeDimension(cube);
            memberParamB = new Block(interpreterContext, timeDimension);
            memberParamB.getCurrentMembers();
            wrkBlocks = new Block[]{memberParamB};
            levelParamB = new Block(interpreterContext, wrkBlocks);
            BlockIterator blockIter = new BlockIterator(wrkBlocks);
            while (blockIter.hasNext()) {
                Object[] blockObj = (Object[])blockIter.next();
                IMember member = (IMember)blockObj[0];
                if (member instanceof NullMember) continue;
                ILevel level = (Level)member.getLevel();
                if (level.getIndex() > 0) {
                    level = level.getPreviousLevel();
                }
                levelParamB.add(blockIter, (Object)level);
            }
        }
        IDataSource dataSource = null;
        if (interpreterContext.getXDataContext() != null && interpreterContext.getXDataContext().getEnvironment() != null) {
            dataSource = interpreterContext.getXDataContext().getEnvironment().getDataSource();
        }
        boolean forceOperationOnRaggedUnbalanced = false;
        if (dataSource != null) {
            forceOperationOnRaggedUnbalanced = dataSource.getCapabilities().getStringValue("engine.forceOperationsOnRaggedTimeHierarchies", "false").equals("true");
        }
        wrkBlocks = new Block[]{levelParamB, memberParamB};
        Block block = new Block(interpreterContext, wrkBlocks);
        BlockIterator blockIter = new BlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Set periodsToDateSet = this.periodsToDate((Level)blockObj[0], (IMember)blockObj[1], forceOperationOnRaggedUnbalanced);
            block.add(blockIter, (Object)periodsToDateSet);
        }
        block.removeInvalidTuples();
        return block;
    }

    protected Set periodsToDate(Level level, IMember member, boolean forceOperationOnRaggedUnbalanced) throws InterpreterException {
        boolean mayContainFillers;
        if (level == null) {
            return new Set(new Tuple(NullMember.getNullMember(member)));
        }
        member = (IMember)MemberOperations.getOriginalCalculatedMember(member);
        boolean bl = mayContainFillers = level.getHierarchy().isRagged() || level.getHierarchy().isUnbalanced();
        if (mayContainFillers && !forceOperationOnRaggedUnbalanced) {
            throw new InterpreterException("X01460", new String[]{this.getName()});
        }
        if (member instanceof NullMember) {
            return new Set(new Tuple(member));
        }
        if (member == null) {
            return new Set(new Tuple[0]);
        }
        if ((MemberOperations.isRegularCalculatedMember(member) || MemberOperations.isExtendedCalculatedMemberTypeParent(member)) && member.getLevel() != level) {
            return new Set(new Tuple(NullMember.getNullMember(member)));
        }
        Set result = null;
        try {
            IMember ancestorMember;
            for (ancestorMember = member; ancestorMember != null && ancestorMember.getLevel() != level; ancestorMember = ancestorMember.getParent()) {
            }
            if (ancestorMember == null) {
                result = new Set(new Tuple(NullMember.getNullMember(member.getHierarchy())));
            } else {
                ArrayList<IMember> descs = ((IMemberCubics)ancestorMember).getDescendants(member.getLevel());
                ArrayList<IMember> periodsSoFar = new ArrayList<IMember>();
                boolean parameterMemberNotAdded = true;
                for (int j = 0; j < descs.size() && parameterMemberNotAdded; ++j) {
                    IMember descMember = descs.get(j);
                    periodsSoFar.add(descMember);
                    if (descMember != member) continue;
                    parameterMemberNotAdded = false;
                }
                IMember[] members = periodsSoFar.toArray(new IMember[0]);
                result = new Set(Tuple.createTupleList(members), false);
            }
        }
        catch (MetadataException e) {
            mErrorLogger.log(e);
        }
        return result;
    }

    protected ILevel findLevelWithType(Dimension time, String levelType) {
        ILevel year = null;
        int levelCount = time.getLevelCount();
        for (int levelIndex = 0; year == null && levelIndex < levelCount; ++levelIndex) {
            ILevel l = time.getLevel(levelIndex);
            Object value = l.getProperty("LevelType");
            if (value != null && value instanceof String && ((String)value).equalsIgnoreCase(levelType)) {
                year = l;
                continue;
            }
            if (l.getName().toUpperCase().indexOf(levelType.toUpperCase()) < 0) continue;
            year = l;
        }
        return year;
    }

    @Override
    public String getName() {
        return PERIODSTODATE_FUNCTION_NAME;
    }

    @Override
    public Class<?> getReturnType() {
        return Set.class;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Level.class}, {Level.class, IMember.class}, new Class[0]};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }
}

