/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.set;

import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import java.util.ArrayList;

public class StripCalculatedMembers
implements Function {
    private static final String STRIP_CALCULATED_MEMBERS_FUNCTION_NAME = "StripCalculatedMembers";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Set.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return 1;
    }

    @Override
    public Class<?> getReturnType() {
        return Set.class;
    }

    @Override
    public String getName() {
        return STRIP_CALCULATED_MEMBERS_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block setParamB = (Block)parameterFetcher.getParameter(0);
        setParamB = Caster.cast(setParamB, Set.class, interpreterContext);
        Block[] wrkBlocks = new Block[]{setParamB};
        Block block = new Block(interpreterContext, wrkBlocks);
        BlockIterator blockIter = new BlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Set set = this.stripCalculatedMembers((Set)blockObj[0]);
            block.add(blockIter, (Object)set);
        }
        block.removeInvalidTuples();
        return block;
    }

    private Set stripCalculatedMembers(Set set) {
        if (set.size() > 0L) {
            int sz = (int)set.size();
            ArrayList<ITuple> tuples = new ArrayList<ITuple>();
            for (int i = 0; i < sz; ++i) {
                ITuple t = set.getTuple(i);
                boolean keepTuple = true;
                for (int j = 0; j < t.size() && keepTuple; ++j) {
                    IMember m = t.getMember(j);
                    if (!(m instanceof CalculatedMember)) continue;
                    keepTuple = false;
                }
                if (!keepTuple) continue;
                tuples.add(t);
            }
            ITuple[] tupsOut = tuples.toArray(new Tuple[0]);
            set = new Set(tupsOut, false);
        }
        return set;
    }
}

