/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.set;

import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.runtree.olap.mdx.functions.CellStreamProcessor;
import com.cognos.xqe.runtree.olap.mdx.functions.ICellStreamResultCalculator;
import com.cognos.xqe.runtree.olap.mdx.functions.IResultCalculatorFactory;
import com.cognos.xqe.runtree.olap.mdx.functions.Utilities;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.CacheableFunction;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.functions.set.CellValueComparatorFactory;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.IOrdinalFilter;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownManager;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.TopBottomCountPushdownUtility;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

public class TopCount
extends CacheableFunction {
    public static final String BOTTOM_COUNT_FUNCTION_NAME = "BottomCount";
    public static final String TOP_COUNT_FUNCTION_NAME = "TopCount";
    private static final String STR_TRUE = "true";
    private static final String STR_FALSE = "false";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Set.class, Set.class}, {Set.class, Integer.class, Tuple.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Set.class;
    }

    @Override
    public String getName() {
        return TOP_COUNT_FUNCTION_NAME;
    }

    @Override
    public Object executeImpl(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        IDataSource dataSource = interpreterContext.getXDataContext().getEnvironment().getDataSource();
        boolean pushdown = false;
        if (dataSource != null) {
            String key = null;
            if (dataSource.isROLAP()) {
                key = "RO";
            } else if (dataSource.isRelational()) {
                key = "DMR";
            }
            if (key != null) {
                IDataSourceCapabilities providerCapabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities(key);
                pushdown = providerCapabilities.isSupported("pushdownTopBottomCountToRelational");
            } else {
                IDataSourceCapabilities capabilities = dataSource.getCapabilities();
                pushdown = capabilities.getStringValue("pushdownTopBottomCountToRelational", STR_FALSE).equalsIgnoreCase(STR_TRUE);
            }
        }
        Block setParamB = (Block)parameterFetcher.getParameter(0);
        setParamB = Caster.cast(setParamB, Set.class, interpreterContext);
        Block countParamB = (Block)parameterFetcher.getParameter(1);
        countParamB.getValues(interpreterContext);
        countParamB = Caster.castToInt(countParamB, interpreterContext);
        if (pushdown) {
            pushdown = TopBottomCountPushdownUtility.configurePushdown(setParamB, countParamB, parameterFetcher, this.getName());
        }
        Block b2 = null;
        boolean prev = interpreterContext.getResultSetConfiguration().setIncrementalContextCells(true);
        b2 = parameterFetcher.getParameterCount() > 2 ? new Block(interpreterContext, setParamB, parameterFetcher, 2, true, true) : new Block(setParamB);
        interpreterContext.getResultSetConfiguration().setIncrementalContextCells(prev);
        Block[] childBlocks = new Block[]{setParamB, countParamB, b2};
        Block retBlock = new Block(interpreterContext, childBlocks);
        if (interpreterContext.inPrimingPhase() && interpreterContext.getPrimingInfo().getPrimingMode() == 1) {
            retBlock.setDefaultValue(new Set(new Tuple[0]));
            if (pushdown) {
                PushdownManager.resetPushdownContext(interpreterContext);
            }
            retBlock.removeInvalidTuples();
            return retBlock;
        }
        IBlockIterator blockIter = Block.getStreamingBlockIterator(childBlocks, 2);
        Comparator<Object> cellComparator = this.getComparator(interpreterContext);
        TopCountCalculatorFactory calculatorFactory = new TopCountCalculatorFactory(cellComparator);
        CellStreamProcessor streamProcessor = new CellStreamProcessor(calculatorFactory);
        streamProcessor.processAllCells(blockIter, retBlock, 0, 2);
        if (pushdown) {
            PushdownManager.resetPushdownContext(interpreterContext);
        }
        if (XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ROLAPPipeline", LogLevel.INFO).isOn(LogLevel.INFO)) {
            String msg = CellStreamProcessor.generateLogMsg(this.getName(), streamProcessor.getResultCalculators(), 1);
            XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ROLAPPipeline", LogLevel.INFO).log(msg);
        }
        retBlock.removeInvalidTuples();
        return retBlock;
    }

    protected boolean useFirstTupleToBreakTieValues() {
        return true;
    }

    private static int calcCountParam(Object[] blockObj) {
        int countParam = 0;
        if (blockObj[1] != null) {
            if (blockObj[1] instanceof Value) {
                Value v = (Value)blockObj[1];
                if (!v.isNull()) {
                    double d = v.getDouble();
                    countParam = d > 2.147483647E9 ? Integer.MAX_VALUE : (d < -2.147483648E9 ? Integer.MIN_VALUE : v.getInteger());
                }
            } else {
                countParam = (Integer)blockObj[1];
            }
        }
        return countParam;
    }

    protected Comparator<Object> getComparator(InterpreterContext interpreterContext) {
        return CellValueComparatorFactory.getComparator(interpreterContext, true);
    }

    private static class TopCountCalculator
    implements ICellStreamResultCalculator {
        private final long setSize;
        private final int numValuesToSave;
        private final Comparator<Object> cellComparator;
        private final TreeSet<Cell> values;
        private IOrdinalFilter ordinals = null;
        private final Cell nullCell;
        private final boolean useLowerOrdinalsFirstForNullCells;
        private long totalCellCount = 0L;
        private int insertedCellCount = 0;
        private int returnedCellCount = 0;

        TopCountCalculator(int numValues, Comparator<Object> comparator, long theSetSize, Cell aNullCell, boolean useLowerOrdinalNullCellsFirst) {
            this.numValuesToSave = numValues;
            this.cellComparator = comparator;
            this.setSize = theSetSize;
            this.values = new TreeSet<Object>(comparator);
            this.ordinals = Utilities.getBestOrdinalFilter(theSetSize);
            this.nullCell = aNullCell;
            this.useLowerOrdinalsFirstForNullCells = useLowerOrdinalNullCellsFirst;
        }

        @Override
        public void processCell(Cell c) {
            ++this.totalCellCount;
            if (this.values.size() < this.numValuesToSave) {
                this.insert(c);
            } else {
                Cell leastDesireableValue = this.values.last();
                if (this.cellComparator.compare(c, leastDesireableValue) < 0) {
                    this.insert(c);
                }
            }
            if (this.ordinals != null) {
                this.ordinals.set(c.getOrdinal(), true);
            }
        }

        private void insert(Cell c) {
            ++this.insertedCellCount;
            this.addCellKeepListMaxSize(c);
            if (this.ordinals != null && this.values.size() == this.numValuesToSave && this.areAllValuesBetterThanNull()) {
                this.ordinals = null;
            }
        }

        private void addCellKeepListMaxSize(Cell c) {
            this.values.add(c);
            if (this.values.size() > this.numValuesToSave) {
                this.values.remove(this.values.last());
            }
        }

        private boolean areAllValuesBetterThanNull() {
            Cell leastDesireableValue = this.values.last();
            return this.cellComparator.compare(this.nullCell, leastDesireableValue) > 0;
        }

        @Override
        public Cell[] getResult() {
            if (this.ordinals != null) {
                List<Cell> nullCells = Utilities.getFirstNulls(this.numValuesToSave, this.useLowerOrdinalsFirstForNullCells, this.setSize, this.ordinals);
                for (Cell aNullCell : nullCells) {
                    this.addCellKeepListMaxSize(aNullCell);
                }
            }
            this.returnedCellCount = this.values.size();
            return this.values.toArray(new Cell[this.values.size()]);
        }

        @Override
        public String getLogMsgText() {
            return CellStreamProcessor.generateLogMsg(this.totalCellCount, this.insertedCellCount, this.returnedCellCount);
        }
    }

    private class TopCountCalculatorFactory
    implements IResultCalculatorFactory {
        private Comparator<Object> cellComparator = null;

        TopCountCalculatorFactory(Comparator<Object> aCellComparator) {
            this.cellComparator = aCellComparator;
        }

        @Override
        public ICellStreamResultCalculator createCalculatorForNewContext(Object[] blockObj, int contextId) {
            Set s = (Set)blockObj[0];
            int countParam = TopCount.calcCountParam(blockObj);
            Cell nullCell = Utilities.createNullCell(0L);
            return new TopCountCalculator(countParam, this.cellComparator, s.size(), nullCell, TopCount.this.useFirstTupleToBreakTieValues());
        }
    }
}

