/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.set;

import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.runtree.olap.mdx.functions.Utilities;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.CacheableFunction;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.functions.set.CellValueComparatorFactory;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullBehavior;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullObject;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownManager;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.TopBottomCountPushdownUtility;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

public class TopPercent
extends CacheableFunction {
    protected static final double ONE_HUNDRED = 100.0;
    public static final String TOP_PERCENT_FUNCTION_NAME = "TopPercent";
    private static final String STR_TRUE = "true";
    private static final String STR_FALSE = "false";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{Set.class, Set.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return Set.class;
    }

    @Override
    public String getName() {
        return TOP_PERCENT_FUNCTION_NAME;
    }

    @Override
    public Object executeImpl(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        IDataSource dataSource = interpreterContext.getXDataContext().getEnvironment().getDataSource();
        boolean pushdown = false;
        boolean filterSet = false;
        if (dataSource != null) {
            IDataSourceCapabilities capabilities = dataSource.getCapabilities();
            pushdown = capabilities.getStringValue("pushdownTopPercentSumToRelational", STR_FALSE).equalsIgnoreCase(STR_TRUE);
            filterSet = capabilities.getStringValue("enableFilterSetInPushDownMode", STR_FALSE).equalsIgnoreCase(STR_TRUE);
        }
        interpreterContext.getContextSet();
        Block setParamB = (Block)parameterFetcher.getParameter(0);
        setParamB = Caster.cast(setParamB, Set.class, interpreterContext);
        Block maxValueParamB = (Block)parameterFetcher.getParameter(1);
        maxValueParamB.getValues(interpreterContext);
        if (pushdown) {
            pushdown = TopBottomCountPushdownUtility.configurePushdown(setParamB, maxValueParamB, parameterFetcher, this.getName());
        }
        Block numExpParamB = null;
        numExpParamB = parameterFetcher.getParameterCount() > 2 ? new Block(interpreterContext, setParamB, parameterFetcher, 2, true, true) : new Block(interpreterContext, setParamB, null, 0, true, true);
        boolean ascending = false;
        if (this.getName().equals("BottomPercent")) {
            ascending = true;
        }
        Block[] childBlocks = new Block[]{setParamB, maxValueParamB, numExpParamB};
        Block retBlock = new Block(interpreterContext, childBlocks);
        IBlockIterator blockIter = Block.getBlockIterator(childBlocks);
        while (blockIter.hasNext()) {
            Serializable v;
            Object[] blockObj = (Object[])blockIter.next();
            Set s = (Set)blockObj[0];
            double maxValue = 0.0;
            if (blockObj[1] != null) {
                if (blockObj[1] instanceof Value) {
                    v = (Value)blockObj[1];
                    if (!((Value)v).isNull()) {
                        maxValue = ((Value)v).getDouble();
                    }
                } else {
                    maxValue = (Double)blockObj[1];
                }
            }
            v = (TreeSet)blockObj[2];
            s = TopBottomCountPushdownUtility.handleNullFiltering(interpreterContext, this.getName(), pushdown, filterSet, s, (TreeSet<Cell>)v);
            Set topSumSet = this.getTopSet(s, ascending, maxValue, (TreeSet<Cell>)v, interpreterContext);
            retBlock.add(blockIter, (Object)topSumSet);
        }
        retBlock.removeInvalidTuples();
        PushdownManager.resetPushdownContext(interpreterContext);
        return retBlock;
    }

    public Set getTopSet(Set s, boolean ascending, double maxPercent, TreeSet<Cell> rs, InterpreterContext interpreterContext) throws InterpreterException {
        Cell c;
        Cell fobj;
        if (s.size() <= 1L) {
            return s;
        }
        if (rs == null) {
            if (!ascending) {
                return (Set)s.head(1L);
            }
            return s.tail(1);
        }
        Set result = null;
        Comparator<Object> cellComparator = CellValueComparatorFactory.getComparator(interpreterContext, true);
        if (ascending) {
            cellComparator = Collections.reverseOrder(cellComparator);
        }
        if ((fobj = rs.first()).getObjectValue() instanceof NullObject) {
            if (!ascending) {
                return (Set)s.head(1L);
            }
            return s.tail(1);
        }
        List<Object> cellsToSort = new ArrayList<Cell>(rs.size());
        double grandTotal = 0.0;
        ArrayList<Cell> allZeroCells = new ArrayList<Cell>();
        Cell largestNegativeCell = null;
        boolean havePostiveCell = false;
        for (Cell cell : rs) {
            if (!cell.isError()) {
                double cellValue = cell.getNumericValue();
                grandTotal += cellValue;
                if (cellValue > 0.0) {
                    havePostiveCell = true;
                    cellsToSort.add(cell);
                    continue;
                }
                if (havePostiveCell) continue;
                if (cellValue == 0.0) {
                    allZeroCells.add(cell);
                    continue;
                }
                if (largestNegativeCell != null && cellComparator.compare(largestNegativeCell, cell) <= 0) continue;
                largestNegativeCell = cell;
                continue;
            }
            if (havePostiveCell && !ascending) continue;
            allZeroCells.add(cell);
        }
        if (!havePostiveCell || ascending) {
            List<Cell> nullCells = Utilities.getFirstNulls(Integer.MAX_VALUE, true, s.size(), rs);
            cellsToSort.addAll(nullCells);
            cellsToSort.addAll(allZeroCells);
            if (largestNegativeCell != null) {
                cellsToSort.add(largestNegativeCell);
            }
        }
        Collections.sort(cellsToSort, cellComparator);
        double totalSoFar = 0.0;
        double maxValue = grandTotal * maxPercent / 100.0;
        int stopIndex = 0;
        for (stopIndex = 0; stopIndex < cellsToSort.size() && ((c = (Cell)cellsToSort.get(stopIndex)).isError() || !((totalSoFar += c.getNumericValue()) >= maxValue) || totalSoFar == 0.0); ++stopIndex) {
        }
        if (stopIndex == cellsToSort.size()) {
            --stopIndex;
        }
        for (int i = cellsToSort.size() - 1; i > stopIndex; --i) {
            cellsToSort.remove(i);
        }
        if (havePostiveCell) {
            if (!ascending && NullBehavior.NULL_FIRST.equals((Object)Utilities.getNullBehavior(interpreterContext))) {
                List<Cell> nullCells = Utilities.getFirstNulls(Integer.MAX_VALUE, true, s.size(), rs);
                nullCells.addAll(cellsToSort);
                cellsToSort = nullCells;
            } else if (totalSoFar < maxValue) {
                cellsToSort.clear();
                cellsToSort.addAll(rs);
                List<Cell> nullCells = Utilities.getFirstNulls(Integer.MAX_VALUE, true, s.size(), rs);
                cellsToSort.addAll(nullCells);
                Collections.sort(cellsToSort, cellComparator);
            }
        }
        Cell[] resultCells = cellsToSort.toArray(new Cell[cellsToSort.size()]);
        result = Utilities.createSortedSet(s, resultCells);
        return result;
    }
}

