/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.string;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.DecimalValue;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.FloatValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.TimeValue;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class Properties
implements Function {
    private static final String PROPERTIES_FUNCTION_NAME = "Properties";

    @Override
    public Class<?> getSubjectType() {
        return String.class;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{String.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return String.class;
    }

    @Override
    public String getName() {
        return PROPERTIES_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block subjectBlock = (Block)subject;
        subjectBlock = Caster.cast(subjectBlock, IMember.class, interpreterContext, this.getName());
        Block propertyNameParamB = (Block)parameterFetcher.getParameter(0);
        Block[] childBlocks = new Block[]{subjectBlock, propertyNameParamB};
        Block retBlock = new Block(interpreterContext, childBlocks);
        BlockIterator blockIter = new BlockIterator(childBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            IMember m = (IMember)blockObj[0];
            String propertyName = blockObj[1] instanceof Value ? ((Value)blockObj[1]).getString() : (String)blockObj[1];
            Object value = this.getMemberProperty(m, propertyName, interpreterContext);
            retBlock.add(blockIter, value);
        }
        return retBlock;
    }

    private Object getMemberProperty(IMember member, String propName, InterpreterContext interpreterContext) {
        if (member instanceof NullMember) {
            return null;
        }
        if (MemberOperations.applySecurityToMember(member, interpreterContext) == null) {
            return null;
        }
        Object propValue = member.getProperty(propName);
        if (propValue != null) {
            if (propValue instanceof String) {
                StringValue v = DataValueFactory.createStringValue();
                ((Value)v).set((String)propValue);
                propValue = v;
            } else if (propValue instanceof Double) {
                DoubleValue v = DataValueFactory.createDoubleValue();
                ((Value)v).set((Double)propValue);
                v.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
                propValue = v;
            } else if (propValue instanceof Integer) {
                IntegerValue v = DataValueFactory.createIntegerValue();
                ((Value)v).set((Integer)propValue);
                v.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
                propValue = v;
            } else if (propValue instanceof BigDecimal) {
                DecimalValue v = DataValueFactory.createDecimalValue();
                ((Value)v).set((BigDecimal)propValue);
                v.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
                propValue = v;
            } else if (propValue instanceof Float) {
                FloatValue v = DataValueFactory.createFloatValue();
                ((Value)v).set((Float)propValue);
                v.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
                propValue = v;
            } else if (propValue instanceof Timestamp) {
                TimestampValue v = DataValueFactory.createTimestampValue();
                ((Value)v).set((Timestamp)propValue);
                v.setFormatId(FormatId.DATETIME_FORMAT_FID);
                propValue = v;
            } else if (propValue instanceof Time) {
                TimeValue v = DataValueFactory.createTimeValue();
                ((Value)v).set((Time)propValue);
                v.setFormatId(FormatId.TIME_FORMAT_FID);
                propValue = v;
            } else if (propValue instanceof Date) {
                DateValue v = DataValueFactory.createDateValue();
                ((Value)v).set((Date)propValue);
                v.setFormatId(FormatId.DATE_FORMAT_FID);
                propValue = v;
            }
            return propValue;
        }
        Level memberLevel = (Level)member.getLevel();
        if (memberLevel.isAllLevel()) {
            return null;
        }
        if (!memberLevel.isValidPropertyName(propName)) {
            return TextValue.ERROR_VALUE;
        }
        return null;
    }
}

