/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.string;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.mdx.parser.MDXParser;
import com.cognos.xqe.ast.mdx.parser.MDXParserVisitorBase;
import com.cognos.xqe.ast.mdx.parser.Node;
import com.cognos.xqe.ast.mdx.parser.ParseException;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.TransformationEngine;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.mdx.data.values.CubicsValue;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSet;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Writer;
import java.rmi.server.UID;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class StrToValue
implements Function {
    private static final String STRTOVALUE_FUNCTION_NAME = "StrToValue";
    private static final String UTF_8_STR = "UTF-8";
    private static final String CONSTRAINED_STR = "CONSTRAINED";
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{String.class, String.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return 2;
    }

    @Override
    public String getName() {
        return STRTOVALUE_FUNCTION_NAME;
    }

    @Override
    public Class<?> getReturnType() {
        return ResultSet.class;
    }

    @Override
    public Class<?> getSubjectType() {
        return String.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        if (parameterFetcher.getParameterCount() > 2) {
            throw new InterpreterException("X01517", new String[]{"1, 2", this.getName()});
        }
        boolean constrained = false;
        if (parameterFetcher.getParameterCount() == 2) {
            Block b2 = (Block)parameterFetcher.getParameter(1);
            Object parameter2 = b2.first();
            if (parameter2 instanceof String && parameter2.toString().equalsIgnoreCase(CONSTRAINED_STR)) {
                constrained = true;
            } else {
                if (!(parameter2 instanceof Value)) throw new InterpreterException("X01490", new String[]{parameter2.toString(), this.getName(), CONSTRAINED_STR});
                Value v = (Value)parameter2;
                if (v.isNull()) throw new InterpreterException("X01490", new String[]{parameter2.toString(), this.getName(), CONSTRAINED_STR});
                String param2String = v.getString();
                if (!param2String.equalsIgnoreCase(CONSTRAINED_STR)) throw new InterpreterException("X01490", new String[]{parameter2.toString(), this.getName(), CONSTRAINED_STR});
                constrained = true;
            }
        }
        Block b1 = (Block)parameterFetcher.getParameter(0);
        String expression = null;
        Object b1Obj = b1.first();
        if (b1Obj instanceof Value) {
            Value v = (Value)b1Obj;
            if (v.isNull()) throw new InterpreterException("X01490", new String[]{"(null)", this.getName(), "CMP_TYPESTRING"});
            expression = v.getString();
        } else {
            expression = (String)b1.first();
        }
        if (expression.startsWith("'")) {
            expression = expression.substring(1, expression.length() - 1);
        }
        RequestEnvironment reqEnv = (RequestEnvironment)parameterFetcher.getInterpreterContext().getXDataContext().getEnvironment().getRequestEnvironment();
        XMdxLocal xNode = this.generateRuntree(expression, reqEnv);
        InterpreterContext ic = parameterFetcher.getInterpreterContext();
        XDataContext dataContext = ic.getXDataContext();
        Block result = (Block)((CubicsValue)xNode.execute(dataContext)).getCubicsObject();
        if (!constrained) return result;
        return this.constrainResult(expression, result, parameterFetcher.getInterpreterContext());
    }

    protected Block constrainResult(String expression, Block result, InterpreterContext interpreterContext) throws InterpreterException {
        Block[] childBlocks = new Block[]{result};
        Block retBlock = new Block(interpreterContext, childBlocks);
        Object cellValue = result.getDefaultValue();
        if (cellValue instanceof String) {
            try {
                retBlock.setDefaultValue(Double.valueOf((String)cellValue));
            }
            catch (NumberFormatException e) {
                mErrorLogger.log(e);
                retBlock.setDefaultValue(TextValue.ERROR_VALUE);
            }
        } else if (cellValue instanceof Value) {
            try {
                DoubleValue v = DataValueFactory.createDoubleValue();
                v.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
                v.set(((Value)cellValue).getDouble());
                retBlock.setDefaultValue(v);
            }
            catch (Exception e) {
                mErrorLogger.log(e);
                retBlock.setDefaultValue(TextValue.ERROR_VALUE);
            }
        } else if (!(cellValue instanceof Double) && !(cellValue instanceof Integer)) {
            retBlock.setDefaultValue(TextValue.ERROR_VALUE);
        }
        BlockIterator blockIter = new BlockIterator(childBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            cellValue = blockObj[0];
            if (cellValue instanceof String) {
                try {
                    retBlock.add(blockIter, (Object)Double.valueOf((String)cellValue));
                }
                catch (NumberFormatException e) {
                    mErrorLogger.log(e);
                    retBlock.add(blockIter, (Object)TextValue.ERROR_VALUE);
                }
                continue;
            }
            if (cellValue instanceof Value) {
                try {
                    DoubleValue v = DataValueFactory.createDoubleValue();
                    v.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
                    v.set(((Value)cellValue).getDouble());
                    retBlock.add(blockIter, (Object)v);
                }
                catch (Exception e) {
                    mErrorLogger.log(e);
                    retBlock.add(blockIter, (Object)TextValue.ERROR_VALUE);
                }
                continue;
            }
            if (cellValue instanceof Double || cellValue instanceof Integer) continue;
            retBlock.add(blockIter, (Object)TextValue.ERROR_VALUE);
        }
        return retBlock;
    }

    protected PlanningEnvironment prepareEnvironment(RequestEnvironment reqEnv) {
        Element commandElement = DocumentHelper.createElement((String)"prepare");
        Element requestIDElement = commandElement.addElement("requestID");
        String requestID = new UID().toString();
        requestIDElement.addAttribute("value", requestID);
        reqEnv.extractParametersFromCommand(commandElement);
        PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(reqEnv);
        return planEnv;
    }

    protected XMdxLocal generateRuntree(String mdxExpression, RequestEnvironment reqEnv) {
        ByteArrayInputStream inputStream;
        PlanningEnvironment planEnv = this.prepareEnvironment(reqEnv);
        Writer logWriter = planEnv.getCurrentTraceWriter();
        XQENodeFactory nodeFactory = planEnv.getNodeFactory();
        XMdxLocal xNode = (XMdxLocal)nodeFactory.createNode(501053);
        xNode.addToIndex();
        try {
            inputStream = new ByteArrayInputStream(mdxExpression.getBytes(UTF_8_STR));
        }
        catch (IOException e) {
            throw new MetadataException("X01499", new String[]{e.toString()}, e);
        }
        MDXParser parser = new MDXParser(inputStream, UTF_8_STR);
        parser.setNodeFactory(planEnv.getNodeFactory());
        try {
            ParseException e = parser.ValueExpression();
            if (e != null) {
                throw e;
            }
            MDXParserVisitor v = new MDXParserVisitor(parser);
            Node child = v.getBaseRootNode();
            xNode.addChild((IXQEQueryNode)((Object)child));
            TransformationEngine.getInstance().applyTransformations(xNode, planEnv);
        }
        catch (ParseException e) {
            throw new MetadataException("X01499", new String[]{e.toString()}, e);
        }
        catch (Throwable e) {
            throw new XQERuntimeException(XQEMessageKeys.MDX_ExecutionFailed, e);
        }
        finally {
            if (logWriter != null) {
                try {
                    logWriter.close();
                }
                catch (IOException e) {
                    mErrorLogger.log(e);
                }
            }
        }
        return xNode;
    }

    protected static class MDXParserVisitor
    extends MDXParserVisitorBase {
        public MDXParserVisitor(MDXParser p) {
            super(p);
        }

        public Node getBaseRootNode() {
            return this.getRootNode();
        }
    }
}

