/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.functions.vb;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.Function;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullObject;

public class LCase
implements Function {
    private static final String LCASE_FUNCTION_NAME = "LCase";

    @Override
    public Class<?> getSubjectType() {
        return null;
    }

    @Override
    public Class<?>[][] getArguments() {
        return new Class[][]{{String.class}};
    }

    @Override
    public int getMaxNumberOfArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?> getReturnType() {
        return String.class;
    }

    @Override
    public String getName() {
        return LCASE_FUNCTION_NAME;
    }

    @Override
    public Object execute(Object subject, ParameterFetcher parameterFetcher) throws InterpreterException {
        if (parameterFetcher.getParameterCount() > 1) {
            throw new InterpreterException("X01517", new String[]{"1", this.getName()});
        }
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        Block b1 = (Block)parameterFetcher.getParameter(0);
        b1.getValues(interpreterContext);
        Block[] wrkBlocks = new Block[]{b1};
        Block block = new Block(interpreterContext, wrkBlocks);
        BlockIterator blockIter = new BlockIterator(wrkBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Object lCaseStr = this.lCase(blockObj[0]);
            block.add(blockIter, lCaseStr);
        }
        return block;
    }

    private Object lCase(Object strParam) throws InterpreterException {
        String str = null;
        if (strParam instanceof String) {
            str = (String)strParam;
        } else if (strParam instanceof Double) {
            str = String.valueOf((Double)strParam);
            String[] doubleParts = str.split("\\.");
            int decimalPart = Integer.parseInt(doubleParts[1]);
            if (decimalPart == 0) {
                str = doubleParts[0];
            }
        } else if (strParam instanceof Value) {
            Value v = (Value)strParam;
            if (v.isNull() || v.isError()) {
                return strParam;
            }
            str = v.getString();
        } else {
            if (strParam == NullObject.instance()) {
                return strParam;
            }
            if (strParam != null) {
                throw new InterpreterException("X01490", new String[]{strParam.getClass().toString(), this.getName(), "String"});
            }
        }
        if (str != null) {
            str = str.toLowerCase();
        }
        StringValue strValue = DataValueFactory.createStringValue();
        strValue.set(str);
        return strValue;
    }
}

