/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BCell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSetIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IStatementResult;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ITupleValueIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSetGenericDelegate;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSetMetadata;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSetPropertyMap;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleOrdinalCalculationCache;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.util.NumberOp;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.pool.XQELongPool;
import com.cognos.xqe.util.pool.XQESoftLongPool;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractResultSet
implements IResultSet,
IStatementResult {
    private static final String ERROR_ADDING_CELL_TO_RESULTSET = "Error adding cell to ResultSet. Ordinal too large : ";
    private static final String THIS_QUERY_SET_HAS = "  This querySet has ";
    private static final String THIS_QUERY_SET_HAS_A_SIZE_OF = " This querySet has a size of ";
    private static final String WHILE_THE_ONE_BEING_ADDED_HAS_A_SIZE_OF = " while the one being added has a size of ";
    private static final String NEED_SAME_STRUCTURE_ERROR_MSG = "ResultSets can only be added if the underlying querySets have the same structure.  ";
    protected ResultSetMetadata metadata;
    protected ResultSetPropertyMap propertyMap;
    protected boolean resultSetDelegateMode = false;
    protected ResultSetGenericDelegate genericDelegate = null;
    protected final CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();

    @Override
    public boolean getResultSetDelegateMode() {
        return this.resultSetDelegateMode;
    }

    public abstract void delegate(boolean[] var1);

    public abstract void undelegate() throws InterpreterException;

    public abstract void resetQuerySet();

    @Override
    public boolean isPipelining() {
        return false;
    }

    @Override
    public boolean supportsParallelAccess() {
        return false;
    }

    @Override
    public boolean isDDLResult() {
        return false;
    }

    @Override
    public boolean isDrillThroughResultSet() {
        return false;
    }

    @Override
    public boolean isMDResultSet() {
        return true;
    }

    public AbstractResultSet() {
        this.metadata = null;
        this.propertyMap = new ResultSetPropertyMap();
    }

    public AbstractResultSet(InterpreterContext interpreterContext) {
        CrossJoinedSet currentContextSet = interpreterContext.getContextSet();
        ISet rsAxes = currentContextSet.getMultipleTupleSets();
        ISet[] axes = null;
        axes = !rsAxes.isEmpty() ? new ISet[]{rsAxes} : new Set[]{};
        ISet slicer = ((Set)currentContextSet).getSingleTupleSet();
        this.metadata = new ResultSetMetadata(axes, slicer);
        this.propertyMap = new ResultSetPropertyMap();
    }

    public AbstractResultSet(ISet[] a, ISet s) {
        this.metadata = new ResultSetMetadata(a, s);
        this.propertyMap = new ResultSetPropertyMap();
    }

    public AbstractResultSet(CrossJoinedSet qs) {
        this.metadata = new ResultSetMetadata(qs);
        this.propertyMap = new ResultSetPropertyMap();
    }

    public AbstractResultSet(AbstractResultSet rs) {
        this.metadata = rs.metadata;
        this.propertyMap = rs.propertyMap;
    }

    @Override
    public ResultSetMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public CrossJoinedSet getQuerySet() {
        return this.metadata.getQuerySet();
    }

    @Override
    public int getNumberOfAxes() {
        return this.getMetadata().getAxes().length;
    }

    @Override
    public ISet getAxis(int index) {
        return this.getMetadata().getAxes()[index];
    }

    @Override
    public ISet[] getAxes() {
        return this.getMetadata().getAxes();
    }

    @Override
    public ISet getSlicer() {
        return this.getMetadata().getSlicer();
    }

    @Override
    public long size() {
        return this.metadata.size();
    }

    @Override
    public BigInteger noOverflowSize() {
        return this.metadata.noOverflowSize();
    }

    @Override
    public final ITupleValueIterator tupleValueIterator() {
        if (this.getDefaultValue() == null || this.size() == (long)this.getCellMap().size()) {
            return new TupleValueIterator();
        }
        return new DefaultTupleValueIterator();
    }

    @Override
    public final ITupleValueIterator tupleValueIterator(IHierarchy[] hierarchyOrder) throws InterpreterException {
        if (this.getDefaultValue() == null || this.size() == (long)this.getCellMap().size()) {
            return new TupleValueIterator(hierarchyOrder);
        }
        return new DefaultTupleValueIterator(hierarchyOrder);
    }

    @Override
    public CrossJoinedSet getAxisCrossJoinedSet() throws InterpreterException {
        return this.metadata.getAxisCrossJoinedSet();
    }

    @Override
    public void setSlicerEmpty() {
        this.metadata.setSlicerEmpty();
    }

    @Override
    public void setPropertiesOnAxes(ArrayList<IProperty>[] axisToProps) {
        this.propertyMap.put("axisToProperties", (Object)axisToProps);
    }

    @Override
    public void addLocalScopedCalculatedMembers(Map<String, CalculatedMember> calcMemberList) {
        for (Map.Entry<String, CalculatedMember> entry : calcMemberList.entrySet()) {
            CalculatedMember cm = entry.getValue();
            if (cm.getType() != MemberTypeEnum.QUERY_CALCULATION) continue;
            this.getCalcMembers().put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void addTagTupleOrdinal(Tuple tagTuple) {
        long[] setSizes = this.getQuerySet().getSetSizesInReverseOrder();
        List<long[]> tupleOrdinals = this.getQuerySet().getTupleOrdinals(tagTuple, null, null);
        for (int i = 0; i < tupleOrdinals.size(); ++i) {
            long[] aTupleOrdinal = tupleOrdinals.get(i);
            long[] aResultSetTupleOrdinal = this.metadata.convertCrossJoinedSetTupleOrdinalToResultSetTupleOrdinal(aTupleOrdinal, setSizes);
            this.getTagTupleOrdinalsList().add(aResultSetTupleOrdinal);
        }
    }

    public void addTagTupleOrdinal(int edgeId, List<Number> tagTupleOrdinals) {
        long[] tagOrdinals = new long[tagTupleOrdinals.size()];
        for (int i = 0; i < tagTupleOrdinals.size(); ++i) {
            tagOrdinals[i] = tagTupleOrdinals.get(i).longValue();
        }
        List<long[]> tagTupleOrdinalsList = this.getTagTupleOrdinalsList();
        if (tagTupleOrdinalsList.isEmpty()) {
            for (int i = 0; i < this.getNumberOfAxes(); ++i) {
                tagTupleOrdinalsList.add(i, new long[0]);
            }
        } else {
            long[] existingOrdinals = tagTupleOrdinalsList.get(edgeId);
            long[] mergedOrdinals = new long[existingOrdinals.length + tagOrdinals.length];
            System.arraycopy(existingOrdinals, 0, mergedOrdinals, 0, existingOrdinals.length);
            System.arraycopy(tagOrdinals, 0, mergedOrdinals, existingOrdinals.length, tagOrdinals.length);
            tagOrdinals = mergedOrdinals;
        }
        tagTupleOrdinalsList.set(edgeId, tagOrdinals);
    }

    @Override
    public IMember getCalculatedMemberResult() {
        return (IMember)this.propertyMap.get("calculatedMemberResult");
    }

    @Override
    public void setCalculatedMemberResult(IMember member) {
        this.propertyMap.put("calculatedMemberResult", (Object)member);
    }

    @Override
    public ArrayList<String> getCellProperties() {
        return (ArrayList)this.propertyMap.get("cellProperties");
    }

    @Override
    public Object getDefaultValue() {
        return this.propertyMap.get("defaultValue");
    }

    @Override
    public void setDefaultValue(Object val) {
        this.propertyMap.put("defaultValue", val);
    }

    @Override
    public Map<String, CalculatedMember> getCalcMembers() {
        return (Map)this.propertyMap.get("calcedMembers");
    }

    @Override
    public void setCalcMembers(Map<String, CalculatedMember> calcMembers) {
        this.propertyMap.put("calcedMembers", (Object)calcMembers);
    }

    @Override
    public List<long[]> getTagTupleOrdinalsList() {
        return (List)this.propertyMap.get("tagTupleOrdinals");
    }

    @Override
    public Tuple getTupleByCellOrdinal(long cellOrdinal) {
        return this.metadata.getTupleByCellOrdinal(cellOrdinal);
    }

    @Override
    public Tuple getTupleByCellOrdinal(BigInteger cellOrdinal) {
        return this.metadata.getTupleByCellOrdinal(cellOrdinal);
    }

    @Override
    public List<long[]> getTupleOrdinals(ITuple tuple, TupleOrdinalCalculationCache cache, List<long[]> result) {
        return this.metadata.getQuerySet().getTupleOrdinals(tuple, cache, result);
    }

    @Override
    public void setCellProperties(ArrayList<String> cellProps) {
        this.propertyMap.put("cellProperties", (Object)cellProps);
    }

    @Override
    public boolean isTupleValueVisible(Number cellOrdinal) {
        return true;
    }

    @Override
    public boolean isTupleValueVisible(ITuple tuple) {
        return true;
    }

    @Override
    public void captureSecuredOrdinal(Number cellOrdinal) {
    }

    @Override
    public boolean isSecuredOrdinal(Number ordinal) {
        return false;
    }

    protected void validateSameMetadataStructure(IResultSet other) throws UnsupportedOperationException {
        IHierarchy[] otherHiers;
        if (this.metadata == null && other.getMetadata() == null) {
            return;
        }
        CrossJoinedSet myCJS = this.getMetadata().getQuerySet();
        CrossJoinedSet otherCJS = other.getMetadata().getQuerySet();
        IHierarchy[] myHiers = myCJS.getHierarchies();
        if (myHiers.length != (otherHiers = otherCJS.getHierarchies()).length) {
            throw new UnsupportedOperationException("ResultSets can only be added if the underlying querySets have the same structure.    This querySet has " + myHiers.length + " hierarchies while the one being added has " + otherHiers.length);
        }
        for (int i = 0; i < myHiers.length; ++i) {
            if (myHiers[i] == otherHiers[i]) continue;
            throw new UnsupportedOperationException("ResultSets can only be added if the underlying querySets have the same structure.    This querySet has " + myHiers[i].getUniqueName() + " in position " + i + " while the one being added has " + otherHiers[i].getUniqueName());
        }
        long mySize = myCJS.size();
        long otherSize = otherCJS.size();
        if (mySize < 0L || otherSize < 0L || otherSize != mySize) {
            BigInteger otherBigSize;
            if (mySize != otherSize && mySize > 0L && otherSize > 0L) {
                throw new UnsupportedOperationException("ResultSets can only be added if the underlying querySets have the same structure.   This querySet has a size of " + myCJS.size() + WHILE_THE_ONE_BEING_ADDED_HAS_A_SIZE_OF + otherCJS.size());
            }
            BigInteger myBigSize = myCJS.noOverflowSize();
            if (myBigSize.compareTo(otherBigSize = myCJS.noOverflowSize()) != 0) {
                throw new UnsupportedOperationException("ResultSets can only be added if the underlying querySets have the same structure.   This querySet has a size of " + myBigSize + WHILE_THE_ONE_BEING_ADDED_HAS_A_SIZE_OF + otherBigSize);
            }
        }
    }

    @Override
    public void addCurrentMemberDimensions(IDimension[] ds) {
        HashSet<IDimension> currentMemberDimensions = (HashSet<IDimension>)this.propertyMap.get("currentMemberDimensions");
        if (ds.length > 0) {
            if (currentMemberDimensions == null) {
                currentMemberDimensions = new HashSet<IDimension>();
                this.propertyMap.put("currentMemberDimensions", (Object)currentMemberDimensions);
            }
            currentMemberDimensions.addAll(Arrays.asList(ds));
        }
    }

    protected void addCellHelper(ITuple tuple, Cell c, TupleOrdinalCalculationCache cache) {
        boolean isCalc = ((Tuple)tuple).containsCalculation();
        long querySize = this.getQuerySet().size();
        if (querySize < 0L) {
            this.addCell(tuple, c, isCalc);
        } else {
            List<long[]> tupleOrdinals = this.getQuerySet().getTupleOrdinals(tuple, cache, null);
            this.addCell(tupleOrdinals, c, isCalc, true);
        }
    }

    @Override
    public void addCell(List<long[]> tupleOrdinals, Cell c, boolean isCalc, boolean alwaysDupCell) {
        long[] setSizes = this.getQuerySet().getSetSizesInReverseOrder();
        long theSize = this.size();
        for (int i = 0; i < tupleOrdinals.size(); ++i) {
            long[] aTupleOrdinal = tupleOrdinals.get(i);
            long aCellOrdinal = ResultSetMetadata.computeCellOrdinal(aTupleOrdinal, setSizes);
            if (aCellOrdinal >= 0L && (aCellOrdinal < theSize || theSize < 0L)) {
                Cell cell = alwaysDupCell || i > 0 ? new Cell(c) : c;
                cell.setOrdinal(aCellOrdinal);
                cell.setIsCalculation(isCalc);
                this.addCell(cell);
                continue;
            }
            if (aCellOrdinal < 0L) {
                Number[] numberTupleOrdinal = new Number[aTupleOrdinal.length];
                Number[] numberSetSizes = this.getQuerySet().getSetSizesInReverseOrder(true);
                for (int j = 0; j < aTupleOrdinal.length; ++j) {
                    numberTupleOrdinal[j] = XQESoftLongPool.getLong(aTupleOrdinal[j]);
                }
                Number numberCellOrdinal = ResultSetMetadata.computeCellOrdinal(numberTupleOrdinal, numberSetSizes);
                BCell bCell = new BCell(c, (BigInteger)numberCellOrdinal);
                bCell.setIsCalculation(isCalc);
                this.addCell(bCell);
                continue;
            }
            throw new IllegalArgumentException("Error: A tupleOrdinal generated an ordinal greater than the set size");
        }
    }

    @Override
    public void addCell(ITuple tuple, Cell c, boolean isCalc) {
        List<Number[]> tupleOrdinals = this.getQuerySet().getTupleOrdinals(tuple, true);
        Number[] setSizes = this.getQuerySet().getSetSizesInReverseOrder(true);
        for (int i = 0; i < tupleOrdinals.size(); ++i) {
            Number[] aTupleOrdinal = tupleOrdinals.get(i);
            this.metadata.convertCrossJoinedSetTupleOrdinalToResultSetTupleOrdinal(aTupleOrdinal, setSizes);
            Number bOrdinal = ResultSetMetadata.computeCellOrdinal(aTupleOrdinal, setSizes);
            Cell cell = null;
            if (bOrdinal instanceof BigInteger) {
                cell = new BCell(c, (BigInteger)bOrdinal);
                cell.setIsCalculation(isCalc);
                this.addCell(cell);
                continue;
            }
            cell = new Cell(c);
            cell.setOrdinal((Long)bOrdinal);
            cell.setIsCalculation(isCalc);
            this.addCell(cell);
        }
    }

    @Override
    public void addCell(ITuple tuple, Cell c, TupleOrdinalCalculationCache cache) {
        if (this.resultSetDelegateMode) {
            this.genericDelegate.addTupleValue(tuple, c);
        } else {
            this.addCellHelper(tuple, c, cache);
        }
    }

    public abstract void putCell(Number var1, Cell var2);

    public abstract void setCachedCell(long var1, Cell var3);

    @Override
    public void addCell(Cell c) {
        BigInteger bigOrdinal;
        long longOrdinal = c.getOrdinal();
        if (this.size() >= 0L && longOrdinal >= this.size() && (bigOrdinal = c.getBigOrdinal()) != null && bigOrdinal.compareTo(this.noOverflowSize()) >= 0) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, ERROR_ADDING_CELL_TO_RESULTSET + c.getOrdinal());
        }
        if (longOrdinal == -123L) {
            BigInteger bigCellOrdinal = c.getBigOrdinal();
            if (!this.isSecuredOrdinal(bigCellOrdinal)) {
                this.captureSecuredOrdinal(bigCellOrdinal);
                this.putCell(bigCellOrdinal, c);
            }
        } else if (this.isSecurityEnabled()) {
            Long tempLongCellOrdinal = XQESoftLongPool.getLong(longOrdinal);
            if (!this.isSecuredOrdinal(tempLongCellOrdinal)) {
                this.captureSecuredOrdinal(tempLongCellOrdinal);
                this.putCell(tempLongCellOrdinal, c);
                this.setCachedCell(longOrdinal, c);
            }
        } else {
            this.putCell(null, c);
            this.setCachedCell(longOrdinal, c);
        }
    }

    public void addCellIntoNonEmptyResultSet(Cell c, Number nonEmptyCellOrdinal) {
        long longSize = this.size();
        Number numSize = longSize < 0L ? this.noOverflowSize() : XQELongPool.getLong(longSize);
        if (NumberOp.compare(nonEmptyCellOrdinal, numSize) >= 0) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, ERROR_ADDING_CELL_TO_RESULTSET + nonEmptyCellOrdinal);
        }
        if (nonEmptyCellOrdinal instanceof BigInteger) {
            c.setBigOrdinal((BigInteger)nonEmptyCellOrdinal);
            this.putCell(nonEmptyCellOrdinal, c);
        } else {
            c.setOrdinal((Long)nonEmptyCellOrdinal);
            this.putCell(nonEmptyCellOrdinal, c);
            this.setCachedCell(c.getOrdinal(), c);
        }
    }

    @Override
    public boolean isSecurityEnabled() {
        return false;
    }

    protected final class TupleValueIterator
    implements ITupleValueIterator {
        private IHierarchy[] hierarchyOrder;
        private HashMap<IHierarchy, Integer> hierarchyToIndex;
        private final CrossJoinedSet crossJoinedSet;
        private final IResultSetIterator cellSetIterator;

        private TupleValueIterator() {
            CrossJoinedSet tmp = null;
            try {
                tmp = AbstractResultSet.this.getAxisCrossJoinedSet();
            }
            catch (InterpreterException interpreterException) {
                // empty catch block
            }
            this.crossJoinedSet = tmp;
            this.cellSetIterator = AbstractResultSet.this.iterator();
        }

        private TupleValueIterator(IHierarchy[] hierOrder) throws InterpreterException {
            this();
            this.hierarchyOrder = hierOrder;
            this.hierarchyToIndex = new HashMap();
            for (int i = 0; i < hierOrder.length; ++i) {
                IHierarchy h = hierOrder[i];
                if (this.crossJoinedSet.multipleHierarchySupport()) {
                    if (!this.crossJoinedSet.contains(h)) continue;
                    this.hierarchyToIndex.put(h, new Integer(((Hierarchy)h).getOrdinal()));
                    continue;
                }
                if (!this.crossJoinedSet.contains(h.getDimension())) continue;
                this.hierarchyToIndex.put(h, new Integer(h.getDimension().getIndex()));
            }
        }

        @Override
        public boolean hasNext() {
            return this.cellSetIterator.hasNext();
        }

        @Override
        public TupleValue next() {
            if (AbstractResultSet.this.cancelManager != null && AbstractResultSet.this.cancelManager.isRequestCancelled()) {
                throw new OperationCanceledException();
            }
            Cell c = (Cell)this.cellSetIterator.next();
            ITuple t = this.getTupleForCellOrdinal(c);
            TupleValue result = new TupleValue(t, c);
            return result;
        }

        private ITuple getTupleForCellOrdinal(Cell c) {
            long ord = c.getOrdinal();
            ITuple t = null;
            t = ord == -123L ? this.crossJoinedSet.getTuple(c.getBigOrdinal()) : this.crossJoinedSet.getTuple(ord);
            if (this.hierarchyToIndex != null) {
                ArrayList<IMember> al = new ArrayList<IMember>();
                for (int i = 0; i < this.hierarchyOrder.length; ++i) {
                    Integer index = this.hierarchyToIndex.get(this.hierarchyOrder[i]);
                    if (index == null) continue;
                    IMember m = t.getMember(index);
                    al.add(m);
                }
                t = new Tuple(al.toArray(new IMember[al.size()]), false);
            }
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object peek() {
            Cell c = (Cell)this.cellSetIterator.peek();
            ITuple t = this.getTupleForCellOrdinal(c);
            TupleValue result = new TupleValue(t, c);
            return result;
        }
    }

    protected final class DefaultTupleValueIterator
    implements ITupleValueIterator {
        private IHierarchy[] hierarchyOrder;
        private HashMap<IHierarchy, Integer> hierarchyToIndex;
        private final CrossJoinedSet crossJoinedSet;
        private final Iterator<ICell> cellSetIterator;
        private long counter = 0L;
        private TupleValue peekedValue;
        private final long size;
        private Cell currentCell;

        private DefaultTupleValueIterator() {
            CrossJoinedSet tmp = null;
            try {
                tmp = AbstractResultSet.this.getAxisCrossJoinedSet();
            }
            catch (InterpreterException interpreterException) {
                // empty catch block
            }
            this.crossJoinedSet = tmp;
            this.size = this.crossJoinedSet.size();
            if (this.size < 0L) {
                throw new UnsupportedOperationException("The set is too big for a DefaultTupleValueIterator.");
            }
            this.cellSetIterator = AbstractResultSet.this.iterator();
            if (this.cellSetIterator.hasNext()) {
                this.currentCell = (Cell)this.cellSetIterator.next();
            }
        }

        private DefaultTupleValueIterator(IHierarchy[] hierOrder) throws InterpreterException {
            this();
            this.hierarchyOrder = hierOrder;
            this.hierarchyToIndex = new HashMap();
            for (int i = 0; i < hierOrder.length; ++i) {
                IHierarchy h = hierOrder[i];
                if (!this.crossJoinedSet.contains(h)) continue;
                this.hierarchyToIndex.put(h, new Integer(this.crossJoinedSet.getHierarchyIndex(h)));
            }
        }

        @Override
        public boolean hasNext() {
            return this.counter < this.size || this.peekedValue != null;
        }

        @Override
        public TupleValue next() {
            if (AbstractResultSet.this.cancelManager != null && AbstractResultSet.this.cancelManager.isRequestCancelled()) {
                throw new OperationCanceledException();
            }
            if (this.peekedValue != null) {
                TupleValue tmp = this.peekedValue;
                this.peekedValue = null;
                return tmp;
            }
            Cell cell = this.getCellForCurrentCounter();
            if (cell != null) {
                if (this.cellSetIterator.hasNext()) {
                    this.currentCell = (Cell)this.cellSetIterator.next();
                }
            } else {
                cell = new Cell(this.counter, AbstractResultSet.this.getDefaultValue(), false);
            }
            ITuple t = this.getTuple(this.counter);
            ++this.counter;
            TupleValue result = new TupleValue(t, cell);
            return result;
        }

        private Cell getCellForCurrentCounter() {
            Cell cell = null;
            if (this.currentCell != null) {
                long ordinal = this.currentCell.getOrdinal();
                if (ordinal == -123L) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Ordinal too large for a DefaultTupleValueIterator: " + this.currentCell.getBigOrdinal());
                }
                if (this.counter == ordinal) {
                    cell = this.currentCell;
                }
            }
            return cell;
        }

        private ITuple getTuple(long index) {
            ITuple t = this.crossJoinedSet.getTuple(index);
            if (this.hierarchyToIndex != null) {
                ArrayList<IMember> al = new ArrayList<IMember>();
                for (int i = 0; i < this.hierarchyOrder.length; ++i) {
                    Integer idx = this.hierarchyToIndex.get(this.hierarchyOrder[i]);
                    if (idx == null) continue;
                    IMember m = t.getMember(idx);
                    al.add(m);
                }
                t = new Tuple(al.toArray(new IMember[al.size()]), false);
            }
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object peek() {
            if (this.peekedValue == null) {
                this.peekedValue = this.next();
            }
            return this.peekedValue;
        }
    }
}

