/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IBlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSetIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ITupleValueIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullObject;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SearchConditionEvaluator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.Member;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.util.monitor.ResourceMonitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class Caster {
    private Caster() {
    }

    public static Object cast(Object o, Class destClass, InterpreterContext interpreterContext) throws InterpreterException {
        return Caster.cast(o, destClass, interpreterContext, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object cast(Object o, Class destClass, InterpreterContext interpreterContext, String functionName) throws InterpreterException {
        if (o == null) throw Caster.getInterpreterException(o, destClass.getClass().getSimpleName(), "CMP_TYPEDIMENSION CMP_TYPEHIERARCHY");
        if (o instanceof Hierarchy || o instanceof Dimension) {
            Dimension dim = o instanceof Hierarchy ? (Dimension)((Hierarchy)o).getDimension() : (Dimension)o;
            IMember[] currentMembers = interpreterContext.getContextSet().getMembers(dim);
            if (destClass == IMember[].class) {
                return currentMembers;
            }
            if (destClass == Tuple[].class) {
                if (currentMembers == null || currentMembers.length <= 0) return null;
                Tuple[] tuples = Tuple.createTuplePerMember(currentMembers);
                for (int i = 0; i < tuples.length; ++i) {
                    tuples[i].addCurrentMemberDimension(dim);
                }
                return tuples;
            }
            if (destClass == Set.class) {
                return new Set(Tuple.createTupleList(currentMembers));
            }
            if (destClass != Set[].class) throw Caster.getInterpreterException(o, destClass.getClass().getSimpleName(), functionName);
            Set[] resultSets = new Set[]{new Set(Tuple.createTupleList(currentMembers))};
            return resultSets;
        }
        if (!(o instanceof Level)) return Caster.cast(o, destClass, functionName);
        Level level = (Level)o;
        List<IMember> memberList = level.getMembers();
        IMember[] mems = memberList.toArray(new IMember[0]);
        mems = MemberOperations.applySecurityToMembers(mems, level.getHierarchy(), interpreterContext);
        if (destClass == IMember[].class) {
            return mems;
        }
        if (destClass == Tuple[].class) {
            if (mems == null || mems.length <= 0) return null;
            Tuple[] tuples = Tuple.createTuplePerMember(mems);
            IDimension dim = level.getDimension();
            for (int i = 0; i < tuples.length; ++i) {
                tuples[i].addCurrentMemberDimension(dim);
            }
            return tuples;
        }
        if (destClass == Set.class) {
            return new Set(Tuple.createTupleList(mems));
        }
        if (destClass != Set[].class) throw Caster.getInterpreterException(o, destClass.getClass().getSimpleName(), functionName);
        Set[] resultSets = new Set[]{new Set(Tuple.createTupleList(mems))};
        return resultSets;
    }

    public static Object cast(Object o, Class destClass) throws InterpreterException {
        return Caster.cast(o, destClass, (String)null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object cast(Object o, Class destClass, String functionName) throws InterpreterException {
        void var3_34;
        if (o == null) {
            throw new InterpreterException("X01461", new String[]{"NULL", destClass.getSimpleName()});
        }
        Object var3_3 = null;
        Class<?> sourceClass = o.getClass();
        if (Caster.isSubclass(destClass, sourceClass)) {
            Double[] doubleArray = o;
            return var3_34;
        } else if (destClass.isArray() && Caster.isSubclass(destClass.getComponentType(), sourceClass)) {
            if (o instanceof Double) {
                Double[] doubleArray = new Double[]{(Double)o};
                return var3_34;
            } else if (o instanceof Set) {
                Set[] setArray = new Set[]{(Set)o};
                return var3_34;
            } else if (o instanceof Tuple) {
                Tuple[] tupleArray = new Tuple[]{(Tuple)o};
                return var3_34;
            } else if (o instanceof IMember) {
                IMember[] iMemberArray = new IMember[]{(IMember)o};
                return var3_34;
            } else if (o instanceof Level) {
                Level[] levelArray = new Level[]{(Level)o};
                return var3_34;
            } else if (o instanceof Hierarchy) {
                Hierarchy[] hierarchyArray = new Hierarchy[]{(Hierarchy)o};
                return var3_34;
            } else {
                if (!(o instanceof Value)) return var3_34;
                IValue[] iValueArray = new IValue[]{(Value)o};
            }
            return var3_34;
        } else if (o instanceof IMember && destClass == IMember.class) {
            Double[] doubleArray = o;
            return var3_34;
        } else if (o instanceof IMember && destClass == IMember[].class) {
            IMember[] iMemberArray = new IMember[]{(IMember)o};
            return var3_34;
        } else if (o instanceof IMember && destClass == Set.class) {
            Set set = new Set(Tuple.createTupleList(new IMember[]{(IMember)o}));
            return var3_34;
        } else if (o instanceof IMember && destClass == Set[].class) {
            Set[] setArray = new Set[]{new Set(new Tuple((IMember)o))};
            return var3_34;
        } else if (o instanceof IMember && destClass == Tuple.class) {
            Tuple tuple = new Tuple((IMember)o);
            return var3_34;
        } else if (o instanceof IMember && destClass == Tuple[].class) {
            Tuple[] tupleArray = new Tuple[]{new Tuple((IMember)o)};
            return var3_34;
        } else if (o instanceof IMember[] && destClass == Set.class) {
            Set set = new Set(Tuple.createTupleList((IMember[])o));
            return var3_34;
        } else if (o instanceof IMember[] && destClass == Set[].class) {
            IMember[] members = (IMember[])o;
            HashSet<IDimension> dims = new HashSet<IDimension>();
            for (int i = 0; i < members.length && i < 2; ++i) {
                dims.add(members[i].getDimension());
                if (dims.size() > 1) break;
            }
            if (dims.size() == 1) {
                IDimension currMemDim = members[0].getDimension();
                IHierarchy currMemHier = members[0].getHierarchy();
                Tuple[] tuples = Tuple.createTuplePerMember(members);
                Set[] sets = new Set[tuples.length];
                for (int i = 0; i < tuples.length; ++i) {
                    sets[i] = new Set(tuples[i]);
                    sets[i].addCurrentMemberDimension(currMemDim);
                    sets[i].addCurrentMemberHierarchy(currMemHier);
                }
                Set[] setArray = sets;
                return var3_34;
            } else {
                Set[] setArray = new Set[]{new Set(new Tuple((IMember[])o))};
            }
            return var3_34;
        } else if (o instanceof IMember[] && destClass == Tuple.class) {
            Tuple tuple = new Tuple((IMember[])o);
            return var3_34;
        } else if (o instanceof IMember[] && destClass == Tuple[].class) {
            ITupleList iTupleList = Tuple.createTupleList((IMember[])o);
            int memberCount = ((IMember[])o).length;
            for (int i = 0; i < memberCount; ++i) {
                ((Tuple[])iTupleList)[i].addCurrentMemberDimension(((IMember[])o)[0].getDimension());
            }
            return var3_34;
        } else if (o instanceof Tuple && destClass == Set.class) {
            Set set = new Set((Tuple)o);
            return var3_34;
        } else if (o instanceof Tuple && destClass == Set[].class) {
            Set[] setArray = new Set[]{new Set((Tuple)o)};
            return var3_34;
        } else if (o instanceof Tuple && destClass == IMember.class) {
            Tuple tuple = (Tuple)o;
            if (tuple.size() != 1) {
                throw Caster.getInterpreterException(o, destClass.getSimpleName(), functionName);
            }
            IMember iMember = tuple.getMember(0);
            return var3_34;
        } else if (o instanceof Tuple[] && destClass == Set[].class) {
            Set[] setArray = new Set[]{new Set((Tuple[])o)};
            return var3_34;
        } else if (o instanceof Tuple[] && destClass == Set.class) {
            Set set = new Set((Tuple[])o);
            return var3_34;
        } else if (o instanceof Tuple[]) {
            Set set = new Set((Tuple[])o);
            if (destClass != IMember[].class) throw Caster.getInterpreterException(o, destClass.getSimpleName(), functionName);
            IDimension[] dims = set.getDimensions();
            IMember[] iMemberArray = set.getMembers(dims[0]);
            return var3_34;
        } else if (o instanceof Set && destClass == Set[].class) {
            Set[] setArray = new Set[]{(Set)o};
            return var3_34;
        } else if (o instanceof Set) {
            Set srcSet = (Set)o;
            if (!srcSet.isCurrentMemberSet()) {
                throw Caster.getInterpreterException(o, destClass.getSimpleName(), functionName);
            }
            IDimension[] currMemDims = srcSet.getCurrentMemberDimensions();
            Hierarchy[] currMemHiers = srcSet.getCurrentMemberHierarchies();
            if (destClass == Tuple[].class) {
                int setSize = (int)srcSet.size();
                ResourceMonitor.checkMaxSetSize((long)setSize, null, XQEMessageKeys.MDX_MaxCrossjoinSize);
                Tuple[] tupleArray = new Tuple[setSize];
                for (int i = 0; i < setSize; ++i) {
                    tupleArray[i] = (Tuple)srcSet.getTuple(i);
                    tupleArray[i].addCurrentMemberDimensions(currMemDims);
                }
                Tuple[] tupleArray2 = tupleArray;
                return var3_34;
            } else {
                if (destClass != IMember[].class) throw Caster.getInterpreterException(o, destClass.getSimpleName(), functionName);
                IDimension[] dims = srcSet.getDimensions();
                IMember[] iMemberArray = srcSet.getMembers(dims[0]);
            }
            return var3_34;
        } else {
            if (o instanceof ResultSet && destClass == Set[].class) {
                ResultSet rs = (ResultSet)o;
                IResultSetIterator it = rs.iterator();
                Set[] sets = new Set[rs.cellCount()];
                for (int i = 0; i < sets.length; ++i) {
                    Object value = ((Cell)it.next()).getObjectValue();
                    if (!(value instanceof IMember)) {
                        throw Caster.getInterpreterException(o, destClass.getSimpleName(), functionName);
                    }
                    sets[i] = new Set(new Tuple((IMember)value));
                }
                return sets;
            }
            if (o instanceof ResultSet && destClass == Set.class) {
                ResultSet rs = (ResultSet)o;
                ArrayList<Tuple> al = new ArrayList<Tuple>();
                ITuple[] tuples = null;
                ITupleValueIterator it = rs.tupleValueIterator();
                while (it.hasNext()) {
                    TupleValue tv = (TupleValue)it.next();
                    al.add(tv.getTuple());
                }
                tuples = al.toArray(new Tuple[al.size()]);
                return new Set(tuples);
            }
            if (o instanceof ResultSet && destClass == TupleValue[].class) {
                ArrayList al = new ArrayList();
                ResultSet rs = (ResultSet)o;
                ITupleValueIterator it = rs.tupleValueIterator();
                while (it.hasNext()) {
                    al.add(it.next());
                }
                return al.toArray(new TupleValue[0]);
            }
            if (!(o instanceof TupleValue[]) || destClass != ResultSet.class) throw Caster.getInterpreterException(o, destClass.getSimpleName(), functionName);
            TupleValue[] tupleValues = (TupleValue[])o;
            ITuple[] tuples = new Tuple[tupleValues.length];
            Cell[] cells = new Cell[tupleValues.length];
            for (int i = 0; i < tupleValues.length; ++i) {
                tuples[i] = tupleValues[i].getTuple();
                cells[i] = tupleValues[i].getCell();
            }
            ResultSet rs = new ResultSet(new Set[]{new Set(tuples)}, new Set(new Tuple[0]));
            for (int i = 0; i < cells.length; ++i) {
                cells[i].setOrdinal(i);
                rs.addCell(cells[i]);
            }
            return rs;
        }
    }

    public static Block cast(Block block, Class destClass, InterpreterContext interpreterContext) throws InterpreterException {
        return Caster.cast(block, destClass, interpreterContext, null);
    }

    public static Block cast(Block block, Class destClass, InterpreterContext interpreterContext, String functionName) throws InterpreterException {
        Object firstObj = block.first();
        if ((firstObj instanceof Hierarchy || firstObj instanceof Dimension) && (destClass == IMember.class || destClass == Member.class || destClass == ITuple.class || destClass == Tuple.class || destClass == ISet.class || destClass == Set.class)) {
            block.getCurrentMembers();
            if (destClass == IMember.class || destClass == Member.class) {
                return block;
            }
        } else if (firstObj instanceof Level && (destClass == ISet.class || destClass == Set.class)) {
            block.getLevelMembers();
        }
        Block[] childBlocks = new Block[]{block};
        Block retBlock = new Block(interpreterContext, childBlocks);
        BlockIterator blockIter = new BlockIterator(childBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Object castedObj = Caster.cast(blockObj[0], destClass, functionName);
            retBlock.add(blockIter, castedObj);
        }
        return retBlock;
    }

    public static Block castToInt(Block block, InterpreterContext interpreterContext) throws InterpreterException {
        Block[] childBlocks = new Block[]{block};
        Block retBlock = new Block(interpreterContext, childBlocks);
        retBlock.setDefaultValue(block.getDefaultValue());
        IBlockIterator blockIter = Block.getBlockIterator(childBlocks);
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Object castedObj = blockObj[0] instanceof Value ? blockObj[0] : Integer.valueOf(Caster.castToInt(interpreterContext, blockObj[0]));
            retBlock.add(blockIter, castedObj);
        }
        if (retBlock.getDefaultValue() == null) {
            int cellSetSize = retBlock.cellSetSize();
            long tupleSetSize = retBlock.tupleSetSize();
            if (cellSetSize == 0 || tupleSetSize < 0L || tupleSetSize > (long)cellSetSize) {
                retBlock.setDefaultValue(new Integer(0));
            }
        }
        return retBlock;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object castCheck(Object o, Class destClass) throws InterpreterException {
        void var2_31;
        Object var2_2 = null;
        if (o == null) throw new InterpreterException();
        Class<?> sourceClass = o.getClass();
        if (Caster.isSubclass(destClass, sourceClass)) {
            IMember[] iMemberArray = o;
            return var2_31;
        } else if (destClass.isArray() && Caster.isSubclass(destClass.getComponentType(), sourceClass)) {
            if (o instanceof Double) {
                Double[] doubleArray = new Double[]{(Double)o};
                return var2_31;
            } else if (o instanceof Set) {
                Set[] setArray = new Set[]{(Set)o};
                return var2_31;
            } else if (o instanceof Tuple) {
                Tuple[] tupleArray = new Tuple[]{(Tuple)o};
                return var2_31;
            } else if (o instanceof IMember) {
                IMember[] iMemberArray = new IMember[]{(IMember)o};
                return var2_31;
            } else if (o instanceof Level) {
                Level[] levelArray = new Level[]{(Level)o};
                return var2_31;
            } else if (o instanceof Hierarchy) {
                Hierarchy[] hierarchyArray = new Hierarchy[]{(Hierarchy)o};
                return var2_31;
            } else {
                if (!(o instanceof Value)) return var2_31;
                IValue[] iValueArray = new IValue[]{(Value)o};
            }
            return var2_31;
        } else if (o instanceof IMember && destClass == IMember[].class) {
            IMember[] iMemberArray = new IMember[]{(IMember)o};
            return var2_31;
        } else if (o instanceof IMember && destClass == Set.class) {
            Set set = new Set(new Tuple((IMember)o));
            return var2_31;
        } else if (o instanceof IMember && destClass == Set[].class) {
            Set[] setArray = new Set[]{new Set(new Tuple((IMember)o))};
            return var2_31;
        } else if (o instanceof IMember && destClass == Tuple.class) {
            Tuple tuple = new Tuple((IMember)o);
            return var2_31;
        } else if (o instanceof IMember && destClass == Tuple[].class) {
            Tuple[] tupleArray = new Tuple[]{new Tuple((IMember)o)};
            return var2_31;
        } else if (o instanceof IMember[] && destClass == Set.class) {
            Set set = new Set(Tuple.createTupleList(o));
            return var2_31;
        } else if (o instanceof IMember[] && destClass == Set[].class) {
            IMember[] members = o;
            HashSet<IDimension> dims = new HashSet<IDimension>();
            for (int i = 0; i < members.length && i < 2; ++i) {
                dims.add(members[i].getDimension());
                if (dims.size() > 1) break;
            }
            if (dims.size() == 1) {
                Set[] sets = new Set[members.length];
                for (int i = 0; i < members.length; ++i) {
                    sets[i] = new Set(Tuple.createTupleList(new IMember[]{members[i]}));
                }
                Set[] setArray = sets;
                return var2_31;
            } else {
                Set[] setArray = new Set[]{new Set(new Tuple(o))};
            }
            return var2_31;
        } else if (o instanceof IMember[] && destClass == Tuple.class) {
            Tuple tuple = new Tuple(o);
            return var2_31;
        } else if (o instanceof IMember[] && destClass == Tuple[].class) {
            ITupleList iTupleList = Tuple.createTupleList(o);
            return var2_31;
        } else if (o instanceof Tuple && destClass == Set.class) {
            Set set = new Set((Tuple)o);
            return var2_31;
        } else if (o instanceof Tuple && destClass == Set[].class) {
            Set[] setArray = new Set[]{new Set((Tuple)o)};
            return var2_31;
        } else if (o instanceof Set && destClass == Set[].class) {
            Set[] setArray = new Set[]{(Set)o};
            return var2_31;
        } else if (o instanceof Tuple[] && destClass == Set[].class) {
            Set[] setArray = new Set[]{new Set((Tuple[])o)};
            return var2_31;
        } else if (o instanceof Tuple[] && destClass == Set.class) {
            Set set = new Set((Tuple[])o);
            return var2_31;
        } else {
            if (o instanceof ResultSet && destClass == Set[].class) {
                ResultSet rs = (ResultSet)o;
                IResultSetIterator it = rs.iterator();
                Set[] sets = new Set[rs.cellCount()];
                for (int i = 0; i < sets.length; ++i) {
                    Object value = ((Cell)it.next()).getObjectValue();
                    if (!(value instanceof IMember)) {
                        throw new InterpreterException();
                    }
                    sets[i] = new Set(new Tuple((IMember)value));
                }
                return sets;
            }
            if (o instanceof ResultSet && destClass == Set.class) {
                ResultSet rs = (ResultSet)o;
                ArrayList<Tuple> al = new ArrayList<Tuple>();
                ITuple[] tuples = null;
                ITupleValueIterator it = rs.tupleValueIterator();
                while (it.hasNext()) {
                    TupleValue tv = (TupleValue)it.next();
                    al.add(tv.getTuple());
                }
                tuples = al.toArray(new Tuple[0]);
                return new Set(tuples);
            }
            if (o instanceof ResultSet && destClass == TupleValue[].class) {
                ArrayList al = new ArrayList();
                ResultSet rs = (ResultSet)o;
                ITupleValueIterator it = rs.tupleValueIterator();
                while (it.hasNext()) {
                    al.add(it.next());
                }
                return al.toArray(new TupleValue[0]);
            }
            if (o instanceof TupleValue[] && destClass == ResultSet.class) {
                TupleValue[] tupleValues = (TupleValue[])o;
                ITuple[] tuples = new Tuple[tupleValues.length];
                Cell[] cells = new Cell[tupleValues.length];
                for (int i = 0; i < tupleValues.length; ++i) {
                    tuples[i] = tupleValues[i].getTuple();
                    cells[i] = tupleValues[i].getCell();
                }
                ResultSet rs = new ResultSet(new Set[]{new Set(tuples)}, new Set(new Tuple[0]));
                for (int i = 0; i < cells.length; ++i) {
                    cells[i].setOrdinal(i);
                    rs.addCell(cells[i]);
                }
                return rs;
            }
            if (o instanceof Set) {
                Set srcSet = (Set)o;
                if (!srcSet.isCurrentMemberSet()) {
                    throw new InterpreterException();
                }
                if (destClass == Tuple[].class) {
                    int setSize = (int)srcSet.size();
                    Tuple[] tupleArray = new Tuple[setSize];
                    for (int i = 0; i < setSize; ++i) {
                        tupleArray[i] = (Tuple)srcSet.getTuple(i);
                    }
                    Tuple[] tupleArray2 = tupleArray;
                    return var2_31;
                } else {
                    if (destClass != IMember[].class) throw new InterpreterException();
                    IDimension[] dims = srcSet.getDimensions();
                    IMember[] iMemberArray = srcSet.getMembers(dims[0]);
                }
                return var2_31;
            } else {
                if (!(o instanceof Tuple[])) throw new InterpreterException();
                Set set = new Set((Tuple[])o);
                if (destClass != IMember[].class) throw new InterpreterException();
                IDimension[] dims = set.getDimensions();
                IMember[] iMemberArray = set.getMembers(dims[0]);
            }
        }
        return var2_31;
    }

    public static boolean isCastable(Object o, Class destClass, InterpreterContext interpreterContext) {
        boolean result = true;
        try {
            Caster.cast(o, destClass, interpreterContext);
        }
        catch (InterpreterException e) {
            result = false;
        }
        return result;
    }

    public static boolean isCastable(Object o, Class destClass) {
        boolean result = true;
        try {
            Caster.castCheck(o, destClass);
        }
        catch (InterpreterException e) {
            result = false;
        }
        return result;
    }

    public static boolean isDownCastable(Object o, Class destClass, InterpreterContext interpreterContext) {
        boolean result = true;
        try {
            Caster.castDown(o, destClass, interpreterContext);
        }
        catch (InterpreterException e) {
            result = false;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object castDown(Object o, Class destClass, InterpreterContext interpreterContext) throws InterpreterException {
        void var3_11;
        Object var3_3 = null;
        if (o != null) {
            Class<?> sourceClass = o.getClass();
            if (Caster.isSubclass(destClass, sourceClass)) {
                IMember[] iMemberArray = o;
            } else if (destClass == IMember.class) {
                if (o instanceof IMember[]) {
                    IMember[] members = o;
                    if (members.length != 1) throw new InterpreterException("X01461", new String[]{o.getClass().getSimpleName(), destClass.getSimpleName()});
                    IMember iMember = members[0];
                } else if (o instanceof Tuple) {
                    Tuple t = (Tuple)o;
                    if (t.size() != 1) throw new InterpreterException("X01461", new String[]{o.getClass().getSimpleName(), destClass.getSimpleName()});
                    IMember iMember = t.getMembers()[0];
                } else {
                    if (!(o instanceof Tuple[])) throw new InterpreterException("X01461", new String[]{o.getClass().getSimpleName(), destClass.getSimpleName()});
                    Tuple[] tuples = (Tuple[])o;
                    if (tuples.length != 1 || tuples[0].size() != 1) throw new InterpreterException("X01461", new String[]{o.getClass().getSimpleName(), destClass.getSimpleName()});
                    IMember iMember = tuples[0].getMembers()[0];
                }
            } else if (destClass == IMember[].class) {
                if (o instanceof Tuple) {
                    Tuple t = (Tuple)o;
                    if (t.size() != 1) throw new InterpreterException("X01461", new String[]{o.getClass().getSimpleName(), destClass.getSimpleName()});
                    IMember[] iMemberArray = t.getMembers();
                } else if (o instanceof Set && ((Set)o).isCurrentMemberSet()) {
                    Set s = (Set)o;
                    ArrayList<IMember> al = new ArrayList<IMember>();
                    if (s.getHierarchies().length == 0) {
                        IMember[] iMemberArray = new IMember[]{};
                    } else {
                        if (s.getHierarchies().length != 1) throw new InterpreterException("X01461", new String[]{o.getClass().getSimpleName(), destClass.getSimpleName()});
                        ResourceMonitor.checkMaxSetSize(s.size(), interpreterContext.getQueryContext(), XQEMessageKeys.MDX_MaxCrossjoinSize);
                        int i = 0;
                        while ((long)i < s.size()) {
                            al.add(s.getTuple(i).getMember(0));
                            ++i;
                        }
                        IMember[] iMemberArray = al.toArray(new IMember[0]);
                    }
                }
            }
        }
        if (var3_11 != null) return var3_11;
        throw new InterpreterException("X01461", new String[]{o.getClass().getSimpleName(), destClass.getSimpleName()});
    }

    public static boolean isSubclass(Class a, Class b) {
        while (b != null) {
            if (b == a) {
                return true;
            }
            b = b.getSuperclass();
        }
        return false;
    }

    public static int castToInt(InterpreterContext context, Object obj) throws InterpreterException {
        int intValue = 0;
        if (obj == null) {
            return intValue;
        }
        if (obj instanceof Integer) {
            intValue = (Integer)obj;
        } else if (obj instanceof Double) {
            intValue = ((Double)obj).intValue();
        } else if (obj instanceof Boolean) {
            intValue = context.getDoubleOperand(obj).intValue();
        } else if (obj instanceof String) {
            double d = Double.parseDouble((String)obj);
            intValue = (int)d;
        } else if (obj instanceof NullObject) {
            intValue = 0;
        } else if (obj instanceof Value) {
            Value v = (Value)obj;
            intValue = v.isNull() ? 0 : v.getInteger();
        } else {
            throw new InterpreterException("X01461", new String[]{obj.getClass().getSimpleName(), "Double, String, NullObject"});
        }
        return intValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int coerceParameterToInteger(InterpreterContext context, Object o) throws InterpreterException {
        int iresult = 0;
        if (o == null) return iresult;
        if (o instanceof SearchConditionEvaluator) {
            o = ((SearchConditionEvaluator)o).getSubject();
        }
        if (o instanceof CalculatedMember) {
            o = ((CalculatedMember)o).executeToResultSet(context);
        } else if (o instanceof Tuple[]) {
            Set set = new Set((Tuple[])o);
            o = (ResultSet)context.setToResultSet(set);
        }
        if (o instanceof Value) {
            Value v = (Value)o;
            if (v.isNull()) {
                return 0;
            }
            double d = v.getDouble();
            if (d > 2.147483647E9) {
                return Integer.MAX_VALUE;
            }
            if (!(d < -2.147483648E9)) return v.getInteger();
            return Integer.MIN_VALUE;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Double) {
            return ((Double)o).intValue();
        }
        if (o instanceof Boolean) {
            return context.getDoubleOperand(o).intValue();
        }
        if (o instanceof String) {
            double d = Double.parseDouble((String)o);
            return (int)d;
        }
        if (o instanceof IMember || o instanceof ResultSet) {
            if (o instanceof IMember) {
                Set s = (Set)Caster.cast(o, Set.class);
                InterpreterContext ic = context;
                o = (ResultSet)ic.setToResultSet(s);
            }
            if (((ResultSet)o).cellCount() > 0) {
                IResultSetIterator it = ((ResultSet)o).iterator();
                if (!it.hasNext()) return iresult;
                Cell c = (Cell)it.next();
                Object cellValue = c.getObjectValue();
                if (cellValue instanceof Value) {
                    Value v = (Value)cellValue;
                    if (!v.isNull()) return v.getInteger();
                    return 0;
                }
                if (cellValue instanceof Double) {
                    return (int)((Double)cellValue).doubleValue();
                }
                if (cellValue instanceof Boolean) {
                    if (cellValue != Boolean.TRUE) return 0;
                    return 1;
                }
                if (!(cellValue instanceof String)) return iresult;
                try {
                    return Double.valueOf((String)cellValue).intValue();
                }
                catch (NumberFormatException e) {
                    throw new InterpreterException("X01461", new String[]{cellValue.getClass().getSimpleName(), "Double"}, e);
                }
            }
            if (((ResultSet)o).cellCount() != 0) throw new InterpreterException("X01461", new String[]{o.getClass().getSimpleName(), "SearchConditionEvaluator, CalculatedMember, Tuple[], Double, String, IMember, ResultSet"});
            return 0;
        }
        if (!(o instanceof NullObject)) throw new InterpreterException("X01461", new String[]{o.getClass().getSimpleName(), "SearchConditionEvaluator, CalculatedMember, Tuple[], Double, String, IMember, ResultSet, NullObject"});
        return 0;
    }

    private static InterpreterException getInterpreterException(Object o, String dest, String funcName) {
        InterpreterException ie = null;
        ie = funcName == null ? new InterpreterException("X01461", new String[]{o.getClass().getSimpleName(), dest}) : new InterpreterException("X01490", new String[]{Caster.getClassAsString(o), funcName, dest});
        return ie;
    }

    private static String getClassAsString(Object o) {
        String oAsString = null;
        oAsString = o instanceof String ? (String)o : (o instanceof IMember ? ((IMember)o).getUniqueName() : (o instanceof ILevel ? ((ILevel)o).getUniqueName() : (o instanceof Number ? o.toString() : (o instanceof Value ? ((Value)o).getString() : o.getClass().getSimpleName()))));
        return oAsString;
    }
}

